/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.test.history;

import java.util.HashMap;
import org.camunda.bpm.engine.exception.NotValidException;
import org.camunda.bpm.engine.history.UserOperationLogEntry;
import org.camunda.bpm.engine.history.UserOperationLogQuery;
import org.camunda.bpm.engine.impl.test.PluggableProcessEngineTestCase;
import org.camunda.bpm.engine.repository.CaseDefinition;
import org.camunda.bpm.engine.repository.ProcessDefinition;
import org.camunda.bpm.engine.runtime.CaseExecution;
import org.camunda.bpm.engine.runtime.ProcessInstance;
import org.camunda.bpm.engine.task.DelegationState;
import org.camunda.bpm.engine.task.Task;
import org.camunda.bpm.engine.test.Deployment;

public class OperationLogTaskProcessTest
extends PluggableProcessEngineTestCase {
    protected ProcessDefinition processDefinition;
    protected ProcessInstance process;
    protected Task task;

    @Deployment(resources={"org/camunda/bpm/engine/test/history/oneTaskProcess.bpmn20.xml"})
    public void testCreateAndCompleteTask() {
        this.identityService.setAuthenticatedUserId("icke");
        this.startTestProcess();
        UserOperationLogQuery query = this.historyService.createUserOperationLogQuery();
        OperationLogTaskProcessTest.assertEquals((long)0L, (long)query.count());
        this.completeTestProcess();
        query = this.queryOperationDetails("Complete");
        OperationLogTaskProcessTest.assertEquals((long)1L, (long)query.count());
        UserOperationLogEntry complete = (UserOperationLogEntry)query.singleResult();
        OperationLogTaskProcessTest.assertEquals((String)"delete", (String)complete.getProperty());
        OperationLogTaskProcessTest.assertTrue((boolean)Boolean.parseBoolean(complete.getNewValue()));
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/history/oneTaskProcess.bpmn20.xml"})
    public void testAssignTask() {
        this.startTestProcess();
        this.taskService.setAssignee(this.task.getId(), "icke");
        UserOperationLogQuery query = this.queryOperationDetails("Assign");
        OperationLogTaskProcessTest.assertEquals((long)1L, (long)query.count());
        UserOperationLogEntry assign = (UserOperationLogEntry)query.singleResult();
        OperationLogTaskProcessTest.assertEquals((String)"assignee", (String)assign.getProperty());
        OperationLogTaskProcessTest.assertEquals((String)"icke", (String)assign.getNewValue());
        this.completeTestProcess();
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/history/oneTaskProcess.bpmn20.xml"})
    public void testChangeTaskOwner() {
        this.startTestProcess();
        this.taskService.setOwner(this.task.getId(), "icke");
        UserOperationLogQuery query = this.queryOperationDetails("SetOwner");
        OperationLogTaskProcessTest.assertEquals((long)1L, (long)query.count());
        UserOperationLogEntry change = (UserOperationLogEntry)query.singleResult();
        OperationLogTaskProcessTest.assertEquals((String)"owner", (String)change.getProperty());
        OperationLogTaskProcessTest.assertEquals((String)"icke", (String)change.getNewValue());
        this.completeTestProcess();
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/history/oneTaskProcess.bpmn20.xml"})
    public void testSetPriority() {
        this.startTestProcess();
        this.taskService.setPriority(this.task.getId(), 10);
        UserOperationLogQuery query = this.queryOperationDetails("SetPriority");
        OperationLogTaskProcessTest.assertEquals((long)1L, (long)query.count());
        UserOperationLogEntry userOperationLogEntry = (UserOperationLogEntry)query.singleResult();
        OperationLogTaskProcessTest.assertEquals((String)"priority", (String)userOperationLogEntry.getProperty());
        OperationLogTaskProcessTest.assertEquals((int)50, (int)Integer.parseInt(userOperationLogEntry.getOrgValue()));
        OperationLogTaskProcessTest.assertEquals((int)10, (int)Integer.parseInt(userOperationLogEntry.getNewValue()));
        this.taskService.setPriority(this.task.getId(), 75);
        query = this.queryOperationDetails("SetPriority");
        OperationLogTaskProcessTest.assertEquals((long)2L, (long)query.count());
        userOperationLogEntry = (UserOperationLogEntry)((UserOperationLogQuery)query.orderByTimestamp().asc()).list().get(1);
        OperationLogTaskProcessTest.assertEquals((String)"priority", (String)userOperationLogEntry.getProperty());
        OperationLogTaskProcessTest.assertEquals((int)10, (int)Integer.parseInt(userOperationLogEntry.getOrgValue()));
        OperationLogTaskProcessTest.assertEquals((int)75, (int)Integer.parseInt(userOperationLogEntry.getNewValue()));
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/history/oneTaskProcess.bpmn20.xml"})
    public void testClaimTask() {
        this.startTestProcess();
        this.taskService.claim(this.task.getId(), "icke");
        UserOperationLogQuery query = this.queryOperationDetails("Claim");
        OperationLogTaskProcessTest.assertEquals((long)1L, (long)query.count());
        UserOperationLogEntry claim = (UserOperationLogEntry)query.singleResult();
        OperationLogTaskProcessTest.assertEquals((String)"assignee", (String)claim.getProperty());
        OperationLogTaskProcessTest.assertEquals((String)"icke", (String)claim.getNewValue());
        this.completeTestProcess();
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/history/oneTaskProcess.bpmn20.xml"})
    public void testDelegateTask() {
        this.startTestProcess();
        this.taskService.claim(this.task.getId(), "icke");
        this.taskService.delegateTask(this.task.getId(), "er");
        UserOperationLogQuery query = this.queryOperationDetails("Delegate");
        OperationLogTaskProcessTest.assertEquals((long)3L, (long)query.count());
        OperationLogTaskProcessTest.assertEquals((String)"icke", (String)((UserOperationLogEntry)this.queryOperationDetails("Delegate", "owner").singleResult()).getNewValue());
        OperationLogTaskProcessTest.assertEquals((String)"er", (String)((UserOperationLogEntry)this.queryOperationDetails("Delegate", "assignee").singleResult()).getNewValue());
        OperationLogTaskProcessTest.assertEquals((String)DelegationState.PENDING.toString(), (String)((UserOperationLogEntry)this.queryOperationDetails("Delegate", "delegation").singleResult()).getNewValue());
        this.completeTestProcess();
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/history/oneTaskProcess.bpmn20.xml"})
    public void testResolveTask() {
        this.startTestProcess();
        this.taskService.resolveTask(this.task.getId());
        UserOperationLogQuery query = this.queryOperationDetails("Resolve");
        OperationLogTaskProcessTest.assertEquals((long)1L, (long)query.count());
        OperationLogTaskProcessTest.assertEquals((String)DelegationState.RESOLVED.toString(), (String)((UserOperationLogEntry)query.singleResult()).getNewValue());
        this.completeTestProcess();
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/history/oneTaskProcess.bpmn20.xml"})
    public void testSubmitTaskForm_Complete() {
        this.startTestProcess();
        this.formService.submitTaskForm(this.task.getId(), new HashMap());
        UserOperationLogQuery query = this.queryOperationDetails("Complete");
        OperationLogTaskProcessTest.assertEquals((long)1L, (long)query.count());
        OperationLogTaskProcessTest.assertFalse((boolean)Boolean.parseBoolean(((UserOperationLogEntry)query.property("delete").singleResult()).getOrgValue()));
        OperationLogTaskProcessTest.assertTrue((boolean)Boolean.parseBoolean(((UserOperationLogEntry)query.property("delete").singleResult()).getNewValue()));
        this.assertProcessEnded(this.process.getId());
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/history/oneTaskProcess.bpmn20.xml"})
    public void testSubmitTaskForm_Resolve() {
        this.startTestProcess();
        this.taskService.delegateTask(this.task.getId(), "demo");
        this.formService.submitTaskForm(this.task.getId(), new HashMap());
        UserOperationLogQuery query = this.queryOperationDetails("Resolve");
        OperationLogTaskProcessTest.assertEquals((long)2L, (long)query.count());
        OperationLogTaskProcessTest.assertEquals((String)DelegationState.PENDING.toString(), (String)((UserOperationLogEntry)query.property("delegation").singleResult()).getOrgValue());
        OperationLogTaskProcessTest.assertEquals((String)DelegationState.RESOLVED.toString(), (String)((UserOperationLogEntry)query.property("delegation").singleResult()).getNewValue());
        OperationLogTaskProcessTest.assertEquals((String)"demo", (String)((UserOperationLogEntry)query.property("assignee").singleResult()).getOrgValue());
        OperationLogTaskProcessTest.assertEquals(null, (String)((UserOperationLogEntry)query.property("assignee").singleResult()).getNewValue());
        this.completeTestProcess();
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/cmmn/oneTaskCase.cmmn"})
    public void testCompleteCaseExecution() {
        String caseDefinitionId = ((CaseDefinition)this.repositoryService.createCaseDefinitionQuery().singleResult()).getId();
        String caseInstanceId = this.caseService.withCaseDefinition(caseDefinitionId).create().getId();
        String humanTaskId = ((CaseExecution)this.caseService.createCaseExecutionQuery().activityId("PI_HumanTask_1").singleResult()).getId();
        this.caseService.withCaseExecution(humanTaskId).manualStart();
        this.caseService.withCaseExecution(humanTaskId).complete();
        UserOperationLogQuery query = this.queryOperationDetails("Complete");
        OperationLogTaskProcessTest.assertEquals((long)1L, (long)query.count());
        UserOperationLogEntry entry = (UserOperationLogEntry)query.singleResult();
        OperationLogTaskProcessTest.assertNotNull((Object)entry);
        OperationLogTaskProcessTest.assertEquals((String)caseDefinitionId, (String)entry.getCaseDefinitionId());
        OperationLogTaskProcessTest.assertEquals((String)caseInstanceId, (String)entry.getCaseInstanceId());
        OperationLogTaskProcessTest.assertEquals((String)humanTaskId, (String)entry.getCaseExecutionId());
        OperationLogTaskProcessTest.assertFalse((boolean)Boolean.valueOf(entry.getOrgValue()));
        OperationLogTaskProcessTest.assertTrue((boolean)Boolean.valueOf(entry.getNewValue()));
        OperationLogTaskProcessTest.assertEquals((String)"delete", (String)entry.getProperty());
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/history/oneTaskProcess.bpmn20.xml"})
    public void testDeleteOpLogEntriesOnUndeployment() {
        this.startTestProcess();
        this.taskService.resolveTask(this.task.getId());
        this.runtimeService.suspendProcessInstanceByProcessDefinitionId(this.processDefinition.getId());
        this.repositoryService.deleteDeployment(this.deploymentId, true);
        OperationLogTaskProcessTest.assertEquals((long)0L, (long)this.historyService.createUserOperationLogQuery().count());
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/history/oneTaskProcess.bpmn20.xml"})
    public void testDeleteOpLogEntry() {
        this.startTestProcess();
        this.taskService.resolveTask(this.task.getId());
        UserOperationLogEntry opLogEntry = (UserOperationLogEntry)this.historyService.createUserOperationLogQuery().singleResult();
        this.historyService.deleteUserOperationLogEntry(opLogEntry.getId());
        OperationLogTaskProcessTest.assertEquals((long)0L, (long)this.historyService.createUserOperationLogQuery().count());
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/history/oneTaskProcess.bpmn20.xml"})
    public void testDeleteOpLogEntryWithNullArgument() {
        this.startTestProcess();
        this.taskService.resolveTask(this.task.getId());
        try {
            this.historyService.deleteUserOperationLogEntry(null);
            OperationLogTaskProcessTest.fail((String)"exeception expected");
        }
        catch (NotValidException notValidException) {
            // empty catch block
        }
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/history/oneTaskProcess.bpmn20.xml"})
    public void testDeleteOpLogNonExstingEntry() {
        this.startTestProcess();
        this.taskService.resolveTask(this.task.getId());
        this.historyService.deleteUserOperationLogEntry("a non existing id");
        OperationLogTaskProcessTest.assertEquals((long)1L, (long)this.historyService.createUserOperationLogQuery().count());
    }

    protected void startTestProcess() {
        this.processDefinition = (ProcessDefinition)this.repositoryService.createProcessDefinitionQuery().processDefinitionKey("oneTaskProcess").singleResult();
        this.process = this.runtimeService.startProcessInstanceById(this.processDefinition.getId());
        this.task = (Task)this.taskService.createTaskQuery().singleResult();
    }

    protected UserOperationLogQuery queryOperationDetails(String type) {
        return this.historyService.createUserOperationLogQuery().operationType(type);
    }

    protected UserOperationLogQuery queryOperationDetails(String type, String property) {
        return this.historyService.createUserOperationLogQuery().operationType(type).property(property);
    }

    protected void completeTestProcess() {
        this.taskService.complete(this.task.getId());
        this.assertProcessEnded(this.process.getId());
    }
}

