/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.test.jobexecutor;

import java.util.Date;
import java.util.HashSet;
import java.util.TreeSet;
import org.camunda.bpm.engine.ProcessEngineConfiguration;
import org.camunda.bpm.engine.impl.interceptor.Command;
import org.camunda.bpm.engine.impl.interceptor.CommandContext;
import org.camunda.bpm.engine.impl.interceptor.CommandExecutor;
import org.camunda.bpm.engine.impl.persistence.entity.JobManager;
import org.camunda.bpm.engine.test.jobexecutor.JobExecutorTestCase;

public class JobExecutorTest
extends JobExecutorTestCase {
    public void testBasicJobExecutorOperation() throws Exception {
        CommandExecutor commandExecutor = this.processEngineConfiguration.getCommandExecutorTxRequired();
        commandExecutor.execute((Command)new Command<Void>(){

            public Void execute(CommandContext commandContext) {
                JobManager jobManager = commandContext.getJobManager();
                jobManager.send(JobExecutorTest.this.createTweetMessage("message-one"));
                jobManager.send(JobExecutorTest.this.createTweetMessage("message-two"));
                jobManager.send(JobExecutorTest.this.createTweetMessage("message-three"));
                jobManager.send(JobExecutorTest.this.createTweetMessage("message-four"));
                jobManager.schedule(JobExecutorTest.this.createTweetTimer("timer-one", new Date()));
                jobManager.schedule(JobExecutorTest.this.createTweetTimer("timer-two", new Date()));
                return null;
            }
        });
        this.executeAvailableJobs();
        HashSet<String> messages = new HashSet<String>(this.tweetHandler.getMessages());
        HashSet<String> expectedMessages = new HashSet<String>();
        expectedMessages.add("message-one");
        expectedMessages.add("message-two");
        expectedMessages.add("message-three");
        expectedMessages.add("message-four");
        expectedMessages.add("timer-one");
        expectedMessages.add("timer-two");
        JobExecutorTest.assertEquals(new TreeSet(expectedMessages), new TreeSet<String>(messages));
    }

    public void testJobExecutorHintConfiguration() {
        ProcessEngineConfiguration engineConfig1 = ProcessEngineConfiguration.createStandaloneInMemProcessEngineConfiguration();
        JobExecutorTest.assertTrue((String)"default setting is true", (boolean)engineConfig1.isHintJobExecutor());
        ProcessEngineConfiguration engineConfig2 = ProcessEngineConfiguration.createStandaloneInMemProcessEngineConfiguration().setHintJobExecutor(false);
        JobExecutorTest.assertFalse((boolean)engineConfig2.isHintJobExecutor());
        ProcessEngineConfiguration engineConfig3 = ProcessEngineConfiguration.createStandaloneInMemProcessEngineConfiguration().setHintJobExecutor(true);
        JobExecutorTest.assertTrue((boolean)engineConfig3.isHintJobExecutor());
    }
}

