/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.test.standalone.scripting;

import org.camunda.bpm.engine.impl.scripting.CompiledExecutableScript;
import org.camunda.bpm.engine.impl.scripting.ExecutableScript;
import org.camunda.bpm.engine.impl.scripting.ScriptFactory;
import org.camunda.bpm.engine.impl.scripting.SourceExecutableScript;
import org.camunda.bpm.engine.impl.test.PluggableProcessEngineTestCase;

public class ScriptFactoryTest
extends PluggableProcessEngineTestCase {
    protected static final String SCRIPT_LANGUAGE = "groovy";
    protected static final String EXAMPLE_SCRIPT = "execution.setVariable('aName', 'aValue')";

    public void testDisableScriptCompilation() {
        ScriptFactory factory = new ScriptFactory(this.processEngineConfiguration.getScriptingEngines(), true);
        ExecutableScript createdScript = factory.createScript(EXAMPLE_SCRIPT, SCRIPT_LANGUAGE);
        ScriptFactoryTest.assertNotNull((Object)createdScript);
        ScriptFactoryTest.assertTrue((boolean)(createdScript instanceof CompiledExecutableScript));
        factory = new ScriptFactory(this.processEngineConfiguration.getScriptingEngines(), false);
        createdScript = factory.createScript(EXAMPLE_SCRIPT, SCRIPT_LANGUAGE);
        ScriptFactoryTest.assertNotNull((Object)createdScript);
        ScriptFactoryTest.assertTrue((boolean)(createdScript instanceof SourceExecutableScript));
    }

    public void testDefaultScriptCompilationEnabled() {
        ExecutableScript createdScript = this.processEngineConfiguration.getScriptFactory().createScript(EXAMPLE_SCRIPT, SCRIPT_LANGUAGE);
        ScriptFactoryTest.assertNotNull((Object)createdScript);
        ScriptFactoryTest.assertTrue((boolean)(createdScript instanceof CompiledExecutableScript));
    }
}

