/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.test.variables;

import java.util.Map;
import org.camunda.bpm.engine.ProcessEngineConfiguration;
import org.camunda.bpm.engine.delegate.SerializedVariableValue;
import org.camunda.bpm.engine.history.HistoricVariableInstance;
import org.camunda.bpm.engine.history.HistoricVariableUpdate;
import org.camunda.bpm.engine.impl.cfg.ProcessEngineConfigurationImpl;
import org.camunda.bpm.engine.impl.test.AbstractProcessEngineTestCase;
import org.camunda.bpm.engine.runtime.ProcessInstance;
import org.camunda.bpm.engine.test.Deployment;
import org.camunda.bpm.engine.test.variables.SimpleBean;
import org.camunda.spin.DataFormats;
import org.json.JSONException;
import org.skyscreamer.jsonassert.JSONAssert;

public class HistoricVariableDataFormatTest
extends AbstractProcessEngineTestCase {
    protected static final String ONE_TASK_PROCESS = "org/camunda/bpm/engine/test/variables/oneTaskProcess.bpmn20.xml";
    protected static final String JSON_FORMAT_NAME = DataFormats.jsonTree().getName();

    protected void initializeProcessEngine() {
        ProcessEngineConfigurationImpl engineConfig = (ProcessEngineConfigurationImpl)ProcessEngineConfiguration.createProcessEngineConfigurationFromResource((String)"camunda.cfg.xml");
        engineConfig.setDefaultSerializationFormat(JSON_FORMAT_NAME);
        this.processEngine = engineConfig.buildProcessEngine();
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/variables/oneTaskProcess.bpmn20.xml"})
    public void testSelectHistoricVariableInstances() throws JSONException {
        ProcessInstance instance = this.runtimeService.startProcessInstanceByKey("oneTaskProcess");
        SimpleBean bean = new SimpleBean("a String", 42, false);
        this.runtimeService.setVariable(instance.getId(), "simpleBean", (Object)bean);
        HistoricVariableInstance historicVariable = (HistoricVariableInstance)this.historyService.createHistoricVariableInstanceQuery().singleResult();
        HistoricVariableDataFormatTest.assertNotNull((Object)historicVariable.getValue());
        HistoricVariableDataFormatTest.assertNull((Object)historicVariable.getErrorMessage());
        HistoricVariableDataFormatTest.assertTrue((boolean)historicVariable.storesCustomObjects());
        HistoricVariableDataFormatTest.assertEquals((String)Object.class.getSimpleName(), (String)historicVariable.getValueTypeName());
        SimpleBean historyValue = (SimpleBean)historicVariable.getValue();
        HistoricVariableDataFormatTest.assertEquals((String)bean.getStringProperty(), (String)historyValue.getStringProperty());
        HistoricVariableDataFormatTest.assertEquals((int)bean.getIntProperty(), (int)historyValue.getIntProperty());
        HistoricVariableDataFormatTest.assertEquals((boolean)bean.getBooleanProperty(), (boolean)historyValue.getBooleanProperty());
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/variables/oneTaskProcess.bpmn20.xml"})
    public void testSelectHistoricSerializedValues() throws JSONException {
        ProcessInstance instance = this.runtimeService.startProcessInstanceByKey("oneTaskProcess");
        SimpleBean bean = new SimpleBean("a String", 42, false);
        this.runtimeService.setVariable(instance.getId(), "simpleBean", (Object)bean);
        SerializedVariableValue historicValue = ((HistoricVariableInstance)this.historyService.createHistoricVariableInstanceQuery().singleResult()).getSerializedValue();
        HistoricVariableDataFormatTest.assertNotNull((Object)historicValue);
        Map config = historicValue.getConfig();
        HistoricVariableDataFormatTest.assertEquals((int)2, (int)config.size());
        HistoricVariableDataFormatTest.assertEquals((Object)JSON_FORMAT_NAME, config.get("dataFormatId"));
        HistoricVariableDataFormatTest.assertEquals((Object)bean.getClass().getCanonicalName(), config.get("rootType"));
        String variableAsJson = (String)historicValue.getValue();
        JSONAssert.assertEquals((String)bean.toExpectedJsonString(), (String)variableAsJson, (boolean)true);
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/variables/oneTaskProcess.bpmn20.xml"})
    public void testSelectHistoricSerializedValuesUpdate() throws JSONException {
        ProcessInstance instance = this.runtimeService.startProcessInstanceByKey("oneTaskProcess");
        SimpleBean bean = new SimpleBean("a String", 42, false);
        this.runtimeService.setVariable(instance.getId(), "simpleBean", (Object)bean);
        if ("full".equals(this.processEngineConfiguration.getHistory())) {
            HistoricVariableUpdate historicUpdate = (HistoricVariableUpdate)this.historyService.createHistoricDetailQuery().variableUpdates().singleResult();
            HistoricVariableDataFormatTest.assertTrue((boolean)historicUpdate.storesCustomObjects());
            HistoricVariableDataFormatTest.assertEquals((String)Object.class.getSimpleName(), (String)historicUpdate.getValueTypeName());
            SerializedVariableValue serializedValue = historicUpdate.getSerializedValue();
            HistoricVariableDataFormatTest.assertNotNull((Object)serializedValue);
            Map config = serializedValue.getConfig();
            HistoricVariableDataFormatTest.assertEquals((int)2, (int)config.size());
            HistoricVariableDataFormatTest.assertEquals((Object)JSON_FORMAT_NAME, config.get("dataFormatId"));
            HistoricVariableDataFormatTest.assertEquals((Object)bean.getClass().getCanonicalName(), config.get("rootType"));
            String variableAsJson = (String)serializedValue.getValue();
            JSONAssert.assertEquals((String)bean.toExpectedJsonString(), (String)variableAsJson, (boolean)true);
        }
    }
}

