/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.test.variables;

import java.lang.constant.Constable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import junit.framework.TestCase;
import org.camunda.bpm.engine.BadUserRequestException;
import org.camunda.bpm.engine.ProcessEngine;
import org.camunda.bpm.engine.ProcessEngineConfiguration;
import org.camunda.bpm.engine.ProcessEngineException;
import org.camunda.bpm.engine.delegate.ProcessEngineVariableType;
import org.camunda.bpm.engine.delegate.SerializedVariableValue;
import org.camunda.bpm.engine.delegate.SerializedVariableValueBuilder;
import org.camunda.bpm.engine.impl.cfg.ProcessEngineConfigurationImpl;
import org.camunda.bpm.engine.impl.interceptor.Command;
import org.camunda.bpm.engine.impl.interceptor.CommandContext;
import org.camunda.bpm.engine.impl.persistence.entity.VariableInstanceEntity;
import org.camunda.bpm.engine.impl.spin.SpinSerializationType;
import org.camunda.bpm.engine.impl.spin.SpinVariableTypeResolver;
import org.camunda.bpm.engine.impl.test.AbstractProcessEngineTestCase;
import org.camunda.bpm.engine.runtime.ProcessInstance;
import org.camunda.bpm.engine.runtime.VariableInstance;
import org.camunda.bpm.engine.task.Task;
import org.camunda.bpm.engine.test.Deployment;
import org.camunda.bpm.engine.test.api.runtime.DummySerializable;
import org.camunda.bpm.engine.test.variables.FailingDeserializationBean;
import org.camunda.bpm.engine.test.variables.FailingSerializationBean;
import org.camunda.bpm.engine.test.variables.SimpleBean;
import org.camunda.spin.DataFormats;
import org.camunda.spin.impl.json.tree.JsonJacksonTreeDataFormat;
import org.json.JSONException;
import org.skyscreamer.jsonassert.JSONAssert;

public class VariableDataFormatTest
extends AbstractProcessEngineTestCase {
    protected static final String ONE_TASK_PROCESS = "org/camunda/bpm/engine/test/variables/oneTaskProcess.bpmn20.xml";
    protected static final String JSON_FORMAT_NAME = DataFormats.jsonTree().getName();

    protected void initializeProcessEngine() {
        ProcessEngineConfigurationImpl engineConfig = (ProcessEngineConfigurationImpl)ProcessEngineConfiguration.createProcessEngineConfigurationFromResource((String)"camunda.cfg.xml");
        engineConfig.setDefaultSerializationFormat(JSON_FORMAT_NAME);
        this.processEngine = engineConfig.buildProcessEngine();
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/variables/oneTaskProcess.bpmn20.xml"})
    public void testSerializationAsJson() throws JSONException {
        ProcessInstance instance = this.runtimeService.startProcessInstanceByKey("oneTaskProcess");
        SimpleBean bean = new SimpleBean("a String", 42, true);
        this.runtimeService.setVariable(instance.getId(), "simpleBean", (Object)bean);
        VariableInstance beanVariable = (VariableInstance)this.runtimeService.createVariableInstanceQuery().singleResult();
        VariableDataFormatTest.assertNotNull((Object)beanVariable);
        VariableDataFormatTest.assertEquals((String)ProcessEngineVariableType.SPIN.getName(), (String)beanVariable.getTypeName());
        SimpleBean returnedBean = (SimpleBean)beanVariable.getValue();
        VariableDataFormatTest.assertNotNull((Object)returnedBean);
        this.assertBeansEqual(returnedBean, bean);
        VariableInstanceEntity variableEntity = (VariableInstanceEntity)beanVariable;
        VariableDataFormatTest.assertEquals((String)JSON_FORMAT_NAME, (String)variableEntity.getDataFormatId());
        String persistedValue = (String)variableEntity.getSerializedValue().getValue();
        String expectedJson = bean.toExpectedJsonString();
        JSONAssert.assertEquals((String)expectedJson, (String)persistedValue, (boolean)true);
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/variables/oneTaskProcess.bpmn20.xml"})
    public void testListSerializationAsJson() throws JSONException {
        ProcessInstance instance = this.runtimeService.startProcessInstanceByKey("oneTaskProcess");
        ArrayList<SimpleBean> beans = new ArrayList<SimpleBean>();
        for (int i = 0; i < 20; ++i) {
            beans.add(new SimpleBean("a String" + i, 42 + i, true));
        }
        this.runtimeService.setVariable(instance.getId(), "simpleBeans", beans);
        VariableInstance beansVariable = (VariableInstance)this.runtimeService.createVariableInstanceQuery().singleResult();
        VariableDataFormatTest.assertNotNull((Object)beansVariable);
        VariableDataFormatTest.assertEquals((String)ProcessEngineVariableType.SPIN.getName(), (String)beansVariable.getTypeName());
        List returnedBeans = (List)beansVariable.getValue();
        VariableDataFormatTest.assertNotNull((Object)returnedBeans);
        VariableDataFormatTest.assertTrue((boolean)(returnedBeans instanceof ArrayList));
        this.assertListsEqual(beans, returnedBeans);
        VariableInstanceEntity variableEntity = (VariableInstanceEntity)beansVariable;
        VariableDataFormatTest.assertEquals((String)JSON_FORMAT_NAME, (String)variableEntity.getDataFormatId());
        String persistedValue = (String)variableEntity.getSerializedValue().getValue();
        String expectedJson = this.toExpectedJsonArray(beans);
        JSONAssert.assertEquals((String)expectedJson, (String)persistedValue, (boolean)true);
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/variables/oneTaskProcess.bpmn20.xml"})
    public void testFailingSerialization() {
        ProcessInstance instance = this.runtimeService.startProcessInstanceByKey("oneTaskProcess");
        FailingSerializationBean failingBean = new FailingSerializationBean("a String", 42, true);
        try {
            this.runtimeService.setVariable(instance.getId(), "simpleBean", (Object)failingBean);
            VariableDataFormatTest.fail((String)"exception expected");
        }
        catch (ProcessEngineException processEngineException) {
            // empty catch block
        }
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/variables/oneTaskProcess.bpmn20.xml"})
    public void testFailingDeserialization() {
        ProcessInstance instance = this.runtimeService.startProcessInstanceByKey("oneTaskProcess");
        FailingDeserializationBean failingBean = new FailingDeserializationBean("a String", 42, true);
        this.runtimeService.setVariable(instance.getId(), "simpleBean", (Object)failingBean);
        VariableInstance variableInstance = (VariableInstance)this.runtimeService.createVariableInstanceQuery().singleResult();
        VariableDataFormatTest.assertNull((Object)variableInstance.getValue());
        VariableDataFormatTest.assertNotNull((Object)variableInstance.getErrorMessage());
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/variables/oneTaskProcess.bpmn20.xml"})
    public void testSettingVariableExceedingTextFieldLength() throws JSONException {
        ProcessInstance instance = this.runtimeService.startProcessInstanceByKey("oneTaskProcess");
        List<SimpleBean> lengthExceedingBeans = this.getListOfBeansExceedingFieldLength();
        this.runtimeService.setVariable(instance.getId(), "simpleBeans", lengthExceedingBeans);
        VariableInstance beansVariable = (VariableInstance)this.runtimeService.createVariableInstanceQuery().singleResult();
        VariableDataFormatTest.assertNotNull((Object)beansVariable);
        VariableDataFormatTest.assertEquals((String)ProcessEngineVariableType.SPIN.getName(), (String)beansVariable.getTypeName());
        List returnedBeans = (List)beansVariable.getValue();
        VariableDataFormatTest.assertNotNull((Object)returnedBeans);
        VariableDataFormatTest.assertTrue((boolean)(returnedBeans instanceof ArrayList));
        this.assertListsEqual(lengthExceedingBeans, returnedBeans);
        VariableInstanceEntity variableEntity = (VariableInstanceEntity)beansVariable;
        String rawJson = (String)variableEntity.getSerializedValue().getValue();
        JSONAssert.assertEquals((String)this.toExpectedJsonArray(lengthExceedingBeans), (String)rawJson, (boolean)true);
    }

    protected List<SimpleBean> getListOfBeansExceedingFieldLength() {
        int textFieldLength = 4000;
        SimpleBean bean = new SimpleBean("a String", 42, true);
        String expectedJson = bean.toExpectedJsonString();
        int expectedBytesPerBean = expectedJson.getBytes().length;
        int beansToExceedFieldLength = textFieldLength / expectedBytesPerBean + 1;
        ArrayList<SimpleBean> lengthExceedingBeans = new ArrayList<SimpleBean>();
        for (int i = 0; i < beansToExceedFieldLength; ++i) {
            lengthExceedingBeans.add(new SimpleBean("a String", 42, true));
        }
        return lengthExceedingBeans;
    }

    public void testFailForNonExistingSerializationFormat() {
        ProcessEngineConfigurationImpl engineConfig = (ProcessEngineConfigurationImpl)ProcessEngineConfiguration.createProcessEngineConfigurationFromResource((String)"camunda.cfg.xml");
        engineConfig.setDefaultSerializationFormat("an unknown data format");
        try {
            engineConfig.buildProcessEngine();
            VariableDataFormatTest.fail((String)"Exception expected");
        }
        catch (ProcessEngineException processEngineException) {
            // empty catch block
        }
    }

    public void testConfigureSerializableFormat() {
        ProcessEngineConfigurationImpl engineConfig = (ProcessEngineConfigurationImpl)ProcessEngineConfiguration.createProcessEngineConfigurationFromResource((String)"camunda.cfg.xml");
        ProcessEngine engine = engineConfig.setDefaultSerializationFormat("java serializable").buildProcessEngine();
        String deploymentId = engine.getRepositoryService().createDeployment().addClasspathResource(ONE_TASK_PROCESS).deploy().getId();
        ProcessInstance instance = engine.getRuntimeService().startProcessInstanceByKey("oneTaskProcess");
        engine.getRuntimeService().setVariable(instance.getId(), "serializableVar", (Object)new DummySerializable());
        VariableInstance variable = (VariableInstance)engine.getRuntimeService().createVariableInstanceQuery().singleResult();
        VariableDataFormatTest.assertEquals((String)ProcessEngineVariableType.SERIALIZABLE.getName(), (String)variable.getTypeName());
        engine.getRepositoryService().deleteDeployment(deploymentId, true);
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/variables/oneTaskProcess.bpmn20.xml"})
    public void testVariableValueCaching() {
        final ProcessInstance instance = this.runtimeService.startProcessInstanceByKey("oneTaskProcess");
        this.processEngineConfiguration.getCommandExecutorTxRequired().execute((Command)new Command<Void>(){

            public Void execute(CommandContext commandContext) {
                SimpleBean bean = new SimpleBean("a String", 42, true);
                VariableDataFormatTest.this.runtimeService.setVariable(instance.getId(), "simpleBean", (Object)bean);
                Object returnedBean = VariableDataFormatTest.this.runtimeService.getVariable(instance.getId(), "simpleBean");
                TestCase.assertSame((Object)bean, (Object)returnedBean);
                return null;
            }
        });
        VariableInstance variableInstance = (VariableInstance)this.runtimeService.createVariableInstanceQuery().singleResult();
        Object returnedBean = variableInstance.getValue();
        Object theSameReturnedBean = variableInstance.getValue();
        VariableDataFormatTest.assertSame((Object)returnedBean, (Object)theSameReturnedBean);
    }

    public void testApplicationOfGlobalConfiguration() throws JSONException {
        DataFormats.jsonTreeGlobal().mapper().config("aKey", (Object)"aValue");
        SpinVariableTypeResolver resolver = new SpinVariableTypeResolver();
        SpinSerializationType variableType = (SpinSerializationType)resolver.getTypeForSerializationFormat(JSON_FORMAT_NAME);
        DataFormats.jsonTreeGlobal().mapper().config("aKey", null);
        JsonJacksonTreeDataFormat dataFormat = (JsonJacksonTreeDataFormat)variableType.getDefaultDataFormat();
        VariableDataFormatTest.assertNotSame((String)"The variable type should not use the global data format instance", (Object)DataFormats.jsonTreeGlobal(), (Object)dataFormat);
        VariableDataFormatTest.assertEquals((String)"The global configuration should have been applied to the variable type's format", (Object)"aValue", dataFormat.mapper().getConfiguration().get("aKey"));
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/variables/oneTaskProcess.bpmn20.xml"})
    public void testGetSerializedVariableValue() throws JSONException {
        ProcessInstance instance = this.runtimeService.startProcessInstanceByKey("oneTaskProcess");
        SimpleBean bean = new SimpleBean("a String", 42, true);
        this.runtimeService.setVariable(instance.getId(), "simpleBean", (Object)bean);
        VariableInstance beanVariable = (VariableInstance)this.runtimeService.createVariableInstanceQuery().singleResult();
        VariableDataFormatTest.assertNotNull((Object)beanVariable);
        VariableDataFormatTest.assertEquals((String)ProcessEngineVariableType.SPIN.getName(), (String)beanVariable.getTypeName());
        VariableDataFormatTest.assertEquals((String)Object.class.getSimpleName(), (String)beanVariable.getValueTypeName());
        VariableDataFormatTest.assertTrue((boolean)beanVariable.storesCustomObjects());
        SerializedVariableValue serializedVariable = beanVariable.getSerializedValue();
        Map config = serializedVariable.getConfig();
        VariableDataFormatTest.assertEquals((int)2, (int)config.size());
        VariableDataFormatTest.assertEquals((Object)JSON_FORMAT_NAME, config.get("dataFormatId"));
        VariableDataFormatTest.assertEquals((Object)bean.getClass().getCanonicalName(), config.get("rootType"));
        String variableAsJson = (String)serializedVariable.getValue();
        JSONAssert.assertEquals((String)bean.toExpectedJsonString(), (String)variableAsJson, (boolean)true);
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/variables/oneTaskProcess.bpmn20.xml"})
    public void testSetSerializedVariableValue() throws JSONException {
        ProcessInstance instance = this.runtimeService.startProcessInstanceByKey("oneTaskProcess");
        SimpleBean bean = new SimpleBean("a String", 42, true);
        String beanAsJson = bean.toExpectedJsonString();
        HashMap<String, String> variableConfig = new HashMap<String, String>();
        variableConfig.put("dataFormatId", JSON_FORMAT_NAME);
        variableConfig.put("rootType", bean.getClass().getCanonicalName());
        this.runtimeService.setVariableFromSerialized(instance.getId(), "simpleBean", (Object)beanAsJson, ProcessEngineVariableType.SPIN.getName(), variableConfig);
        VariableInstance variableInstance = (VariableInstance)this.runtimeService.createVariableInstanceQuery().singleResult();
        SimpleBean returnedBean = (SimpleBean)variableInstance.getValue();
        this.assertBeansEqual(bean, returnedBean);
        SerializedVariableValue serializedVariable = variableInstance.getSerializedValue();
        JSONAssert.assertEquals((String)beanAsJson, (String)((String)serializedVariable.getValue()), (boolean)true);
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/variables/oneTaskProcess.bpmn20.xml"})
    public void testSetSerializedVariableValueWithoutConfig() throws JSONException {
        ProcessInstance instance = this.runtimeService.startProcessInstanceByKey("oneTaskProcess");
        SimpleBean bean = new SimpleBean("a String", 42, true);
        String beanAsJson = bean.toExpectedJsonString();
        try {
            this.runtimeService.setVariableFromSerialized(instance.getId(), "simpleBean", (Object)beanAsJson, ProcessEngineVariableType.SPIN.getName(), null);
            VariableDataFormatTest.fail();
        }
        catch (BadUserRequestException e) {
            // empty catch block
        }
        try {
            this.runtimeService.setVariableFromSerialized(instance.getId(), "simpleBean", (Object)beanAsJson, ProcessEngineVariableType.SPIN.getName(), new HashMap());
            VariableDataFormatTest.fail();
        }
        catch (BadUserRequestException e) {
            // empty catch block
        }
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/variables/oneTaskProcess.bpmn20.xml"})
    public void testSetSerializedVariableValueWithMismatchingTypeConfig() throws JSONException {
        ProcessInstance instance = this.runtimeService.startProcessInstanceByKey("oneTaskProcess");
        SimpleBean bean = new SimpleBean("a String", 42, true);
        String beanAsJson = bean.toExpectedJsonString();
        HashMap<String, String> variableConfig = new HashMap<String, String>();
        variableConfig.put("dataFormatId", JSON_FORMAT_NAME);
        variableConfig.put("rootType", "a non-sensical class name");
        this.runtimeService.setVariableFromSerialized(instance.getId(), "simpleBean", (Object)beanAsJson, ProcessEngineVariableType.SPIN.getName(), variableConfig);
        this.assertCannotRetrieveVariable(instance.getId(), "simpleBean");
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/variables/oneTaskProcess.bpmn20.xml"})
    public void testSetSerializedVariableValueWithMismatchingDataFormatConfig() throws JSONException {
        ProcessInstance instance = this.runtimeService.startProcessInstanceByKey("oneTaskProcess");
        SimpleBean bean = new SimpleBean("a String", 42, true);
        String beanAsJson = bean.toExpectedJsonString();
        HashMap<String, String> variableConfig = new HashMap<String, String>();
        variableConfig.put("dataFormatId", "a non-existing data format");
        variableConfig.put("rootType", bean.getClass().getCanonicalName());
        try {
            this.runtimeService.setVariableFromSerialized(instance.getId(), "simpleBean", (Object)beanAsJson, ProcessEngineVariableType.SPIN.getName(), variableConfig);
            VariableDataFormatTest.fail();
        }
        catch (BadUserRequestException e) {
            // empty catch block
        }
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/variables/oneTaskProcess.bpmn20.xml"})
    public void testSetSerializedVariableValueExceedingFieldLength() throws JSONException {
        ProcessInstance instance = this.runtimeService.startProcessInstanceByKey("oneTaskProcess");
        List<SimpleBean> lengthExceedingBeans = this.getListOfBeansExceedingFieldLength();
        String beansAsJson = this.toExpectedJsonArray(lengthExceedingBeans);
        HashMap<String, String> variableConfig = new HashMap<String, String>();
        variableConfig.put("dataFormatId", JSON_FORMAT_NAME);
        variableConfig.put("rootType", "java.util.ArrayList<" + SimpleBean.class.getCanonicalName() + ">");
        this.runtimeService.setVariableFromSerialized(instance.getId(), "simpleBeans", (Object)beansAsJson, ProcessEngineVariableType.SPIN.getName(), variableConfig);
        List returnedBeans = (List)this.runtimeService.getVariable(instance.getId(), "simpleBeans");
        this.assertListsEqual(lengthExceedingBeans, returnedBeans);
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/variables/oneTaskProcess.bpmn20.xml"})
    public void testSetSerializedVariableValueWithConfigOfWrongType() {
        ProcessInstance instance = this.runtimeService.startProcessInstanceByKey("oneTaskProcess");
        SimpleBean bean = new SimpleBean("a String", 42, true);
        String beanAsJson = bean.toExpectedJsonString();
        HashMap<String, Constable> configuration = new HashMap<String, Constable>();
        configuration.put("dataFormatId", Integer.valueOf(42));
        configuration.put("rootType", Boolean.valueOf(true));
        try {
            this.runtimeService.setVariableFromSerialized(instance.getId(), "simpleBean", (Object)beanAsJson, ProcessEngineVariableType.SPIN.getName(), configuration);
            VariableDataFormatTest.fail();
        }
        catch (BadUserRequestException e) {
            // empty catch block
        }
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/variables/oneTaskProcess.bpmn20.xml"})
    public void testSetSerializedVariableNullValue() throws JSONException {
        ProcessInstance instance = this.runtimeService.startProcessInstanceByKey("oneTaskProcess");
        HashMap<String, String> variableConfig = new HashMap<String, String>();
        variableConfig.put("dataFormatId", JSON_FORMAT_NAME);
        variableConfig.put("rootType", "java.lang.Object");
        this.runtimeService.setVariableFromSerialized(instance.getId(), "simpleBean", null, ProcessEngineVariableType.SPIN.getName(), variableConfig);
        VariableInstance variable = (VariableInstance)this.runtimeService.createVariableInstanceQuery().singleResult();
        VariableDataFormatTest.assertNotNull((Object)variable);
        VariableDataFormatTest.assertEquals((String)"simpleBean", (String)variable.getName());
        VariableDataFormatTest.assertNull((Object)variable.getValue());
        SerializedVariableValue serializedValue = variable.getSerializedValue();
        VariableDataFormatTest.assertNotNull((Object)serializedValue);
        VariableDataFormatTest.assertNull((Object)serializedValue.getValue());
        VariableDataFormatTest.assertEquals((int)2, (int)serializedValue.getConfig().size());
        VariableDataFormatTest.assertEquals((Object)JSON_FORMAT_NAME, serializedValue.getConfig().get("dataFormatId"));
        VariableDataFormatTest.assertEquals((Object)"java.lang.Object", serializedValue.getConfig().get("rootType"));
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/variables/oneTaskProcess.bpmn20.xml"})
    public void testSerializedVarValue() {
        ProcessInstance instance = this.runtimeService.startProcessInstanceByKey("oneTaskProcess");
        SimpleBean simpleBean = new SimpleBean("someString", 1, true);
        SerializedVariableValue serializedValue = SerializedVariableValueBuilder.create().value((Object)simpleBean.toExpectedJsonString()).configValue("dataFormatId", (Object)JSON_FORMAT_NAME).configValue("rootType", (Object)SimpleBean.class.getCanonicalName()).done();
        this.runtimeService.setVariable(instance.getId(), "beanVariable", (Object)serializedValue);
        SimpleBean actualValue = (SimpleBean)this.runtimeService.getVariable(instance.getId(), "beanVariable");
        VariableDataFormatTest.assertEquals((Object)simpleBean, (Object)actualValue);
    }

    public void testDisabledDeserialization() {
        Task task = this.taskService.newTask();
        this.taskService.saveTask(task);
        HashMap<String, String> variableConfiguration = new HashMap<String, String>();
        variableConfiguration.put("rootType", "an.unavailable.JavaClass");
        variableConfiguration.put("dataFormatId", JSON_FORMAT_NAME);
        this.taskService.setVariableLocalFromSerialized(task.getId(), "variableWithoutClass", (Object)"{\"aKey\" : \"aValue\"}", ProcessEngineVariableType.SPIN.getName(), variableConfiguration);
        VariableInstance instance = (VariableInstance)this.runtimeService.createVariableInstanceQuery().disableCustomObjectDeserialization().singleResult();
        VariableDataFormatTest.assertNotNull((Object)instance);
        VariableDataFormatTest.assertNotNull((Object)instance.getSerializedValue());
        VariableDataFormatTest.assertNotNull((Object)instance.getSerializedValue().getValue());
        this.taskService.deleteTask(task.getId(), true);
    }

    protected void assertCannotRetrieveVariable(String scopeId, String variableName) {
        try {
            this.runtimeService.getVariable(scopeId, variableName);
            VariableDataFormatTest.fail();
        }
        catch (ProcessEngineException e) {
            // empty catch block
        }
        VariableInstance variableInstance = (VariableInstance)this.runtimeService.createVariableInstanceQuery().singleResult();
        VariableDataFormatTest.assertNotNull((Object)variableInstance);
        VariableDataFormatTest.assertNotNull((Object)variableInstance.getErrorMessage());
        VariableDataFormatTest.assertNull((Object)variableInstance.getValue());
    }

    protected void assertListsEqual(List<SimpleBean> expectedBeans, List<SimpleBean> actualBeans) {
        VariableDataFormatTest.assertEquals((int)expectedBeans.size(), (int)actualBeans.size());
        for (int i = 0; i < actualBeans.size(); ++i) {
            SimpleBean actualBean = actualBeans.get(i);
            SimpleBean expectedBean = expectedBeans.get(i);
            this.assertBeansEqual(expectedBean, actualBean);
        }
    }

    protected void assertBeansEqual(SimpleBean expectedBean, SimpleBean actualBean) {
        VariableDataFormatTest.assertEquals((String)expectedBean.getStringProperty(), (String)actualBean.getStringProperty());
        VariableDataFormatTest.assertEquals((int)expectedBean.getIntProperty(), (int)actualBean.getIntProperty());
        VariableDataFormatTest.assertEquals((boolean)expectedBean.getBooleanProperty(), (boolean)actualBean.getBooleanProperty());
    }

    protected String toExpectedJsonArray(List<SimpleBean> beans) {
        StringBuilder jsonBuilder = new StringBuilder();
        jsonBuilder.append("[");
        for (int i = 0; i < beans.size(); ++i) {
            jsonBuilder.append(beans.get(i).toExpectedJsonString());
            if (i == beans.size() - 1) continue;
            jsonBuilder.append(", ");
        }
        jsonBuilder.append("]");
        return jsonBuilder.toString();
    }
}

