/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.impl;

import java.util.Map;
import java.util.logging.Logger;
import org.camunda.bpm.engine.AuthorizationService;
import org.camunda.bpm.engine.CaseService;
import org.camunda.bpm.engine.FilterService;
import org.camunda.bpm.engine.FormService;
import org.camunda.bpm.engine.HistoryService;
import org.camunda.bpm.engine.IdentityService;
import org.camunda.bpm.engine.ManagementService;
import org.camunda.bpm.engine.ProcessEngine;
import org.camunda.bpm.engine.ProcessEngines;
import org.camunda.bpm.engine.RepositoryService;
import org.camunda.bpm.engine.RuntimeService;
import org.camunda.bpm.engine.TaskService;
import org.camunda.bpm.engine.impl.SchemaOperationProcessEngineClose;
import org.camunda.bpm.engine.impl.SchemaOperationsProcessEngineBuild;
import org.camunda.bpm.engine.impl.cfg.ProcessEngineConfigurationImpl;
import org.camunda.bpm.engine.impl.cfg.TransactionContextFactory;
import org.camunda.bpm.engine.impl.el.ExpressionManager;
import org.camunda.bpm.engine.impl.interceptor.CommandExecutor;
import org.camunda.bpm.engine.impl.interceptor.SessionFactory;
import org.camunda.bpm.engine.impl.jobexecutor.JobExecutor;

public class ProcessEngineImpl
implements ProcessEngine {
    private static Logger log = Logger.getLogger(ProcessEngineImpl.class.getName());
    protected String name;
    protected RepositoryService repositoryService;
    protected RuntimeService runtimeService;
    protected HistoryService historicDataService;
    protected IdentityService identityService;
    protected TaskService taskService;
    protected FormService formService;
    protected ManagementService managementService;
    protected AuthorizationService authorizationService;
    protected CaseService caseService;
    protected FilterService filterService;
    protected String databaseSchemaUpdate;
    protected JobExecutor jobExecutor;
    protected CommandExecutor commandExecutor;
    protected CommandExecutor commandExecutorSchemaOperations;
    protected Map<Class<?>, SessionFactory> sessionFactories;
    protected ExpressionManager expressionManager;
    protected int historyLevel;
    protected TransactionContextFactory transactionContextFactory;
    protected ProcessEngineConfigurationImpl processEngineConfiguration;

    public ProcessEngineImpl(ProcessEngineConfigurationImpl processEngineConfiguration) {
        this.processEngineConfiguration = processEngineConfiguration;
        this.name = processEngineConfiguration.getProcessEngineName();
        this.repositoryService = processEngineConfiguration.getRepositoryService();
        this.runtimeService = processEngineConfiguration.getRuntimeService();
        this.historicDataService = processEngineConfiguration.getHistoryService();
        this.identityService = processEngineConfiguration.getIdentityService();
        this.taskService = processEngineConfiguration.getTaskService();
        this.formService = processEngineConfiguration.getFormService();
        this.managementService = processEngineConfiguration.getManagementService();
        this.authorizationService = processEngineConfiguration.getAuthorizationService();
        this.caseService = processEngineConfiguration.getCaseService();
        this.filterService = processEngineConfiguration.getFilterService();
        this.databaseSchemaUpdate = processEngineConfiguration.getDatabaseSchemaUpdate();
        this.jobExecutor = processEngineConfiguration.getJobExecutor();
        this.commandExecutor = processEngineConfiguration.getCommandExecutorTxRequired();
        this.commandExecutorSchemaOperations = processEngineConfiguration.getCommandExecutorSchemaOperations();
        this.sessionFactories = processEngineConfiguration.getSessionFactories();
        this.historyLevel = processEngineConfiguration.getHistoryLevel();
        this.transactionContextFactory = processEngineConfiguration.getTransactionContextFactory();
        this.executeSchemaOperations();
        if (this.name == null) {
            log.info("default activiti ProcessEngine created");
        } else {
            log.info("ProcessEngine " + this.name + " created");
        }
        ProcessEngines.registerProcessEngine(this);
        if (this.jobExecutor != null) {
            this.jobExecutor.registerProcessEngine(this);
        }
    }

    protected void executeSchemaOperations() {
        this.commandExecutorSchemaOperations.execute(new SchemaOperationsProcessEngineBuild());
    }

    @Override
    public void close() {
        ProcessEngines.unregister(this);
        if (this.jobExecutor != null) {
            this.jobExecutor.unregisterProcessEngine(this);
        }
        this.commandExecutorSchemaOperations.execute(new SchemaOperationProcessEngineClose());
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public IdentityService getIdentityService() {
        return this.identityService;
    }

    @Override
    public ManagementService getManagementService() {
        return this.managementService;
    }

    @Override
    public TaskService getTaskService() {
        return this.taskService;
    }

    @Override
    public HistoryService getHistoryService() {
        return this.historicDataService;
    }

    @Override
    public RuntimeService getRuntimeService() {
        return this.runtimeService;
    }

    @Override
    public RepositoryService getRepositoryService() {
        return this.repositoryService;
    }

    @Override
    public FormService getFormService() {
        return this.formService;
    }

    @Override
    public AuthorizationService getAuthorizationService() {
        return this.authorizationService;
    }

    @Override
    public CaseService getCaseService() {
        return this.caseService;
    }

    @Override
    public FilterService getFilterService() {
        return this.filterService;
    }

    public ProcessEngineConfigurationImpl getProcessEngineConfiguration() {
        return this.processEngineConfiguration;
    }
}

