/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.impl.bpmn.behavior;

import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import org.camunda.bpm.engine.impl.bpmn.behavior.AbstractBpmnActivityBehavior;
import org.camunda.bpm.engine.impl.bpmn.behavior.MultiInstanceActivityBehavior;
import org.camunda.bpm.engine.impl.bpmn.parser.EventSubscriptionDeclaration;
import org.camunda.bpm.engine.impl.jobexecutor.TimerDeclarationImpl;
import org.camunda.bpm.engine.impl.persistence.entity.ExecutionEntity;
import org.camunda.bpm.engine.impl.pvm.delegate.ActivityExecution;
import org.camunda.bpm.engine.impl.pvm.process.ActivityImpl;

public class ParallelMultiInstanceBehavior
extends MultiInstanceActivityBehavior {
    public ParallelMultiInstanceBehavior(ActivityImpl activity, AbstractBpmnActivityBehavior originalActivityBehavior) {
        super(activity, originalActivityBehavior);
    }

    @Override
    protected void createInstances(ActivityExecution execution, int nrOfInstances) throws Exception {
        ActivityExecution concurrentExecution;
        int loopCounter;
        this.setLoopVariable(execution, "nrOfInstances", nrOfInstances);
        this.setLoopVariable(execution, "nrOfCompletedInstances", 0);
        this.setLoopVariable(execution, "nrOfActiveInstances", nrOfInstances);
        this.fixMiRootActivityInstanceId(execution);
        ArrayList<ActivityExecution> concurrentExecutions = new ArrayList<ActivityExecution>();
        for (loopCounter = 0; loopCounter < nrOfInstances; ++loopCounter) {
            concurrentExecution = execution.createExecution(loopCounter != 0);
            concurrentExecution.setActive(true);
            concurrentExecution.setConcurrent(true);
            concurrentExecution.setScope(false);
            if (this.isExtraScopeNeeded()) {
                ActivityExecution extraScopedExecution = concurrentExecution.createExecution();
                extraScopedExecution.setActive(true);
                extraScopedExecution.setConcurrent(false);
                extraScopedExecution.setScope(true);
                concurrentExecution = extraScopedExecution;
            }
            for (EventSubscriptionDeclaration declaration : EventSubscriptionDeclaration.getDeclarationsForScope(execution.getActivity())) {
                declaration.createSubscriptionForParallelMultiInstance((ExecutionEntity)concurrentExecution);
            }
            List timerDeclarations = (List)concurrentExecution.getActivity().getProperty("timerDeclarations");
            if (timerDeclarations != null) {
                for (TimerDeclarationImpl timerDeclaration : timerDeclarations) {
                    timerDeclaration.createTimerInstanceForParallelMultiInstance((ExecutionEntity)concurrentExecution);
                }
            }
            concurrentExecutions.add(concurrentExecution);
            this.logLoopDetails(concurrentExecution, "initialized", loopCounter, 0, nrOfInstances, nrOfInstances);
        }
        for (loopCounter = 0; loopCounter < nrOfInstances; ++loopCounter) {
            concurrentExecution = (ActivityExecution)concurrentExecutions.get(loopCounter);
            if (!concurrentExecution.isActive() || concurrentExecution.isEnded() || !concurrentExecution.getParent().isActive() || concurrentExecution.getParent().isEnded()) continue;
            this.setLoopVariable(concurrentExecution, "loopCounter", loopCounter);
            this.executeOriginalBehavior(concurrentExecution, loopCounter);
        }
        if (!concurrentExecutions.isEmpty()) {
            execution.inactivate();
        }
    }

    @Override
    public void leave(ActivityExecution execution) {
        if (!this.isExtraScopeNeeded() && !execution.getActivityInstanceId().equals(execution.getParent().getActivityInstanceId())) {
            this.callActivityEndListeners(execution);
        }
        int loopCounter = this.getLoopVariable(execution, "loopCounter");
        int nrOfInstances = this.getLoopVariable(execution, "nrOfInstances");
        int nrOfCompletedInstances = this.getLoopVariable(execution, "nrOfCompletedInstances") + 1;
        int nrOfActiveInstances = this.getLoopVariable(execution, "nrOfActiveInstances") - 1;
        if (this.isExtraScopeNeeded()) {
            this.resetMiRootActivityInstanceId(execution);
            ExecutionEntity extraScope = (ExecutionEntity)execution;
            execution = execution.getParent();
            extraScope.remove();
        }
        this.setLoopVariable(execution.getParent(), "nrOfCompletedInstances", nrOfCompletedInstances);
        this.setLoopVariable(execution.getParent(), "nrOfActiveInstances", nrOfActiveInstances);
        this.logLoopDetails(execution, "instance completed", loopCounter, nrOfCompletedInstances, nrOfActiveInstances, nrOfInstances);
        ExecutionEntity executionEntity = (ExecutionEntity)execution;
        executionEntity.removeEventSubscriptions();
        executionEntity.inactivate();
        executionEntity.getParent().forceUpdate();
        List<ActivityExecution> joinedExecutions = executionEntity.findInactiveConcurrentExecutions(execution.getActivity());
        if (joinedExecutions.size() == nrOfInstances || this.completionConditionSatisfied(execution)) {
            this.resetMiRootActivityInstanceId(execution);
            ArrayList<ExecutionEntity> executionsToRemove = new ArrayList<ExecutionEntity>();
            for (ExecutionEntity childExecution : executionEntity.getParent().getExecutions()) {
                if (!childExecution.isActive()) continue;
                executionsToRemove.add(childExecution);
            }
            for (ExecutionEntity executionToRemove : executionsToRemove) {
                if (LOGGER.isLoggable(Level.FINE)) {
                    LOGGER.fine("Execution " + executionToRemove + " still active, " + "but multi-instance is completed. Removing this execution.");
                }
                executionToRemove.inactivate();
                executionToRemove.deleteCascade("multi-instance completed");
            }
            executionEntity.takeAll(this.activity.getOutgoingTransitions(), joinedExecutions);
        } else if (this.isExtraScopeNeeded()) {
            this.callActivityEndListeners(execution);
        } else {
            executionEntity.setActivityInstanceId(null);
        }
    }

    protected void fixMiRootActivityInstanceId(ActivityExecution execution) {
        ActivityExecution miRoot = execution.getParent();
        miRoot.setActivityInstanceId(miRoot.getParentActivityInstanceId());
    }

    protected void resetMiRootActivityInstanceId(ActivityExecution execution) {
        ActivityExecution miEnteringExecution = execution.getParent();
        ActivityExecution miRoot = miEnteringExecution.getParent();
        miRoot.setActivityInstanceId(miEnteringExecution.getActivityInstanceId());
    }
}

