/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.impl.bpmn.behavior;

import org.camunda.bpm.connect.Connector;
import org.camunda.bpm.connect.ConnectorRequest;
import org.camunda.bpm.connect.ConnectorResponse;
import org.camunda.bpm.engine.ProcessEngineException;
import org.camunda.bpm.engine.impl.bpmn.behavior.TaskActivityBehavior;
import org.camunda.bpm.engine.impl.connector.ConnectorVariableScope;
import org.camunda.bpm.engine.impl.connector.Connectors;
import org.camunda.bpm.engine.impl.context.Context;
import org.camunda.bpm.engine.impl.core.mapping.IoMapping;
import org.camunda.bpm.engine.impl.core.variable.CoreVariableScope;
import org.camunda.bpm.engine.impl.pvm.delegate.ActivityExecution;

public class ServiceTaskConnectorActivityBehavior
extends TaskActivityBehavior {
    protected String connectorId;
    protected Connector<ConnectorRequest<?>> connectorInstance;
    protected IoMapping ioMapping;

    public ServiceTaskConnectorActivityBehavior(String connectorId, IoMapping ioMapping) {
        this.connectorId = connectorId;
        this.ioMapping = ioMapping;
    }

    @Override
    public void execute(ActivityExecution execution) throws Exception {
        this.ensureConnectorInitialized();
        ConnectorRequest request = this.connectorInstance.createRequest();
        ConnectorVariableScope connectorInputVariableScope = new ConnectorVariableScope((CoreVariableScope)((Object)execution));
        ConnectorVariableScope connectorOuputVariableScope = new ConnectorVariableScope((CoreVariableScope)((Object)execution));
        if (this.ioMapping != null) {
            this.ioMapping.executeInputParameters(connectorInputVariableScope);
            connectorInputVariableScope.writeToRequest(request);
        }
        try {
            ConnectorResponse response = request.execute();
            if (this.ioMapping != null) {
                connectorOuputVariableScope.readFromResponse(response);
                this.ioMapping.executeOutputParameters(connectorOuputVariableScope);
            }
            this.leave(execution);
        }
        catch (Exception e) {
            throw new ProcessEngineException("Exception while invoking connector " + e.getMessage(), e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void ensureConnectorInitialized() {
        if (this.connectorInstance == null) {
            ServiceTaskConnectorActivityBehavior serviceTaskConnectorActivityBehavior = this;
            synchronized (serviceTaskConnectorActivityBehavior) {
                if (this.connectorInstance == null) {
                    Connectors connectors = Context.getProcessEngineConfiguration().getConnectors();
                    this.connectorInstance = connectors.crateConnectorInstance(this.connectorId);
                }
            }
        }
    }
}

