/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.impl.cmd;

import java.util.Map;
import org.camunda.bpm.engine.delegate.PersistentVariableScope;
import org.camunda.bpm.engine.impl.interceptor.Command;
import org.camunda.bpm.engine.impl.interceptor.CommandContext;
import org.camunda.bpm.engine.impl.util.EnsureUtil;

public abstract class SetScopeVariableFromSerializedCmd
implements Command<Void> {
    protected boolean isLocal;
    protected String variableName;
    protected Object serializedVariableValue;
    protected String variableType;
    protected Map<String, Object> configuration;
    protected String scopeId;

    public SetScopeVariableFromSerializedCmd(String scopeId, String variableName, Object serializedVariableValue, String variableType, Map<String, Object> configuration, boolean isLocal) {
        this.isLocal = isLocal;
        this.variableName = variableName;
        this.serializedVariableValue = serializedVariableValue;
        this.variableType = variableType;
        this.configuration = configuration;
        this.scopeId = scopeId;
    }

    @Override
    public Void execute(CommandContext commandContext) {
        EnsureUtil.ensureNotNull("variableType", (Object)this.variableType);
        PersistentVariableScope scope = this.getPersistentVariableScope(commandContext);
        if (this.isLocal) {
            scope.setVariableLocalFromSerialized(this.variableName, this.serializedVariableValue, this.variableType, this.configuration);
        } else {
            scope.setVariableFromSerialized(this.variableName, this.serializedVariableValue, this.variableType, this.configuration);
        }
        return null;
    }

    protected abstract PersistentVariableScope getPersistentVariableScope(CommandContext var1);
}

