/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.impl.cmmn.behavior;

import java.util.List;
import org.camunda.bpm.engine.exception.cmmn.CaseIllegalStateTransitionException;
import org.camunda.bpm.engine.impl.cmmn.CaseControlRule;
import org.camunda.bpm.engine.impl.cmmn.behavior.CmmnActivityBehavior;
import org.camunda.bpm.engine.impl.cmmn.execution.CaseExecutionState;
import org.camunda.bpm.engine.impl.cmmn.execution.CmmnActivityExecution;
import org.camunda.bpm.engine.impl.cmmn.model.CmmnActivity;
import org.camunda.bpm.engine.impl.cmmn.model.CmmnSentryDeclaration;
import org.camunda.bpm.engine.impl.pvm.PvmException;

public abstract class PlanItemDefinitionActivityBehavior
implements CmmnActivityBehavior {
    @Override
    public void execute(CmmnActivityExecution execution) throws Exception {
    }

    protected boolean isEntryCriteriaSatisfied(CmmnActivityExecution execution) {
        String id = execution.getId();
        CmmnActivity activity = execution.getActivity();
        if (activity != null) {
            List<CmmnSentryDeclaration> entryCriteria = activity.getEntryCriteria();
            if (entryCriteria != null && !entryCriteria.isEmpty()) {
                CmmnActivityExecution parent = execution.getParent();
                if (parent != null) {
                    for (CmmnSentryDeclaration sentryDeclaration : entryCriteria) {
                        String sentryId = sentryDeclaration.getId();
                        if (!parent.isSentrySatisfied(sentryId)) continue;
                        return true;
                    }
                    return false;
                }
                throw new PvmException("Case execution '" + id + "': has no parent.");
            }
            return true;
        }
        throw new PvmException("Case execution '" + id + "': has no current activity.");
    }

    protected boolean isExitCriteriaSatisfied(CmmnActivityExecution execution) {
        String id = execution.getId();
        CmmnActivity activity = execution.getActivity();
        if (activity != null) {
            List<CmmnSentryDeclaration> exitCriteria = activity.getExitCriteria();
            if (exitCriteria != null && !exitCriteria.isEmpty()) {
                CmmnActivityExecution parent = execution.getParent();
                if (parent != null) {
                    for (CmmnSentryDeclaration sentryDeclaration : exitCriteria) {
                        String sentryId = sentryDeclaration.getId();
                        if (!parent.isSentrySatisfied(sentryId)) continue;
                        return true;
                    }
                    return false;
                }
                throw new PvmException("Case execution '" + id + "': has no parent.");
            }
            return false;
        }
        throw new PvmException("Case execution '" + id + "': has no current activity.");
    }

    @Override
    public void created(CmmnActivityExecution execution) {
        if (this.isExitCriteriaSatisfied(execution)) {
            this.triggerExitCriteria(execution);
            return;
        }
        if (this.isEntryCriteriaSatisfied(execution)) {
            this.triggerEntryCriteria(execution);
        }
    }

    @Override
    public void triggerExitCriteria(CmmnActivityExecution execution) {
        execution.exit();
    }

    @Override
    public void onCreate(CmmnActivityExecution execution) {
        this.ensureTransitionAllowed(execution, CaseExecutionState.NEW, CaseExecutionState.AVAILABLE, "create");
        this.creating(execution);
    }

    @Override
    public void onClose(CmmnActivityExecution execution) {
        String id = execution.getId();
        if (execution.isCaseInstanceExecution()) {
            if (execution.isClosed()) {
                String message = "Case instance'" + id + "' is already closed.";
                throw this.createIllegalStateTransitionException("close", message, execution);
            }
            if (execution.isActive()) {
                String message = "Case instance '" + id + "' must be {completed|terminated|suspended} to close it, but was 'active'.";
                throw this.createIllegalStateTransitionException("close", message, execution);
            }
        } else {
            String message = "It is not possible to close case execution '" + id + "' which is not a case instance.";
            throw this.createIllegalStateTransitionException("close", message, execution);
        }
    }

    protected void creating(CmmnActivityExecution execution) {
    }

    protected void terminating(CmmnActivityExecution execution) {
    }

    protected void completing(CmmnActivityExecution execution) {
    }

    protected void manualCompleting(CmmnActivityExecution execution) {
    }

    protected void suspending(CmmnActivityExecution execution) {
    }

    protected void resuming(CmmnActivityExecution execution) {
    }

    @Override
    public void resumed(CmmnActivityExecution execution) {
    }

    @Override
    public void reactivated(CmmnActivityExecution execution) {
    }

    @Override
    public void started(CmmnActivityExecution execution) {
    }

    protected void evaluateRequiredRule(CmmnActivityExecution execution) {
        CmmnActivity activity = execution.getActivity();
        Object requiredRule = activity.getProperty("requiredRule");
        if (requiredRule != null) {
            CaseControlRule rule = (CaseControlRule)requiredRule;
            boolean required = rule.evaluate(execution);
            execution.setRequired(required);
        }
    }

    protected void evaluateRepetitionRule(CmmnActivityExecution execution) {
        CmmnActivity activity = execution.getActivity();
        Object repetitionRule = activity.getProperty("repetitionRule");
        if (repetitionRule != null) {
            CaseControlRule rule = (CaseControlRule)repetitionRule;
            rule.evaluate(execution);
        }
    }

    protected void ensureTransitionAllowed(CmmnActivityExecution execution, CaseExecutionState expected, CaseExecutionState target, String transition) {
        String id = execution.getId();
        CaseExecutionState currentState = execution.getCurrentState();
        if (target.equals(currentState)) {
            String message = "Case execution '" + id + "' is already " + target + ".";
            throw this.createIllegalStateTransitionException(transition, message, execution);
        }
        if (!expected.equals(currentState)) {
            String message = "Case execution '" + id + "' must be " + expected + " to " + transition + " it, but was " + currentState + ".";
            throw this.createIllegalStateTransitionException(transition, message, execution);
        }
    }

    protected void ensureNotCaseInstance(CmmnActivityExecution execution, String transition) {
        if (execution.isCaseInstanceExecution()) {
            String id = execution.getId();
            String message = "It is not possible to " + transition + " case instance '" + id + "'.";
            throw this.createIllegalStateTransitionException(transition, message, execution);
        }
    }

    protected CaseIllegalStateTransitionException createIllegalStateTransitionException(String transition, String message, CmmnActivityExecution execution) {
        String id = execution.getId();
        String errorMessage = String.format("Could not perform transition '%s' on case execution '%s': %s", transition, id, message);
        return new CaseIllegalStateTransitionException(errorMessage);
    }
}

