/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.impl.cmmn.behavior;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.camunda.bpm.engine.delegate.VariableScope;
import org.camunda.bpm.engine.impl.cmmn.behavior.CallableElement;
import org.camunda.bpm.engine.impl.cmmn.behavior.CallableElementParameter;
import org.camunda.bpm.engine.impl.cmmn.behavior.TaskActivityBehavior;
import org.camunda.bpm.engine.impl.cmmn.behavior.TransferVariablesActivityBehavior;
import org.camunda.bpm.engine.impl.cmmn.entity.repository.CaseDefinitionEntity;
import org.camunda.bpm.engine.impl.cmmn.execution.CmmnActivityExecution;
import org.camunda.bpm.engine.impl.cmmn.execution.CmmnExecution;
import org.camunda.bpm.engine.impl.cmmn.model.CmmnCaseDefinition;
import org.camunda.bpm.engine.impl.core.variable.CoreVariableScope;

public abstract class ProcessOrCaseTaskActivityBehavior
extends TaskActivityBehavior
implements TransferVariablesActivityBehavior {
    protected CallableElement callableElement;

    @Override
    protected void performStart(CmmnActivityExecution execution) {
        CmmnExecution caseExecution = (CmmnExecution)execution;
        List<CallableElementParameter> inputs = this.callableElement.getInputs();
        Map<String, Object> variables = this.getVariables(inputs, caseExecution);
        String businessKey = this.callableElement.getBusinessKey(caseExecution);
        this.triggerCallableElement(caseExecution, variables, businessKey);
        if (caseExecution.isActive() && !this.isBlocking(caseExecution)) {
            caseExecution.complete();
        }
    }

    @Override
    public void transferVariables(VariableScope<?> from, VariableScope<?> to) {
        CoreVariableScope fromVariableScope = (CoreVariableScope)from;
        List<CallableElementParameter> outputs = this.callableElement.getOutputs();
        Map<String, Object> variables = this.getVariables(outputs, fromVariableScope);
        to.setVariables(variables);
    }

    protected Map<String, Object> getVariables(List<CallableElementParameter> params, CoreVariableScope<?> variableScope) {
        HashMap<String, Object> result = new HashMap<String, Object>();
        for (CallableElementParameter param : params) {
            if (param.isAllVariables()) {
                Map<String, Object> allVariables = variableScope.getVariables();
                result.putAll(allVariables);
                continue;
            }
            String targetVariableName = param.getTarget();
            Object value = param.getSource(variableScope);
            result.put(targetVariableName, value);
        }
        return result;
    }

    public CallableElement getCallableElement() {
        return this.callableElement;
    }

    public void setCallableElement(CallableElement callableElement) {
        this.callableElement = callableElement;
    }

    protected String getDefinitionKey(CmmnActivityExecution execution) {
        CmmnExecution caseExecution = (CmmnExecution)execution;
        return this.getCallableElement().getDefinitionKey(caseExecution);
    }

    protected CallableElement.CallableElementBinding getBinding() {
        return this.getCallableElement().getBinding();
    }

    protected Integer getVersion(CmmnActivityExecution execution) {
        CmmnExecution caseExecution = (CmmnExecution)execution;
        return this.getCallableElement().getVersion(caseExecution);
    }

    protected String getDeploymentId(CmmnActivityExecution execution) {
        CmmnExecution caseExecution = (CmmnExecution)execution;
        CmmnCaseDefinition definition = caseExecution.getCaseDefinition();
        if (definition instanceof CaseDefinitionEntity) {
            CaseDefinitionEntity caseDefinition = (CaseDefinitionEntity)definition;
            return caseDefinition.getDeploymentId();
        }
        return null;
    }

    protected boolean isLatestBinding() {
        CallableElement.CallableElementBinding binding = this.getBinding();
        return binding == null || CallableElement.CallableElementBinding.LATEST.equals((Object)binding);
    }

    protected boolean isDeploymentBinding() {
        CallableElement.CallableElementBinding binding = this.getBinding();
        return CallableElement.CallableElementBinding.DEPLOYMENT.equals((Object)binding);
    }

    protected boolean isVersionBinding() {
        CallableElement.CallableElementBinding binding = this.getBinding();
        return CallableElement.CallableElementBinding.VERSION.equals((Object)binding);
    }

    protected abstract void triggerCallableElement(CmmnActivityExecution var1, Map<String, Object> var2, String var3);
}

