/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.impl.cmmn.behavior;

import org.camunda.bpm.engine.impl.cmmn.CaseControlRule;
import org.camunda.bpm.engine.impl.cmmn.behavior.PlanItemDefinitionActivityBehavior;
import org.camunda.bpm.engine.impl.cmmn.execution.CaseExecutionState;
import org.camunda.bpm.engine.impl.cmmn.execution.CmmnActivityExecution;
import org.camunda.bpm.engine.impl.cmmn.model.CmmnActivity;

public abstract class StageOrTaskActivityBehavior
extends PlanItemDefinitionActivityBehavior {
    @Override
    protected void creating(CmmnActivityExecution execution) {
        this.evaluateRequiredRule(execution);
        this.evaluateRepetitionRule(execution);
    }

    @Override
    public void onEnable(CmmnActivityExecution execution) {
        this.ensureNotCaseInstance(execution, "enable");
        this.ensureTransitionAllowed(execution, CaseExecutionState.AVAILABLE, CaseExecutionState.ENABLED, "enable");
    }

    @Override
    public void onReenable(CmmnActivityExecution execution) {
        this.ensureNotCaseInstance(execution, "re-enable");
        this.ensureTransitionAllowed(execution, CaseExecutionState.DISABLED, CaseExecutionState.ENABLED, "re-enable");
    }

    @Override
    public void onDisable(CmmnActivityExecution execution) {
        this.ensureNotCaseInstance(execution, "disable");
        this.ensureTransitionAllowed(execution, CaseExecutionState.ENABLED, CaseExecutionState.DISABLED, "disable");
    }

    @Override
    public void onStart(CmmnActivityExecution execution) {
        this.ensureNotCaseInstance(execution, "start");
        this.ensureTransitionAllowed(execution, CaseExecutionState.AVAILABLE, CaseExecutionState.ACTIVE, "start");
    }

    @Override
    public void onManualStart(CmmnActivityExecution execution) {
        this.ensureNotCaseInstance(execution, "manualStart");
        this.ensureTransitionAllowed(execution, CaseExecutionState.ENABLED, CaseExecutionState.ACTIVE, "start");
    }

    @Override
    public void onCompletion(CmmnActivityExecution execution) {
        this.ensureTransitionAllowed(execution, CaseExecutionState.ACTIVE, CaseExecutionState.COMPLETED, "complete");
        this.completing(execution);
    }

    @Override
    public void onManualCompletion(CmmnActivityExecution execution) {
        this.ensureTransitionAllowed(execution, CaseExecutionState.ACTIVE, CaseExecutionState.COMPLETED, "complete");
        this.manualCompleting(execution);
    }

    @Override
    public void onTermination(CmmnActivityExecution execution) {
        this.ensureTransitionAllowed(execution, CaseExecutionState.ACTIVE, CaseExecutionState.TERMINATED, "terminate");
        this.terminating(execution);
    }

    @Override
    public void onParentTermination(CmmnActivityExecution execution) {
        String id = execution.getId();
        String message = "It is not possible to parentTerminate case execution '" + id + "' which associated with a " + this.getTypeName() + ".";
        throw this.createIllegalStateTransitionException("parentTerminate", message, execution);
    }

    @Override
    public void onExit(CmmnActivityExecution execution) {
        String id = execution.getId();
        if (execution.isTerminated()) {
            String message = "Case execution '" + id + "' is already terminated.";
            throw this.createIllegalStateTransitionException("exit", message, execution);
        }
        if (execution.isCompleted()) {
            String message = "Case execution '" + id + "' must be {available|enabled|disabled|active|failed|suspended} to exit it, but was completed.";
            throw this.createIllegalStateTransitionException("exit", message, execution);
        }
        this.terminating(execution);
    }

    @Override
    public void onOccur(CmmnActivityExecution execution) {
        String id = execution.getId();
        String message = "It is not possible to occur case execution '" + id + "' which associated with a " + this.getTypeName() + ".";
        throw this.createIllegalStateTransitionException("occur", message, execution);
    }

    @Override
    public void onSuspension(CmmnActivityExecution execution) {
        this.ensureTransitionAllowed(execution, CaseExecutionState.ACTIVE, CaseExecutionState.SUSPENDED, "suspend");
        this.suspending(execution);
    }

    @Override
    public void onParentSuspension(CmmnActivityExecution execution) {
        this.ensureNotCaseInstance(execution, "parentSuspension");
        String id = execution.getId();
        if (execution.isSuspended()) {
            String message = "Case execution '" + id + "' is already suspended.";
            throw this.createIllegalStateTransitionException("parentSuspend", message, execution);
        }
        if (execution.isCompleted() || execution.isTerminated()) {
            String message = "Case execution '" + id + "' must be {available|enabled|disabled|active} to suspend it, but was " + execution.getCurrentState() + ".";
            throw this.createIllegalStateTransitionException("parentSuspend", message, execution);
        }
        this.suspending(execution);
    }

    @Override
    public void onResume(CmmnActivityExecution execution) {
        this.ensureNotCaseInstance(execution, "resume");
        this.ensureTransitionAllowed(execution, CaseExecutionState.SUSPENDED, CaseExecutionState.ACTIVE, "resume");
        CmmnActivityExecution parent = execution.getParent();
        if (parent != null && !parent.isActive()) {
            String id = execution.getId();
            String message = "It is not possible to resume case execution '" + id + "' which parent is not active.";
            throw this.createIllegalStateTransitionException("resume", message, execution);
        }
        this.resuming(execution);
    }

    @Override
    public void onParentResume(CmmnActivityExecution execution) {
        this.ensureNotCaseInstance(execution, "parentResume");
        String id = execution.getId();
        if (!execution.isSuspended()) {
            String message = "Case execution '" + id + "' must be suspended to resume it, but was " + execution.getCurrentState() + ".";
            throw this.createIllegalStateTransitionException("parentResume", message, execution);
        }
        CmmnActivityExecution parent = execution.getParent();
        if (parent != null && !parent.isActive()) {
            String message = "It is not possible to resume case execution '" + id + "' which parent is not active.";
            throw this.createIllegalStateTransitionException("parentResume", message, execution);
        }
        this.resuming(execution);
    }

    @Override
    public void started(CmmnActivityExecution execution) {
        if (execution.isActive()) {
            this.performStart(execution);
        }
    }

    protected abstract void performStart(CmmnActivityExecution var1);

    protected abstract String getTypeName();

    @Override
    public void triggerEntryCriteria(CmmnActivityExecution execution) {
        CmmnActivity activity = execution.getActivity();
        boolean manualActivation = true;
        Object manualActivationRule = activity.getProperty("manualActivationRule");
        if (manualActivationRule != null) {
            CaseControlRule rule = (CaseControlRule)manualActivationRule;
            manualActivation = rule.evaluate(execution);
        }
        if (manualActivation) {
            execution.enable();
        } else {
            execution.start();
        }
    }
}

