/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.impl.cmmn.cmd;

import java.io.Serializable;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.camunda.bpm.engine.exception.cmmn.CaseExecutionNotFoundException;
import org.camunda.bpm.engine.impl.cmmn.entity.runtime.CaseExecutionEntity;
import org.camunda.bpm.engine.impl.interceptor.Command;
import org.camunda.bpm.engine.impl.interceptor.CommandContext;
import org.camunda.bpm.engine.impl.util.EnsureUtil;

public class GetCaseExecutionVariablesCmd
implements Command<Map<String, Object>>,
Serializable {
    private static final long serialVersionUID = 1L;
    protected String caseExecutionId;
    protected Collection<String> variableNames;
    protected boolean isLocal;

    public GetCaseExecutionVariablesCmd(String caseExecutionId, Collection<String> variableNames, boolean isLocal) {
        this.caseExecutionId = caseExecutionId;
        this.variableNames = variableNames;
        this.isLocal = isLocal;
    }

    @Override
    public Map<String, Object> execute(CommandContext commandContext) {
        EnsureUtil.ensureNotNull("caseExecutionId", (Object)this.caseExecutionId);
        CaseExecutionEntity caseExecution = commandContext.getCaseExecutionManager().findCaseExecutionById(this.caseExecutionId);
        EnsureUtil.ensureNotNull(CaseExecutionNotFoundException.class, "case execution " + this.caseExecutionId + " doesn't exist", "caseExecution", (Object)caseExecution);
        Map<String, Object> caseExecutionVariables = this.isLocal ? caseExecution.getVariablesLocal() : caseExecution.getVariables();
        if (this.variableNames != null && this.variableNames.size() > 0) {
            HashMap<String, Object> tempVariables = new HashMap<String, Object>();
            for (String variableName : this.variableNames) {
                if (!caseExecutionVariables.containsKey(variableName)) continue;
                tempVariables.put(variableName, caseExecutionVariables.get(variableName));
            }
            caseExecutionVariables = tempVariables;
        }
        return caseExecutionVariables;
    }
}

