/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.impl.cmmn.entity.runtime;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.camunda.bpm.engine.ProcessEngineException;
import org.camunda.bpm.engine.ProcessEngineServices;
import org.camunda.bpm.engine.impl.cmmn.entity.repository.CaseDefinitionEntity;
import org.camunda.bpm.engine.impl.cmmn.entity.runtime.CaseExecutionEntityVariableStore;
import org.camunda.bpm.engine.impl.cmmn.entity.runtime.CaseSentryPartEntity;
import org.camunda.bpm.engine.impl.cmmn.execution.CmmnExecution;
import org.camunda.bpm.engine.impl.cmmn.execution.CmmnSentryPart;
import org.camunda.bpm.engine.impl.cmmn.model.CmmnActivity;
import org.camunda.bpm.engine.impl.cmmn.model.CmmnCaseDefinition;
import org.camunda.bpm.engine.impl.cmmn.operation.CmmnAtomicOperation;
import org.camunda.bpm.engine.impl.context.Context;
import org.camunda.bpm.engine.impl.core.instance.CoreExecution;
import org.camunda.bpm.engine.impl.core.operation.CoreAtomicOperation;
import org.camunda.bpm.engine.impl.core.variable.CorePersistentVariableStore;
import org.camunda.bpm.engine.impl.db.DbEntity;
import org.camunda.bpm.engine.impl.db.HasDbReferences;
import org.camunda.bpm.engine.impl.db.HasDbRevision;
import org.camunda.bpm.engine.impl.interceptor.CommandContext;
import org.camunda.bpm.engine.impl.persistence.entity.ExecutionEntity;
import org.camunda.bpm.engine.impl.persistence.entity.VariableInstanceEntity;
import org.camunda.bpm.engine.impl.pvm.PvmProcessDefinition;
import org.camunda.bpm.engine.impl.pvm.runtime.PvmExecutionImpl;
import org.camunda.bpm.engine.runtime.CaseExecution;
import org.camunda.bpm.engine.runtime.CaseInstance;
import org.camunda.bpm.model.cmmn.CmmnModelInstance;
import org.camunda.bpm.model.cmmn.instance.CmmnElement;
import org.camunda.bpm.model.xml.instance.ModelElementInstance;
import org.camunda.bpm.model.xml.type.ModelElementType;

public class CaseExecutionEntity
extends CmmnExecution
implements CaseExecution,
CaseInstance,
DbEntity,
HasDbRevision,
HasDbReferences {
    private static final long serialVersionUID = 1L;
    protected transient CaseExecutionEntity caseInstance;
    protected transient CaseExecutionEntity parent;
    protected List<CaseExecutionEntity> caseExecutions;
    protected List<CaseSentryPartEntity> caseSentryParts;
    protected Map<String, List<CaseSentryPartEntity>> sentries;
    protected transient ExecutionEntity subProcessInstance;
    protected transient CaseExecutionEntity subCaseInstance;
    protected transient CaseExecutionEntity superCaseExecution;
    protected CaseExecutionEntityVariableStore variableStore = new CaseExecutionEntityVariableStore(this);
    protected int revision = 1;
    protected String caseDefinitionId;
    protected String activityId;
    protected String activityName;
    protected String caseInstanceId;
    protected String parentId;
    protected String superCaseExecutionId;
    protected boolean forcedUpdate;

    @Override
    public String getCaseDefinitionId() {
        return this.caseDefinitionId;
    }

    @Override
    public CmmnCaseDefinition getCaseDefinition() {
        this.ensureCaseDefinitionInitialized();
        return this.caseDefinition;
    }

    @Override
    public void setCaseDefinition(CmmnCaseDefinition caseDefinition) {
        super.setCaseDefinition(caseDefinition);
        this.caseDefinitionId = null;
        if (caseDefinition != null) {
            this.caseDefinitionId = caseDefinition.getId();
        }
    }

    protected void ensureCaseDefinitionInitialized() {
        if (this.caseDefinition == null && this.caseDefinitionId != null) {
            CaseDefinitionEntity deployedCaseDefinition = Context.getProcessEngineConfiguration().getDeploymentCache().getCaseDefinitionById(this.caseDefinitionId);
            this.setCaseDefinition(deployedCaseDefinition);
        }
    }

    @Override
    public CaseExecutionEntity getParent() {
        this.ensureParentInitialized();
        return this.parent;
    }

    @Override
    public void setParent(CmmnExecution parent) {
        this.parent = (CaseExecutionEntity)parent;
        this.parentId = parent != null ? parent.getId() : null;
    }

    protected void ensureParentInitialized() {
        if (this.parent == null && this.parentId != null) {
            this.parent = Context.getCommandContext().getCaseExecutionManager().findCaseExecutionById(this.parentId);
        }
    }

    @Override
    public String getParentId() {
        return this.parentId;
    }

    @Override
    public String getActivityId() {
        return this.activityId;
    }

    @Override
    public String getActivityName() {
        return this.activityName;
    }

    @Override
    public CmmnActivity getActivity() {
        this.ensureActivityInitialized();
        return super.getActivity();
    }

    @Override
    public void setActivity(CmmnActivity activity) {
        super.setActivity(activity);
        if (activity != null) {
            this.activityId = activity.getId();
            this.activityName = activity.getName();
        } else {
            this.activityId = null;
            this.activityName = null;
        }
    }

    protected void ensureActivityInitialized() {
        if (this.activity == null && this.activityId != null) {
            this.setActivity(this.getCaseDefinition().findActivity(this.activityId));
        }
    }

    public List<CaseExecutionEntity> getCaseExecutions() {
        return new ArrayList<CaseExecutionEntity>(this.getCaseExecutionsInternal());
    }

    protected List<CaseExecutionEntity> getCaseExecutionsInternal() {
        this.ensureCaseExecutionsInitialized();
        return this.caseExecutions;
    }

    protected void ensureCaseExecutionsInitialized() {
        if (this.caseExecutions == null) {
            this.caseExecutions = Context.getCommandContext().getCaseExecutionManager().findChildCaseExecutionsByParentCaseExecutionId(this.id);
        }
    }

    @Override
    public String getCaseInstanceId() {
        return this.caseInstanceId;
    }

    @Override
    public CaseExecutionEntity getCaseInstance() {
        this.ensureCaseInstanceInitialized();
        return this.caseInstance;
    }

    @Override
    public void setCaseInstance(CmmnExecution caseInstance) {
        this.caseInstance = (CaseExecutionEntity)caseInstance;
        if (caseInstance != null) {
            this.caseInstanceId = this.caseInstance.getId();
        }
    }

    protected void ensureCaseInstanceInitialized() {
        if (this.caseInstance == null && this.caseInstanceId != null) {
            this.caseInstance = Context.getCommandContext().getCaseExecutionManager().findCaseExecutionById(this.caseInstanceId);
        }
    }

    @Override
    public boolean isCaseInstanceExecution() {
        return this.parentId == null;
    }

    @Override
    protected CaseExecutionEntity createCaseExecution(CmmnActivity activity) {
        CaseExecutionEntity child = this.newCaseExecution();
        child.setActivity(activity);
        child.setParent(this);
        this.getCaseExecutionsInternal().add(child);
        child.setCaseInstance(this.getCaseInstance());
        child.setCaseDefinition(this.getCaseDefinition());
        return child;
    }

    @Override
    protected CaseExecutionEntity newCaseExecution() {
        CaseExecutionEntity newCaseExecution = new CaseExecutionEntity();
        Context.getCommandContext().getCaseExecutionManager().insertCaseExecution(newCaseExecution);
        return newCaseExecution;
    }

    @Override
    public ExecutionEntity getSubProcessInstance() {
        this.ensureSubProcessInstanceInitialized();
        return this.subProcessInstance;
    }

    @Override
    public void setSubProcessInstance(PvmExecutionImpl subProcessInstance) {
        this.subProcessInstance = (ExecutionEntity)subProcessInstance;
    }

    @Override
    public ExecutionEntity createSubProcessInstance(PvmProcessDefinition processDefinition) {
        return this.createSubProcessInstance(processDefinition, null);
    }

    @Override
    public ExecutionEntity createSubProcessInstance(PvmProcessDefinition processDefinition, String businessKey) {
        return this.createSubProcessInstance(processDefinition, businessKey, this.getCaseInstanceId());
    }

    @Override
    public ExecutionEntity createSubProcessInstance(PvmProcessDefinition processDefinition, String businessKey, String caseInstanceId) {
        ExecutionEntity subProcessInstance = (ExecutionEntity)processDefinition.createProcessInstance(businessKey, caseInstanceId);
        subProcessInstance.setSuperCaseExecution(this);
        this.setSubProcessInstance(subProcessInstance);
        return subProcessInstance;
    }

    protected void ensureSubProcessInstanceInitialized() {
        if (this.subProcessInstance == null) {
            this.subProcessInstance = Context.getCommandContext().getExecutionManager().findSubProcessInstanceBySuperCaseExecutionId(this.id);
        }
    }

    @Override
    public CaseExecutionEntity getSubCaseInstance() {
        this.ensureSubCaseInstanceInitialized();
        return this.subCaseInstance;
    }

    @Override
    public void setSubCaseInstance(CmmnExecution subCaseInstance) {
        this.subCaseInstance = (CaseExecutionEntity)subCaseInstance;
    }

    @Override
    public CaseExecutionEntity createSubCaseInstance(CmmnCaseDefinition caseDefinition) {
        return this.createSubCaseInstance(caseDefinition, null);
    }

    @Override
    public CaseExecutionEntity createSubCaseInstance(CmmnCaseDefinition caseDefinition, String businessKey) {
        CaseExecutionEntity subCaseInstance = (CaseExecutionEntity)caseDefinition.createCaseInstance(businessKey);
        subCaseInstance.setSuperCaseExecution(this);
        this.setSubCaseInstance(subCaseInstance);
        return subCaseInstance;
    }

    protected void ensureSubCaseInstanceInitialized() {
        if (this.subCaseInstance == null) {
            this.subCaseInstance = Context.getCommandContext().getCaseExecutionManager().findSubCaseInstanceBySuperCaseExecutionId(this.id);
        }
    }

    public String getSuperCaseExecutionId() {
        return this.superCaseExecutionId;
    }

    public void setSuperCaseExecutionId(String superCaseExecutionId) {
        this.superCaseExecutionId = superCaseExecutionId;
    }

    @Override
    public CmmnExecution getSuperCaseExecution() {
        this.ensureSuperCaseExecutionInitialized();
        return this.superCaseExecution;
    }

    @Override
    public void setSuperCaseExecution(CmmnExecution superCaseExecution) {
        this.superCaseExecution = (CaseExecutionEntity)superCaseExecution;
        this.superCaseExecutionId = superCaseExecution != null ? superCaseExecution.getId() : null;
    }

    protected void ensureSuperCaseExecutionInitialized() {
        if (this.superCaseExecution == null && this.superCaseExecutionId != null) {
            this.superCaseExecution = Context.getCommandContext().getCaseExecutionManager().findCaseExecutionById(this.superCaseExecutionId);
        }
    }

    public List<CaseSentryPartEntity> getCaseSentryParts() {
        this.ensureCaseSentryPartsInitialized();
        return this.caseSentryParts;
    }

    protected void ensureCaseSentryPartsInitialized() {
        if (this.caseSentryParts == null) {
            this.caseSentryParts = Context.getCommandContext().getCaseSentryPartManager().findCaseSentryPartsByCaseExecutionId(this.id);
            this.sentries = new HashMap<String, List<CaseSentryPartEntity>>();
            for (CaseSentryPartEntity sentryPart : this.caseSentryParts) {
                String sentryId = sentryPart.getSentryId();
                List<CaseSentryPartEntity> parts = this.sentries.get(sentryId);
                if (parts == null) {
                    parts = new ArrayList<CaseSentryPartEntity>();
                    this.sentries.put(sentryId, parts);
                }
                parts.add(sentryPart);
            }
        }
    }

    @Override
    protected void addSentryPart(CmmnSentryPart sentryPart) {
        CaseSentryPartEntity entity = (CaseSentryPartEntity)sentryPart;
        this.getCaseSentryParts().add(entity);
        String sentryId = sentryPart.getSentryId();
        List<CaseSentryPartEntity> parts = this.sentries.get(sentryId);
        if (parts == null) {
            parts = new ArrayList<CaseSentryPartEntity>();
            this.sentries.put(sentryId, parts);
        }
        parts.add(entity);
    }

    protected List<CaseSentryPartEntity> findSentry(String sentryId) {
        this.ensureCaseSentryPartsInitialized();
        return this.sentries.get(sentryId);
    }

    @Override
    protected CaseSentryPartEntity newSentryPart() {
        CaseSentryPartEntity caseSentryPart = new CaseSentryPartEntity();
        Context.getCommandContext().getCaseSentryPartManager().insertCaseSentryPart(caseSentryPart);
        return caseSentryPart;
    }

    @Override
    protected CorePersistentVariableStore getVariableStore() {
        return this.variableStore;
    }

    protected void initializeVariableInstanceBackPointer(VariableInstanceEntity variableInstance) {
        variableInstance.setCaseInstanceId(this.caseInstanceId);
        variableInstance.setCaseExecutionId(this.id);
    }

    protected List<VariableInstanceEntity> loadVariableInstances() {
        return Context.getCommandContext().getVariableInstanceManager().findVariableInstancesByCaseExecutionId(this.id);
    }

    @Override
    public String toString() {
        if (this.isCaseInstanceExecution()) {
            return "CaseInstance[" + this.getToStringIdentity() + "]";
        }
        return "CaseExecution[" + this.getToStringIdentity() + "]";
    }

    @Override
    protected String getToStringIdentity() {
        return this.id;
    }

    @Override
    public void remove() {
        super.remove();
        this.variableStore.removeVariablesWithoutFiringEvents();
        CommandContext commandContext = Context.getCommandContext();
        for (CaseSentryPartEntity sentryPart : this.getCaseSentryParts()) {
            commandContext.getCaseSentryPartManager().deleteSentryPart(sentryPart);
        }
        commandContext.getCaseExecutionManager().deleteCaseExecution(this);
    }

    @Override
    public int getRevision() {
        return this.revision;
    }

    @Override
    public void setRevision(int revision) {
        this.revision = revision;
    }

    @Override
    public int getRevisionNext() {
        return this.revision + 1;
    }

    public void forceUpdate() {
        this.forcedUpdate = true;
    }

    @Override
    public boolean hasReferenceTo(DbEntity entity) {
        if (entity instanceof CaseExecutionEntity) {
            CaseExecutionEntity otherEntity = (CaseExecutionEntity)entity;
            String otherId = otherEntity.getId();
            if (this.parentId != null && this.parentId.equals(otherId)) {
                return true;
            }
            if (this.superCaseExecutionId != null && this.superCaseExecutionId.equals(otherId)) {
                return true;
            }
        }
        return false;
    }

    @Override
    public Object getPersistentState() {
        HashMap<String, Object> persistentState = new HashMap<String, Object>();
        persistentState.put("caseDefinitionId", this.caseDefinitionId);
        persistentState.put("businessKey", this.businessKey);
        persistentState.put("activityId", this.activityId);
        persistentState.put("parentId", this.parentId);
        persistentState.put("currentState", this.currentState);
        persistentState.put("previousState", this.previousState);
        if (this.forcedUpdate) {
            persistentState.put("forcedUpdate", Boolean.TRUE);
        }
        return persistentState;
    }

    @Override
    public CmmnModelInstance getCmmnModelInstance() {
        if (this.caseDefinitionId != null) {
            return Context.getProcessEngineConfiguration().getDeploymentCache().findCmmnModelInstanceForCaseDefinition(this.caseDefinitionId);
        }
        return null;
    }

    @Override
    public CmmnElement getCmmnModelElementInstance() {
        CmmnModelInstance cmmnModelInstance = this.getCmmnModelInstance();
        if (cmmnModelInstance != null) {
            ModelElementInstance modelElementInstance = cmmnModelInstance.getModelElementById(this.activityId);
            try {
                return (CmmnElement)modelElementInstance;
            }
            catch (ClassCastException e) {
                ModelElementType elementType = modelElementInstance.getElementType();
                throw new ProcessEngineException("Cannot cast " + modelElementInstance + " to CmmnElement. " + "Is of type " + elementType.getTypeName() + " Namespace " + elementType.getTypeNamespace(), e);
            }
        }
        return null;
    }

    @Override
    public ProcessEngineServices getProcessEngineServices() {
        return Context.getProcessEngineConfiguration().getProcessEngine();
    }

    @Override
    public <T extends CoreExecution> void performOperation(CoreAtomicOperation<T> operation) {
        Context.getCommandContext().performOperation((CmmnAtomicOperation)operation, this);
    }

    @Override
    public <T extends CoreExecution> void performOperationSync(CoreAtomicOperation<T> operation) {
        Context.getCommandContext().performOperation((CmmnAtomicOperation)operation, this);
    }
}

