/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.impl.cmmn.entity.runtime;

import java.util.HashMap;
import org.camunda.bpm.engine.impl.cmmn.entity.runtime.CaseExecutionEntity;
import org.camunda.bpm.engine.impl.cmmn.execution.CmmnExecution;
import org.camunda.bpm.engine.impl.cmmn.execution.CmmnSentryPart;
import org.camunda.bpm.engine.impl.context.Context;
import org.camunda.bpm.engine.impl.db.DbEntity;
import org.camunda.bpm.engine.impl.db.HasDbRevision;

public class CaseSentryPartEntity
extends CmmnSentryPart
implements DbEntity,
HasDbRevision {
    private static final long serialVersionUID = 1L;
    protected CaseExecutionEntity caseInstance;
    protected CaseExecutionEntity caseExecution;
    protected CaseExecutionEntity sourceCaseExecution;
    protected String id;
    protected int revision = 1;
    protected String caseInstanceId;
    protected String caseExecutionId;
    protected String sourceCaseExecutionId;

    @Override
    public String getId() {
        return this.id;
    }

    @Override
    public void setId(String id) {
        this.id = id;
    }

    @Override
    public String getCaseInstanceId() {
        return this.caseInstanceId;
    }

    @Override
    public CaseExecutionEntity getCaseInstance() {
        this.ensureCaseInstanceInitialized();
        return this.caseInstance;
    }

    protected void ensureCaseInstanceInitialized() {
        if (this.caseInstance == null && this.caseInstanceId != null) {
            this.caseInstance = this.findCaseExecutionById(this.caseInstanceId);
        }
    }

    @Override
    public void setCaseInstance(CmmnExecution caseInstance) {
        this.caseInstance = (CaseExecutionEntity)caseInstance;
        this.caseInstanceId = caseInstance != null ? caseInstance.getId() : null;
    }

    @Override
    public String getCaseExecutionId() {
        return this.caseExecutionId;
    }

    @Override
    public CaseExecutionEntity getCaseExecution() {
        this.ensureCaseExecutionInitialized();
        return this.caseExecution;
    }

    protected void ensureCaseExecutionInitialized() {
        if (this.caseExecution == null && this.caseExecutionId != null) {
            this.caseExecution = this.findCaseExecutionById(this.caseExecutionId);
        }
    }

    @Override
    public void setCaseExecution(CmmnExecution caseExecution) {
        this.caseExecution = (CaseExecutionEntity)caseExecution;
        this.caseExecutionId = caseExecution != null ? caseExecution.getId() : null;
    }

    @Override
    public String getSourceCaseExecutionId() {
        return this.sourceCaseExecutionId;
    }

    @Override
    public CmmnExecution getSourceCaseExecution() {
        this.ensureSourceCaseExecutionInitialized();
        return this.sourceCaseExecution;
    }

    protected void ensureSourceCaseExecutionInitialized() {
        if (this.sourceCaseExecution == null && this.sourceCaseExecutionId != null) {
            this.sourceCaseExecution = this.findCaseExecutionById(this.sourceCaseExecutionId);
        }
    }

    @Override
    public void setSourceCaseExecution(CmmnExecution sourceCaseExecution) {
        this.sourceCaseExecution = (CaseExecutionEntity)sourceCaseExecution;
        this.sourceCaseExecutionId = sourceCaseExecution != null ? sourceCaseExecution.getId() : null;
    }

    @Override
    public int getRevision() {
        return this.revision;
    }

    @Override
    public void setRevision(int revision) {
        this.revision = revision;
    }

    @Override
    public int getRevisionNext() {
        return this.revision + 1;
    }

    @Override
    public Object getPersistentState() {
        HashMap<String, Boolean> persistentState = new HashMap<String, Boolean>();
        persistentState.put("satisfied", this.isSatisfied());
        return persistentState;
    }

    protected CaseExecutionEntity findCaseExecutionById(String caseExecutionId) {
        return Context.getCommandContext().getCaseExecutionManager().findCaseExecutionById(caseExecutionId);
    }
}

