/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.impl.cmmn.transformer;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.camunda.bpm.engine.ProcessEngineException;
import org.camunda.bpm.engine.impl.cmmn.entity.repository.CaseDefinitionEntity;
import org.camunda.bpm.engine.impl.cmmn.handler.CasePlanModelHandler;
import org.camunda.bpm.engine.impl.cmmn.handler.CmmnElementHandler;
import org.camunda.bpm.engine.impl.cmmn.handler.CmmnHandlerContext;
import org.camunda.bpm.engine.impl.cmmn.handler.DefaultCmmnElementHandlerRegistry;
import org.camunda.bpm.engine.impl.cmmn.handler.ItemHandler;
import org.camunda.bpm.engine.impl.cmmn.handler.SentryHandler;
import org.camunda.bpm.engine.impl.cmmn.model.CmmnActivity;
import org.camunda.bpm.engine.impl.cmmn.model.CmmnCaseDefinition;
import org.camunda.bpm.engine.impl.cmmn.transformer.CmmnTransformListener;
import org.camunda.bpm.engine.impl.cmmn.transformer.CmmnTransformer;
import org.camunda.bpm.engine.impl.core.transformer.Transform;
import org.camunda.bpm.engine.impl.el.ExpressionManager;
import org.camunda.bpm.engine.impl.persistence.entity.DeploymentEntity;
import org.camunda.bpm.engine.impl.persistence.entity.ResourceEntity;
import org.camunda.bpm.model.cmmn.Cmmn;
import org.camunda.bpm.model.cmmn.CmmnModelException;
import org.camunda.bpm.model.cmmn.CmmnModelInstance;
import org.camunda.bpm.model.cmmn.impl.instance.CasePlanModel;
import org.camunda.bpm.model.cmmn.instance.Case;
import org.camunda.bpm.model.cmmn.instance.CaseTask;
import org.camunda.bpm.model.cmmn.instance.CmmnElement;
import org.camunda.bpm.model.cmmn.instance.Definitions;
import org.camunda.bpm.model.cmmn.instance.EventListener;
import org.camunda.bpm.model.cmmn.instance.HumanTask;
import org.camunda.bpm.model.cmmn.instance.Milestone;
import org.camunda.bpm.model.cmmn.instance.PlanFragment;
import org.camunda.bpm.model.cmmn.instance.PlanItem;
import org.camunda.bpm.model.cmmn.instance.PlanItemDefinition;
import org.camunda.bpm.model.cmmn.instance.PlanningTable;
import org.camunda.bpm.model.cmmn.instance.ProcessTask;
import org.camunda.bpm.model.cmmn.instance.Sentry;
import org.camunda.bpm.model.cmmn.instance.Stage;
import org.camunda.bpm.model.cmmn.instance.Task;

public class CmmnTransform
implements Transform<CaseDefinitionEntity> {
    protected CmmnTransformer transformer;
    protected ExpressionManager expressionManager;
    protected DefaultCmmnElementHandlerRegistry handlerRegistry;
    protected List<CmmnTransformListener> parseListeners;
    protected ResourceEntity resource;
    protected DeploymentEntity deployment;
    protected CmmnModelInstance model;
    protected CmmnHandlerContext context = new CmmnHandlerContext();
    protected List<CaseDefinitionEntity> caseDefinitions = new ArrayList<CaseDefinitionEntity>();

    public CmmnTransform(CmmnTransformer transformer) {
        this.transformer = transformer;
        this.expressionManager = transformer.getExpressionManager();
        this.handlerRegistry = transformer.getCmmnElementHandlerRegistry();
        this.parseListeners = transformer.getTransformListener();
    }

    public CmmnTransform deployment(DeploymentEntity deployment) {
        this.deployment = deployment;
        return this;
    }

    public CmmnTransform resource(ResourceEntity resource) {
        this.resource = resource;
        return this;
    }

    @Override
    public List<CaseDefinitionEntity> transform() {
        String resourceName = this.resource.getName();
        byte[] bytes = this.resource.getBytes();
        ByteArrayInputStream inputStream = new ByteArrayInputStream(bytes);
        try {
            this.model = Cmmn.readModelFromStream((InputStream)inputStream);
        }
        catch (CmmnModelException e) {
            throw new ProcessEngineException("Couldn't transform '" + resourceName + "': " + e.getMessage(), e);
        }
        this.context.setModel(this.model);
        this.context.setDeployment(this.deployment);
        this.context.setExpressionManager(this.expressionManager);
        try {
            this.parseRootElement();
        }
        catch (Exception e) {
            throw new ProcessEngineException("Error while parsing process: " + e.getMessage(), e);
        }
        return this.caseDefinitions;
    }

    protected void parseRootElement() {
        this.parseImports();
        this.parseCaseDefinitions();
    }

    protected void parseImports() {
    }

    protected void parseCaseDefinitions() {
        Definitions definitions = this.model.getDefinitions();
        Collection cases = definitions.getCases();
        for (Case currentCase : cases) {
            CaseDefinitionEntity caseDefinition = this.parseCase(currentCase);
            this.caseDefinitions.add(caseDefinition);
        }
    }

    protected CaseDefinitionEntity parseCase(Case element) {
        CmmnElementHandler<Case, CmmnActivity> caseTransformer = this.getDefinitionHandler(Case.class);
        CmmnActivity definition = caseTransformer.handleElement(element, this.context);
        this.context.setCaseDefinition((CmmnCaseDefinition)definition);
        this.context.setParent(definition);
        CasePlanModel casePlanModel = element.getCasePlanModel();
        this.parseCasePlanModel(casePlanModel);
        return (CaseDefinitionEntity)definition;
    }

    protected void parseCasePlanModel(CasePlanModel casePlanModel) {
        CasePlanModelHandler transformer = (CasePlanModelHandler)this.getPlanItemHandler(CasePlanModel.class);
        CmmnActivity newActivity = transformer.handleElement((CmmnElement)casePlanModel, this.context);
        this.context.setParent(newActivity);
        this.parseStage((Stage)casePlanModel, newActivity);
        this.context.setParent(newActivity);
        transformer.initializeExitCriterias(casePlanModel, newActivity, this.context);
    }

    protected void parseStage(Stage stage, CmmnActivity parent) {
        this.context.setParent(parent);
        this.parseSentries(stage);
        this.parsePlanItems((PlanFragment)stage, parent);
        this.parseSentryOnParts(stage);
        this.parsePlanningTable(stage.getPlanningTable(), parent);
    }

    protected void parsePlanningTable(PlanningTable planningTable, CmmnActivity parent) {
    }

    protected void parseSentries(Stage stage) {
        Collection sentries = stage.getSentrys();
        if (sentries != null && !sentries.isEmpty()) {
            SentryHandler handler = this.getSentryHandler();
            for (Sentry sentry : sentries) {
                handler.handleElement(sentry, this.context);
            }
        }
    }

    protected void parseSentryOnParts(Stage stage) {
        Collection sentries = stage.getSentrys();
        if (sentries != null && !sentries.isEmpty()) {
            SentryHandler handler = this.getSentryHandler();
            for (Sentry sentry : sentries) {
                handler.initializeOnParts(sentry, this.context);
            }
        }
    }

    protected void parsePlanItems(PlanFragment planFragment, CmmnActivity parent) {
        Collection planItems = planFragment.getPlanItems();
        for (PlanItem planItem : planItems) {
            this.parsePlanItem(planItem, parent);
        }
    }

    protected void parsePlanItem(PlanItem planItem, CmmnActivity parent) {
        PlanItemDefinition definition = planItem.getDefinition();
        ItemHandler planItemTransformer = null;
        if (definition instanceof HumanTask) {
            planItemTransformer = this.getPlanItemHandler(HumanTask.class);
        } else if (definition instanceof ProcessTask) {
            planItemTransformer = this.getPlanItemHandler(ProcessTask.class);
        } else if (definition instanceof CaseTask) {
            planItemTransformer = this.getPlanItemHandler(CaseTask.class);
        } else if (definition instanceof Task) {
            planItemTransformer = this.getPlanItemHandler(Task.class);
        } else if (definition instanceof Stage) {
            planItemTransformer = this.getPlanItemHandler(Stage.class);
        } else if (definition instanceof Milestone) {
            planItemTransformer = this.getPlanItemHandler(Milestone.class);
        } else if (definition instanceof EventListener) {
            planItemTransformer = this.getPlanItemHandler(EventListener.class);
        }
        CmmnActivity newActivity = planItemTransformer.handleElement((CmmnElement)planItem, this.context);
        if (definition instanceof Stage) {
            Stage stage = (Stage)definition;
            this.parseStage(stage, newActivity);
            this.context.setParent(parent);
        } else if (definition instanceof HumanTask) {
            HumanTask humanTask = (HumanTask)definition;
            Collection planningTables = humanTask.getPlanningTables();
            for (PlanningTable planningTable : planningTables) {
                this.parsePlanningTable(planningTable, parent);
            }
        }
    }

    public DeploymentEntity getDeployment() {
        return this.deployment;
    }

    public void setDeployment(DeploymentEntity deployment) {
        this.deployment = deployment;
    }

    public ResourceEntity getResource() {
        return this.resource;
    }

    public void setResource(ResourceEntity resource) {
        this.resource = resource;
    }

    public DefaultCmmnElementHandlerRegistry getHandlerRegistry() {
        return this.handlerRegistry;
    }

    public void setHandlerRegistry(DefaultCmmnElementHandlerRegistry handlerRegistry) {
        this.handlerRegistry = handlerRegistry;
    }

    protected <V extends CmmnElement> CmmnElementHandler<V, CmmnActivity> getDefinitionHandler(Class<V> cls) {
        return this.getHandlerRegistry().getDefinitionElementHandlers().get(cls);
    }

    protected ItemHandler getPlanItemHandler(Class<? extends PlanItemDefinition> cls) {
        return this.getHandlerRegistry().getPlanItemElementHandlers().get(cls);
    }

    protected ItemHandler getDiscretionaryItemHandler(Class<? extends PlanItemDefinition> cls) {
        return this.getHandlerRegistry().getDiscretionaryElementHandlers().get(cls);
    }

    protected SentryHandler getSentryHandler() {
        return this.getHandlerRegistry().getSentryHandler();
    }

    public ExpressionManager getExpressionManager() {
        return this.expressionManager;
    }

    public void setExpressionManager(ExpressionManager expressionManager) {
        this.expressionManager = expressionManager;
    }
}

