/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.impl.core.instance;

import java.util.logging.Level;
import java.util.logging.Logger;
import org.camunda.bpm.engine.delegate.BaseDelegateExecution;
import org.camunda.bpm.engine.delegate.DelegateListener;
import org.camunda.bpm.engine.impl.core.model.CoreModelElement;
import org.camunda.bpm.engine.impl.core.operation.CoreAtomicOperation;
import org.camunda.bpm.engine.impl.core.variable.CorePersistentVariableScope;

public abstract class CoreExecution
extends CorePersistentVariableScope
implements BaseDelegateExecution {
    private static final long serialVersionUID = 1L;
    private static Logger log = Logger.getLogger(CoreExecution.class.getName());
    protected String id;
    protected String businessKey;
    protected String eventName;
    protected CoreModelElement eventSource;
    protected int listenerIndex = 0;
    protected boolean skipCustomListeners;

    public <T extends CoreExecution> void performOperation(CoreAtomicOperation<T> operation) {
        if (log.isLoggable(Level.FINEST)) {
            log.finest("AtomicOperation: " + operation + " on " + this);
        }
        operation.execute(this);
    }

    public <T extends CoreExecution> void performOperationSync(CoreAtomicOperation<T> operation) {
        if (log.isLoggable(Level.FINEST)) {
            log.finest("AtomicOperation: " + operation + " on " + this);
        }
        operation.execute(this);
    }

    @Override
    public String getEventName() {
        return this.eventName;
    }

    public void setEventName(String eventName) {
        this.eventName = eventName;
    }

    public CoreModelElement getEventSource() {
        return this.eventSource;
    }

    public void setEventSource(CoreModelElement eventSource) {
        this.eventSource = eventSource;
    }

    public int getListenerIndex() {
        return this.listenerIndex;
    }

    public void setListenerIndex(int listenerIndex) {
        this.listenerIndex = listenerIndex;
    }

    public void invokeListener(DelegateListener listener) throws Exception {
        listener.notify(this);
    }

    @Override
    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    @Override
    public String getBusinessKey() {
        return this.businessKey;
    }

    public void setBusinessKey(String businessKey) {
        this.businessKey = businessKey;
    }

    public boolean isSkipCustomListeners() {
        return this.skipCustomListeners;
    }

    public void setSkipCustomListeners(boolean skipCustomListeners) {
        this.skipCustomListeners = skipCustomListeners;
    }
}

