/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.impl.core.variable;

import java.util.Map;
import org.camunda.bpm.engine.ProcessEngineException;
import org.camunda.bpm.engine.delegate.PersistentVariableInstance;
import org.camunda.bpm.engine.delegate.PersistentVariableScope;
import org.camunda.bpm.engine.impl.core.variable.CorePersistentVariableStore;
import org.camunda.bpm.engine.impl.core.variable.CoreVariableScope;

public abstract class CorePersistentVariableScope
extends CoreVariableScope<PersistentVariableInstance>
implements PersistentVariableScope {
    private static final long serialVersionUID = 1L;

    @Override
    public void setVariableFromSerialized(String variableName, Object value, String variableTypeName, Map<String, Object> configuration) {
        this.setVariableFromSerialized(variableName, value, variableTypeName, configuration, this.getSourceActivityVariableScope());
    }

    protected void setVariableFromSerialized(String variableName, Object value, String variableTypeName, Map<String, Object> configuration, CoreVariableScope<PersistentVariableInstance> sourceActivityExecution) {
        if (this.hasVariableLocal(variableName)) {
            this.setVariableLocalFromSerialized(variableName, value, variableTypeName, configuration, sourceActivityExecution);
            return;
        }
        CorePersistentVariableScope parentVariableScope = this.getParentVariableScope();
        if (parentVariableScope != null) {
            if (sourceActivityExecution == null) {
                parentVariableScope.setVariableFromSerialized(variableName, value, variableTypeName, configuration);
            } else {
                parentVariableScope.setVariableFromSerialized(variableName, value, variableTypeName, configuration, sourceActivityExecution);
            }
            return;
        }
        this.createVariableLocalFromSerialized(variableName, value, variableTypeName, configuration, sourceActivityExecution);
    }

    protected void createVariableLocalFromSerialized(String variableName, Object value, String variableTypeName, Map<String, Object> configuration, CoreVariableScope<PersistentVariableInstance> sourceActivityExecution) {
        if (this.getVariableStore().containsVariableInstance(variableName)) {
            throw new ProcessEngineException("variable '" + variableName + "' already exists. Use setVariableLocal if you want to overwrite the value");
        }
        this.getVariableStore().createVariableInstanceFromSerialized(variableName, value, variableTypeName, configuration, sourceActivityExecution);
    }

    @Override
    public void setVariableLocalFromSerialized(String variableName, Object value, String variableTypeName, Map<String, Object> configuration) {
        this.setVariableLocalFromSerialized(variableName, value, variableTypeName, configuration, this.getSourceActivityVariableScope());
    }

    protected void setVariableLocalFromSerialized(String variableName, Object value, String variableTypeName, Map<String, Object> configuration, CoreVariableScope<PersistentVariableInstance> sourceActivityExecution) {
        this.getVariableStore().createOrUpdateVariableFromSerialized(variableName, value, variableTypeName, configuration, sourceActivityExecution);
    }

    public abstract CorePersistentVariableScope getParentVariableScope();

    protected abstract CorePersistentVariableStore getVariableStore();
}

