/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.impl.core.variable;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.camunda.bpm.engine.delegate.CoreVariableInstance;
import org.camunda.bpm.engine.delegate.VariableScope;
import org.camunda.bpm.engine.impl.core.variable.CoreVariableStore;
import org.camunda.bpm.engine.impl.javax.el.ELContext;

public abstract class CoreVariableScope<T extends CoreVariableInstance>
implements Serializable,
VariableScope<T> {
    private static final long serialVersionUID = 1L;
    protected ELContext cachedElContext;

    protected abstract CoreVariableStore<T> getVariableStore();

    public abstract CoreVariableScope<T> getParentVariableScope();

    @Override
    public Map<String, Object> getVariables() {
        return this.collectVariables(new HashMap<String, Object>());
    }

    @Override
    public Map<String, T> getVariableInstances() {
        return this.collectVariableInstances(new HashMap(), null);
    }

    @Override
    public Map<String, T> getVariableInstancesLocal() {
        CoreVariableStore<T> variableStore = this.getVariableStore();
        return new HashMap<String, T>(variableStore.getVariableInstances());
    }

    public Map<String, T> getVariableInstances(Collection<String> variableNames) {
        return this.collectVariableInstances(new HashMap(), variableNames);
    }

    public Map<String, T> collectVariableInstances(Map<String, T> variables, Collection<String> variableNames) {
        Map<String, T> variableInstances = this.getVariableInstancesLocal();
        for (CoreVariableInstance variable : variableInstances.values()) {
            if (variables.containsKey(variable.getName()) || variableNames != null && !variableNames.contains(variable.getName())) continue;
            variables.put(variable.getName(), variable);
        }
        CoreVariableScope<T> parentScope = this.getParentVariableScope();
        if (!(parentScope == null || variableNames != null && ((Object)variables.keySet()).equals(variableNames))) {
            parentScope.collectVariableInstances(variables, variableNames);
        }
        return variables;
    }

    protected Map<String, Object> collectVariables(HashMap<String, Object> variables) {
        CoreVariableScope<T> parentScope = this.getParentVariableScope();
        if (parentScope != null) {
            variables.putAll(parentScope.collectVariables(variables));
        }
        for (CoreVariableInstance variableInstance : this.getVariableStore().getVariableInstancesValues()) {
            variables.put(variableInstance.getName(), variableInstance.getValue());
        }
        return variables;
    }

    @Override
    public Object getVariable(String variableName) {
        T variableInstance = this.getVariableInstance(variableName);
        if (variableInstance != null) {
            return variableInstance.getValue();
        }
        return null;
    }

    @Override
    public Object getVariableLocal(String variableName) {
        T variableInstance = this.getVariableInstanceLocal(variableName);
        if (variableInstance != null) {
            return variableInstance.getValue();
        }
        return null;
    }

    @Override
    public T getVariableInstance(String variableName) {
        T variableInstance = this.getVariableInstanceLocal(variableName);
        if (variableInstance != null) {
            return variableInstance;
        }
        CoreVariableScope<T> parentScope = this.getParentVariableScope();
        if (parentScope != null) {
            return parentScope.getVariableInstance(variableName);
        }
        return null;
    }

    @Override
    public T getVariableInstanceLocal(String name) {
        return this.getVariableStore().getVariableInstance(name);
    }

    @Override
    public boolean hasVariables() {
        if (!this.getVariableStore().isEmpty()) {
            return true;
        }
        CoreVariableScope<T> parentScope = this.getParentVariableScope();
        return parentScope != null && parentScope.hasVariables();
    }

    @Override
    public boolean hasVariablesLocal() {
        return !this.getVariableStore().isEmpty();
    }

    @Override
    public boolean hasVariable(String variableName) {
        if (this.hasVariableLocal(variableName)) {
            return true;
        }
        CoreVariableScope<T> parentScope = this.getParentVariableScope();
        return parentScope != null && parentScope.hasVariable(variableName);
    }

    @Override
    public boolean hasVariableLocal(String variableName) {
        return this.getVariableStore().containsVariableInstance(variableName);
    }

    protected Set<String> collectVariableNames(Set<String> variableNames) {
        CoreVariableScope<T> parentScope = this.getParentVariableScope();
        if (parentScope != null) {
            variableNames.addAll(parentScope.collectVariableNames(variableNames));
        }
        for (CoreVariableInstance variableInstance : this.getVariableStore().getVariableInstancesValues()) {
            variableNames.add(variableInstance.getName());
        }
        return variableNames;
    }

    @Override
    public Set<String> getVariableNames() {
        return this.collectVariableNames(new HashSet<String>());
    }

    @Override
    public Map<String, Object> getVariablesLocal() {
        HashMap<String, Object> variables = new HashMap<String, Object>();
        for (CoreVariableInstance variableInstance : this.getVariableStore().getVariableInstancesValues()) {
            variables.put(variableInstance.getName(), variableInstance.getValue());
        }
        return variables;
    }

    @Override
    public Set<String> getVariableNamesLocal() {
        return this.getVariableStore().getVariableNames();
    }

    @Override
    public void setVariables(Map<String, ? extends Object> variables) {
        if (variables != null) {
            for (String variableName : variables.keySet()) {
                this.setVariable(variableName, variables.get(variableName));
            }
        }
    }

    @Override
    public void setVariablesLocal(Map<String, ? extends Object> variables) {
        if (variables != null) {
            for (String variableName : variables.keySet()) {
                this.setVariableLocal(variableName, variables.get(variableName));
            }
        }
    }

    @Override
    public void removeVariables() {
        HashSet<String> variableNames = new HashSet<String>(this.getVariableStore().getVariableNames());
        for (String variableName : variableNames) {
            this.removeVariable(variableName);
        }
    }

    @Override
    public void removeVariablesLocal() {
        ArrayList<String> variableNames = new ArrayList<String>(this.getVariableNamesLocal());
        for (String variableName : variableNames) {
            this.removeVariableLocal(variableName);
        }
    }

    @Override
    public void removeVariables(Collection<String> variableNames) {
        if (variableNames != null) {
            for (String variableName : variableNames) {
                this.removeVariable(variableName);
            }
        }
    }

    @Override
    public void removeVariablesLocal(Collection<String> variableNames) {
        if (variableNames != null) {
            for (String variableName : variableNames) {
                this.removeVariableLocal(variableName);
            }
        }
    }

    @Override
    public void setVariable(String variableName, Object value) {
        this.setVariable(variableName, value, this.getSourceActivityVariableScope());
    }

    protected void setVariable(String variableName, Object value, CoreVariableScope<T> sourceActivityExecution) {
        if (this.hasVariableLocal(variableName)) {
            this.setVariableLocal(variableName, value, sourceActivityExecution);
            return;
        }
        CoreVariableScope<T> parentVariableScope = this.getParentVariableScope();
        if (parentVariableScope != null) {
            if (sourceActivityExecution == null) {
                parentVariableScope.setVariable(variableName, value);
            } else {
                parentVariableScope.setVariable(variableName, value, sourceActivityExecution);
            }
            return;
        }
        this.setVariableLocal(variableName, value, sourceActivityExecution);
    }

    public void setVariableLocal(String variableName, Object value, CoreVariableScope<T> sourceActivityExecution) {
        this.getVariableStore().createOrUpdateVariable(variableName, value, sourceActivityExecution);
    }

    @Override
    public void setVariableLocal(String variableName, Object value) {
        this.getVariableStore().createOrUpdateVariable(variableName, value, this.getSourceActivityVariableScope());
    }

    @Override
    public void removeVariable(String variableName) {
        this.removeVariable(variableName, this.getSourceActivityVariableScope());
    }

    protected void removeVariable(String variableName, CoreVariableScope<T> sourceActivityExecution) {
        if (this.getVariableStore().containsVariableInstance(variableName)) {
            this.removeVariableLocal(variableName);
            return;
        }
        CoreVariableScope<T> parentVariableScope = this.getParentVariableScope();
        if (parentVariableScope != null) {
            if (sourceActivityExecution == null) {
                parentVariableScope.removeVariable(variableName);
            } else {
                parentVariableScope.removeVariable(variableName, sourceActivityExecution);
            }
        }
    }

    @Override
    public void removeVariableLocal(String variableName) {
        this.removeVariableLocal(variableName, this.getSourceActivityVariableScope());
    }

    protected CoreVariableScope<T> getSourceActivityVariableScope() {
        return this;
    }

    protected void removeVariableLocal(String variableName, CoreVariableScope<T> sourceActivityExecution) {
        this.getVariableStore().removeVariableInstance(variableName, sourceActivityExecution);
    }

    public ELContext getCachedElContext() {
        return this.cachedElContext;
    }

    public void setCachedElContext(ELContext cachedElContext) {
        this.cachedElContext = cachedElContext;
    }
}

