/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.impl.db;

import org.camunda.bpm.engine.ProcessEngineException;
import org.camunda.bpm.engine.WrongDbException;
import org.camunda.bpm.engine.impl.cfg.ProcessEngineConfigurationImpl;
import org.camunda.bpm.engine.impl.context.Context;
import org.camunda.bpm.engine.impl.db.PersistenceSession;
import org.camunda.bpm.engine.impl.db.entitymanager.operation.DbBulkOperation;
import org.camunda.bpm.engine.impl.db.entitymanager.operation.DbEntityOperation;
import org.camunda.bpm.engine.impl.db.entitymanager.operation.DbOperation;

public abstract class AbstractPersistenceSession
implements PersistenceSession {
    @Override
    public void executeDbOperation(DbOperation operation) {
        switch (operation.getOperationType()) {
            case INSERT: {
                this.insertEntity((DbEntityOperation)operation);
                break;
            }
            case DELETE: {
                this.deleteEntity((DbEntityOperation)operation);
                break;
            }
            case DELETE_BULK: {
                this.deleteBulk((DbBulkOperation)operation);
                break;
            }
            case UPDATE: {
                this.updateEntity((DbEntityOperation)operation);
                break;
            }
            case UPDATE_BULK: {
                this.updateBulk((DbBulkOperation)operation);
            }
        }
    }

    protected abstract void insertEntity(DbEntityOperation var1);

    protected abstract void deleteEntity(DbEntityOperation var1);

    protected abstract void deleteBulk(DbBulkOperation var1);

    protected abstract void updateEntity(DbEntityOperation var1);

    protected abstract void updateBulk(DbBulkOperation var1);

    protected abstract String getDbVersion();

    @Override
    public void dbSchemaCreate() {
        ProcessEngineConfigurationImpl processEngineConfiguration = Context.getProcessEngineConfiguration();
        int configuredHistoryLevel = processEngineConfiguration.getHistoryLevel();
        if (!processEngineConfiguration.isDbHistoryUsed() && configuredHistoryLevel > 0) {
            throw new ProcessEngineException("historyLevel config is higher then 'none' and dbHistoryUsed is set to false");
        }
        if (this.isEngineTablePresent()) {
            String dbVersion = this.getDbVersion();
            if (!"fox".equals(dbVersion)) {
                throw new WrongDbException("fox", dbVersion);
            }
        } else {
            this.dbSchemaCreateEngine();
        }
        if (processEngineConfiguration.isDbHistoryUsed()) {
            this.dbSchemaCreateHistory();
        }
        if (processEngineConfiguration.isDbIdentityUsed()) {
            this.dbSchemaCreateIdentity();
        }
        if (processEngineConfiguration.isCmmnEnabled()) {
            this.dbSchemaCreateCmmn();
        }
    }

    protected abstract void dbSchemaCreateIdentity();

    protected abstract void dbSchemaCreateHistory();

    protected abstract void dbSchemaCreateEngine();

    protected abstract void dbSchemaCreateCmmn();

    @Override
    public void dbSchemaDrop() {
        ProcessEngineConfigurationImpl processEngineConfiguration = Context.getProcessEngineConfiguration();
        if (processEngineConfiguration.isCmmnEnabled()) {
            this.dbSchemaDropCmmn();
        }
        this.dbSchemaDropEngine();
        if (processEngineConfiguration.isDbHistoryUsed()) {
            this.dbSchemaDropHistory();
        }
        if (processEngineConfiguration.isDbIdentityUsed()) {
            this.dbSchemaDropIdentity();
        }
    }

    protected abstract void dbSchemaDropIdentity();

    protected abstract void dbSchemaDropHistory();

    protected abstract void dbSchemaDropEngine();

    protected abstract void dbSchemaDropCmmn();

    @Override
    public void dbSchemaPrune() {
        ProcessEngineConfigurationImpl processEngineConfiguration = Context.getProcessEngineConfiguration();
        if (this.isHistoryTablePresent() && !processEngineConfiguration.isDbHistoryUsed()) {
            this.dbSchemaDropHistory();
        }
        if (this.isIdentityTablePresent() && !processEngineConfiguration.isDbIdentityUsed()) {
            this.dbSchemaDropIdentity();
        }
        if (this.isCaseDefinitionTablePresent() && !processEngineConfiguration.isCmmnEnabled()) {
            this.dbSchemaDropCmmn();
        }
    }

    public abstract boolean isEngineTablePresent();

    public abstract boolean isHistoryTablePresent();

    public abstract boolean isIdentityTablePresent();

    public abstract boolean isCaseDefinitionTablePresent();

    @Override
    public void dbSchemaUpdate() {
        ProcessEngineConfigurationImpl processEngineConfiguration = Context.getProcessEngineConfiguration();
        if (!this.isEngineTablePresent()) {
            this.dbSchemaCreateEngine();
        }
        if (!this.isHistoryTablePresent() && processEngineConfiguration.isDbHistoryUsed()) {
            this.dbSchemaCreateHistory();
        }
        if (!this.isIdentityTablePresent() && processEngineConfiguration.isDbIdentityUsed()) {
            this.dbSchemaCreateIdentity();
        }
        if (!this.isCaseDefinitionTablePresent() && processEngineConfiguration.isCmmnEnabled()) {
            this.dbSchemaCreateCmmn();
        }
    }
}

