/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.impl.db;

import java.sql.CallableStatement;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import org.apache.ibatis.type.JdbcType;
import org.apache.ibatis.type.TypeHandler;
import org.camunda.bpm.engine.impl.context.Context;
import org.camunda.bpm.engine.impl.util.EnsureUtil;
import org.camunda.bpm.engine.impl.variable.VariableType;
import org.camunda.bpm.engine.impl.variable.VariableTypes;

public class IbatisVariableTypeHandler
implements TypeHandler<VariableType> {
    protected VariableTypes variableTypes;

    public VariableType getResult(ResultSet rs, String columnName) throws SQLException {
        String typeName = rs.getString(columnName);
        VariableType type = this.getVariableTypes().getVariableType(typeName);
        EnsureUtil.ensureNotNull("unknown variable type name " + typeName, "type", (Object)type);
        return type;
    }

    public VariableType getResult(CallableStatement cs, int columnIndex) throws SQLException {
        String typeName = cs.getString(columnIndex);
        VariableType type = this.getVariableTypes().getVariableType(typeName);
        EnsureUtil.ensureNotNull("unknown variable type name " + typeName, "type", (Object)type);
        return type;
    }

    public void setParameter(PreparedStatement ps, int i, VariableType parameter, JdbcType jdbcType) throws SQLException {
        String typeName = parameter.getTypeName();
        ps.setString(i, typeName);
    }

    protected VariableTypes getVariableTypes() {
        if (this.variableTypes == null) {
            this.variableTypes = Context.getProcessEngineConfiguration().getVariableTypes();
        }
        return this.variableTypes;
    }

    public VariableType getResult(ResultSet resultSet, int columnIndex) throws SQLException {
        String typeName = resultSet.getString(columnIndex);
        VariableType type = this.getVariableTypes().getVariableType(typeName);
        EnsureUtil.ensureNotNull("unknown variable type name " + typeName, "type", (Object)type);
        return type;
    }
}

