/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.impl.db.entitymanager;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.logging.Logger;
import org.camunda.bpm.engine.ProcessEngineException;
import org.camunda.bpm.engine.impl.DeploymentQueryImpl;
import org.camunda.bpm.engine.impl.ExecutionQueryImpl;
import org.camunda.bpm.engine.impl.GroupQueryImpl;
import org.camunda.bpm.engine.impl.HistoricActivityInstanceQueryImpl;
import org.camunda.bpm.engine.impl.HistoricDetailQueryImpl;
import org.camunda.bpm.engine.impl.HistoricProcessInstanceQueryImpl;
import org.camunda.bpm.engine.impl.HistoricTaskInstanceQueryImpl;
import org.camunda.bpm.engine.impl.HistoricVariableInstanceQueryImpl;
import org.camunda.bpm.engine.impl.JobQueryImpl;
import org.camunda.bpm.engine.impl.Page;
import org.camunda.bpm.engine.impl.ProcessDefinitionQueryImpl;
import org.camunda.bpm.engine.impl.ProcessInstanceQueryImpl;
import org.camunda.bpm.engine.impl.TaskQueryImpl;
import org.camunda.bpm.engine.impl.UserQueryImpl;
import org.camunda.bpm.engine.impl.cfg.IdGenerator;
import org.camunda.bpm.engine.impl.cmmn.entity.repository.CaseDefinitionQueryImpl;
import org.camunda.bpm.engine.impl.db.DbEntity;
import org.camunda.bpm.engine.impl.db.ListQueryParameterObject;
import org.camunda.bpm.engine.impl.db.PersistenceSession;
import org.camunda.bpm.engine.impl.db.entitymanager.cache.CachedDbEntity;
import org.camunda.bpm.engine.impl.db.entitymanager.cache.DbEntityCache;
import org.camunda.bpm.engine.impl.db.entitymanager.cache.DbEntityState;
import org.camunda.bpm.engine.impl.db.entitymanager.operation.DbBulkOperation;
import org.camunda.bpm.engine.impl.db.entitymanager.operation.DbEntityOperation;
import org.camunda.bpm.engine.impl.db.entitymanager.operation.DbOperation;
import org.camunda.bpm.engine.impl.db.entitymanager.operation.DbOperationManager;
import org.camunda.bpm.engine.impl.db.entitymanager.operation.DbOperationType;
import org.camunda.bpm.engine.impl.identity.db.DbGroupQueryImpl;
import org.camunda.bpm.engine.impl.identity.db.DbUserQueryImpl;
import org.camunda.bpm.engine.impl.interceptor.Session;

public class DbEntityManager
implements Session {
    private static Logger log = Logger.getLogger(DbEntityManager.class.getName());
    protected IdGenerator idGenerator;
    protected DbEntityCache dbEntityCache;
    protected DbOperationManager dbOperationManager;
    protected PersistenceSession persistenceSession;

    public DbEntityManager(IdGenerator idGenerator, PersistenceSession persistenceSession) {
        this.idGenerator = idGenerator;
        this.persistenceSession = persistenceSession;
        this.dbEntityCache = new DbEntityCache();
        this.dbOperationManager = new DbOperationManager();
    }

    public List selectList(String statement) {
        return this.selectList(statement, null, 0, Integer.MAX_VALUE);
    }

    public List selectList(String statement, Object parameter) {
        return this.selectList(statement, parameter, 0, Integer.MAX_VALUE);
    }

    public List selectList(String statement, Object parameter, Page page) {
        if (page != null) {
            return this.selectList(statement, parameter, page.getFirstResult(), page.getMaxResults());
        }
        return this.selectList(statement, parameter, 0, Integer.MAX_VALUE);
    }

    public List selectList(String statement, ListQueryParameterObject parameter, Page page) {
        return this.selectList(statement, parameter);
    }

    public List selectList(String statement, Object parameter, int firstResult, int maxResults) {
        return this.selectList(statement, new ListQueryParameterObject(parameter, firstResult, maxResults));
    }

    public List selectList(String statement, ListQueryParameterObject parameter) {
        return this.selectListWithRawParameter(statement, parameter, parameter.getFirstResult(), parameter.getMaxResults());
    }

    public List selectListWithRawParameter(String statement, Object parameter, int firstResult, int maxResults) {
        if (firstResult == -1 || maxResults == -1) {
            return Collections.EMPTY_LIST;
        }
        List<Object> loadedObjects = this.persistenceSession.selectList(statement, parameter);
        return this.filterLoadedObjects(loadedObjects);
    }

    public Object selectOne(String statement, Object parameter) {
        Object result = this.persistenceSession.selectOne(statement, parameter);
        if (result instanceof DbEntity) {
            DbEntity loadedObject = (DbEntity)result;
            result = this.cacheFilter(loadedObject);
        }
        return result;
    }

    public boolean selectBoolean(String statement, Object parameter) {
        List<?> result = this.persistenceSession.selectList(statement, parameter);
        if (result != null) {
            return result.contains(1);
        }
        return false;
    }

    public <T extends DbEntity> T selectById(Class<T> entityClass, String id) {
        T persistentObject = this.dbEntityCache.get(entityClass, id);
        if (persistentObject != null) {
            return persistentObject;
        }
        persistentObject = this.persistenceSession.selectById(entityClass, id);
        if (persistentObject == null) {
            return null;
        }
        this.dbEntityCache.putPersistent((DbEntity)persistentObject);
        return persistentObject;
    }

    public <T extends DbEntity> T getCachedEntity(Class<T> type, String id) {
        return this.dbEntityCache.get(type, id);
    }

    public <T extends DbEntity> List<T> getCachedEntitiesByType(Class<T> type) {
        return this.dbEntityCache.getEntitiesByType(type);
    }

    protected List filterLoadedObjects(List<Object> loadedObjects) {
        if (loadedObjects.isEmpty()) {
            return loadedObjects;
        }
        if (!DbEntity.class.isAssignableFrom(loadedObjects.get(0).getClass())) {
            return loadedObjects;
        }
        ArrayList<DbEntity> filteredObjects = new ArrayList<DbEntity>(loadedObjects.size());
        for (Object loadedObject : loadedObjects) {
            DbEntity cachedPersistentObject = this.cacheFilter((DbEntity)loadedObject);
            filteredObjects.add(cachedPersistentObject);
        }
        return filteredObjects;
    }

    protected DbEntity cacheFilter(DbEntity persistentObject) {
        Object cachedPersistentObject = this.dbEntityCache.get(persistentObject.getClass(), persistentObject.getId());
        if (cachedPersistentObject != null) {
            return cachedPersistentObject;
        }
        this.dbEntityCache.putPersistent(persistentObject);
        return persistentObject;
    }

    public void lock(String statement) {
        this.persistenceSession.lock(statement);
    }

    public boolean isDirty(DbEntity dbEntity) {
        CachedDbEntity cachedEntity = this.dbEntityCache.getCachedEntity(dbEntity);
        if (cachedEntity == null) {
            return false;
        }
        return cachedEntity.isDirty() || cachedEntity.getEntityState() == DbEntityState.MERGED;
    }

    @Override
    public void flush() {
        this.flushEntityCache();
        List<DbOperation> operationsToFlush = this.dbOperationManager.calculateFlush();
        this.logFlushSummary(operationsToFlush);
        for (DbOperation dbOperation : operationsToFlush) {
            this.persistenceSession.executeDbOperation(dbOperation);
        }
    }

    protected void flushEntityCache() {
        List<CachedDbEntity> cachedEntities = this.dbEntityCache.getCachedEntities();
        for (CachedDbEntity cachedDbEntity : cachedEntities) {
            if (cachedDbEntity.getEntityState() == DbEntityState.TRANSIENT) {
                this.performEntityOperation(cachedDbEntity, DbOperationType.INSERT);
                cachedDbEntity.setEntityState(DbEntityState.PERSISTENT);
            } else if (cachedDbEntity.isDirty()) {
                this.performEntityOperation(cachedDbEntity, DbOperationType.UPDATE);
            } else if (cachedDbEntity.getEntityState() == DbEntityState.MERGED) {
                this.performEntityOperation(cachedDbEntity, DbOperationType.UPDATE);
                cachedDbEntity.setEntityState(DbEntityState.PERSISTENT);
            } else if (cachedDbEntity.getEntityState() == DbEntityState.DELETED_TRANSIENT) {
                this.dbEntityCache.remove(cachedDbEntity);
            } else if (cachedDbEntity.getEntityState() == DbEntityState.DELETED_PERSISTENT || cachedDbEntity.getEntityState() == DbEntityState.DELETED_MERGED) {
                this.performEntityOperation(cachedDbEntity, DbOperationType.DELETE);
                this.dbEntityCache.remove(cachedDbEntity);
            }
            if (cachedDbEntity.getEntityState() != DbEntityState.PERSISTENT) continue;
            cachedDbEntity.makeCopy();
        }
    }

    public void insert(DbEntity dbEntity) {
        this.ensureHasId(dbEntity);
        this.dbEntityCache.putTransient(dbEntity);
    }

    public void merge(DbEntity dbEntity) {
        if (dbEntity.getId() == null) {
            throw new ProcessEngineException("Cannot merge dbEntity without id" + dbEntity);
        }
        this.dbEntityCache.putMerged(dbEntity);
    }

    public void delete(DbEntity dbEntity) {
        this.dbEntityCache.setDeleted(dbEntity);
    }

    public void update(Class<? extends DbEntity> entityType, String statement, Object parameter) {
        this.performBulkOperation(entityType, statement, parameter, DbOperationType.UPDATE_BULK);
    }

    public void delete(Class<? extends DbEntity> entityType, String statement, Object parameter) {
        this.performBulkOperation(entityType, statement, parameter, DbOperationType.DELETE_BULK);
    }

    protected DbBulkOperation performBulkOperation(Class<? extends DbEntity> entityType, String statement, Object parameter, DbOperationType operationType) {
        DbBulkOperation bulkOperation = new DbBulkOperation();
        bulkOperation.setOperationType(operationType);
        bulkOperation.setEntityType(entityType);
        bulkOperation.setStatement(statement);
        bulkOperation.setParameter(parameter);
        this.dbOperationManager.addOperation(bulkOperation);
        return bulkOperation;
    }

    protected void performEntityOperation(CachedDbEntity cachedDbEntity, DbOperationType type) {
        DbEntityOperation dbOperation = new DbEntityOperation();
        dbOperation.setEntity(cachedDbEntity.getEntity());
        dbOperation.setOperationType(type);
        this.dbOperationManager.addOperation(dbOperation);
    }

    protected void logFlushSummary(Collection<DbOperation> operations) {
        log.fine("Flush Summary:");
        for (DbOperation dbOperation : operations) {
            log.fine("  " + dbOperation);
        }
    }

    @Override
    public void close() {
    }

    public boolean isDeleted(DbEntity object) {
        return this.dbEntityCache.isDeleted(object);
    }

    protected void ensureHasId(DbEntity dbEntity) {
        if (dbEntity.getId() == null) {
            String nextId = this.idGenerator.getNextId();
            dbEntity.setId(nextId);
        }
    }

    public <T extends DbEntity> List<T> pruneDeletedEntities(List<T> listToPrune) {
        ArrayList<DbEntity> prunedList = new ArrayList<DbEntity>();
        for (DbEntity potentiallyDeleted : listToPrune) {
            if (this.isDeleted(potentiallyDeleted)) continue;
            prunedList.add(potentiallyDeleted);
        }
        return prunedList;
    }

    public DbOperationManager getDbOperationManager() {
        return this.dbOperationManager;
    }

    public void setDbOperationManager(DbOperationManager operationManager) {
        this.dbOperationManager = operationManager;
    }

    public DbEntityCache getDbEntityCache() {
        return this.dbEntityCache;
    }

    public void setDbEntityCache(DbEntityCache dbEntityCache) {
        this.dbEntityCache = dbEntityCache;
    }

    public DeploymentQueryImpl createDeploymentQuery() {
        return new DeploymentQueryImpl();
    }

    public ProcessDefinitionQueryImpl createProcessDefinitionQuery() {
        return new ProcessDefinitionQueryImpl();
    }

    public CaseDefinitionQueryImpl createCaseDefinitionQuery() {
        return new CaseDefinitionQueryImpl();
    }

    public ProcessInstanceQueryImpl createProcessInstanceQuery() {
        return new ProcessInstanceQueryImpl();
    }

    public ExecutionQueryImpl createExecutionQuery() {
        return new ExecutionQueryImpl();
    }

    public TaskQueryImpl createTaskQuery() {
        return new TaskQueryImpl();
    }

    public JobQueryImpl createJobQuery() {
        return new JobQueryImpl();
    }

    public HistoricProcessInstanceQueryImpl createHistoricProcessInstanceQuery() {
        return new HistoricProcessInstanceQueryImpl();
    }

    public HistoricActivityInstanceQueryImpl createHistoricActivityInstanceQuery() {
        return new HistoricActivityInstanceQueryImpl();
    }

    public HistoricTaskInstanceQueryImpl createHistoricTaskInstanceQuery() {
        return new HistoricTaskInstanceQueryImpl();
    }

    public HistoricDetailQueryImpl createHistoricDetailQuery() {
        return new HistoricDetailQueryImpl();
    }

    public HistoricVariableInstanceQueryImpl createHistoricVariableInstanceQuery() {
        return new HistoricVariableInstanceQueryImpl();
    }

    public UserQueryImpl createUserQuery() {
        return new DbUserQueryImpl();
    }

    public GroupQueryImpl createGroupQuery() {
        return new DbGroupQueryImpl();
    }
}

