/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.impl.db.sql;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.StringReader;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.ResultSet;
import java.sql.Statement;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.ibatis.session.SqlSession;
import org.camunda.bpm.engine.OptimisticLockingException;
import org.camunda.bpm.engine.ProcessEngineException;
import org.camunda.bpm.engine.WrongDbException;
import org.camunda.bpm.engine.impl.db.AbstractPersistenceSession;
import org.camunda.bpm.engine.impl.db.DbEntity;
import org.camunda.bpm.engine.impl.db.HasDbRevision;
import org.camunda.bpm.engine.impl.db.entitymanager.operation.DbBulkOperation;
import org.camunda.bpm.engine.impl.db.entitymanager.operation.DbEntityOperation;
import org.camunda.bpm.engine.impl.db.sql.DbSqlSessionFactory;
import org.camunda.bpm.engine.impl.util.ClassNameUtil;
import org.camunda.bpm.engine.impl.util.EnsureUtil;
import org.camunda.bpm.engine.impl.util.IoUtil;
import org.camunda.bpm.engine.impl.util.ReflectUtil;

public class DbSqlSession
extends AbstractPersistenceSession {
    private static Logger log = Logger.getLogger(DbSqlSession.class.getName());
    protected SqlSession sqlSession;
    protected DbSqlSessionFactory dbSqlSessionFactory;
    protected String connectionMetadataDefaultCatalog = null;
    protected String connectionMetadataDefaultSchema = null;
    public static String[] JDBC_METADATA_TABLE_TYPES = new String[]{"TABLE"};

    public DbSqlSession(DbSqlSessionFactory dbSqlSessionFactory) {
        this.dbSqlSessionFactory = dbSqlSessionFactory;
        this.sqlSession = dbSqlSessionFactory.getSqlSessionFactory().openSession();
    }

    public DbSqlSession(DbSqlSessionFactory dbSqlSessionFactory, Connection connection, String catalog, String schema) {
        this.dbSqlSessionFactory = dbSqlSessionFactory;
        this.sqlSession = dbSqlSessionFactory.getSqlSessionFactory().openSession(connection);
        this.connectionMetadataDefaultCatalog = catalog;
        this.connectionMetadataDefaultSchema = schema;
    }

    @Override
    public List<?> selectList(String statement, Object parameter) {
        statement = this.dbSqlSessionFactory.mapStatement(statement);
        return this.sqlSession.selectList(statement, parameter);
    }

    @Override
    public <T extends DbEntity> T selectById(Class<T> type, String id) {
        String selectStatement = this.dbSqlSessionFactory.getSelectStatement(type);
        selectStatement = this.dbSqlSessionFactory.mapStatement(selectStatement);
        EnsureUtil.ensureNotNull("no select statement for " + type + " in the ibatis mapping files", "selectStatement", (Object)selectStatement);
        return (T)((DbEntity)this.sqlSession.selectOne(selectStatement, (Object)id));
    }

    @Override
    public Object selectOne(String statement, Object parameter) {
        statement = this.dbSqlSessionFactory.mapStatement(statement);
        return this.sqlSession.selectOne(statement, parameter);
    }

    @Override
    public void lock(String statement) {
        if (!"h2".equals(this.dbSqlSessionFactory.getDatabaseType())) {
            String mappedStatement = this.dbSqlSessionFactory.mapStatement(statement);
            this.sqlSession.update(mappedStatement);
        }
    }

    @Override
    protected void insertEntity(DbEntityOperation operation) {
        DbEntity dbEntity = operation.getEntity();
        String insertStatement = this.dbSqlSessionFactory.getInsertStatement(dbEntity);
        insertStatement = this.dbSqlSessionFactory.mapStatement(insertStatement);
        EnsureUtil.ensureNotNull("no insert statement for " + dbEntity.getClass() + " in the ibatis mapping files", "insertStatement", (Object)insertStatement);
        this.executeInsertEntity(insertStatement, dbEntity);
        this.entityInserted(dbEntity);
    }

    protected void executeInsertEntity(String insertStatement, Object parameter) {
        if (log.isLoggable(Level.FINE)) {
            log.fine("inserting: " + this.toString(parameter));
        }
        this.sqlSession.insert(insertStatement, parameter);
        if (parameter instanceof HasDbRevision) {
            HasDbRevision versionedObject = (HasDbRevision)parameter;
            versionedObject.setRevision(versionedObject.getRevisionNext());
        }
    }

    protected void entityInserted(DbEntity entity) {
    }

    @Override
    protected void deleteEntity(DbEntityOperation operation) {
        DbEntity dbEntity = operation.getEntity();
        String deleteStatement = this.dbSqlSessionFactory.getDeleteStatement(dbEntity.getClass());
        EnsureUtil.ensureNotNull("no delete statement for " + dbEntity.getClass() + " in the ibatis mapping files", "deleteStatement", (Object)deleteStatement);
        if (log.isLoggable(Level.FINE)) {
            log.fine("deleting: " + this.toString(dbEntity));
        }
        this.executeDelete(deleteStatement, dbEntity);
        this.entityDeleted(dbEntity);
    }

    protected void executeDelete(String deleteStatement, Object parameter) {
        deleteStatement = this.dbSqlSessionFactory.mapStatement(deleteStatement);
        if (parameter instanceof HasDbRevision) {
            int nrOfRowsDeleted = this.sqlSession.delete(deleteStatement, parameter);
            if (nrOfRowsDeleted == 0) {
                throw new OptimisticLockingException(this.toString(parameter) + " was updated by another transaction concurrently");
            }
        } else {
            this.sqlSession.delete(deleteStatement, parameter);
        }
    }

    protected void entityDeleted(DbEntity entity) {
    }

    @Override
    protected void deleteBulk(DbBulkOperation operation) {
        String statement = operation.getStatement();
        Object parameter = operation.getParameter();
        if (log.isLoggable(Level.FINE)) {
            log.fine("deleting (bulk): " + statement + " " + parameter);
        }
        this.executeDelete(statement, parameter);
    }

    @Override
    protected void updateEntity(DbEntityOperation operation) {
        DbEntity dbEntity = operation.getEntity();
        String updateStatement = this.dbSqlSessionFactory.getUpdateStatement(dbEntity);
        EnsureUtil.ensureNotNull("no update statement for " + dbEntity.getClass() + " in the ibatis mapping files", "updateStatement", (Object)updateStatement);
        if (log.isLoggable(Level.FINE)) {
            log.fine("updating: " + this.toString(dbEntity) + "]");
        }
        this.executeUpdate(updateStatement, dbEntity);
        this.entityUpdated(dbEntity);
    }

    protected void executeUpdate(String updateStatement, Object parameter) {
        updateStatement = this.dbSqlSessionFactory.mapStatement(updateStatement);
        int updatedRecords = this.sqlSession.update(updateStatement, parameter);
        if (parameter instanceof HasDbRevision) {
            if (updatedRecords != 1) {
                throw new OptimisticLockingException(this.toString(parameter) + " was updated by another transaction concurrently");
            }
            HasDbRevision versionedObject = (HasDbRevision)parameter;
            versionedObject.setRevision(versionedObject.getRevisionNext());
        }
    }

    protected void entityUpdated(DbEntity entity) {
    }

    @Override
    protected void updateBulk(DbBulkOperation operation) {
        String statement = operation.getStatement();
        Object parameter = operation.getParameter();
        if (log.isLoggable(Level.FINE)) {
            log.fine("updating (bulk): " + statement + " " + parameter);
        }
        this.executeUpdate(statement, parameter);
    }

    protected String toString(Object object) {
        if (object == null) {
            return "null";
        }
        if (object instanceof DbEntity) {
            DbEntity dbEntity = (DbEntity)object;
            return ClassNameUtil.getClassNameWithoutPackage(dbEntity) + "[" + dbEntity.getId() + "]";
        }
        return object.toString();
    }

    @Override
    public void flush() {
    }

    @Override
    public void close() {
        this.sqlSession.close();
    }

    @Override
    public void commit() {
        this.sqlSession.commit();
    }

    @Override
    public void rollback() {
        this.sqlSession.rollback();
    }

    @Override
    public void dbSchemaCheckVersion() {
        try {
            String dbVersion = this.getDbVersion();
            if (!"fox".equals(dbVersion)) {
                throw new WrongDbException("fox", dbVersion);
            }
            String errorMessage = null;
            if (!this.isEngineTablePresent()) {
                errorMessage = this.addMissingComponent(errorMessage, "engine");
            }
            if (this.dbSqlSessionFactory.isDbHistoryUsed() && !this.isHistoryTablePresent()) {
                errorMessage = this.addMissingComponent(errorMessage, "history");
            }
            if (this.dbSqlSessionFactory.isDbIdentityUsed() && !this.isIdentityTablePresent()) {
                errorMessage = this.addMissingComponent(errorMessage, "identity");
            }
            if (this.dbSqlSessionFactory.isCmmnEnabled() && !this.isCaseDefinitionTablePresent()) {
                errorMessage = this.addMissingComponent(errorMessage, "case.engine");
            }
            if (errorMessage != null) {
                throw new ProcessEngineException("Activiti database problem: " + errorMessage);
            }
        }
        catch (Exception e) {
            if (this.isMissingTablesException(e)) {
                throw new ProcessEngineException("no activiti tables in db.  set <property name=\"databaseSchemaUpdate\" to value=\"true\" or value=\"create-drop\" (use create-drop for testing only!) in bean processEngineConfiguration in camunda.cfg.xml for automatic schema creation", e);
            }
            if (e instanceof RuntimeException) {
                throw (RuntimeException)e;
            }
            throw new ProcessEngineException("couldn't get db schema version", e);
        }
        log.fine("activiti db schema check successful");
    }

    protected String addMissingComponent(String missingComponents, String component) {
        if (missingComponents == null) {
            return "Tables missing for component(s) " + component;
        }
        return missingComponents + ", " + component;
    }

    @Override
    protected String getDbVersion() {
        String selectSchemaVersionStatement = this.dbSqlSessionFactory.mapStatement("selectDbSchemaVersion");
        return (String)this.sqlSession.selectOne(selectSchemaVersionStatement);
    }

    @Override
    protected void dbSchemaCreateIdentity() {
        this.executeMandatorySchemaResource("create", "identity");
    }

    @Override
    protected void dbSchemaCreateHistory() {
        this.executeMandatorySchemaResource("create", "history");
    }

    @Override
    protected void dbSchemaCreateEngine() {
        this.executeMandatorySchemaResource("create", "engine");
    }

    @Override
    protected void dbSchemaCreateCmmn() {
        this.executeMandatorySchemaResource("create", "case.engine");
    }

    @Override
    protected void dbSchemaDropIdentity() {
        this.executeMandatorySchemaResource("drop", "identity");
    }

    @Override
    protected void dbSchemaDropHistory() {
        this.executeMandatorySchemaResource("drop", "history");
    }

    @Override
    protected void dbSchemaDropEngine() {
        this.executeMandatorySchemaResource("drop", "engine");
    }

    @Override
    protected void dbSchemaDropCmmn() {
        this.executeMandatorySchemaResource("drop", "case.engine");
    }

    public void executeMandatorySchemaResource(String operation, String component) {
        this.executeSchemaResource(operation, component, this.getResourceForDbOperation(operation, operation, component), false);
    }

    @Override
    public boolean isEngineTablePresent() {
        return this.isTablePresent("ACT_RU_EXECUTION");
    }

    @Override
    public boolean isHistoryTablePresent() {
        return this.isTablePresent("ACT_HI_PROCINST");
    }

    @Override
    public boolean isIdentityTablePresent() {
        return this.isTablePresent("ACT_ID_USER");
    }

    @Override
    public boolean isCaseDefinitionTablePresent() {
        return this.isTablePresent("ACT_RE_CASE_DEF");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isTablePresent(String tableName) {
        boolean bl;
        String databaseType;
        tableName = this.prependDatabaseTablePrefix(tableName);
        Connection connection = null;
        connection = this.sqlSession.getConnection();
        DatabaseMetaData databaseMetaData = connection.getMetaData();
        ResultSet tables = null;
        String schema = this.connectionMetadataDefaultSchema;
        if (this.dbSqlSessionFactory.getDatabaseSchema() != null) {
            schema = this.dbSqlSessionFactory.getDatabaseSchema();
        }
        if ("postgres".equals(databaseType = this.dbSqlSessionFactory.getDatabaseType())) {
            tableName = tableName.toLowerCase();
        }
        try {
            tables = databaseMetaData.getTables(this.connectionMetadataDefaultCatalog, schema, tableName, JDBC_METADATA_TABLE_TYPES);
            bl = tables.next();
        }
        catch (Throwable throwable) {
            try {
                tables.close();
                throw throwable;
            }
            catch (Exception e) {
                throw new ProcessEngineException("couldn't check if tables are already present using metadata: " + e.getMessage(), e);
            }
        }
        tables.close();
        return bl;
    }

    protected String prependDatabaseTablePrefix(String tableName) {
        return this.dbSqlSessionFactory.getDatabaseTablePrefix() + tableName;
    }

    public String getResourceForDbOperation(String directory, String operation, String component) {
        String databaseType = this.dbSqlSessionFactory.getDatabaseType();
        return "org/camunda/bpm/engine/db/" + directory + "/activiti." + databaseType + "." + operation + "." + component + ".sql";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void executeSchemaResource(String operation, String component, String resourceName, boolean isOptional) {
        InputStream inputStream = null;
        try {
            inputStream = ReflectUtil.getResourceAsStream(resourceName);
            if (inputStream == null) {
                if (!isOptional) throw new ProcessEngineException("resource '" + resourceName + "' is not available");
                log.fine("no schema resource " + resourceName + " for " + operation);
                return;
            } else {
                this.executeSchemaResource(operation, component, resourceName, inputStream);
            }
            return;
        }
        finally {
            IoUtil.closeSilently(inputStream);
        }
    }

    public void executeSchemaResource(String schemaFileResourceName) {
        FileInputStream inputStream = null;
        try {
            inputStream = new FileInputStream(new File(schemaFileResourceName));
            this.executeSchemaResource("schema operation", "process engine", schemaFileResourceName, inputStream);
        }
        catch (FileNotFoundException e) {
            try {
                throw new ProcessEngineException("Cannot find schema resource file '" + schemaFileResourceName, e);
            }
            catch (Throwable throwable) {
                IoUtil.closeSilently(inputStream);
                throw throwable;
            }
        }
        IoUtil.closeSilently(inputStream);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void executeSchemaResource(String operation, String component, String resourceName, InputStream inputStream) {
        log.info("performing " + operation + " on " + component + " with resource " + resourceName);
        String sqlStatement = null;
        String exceptionSqlStatement = null;
        try {
            Connection connection = this.sqlSession.getConnection();
            Exception exception = null;
            byte[] bytes = IoUtil.readInputStream(inputStream, resourceName);
            String ddlStatements = new String(bytes);
            BufferedReader reader = new BufferedReader(new StringReader(ddlStatements));
            String line = this.readNextTrimmedLine(reader);
            while (line != null) {
                if (line.startsWith("# ")) {
                    log.fine(line.substring(2));
                } else if (line.startsWith("-- ")) {
                    log.fine(line.substring(3));
                } else if (line.length() > 0) {
                    if (line.endsWith(";")) {
                        sqlStatement = this.addSqlStatementPiece(sqlStatement, line.substring(0, line.length() - 1));
                        Statement jdbcStatement = connection.createStatement();
                        try {
                            log.fine("SQL: " + sqlStatement);
                            jdbcStatement.execute(sqlStatement);
                            jdbcStatement.close();
                        }
                        catch (Exception e) {
                            if (exception == null) {
                                exception = e;
                                exceptionSqlStatement = sqlStatement;
                            }
                            log.log(Level.SEVERE, "problem during schema " + operation + ", statement '" + sqlStatement, e);
                        }
                        finally {
                            sqlStatement = null;
                        }
                    } else {
                        sqlStatement = this.addSqlStatementPiece(sqlStatement, line);
                    }
                }
                line = this.readNextTrimmedLine(reader);
            }
            if (exception != null) {
                throw exception;
            }
            log.fine("activiti db schema " + operation + " for component " + component + " successful");
        }
        catch (Exception e) {
            throw new ProcessEngineException("couldn't " + operation + " db schema: " + exceptionSqlStatement, e);
        }
    }

    protected String addSqlStatementPiece(String sqlStatement, String line) {
        if (sqlStatement == null) {
            return line;
        }
        return sqlStatement + " \n" + line;
    }

    protected String readNextTrimmedLine(BufferedReader reader) throws IOException {
        String line = reader.readLine();
        if (line != null) {
            line = line.trim();
        }
        return line;
    }

    protected boolean isMissingTablesException(Exception e) {
        String exceptionMessage = e.getMessage();
        if (e.getMessage() != null) {
            if (exceptionMessage.indexOf("Table") != -1 && exceptionMessage.indexOf("not found") != -1) {
                return true;
            }
            if ((exceptionMessage.indexOf("Table") != -1 || exceptionMessage.indexOf("table") != -1) && exceptionMessage.indexOf("doesn't exist") != -1) {
                return true;
            }
            if ((exceptionMessage.indexOf("relation") != -1 || exceptionMessage.indexOf("table") != -1) && exceptionMessage.indexOf("does not exist") != -1) {
                return true;
            }
        }
        return false;
    }

    public SqlSession getSqlSession() {
        return this.sqlSession;
    }

    public DbSqlSessionFactory getDbSqlSessionFactory() {
        return this.dbSqlSessionFactory;
    }
}

