/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.impl.el;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.camunda.bpm.engine.delegate.Expression;
import org.camunda.bpm.engine.delegate.VariableScope;
import org.camunda.bpm.engine.impl.core.variable.CoreVariableScope;
import org.camunda.bpm.engine.impl.el.JuelExpression;
import org.camunda.bpm.engine.impl.el.ProcessApplicationElResolverDelegate;
import org.camunda.bpm.engine.impl.el.ProcessEngineElContext;
import org.camunda.bpm.engine.impl.el.ReadOnlyMapELResolver;
import org.camunda.bpm.engine.impl.el.VariableScopeElResolver;
import org.camunda.bpm.engine.impl.javax.el.ArrayELResolver;
import org.camunda.bpm.engine.impl.javax.el.BeanELResolver;
import org.camunda.bpm.engine.impl.javax.el.CompositeELResolver;
import org.camunda.bpm.engine.impl.javax.el.ELContext;
import org.camunda.bpm.engine.impl.javax.el.ELResolver;
import org.camunda.bpm.engine.impl.javax.el.ExpressionFactory;
import org.camunda.bpm.engine.impl.javax.el.FunctionMapper;
import org.camunda.bpm.engine.impl.javax.el.ListELResolver;
import org.camunda.bpm.engine.impl.javax.el.MapELResolver;
import org.camunda.bpm.engine.impl.javax.el.ValueExpression;
import org.camunda.bpm.engine.impl.juel.ExpressionFactoryImpl;

public class ExpressionManager {
    protected List<FunctionMapper> functionMappers = new ArrayList<FunctionMapper>();
    protected ExpressionFactory expressionFactory;
    protected ELContext parsingElContext = new ProcessEngineElContext(this.functionMappers);
    protected Map<Object, Object> beans;

    public ExpressionManager() {
        this(null);
    }

    public ExpressionManager(Map<Object, Object> beans) {
        this.expressionFactory = new ExpressionFactoryImpl();
        this.beans = beans;
    }

    public Expression createExpression(String expression) {
        ValueExpression valueExpression = this.expressionFactory.createValueExpression(this.parsingElContext, expression, Object.class);
        return new JuelExpression(valueExpression, this, expression);
    }

    public void setExpressionFactory(ExpressionFactory expressionFactory) {
        this.expressionFactory = expressionFactory;
    }

    public ELContext getElContext(VariableScope<?> variableScope) {
        ELContext elContext = null;
        if (variableScope instanceof CoreVariableScope) {
            CoreVariableScope variableScopeImpl = (CoreVariableScope)variableScope;
            elContext = variableScopeImpl.getCachedElContext();
        }
        if (elContext == null) {
            elContext = this.createElContext(variableScope);
            if (variableScope instanceof CoreVariableScope) {
                ((CoreVariableScope)variableScope).setCachedElContext(elContext);
            }
        }
        return elContext;
    }

    protected ProcessEngineElContext createElContext(VariableScope<?> variableScope) {
        ELResolver elResolver = this.createElResolver(variableScope);
        return new ProcessEngineElContext(this.functionMappers, elResolver);
    }

    protected ELResolver createElResolver(VariableScope<?> variableScope) {
        CompositeELResolver elResolver = new CompositeELResolver();
        elResolver.add(new VariableScopeElResolver(variableScope));
        if (this.beans != null) {
            elResolver.add(new ReadOnlyMapELResolver(this.beans));
        }
        elResolver.add(new ProcessApplicationElResolverDelegate());
        elResolver.add(new ArrayELResolver());
        elResolver.add(new ListELResolver());
        elResolver.add(new MapELResolver());
        elResolver.add(new BeanELResolver());
        return elResolver;
    }

    public void addFunctionMapper(FunctionMapper elFunctionMapper) {
        this.functionMappers.add(elFunctionMapper);
    }
}

