/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.impl.form.handler;

import java.util.Map;
import org.camunda.bpm.engine.ProcessEngineException;
import org.camunda.bpm.engine.form.FormFieldValidationConstraint;
import org.camunda.bpm.engine.impl.form.FormFieldValidationConstraintImpl;
import org.camunda.bpm.engine.impl.form.handler.DefaultFormFieldValidatorContext;
import org.camunda.bpm.engine.impl.form.handler.FormFieldHandler;
import org.camunda.bpm.engine.impl.form.validator.FormFieldValidator;
import org.camunda.bpm.engine.impl.persistence.entity.ExecutionEntity;

public class FormFieldValidationConstraintHandler {
    protected String name;
    protected String config;
    protected FormFieldValidator validator;

    public FormFieldValidationConstraint createValidationConstraint(ExecutionEntity execution) {
        return new FormFieldValidationConstraintImpl(this.name, this.config);
    }

    public void validate(Object submittedValue, Map<String, Object> submittedValues, FormFieldHandler formFieldHandler, ExecutionEntity execution) {
        boolean isValid = this.validator.validate(submittedValue, new DefaultFormFieldValidatorContext(execution, this.config, submittedValues));
        if (!isValid) {
            throw new ProcessEngineException("Invalid value submitted for form field '" + formFieldHandler.getId() + "': validation of " + this + " failed.");
        }
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setConfig(String config) {
        this.config = config;
    }

    public String getConfig() {
        return this.config;
    }

    public void setValidator(FormFieldValidator validator) {
        this.validator = validator;
    }

    public FormFieldValidator getValidator() {
        return this.validator;
    }

    public String toString() {
        return this.name + (this.config != null ? "(" + this.config + ")" : "");
    }
}

