/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.impl.interceptor;

import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.ibatis.exceptions.PersistenceException;
import org.camunda.bpm.engine.ProcessEngineException;
import org.camunda.bpm.engine.impl.interceptor.Command;

public class CommandInvocationContext {
    private static Logger log = Logger.getLogger(CommandInvocationContext.class.getName());
    protected Throwable throwable;
    protected Command<?> command;

    public CommandInvocationContext(Command<?> command) {
        this.command = command;
    }

    public Throwable getThrowable() {
        return this.throwable;
    }

    public Command<?> getCommand() {
        return this.command;
    }

    public void trySetThrowable(Throwable t) {
        if (this.throwable == null) {
            this.throwable = t;
        } else {
            log.log(Level.SEVERE, "masked exception in command context. for root cause, see below as it will be rethrown later.", this.throwable);
        }
    }

    public void rethrow() {
        if (this.throwable != null) {
            if (this.throwable instanceof Error) {
                throw (Error)this.throwable;
            }
            if (this.throwable instanceof PersistenceException) {
                throw new ProcessEngineException("Process engine persistence exception", this.throwable);
            }
            if (this.throwable instanceof RuntimeException) {
                throw (RuntimeException)this.throwable;
            }
            throw new ProcessEngineException("exception while executing command " + this.command, this.throwable);
        }
    }
}

