/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.impl.jobexecutor;

import java.text.SimpleDateFormat;
import java.util.Date;
import org.camunda.bpm.engine.ProcessEngineException;
import org.camunda.bpm.engine.delegate.Expression;
import org.camunda.bpm.engine.delegate.PersistentVariableInstance;
import org.camunda.bpm.engine.delegate.VariableScope;
import org.camunda.bpm.engine.impl.bpmn.behavior.ParallelMultiInstanceBehavior;
import org.camunda.bpm.engine.impl.calendar.BusinessCalendar;
import org.camunda.bpm.engine.impl.context.Context;
import org.camunda.bpm.engine.impl.el.StartProcessVariableScope;
import org.camunda.bpm.engine.impl.jobexecutor.JobDeclaration;
import org.camunda.bpm.engine.impl.jobexecutor.TimerDeclarationType;
import org.camunda.bpm.engine.impl.persistence.entity.ExecutionEntity;
import org.camunda.bpm.engine.impl.persistence.entity.TimerEntity;
import org.camunda.bpm.engine.impl.pvm.process.ActivityImpl;
import org.camunda.bpm.engine.impl.util.ClockUtil;

public class TimerDeclarationImpl
extends JobDeclaration<TimerEntity> {
    private static final long serialVersionUID = 1L;
    protected Expression description;
    protected TimerDeclarationType type;
    protected String repeat;
    protected boolean isInterruptingTimer;
    protected String eventScopeActivityId = null;
    protected Boolean isParallelMultiInstance;

    public TimerDeclarationImpl(Expression expression, TimerDeclarationType type, String jobHandlerType) {
        super(jobHandlerType);
        this.description = expression;
        this.type = type;
    }

    public boolean isInterruptingTimer() {
        return this.isInterruptingTimer;
    }

    public void setInterruptingTimer(boolean isInterruptingTimer) {
        this.isInterruptingTimer = isInterruptingTimer;
    }

    public String getRepeat() {
        return this.repeat;
    }

    public void setEventScopeActivityId(String eventScopeActivityId) {
        this.eventScopeActivityId = eventScopeActivityId;
    }

    public String getEventScopeActivityId() {
        return this.eventScopeActivityId;
    }

    @Override
    protected TimerEntity newJobInstance(ExecutionEntity execution) {
        Object dueDateValue;
        BusinessCalendar businessCalendar = Context.getProcessEngineConfiguration().getBusinessCalendarManager().getBusinessCalendar(this.type.calendarName);
        if (this.description == null) {
            throw new ProcessEngineException("Timer '" + execution.getActivityId() + "' was not configured with a valid duration/time");
        }
        String dueDateString = null;
        Date duedate = null;
        VariableScope<PersistentVariableInstance> scopeForExpression = execution;
        if (scopeForExpression == null) {
            scopeForExpression = StartProcessVariableScope.getSharedInstance();
        }
        if ((dueDateValue = this.description.getValue(scopeForExpression)) instanceof String) {
            dueDateString = (String)dueDateValue;
        } else if (dueDateValue instanceof Date) {
            duedate = (Date)dueDateValue;
        } else {
            throw new ProcessEngineException("Timer '" + execution.getActivityId() + "' was not configured with a valid duration/time, either hand in a java.util.Date or a String in format 'yyyy-MM-dd'T'hh:mm:ss'");
        }
        if (duedate == null) {
            duedate = businessCalendar.resolveDuedate(dueDateString);
        }
        TimerEntity timer = new TimerEntity(this);
        timer.setDuedate(duedate);
        if (execution != null) {
            timer.setExecution(execution);
        }
        if (this.type == TimerDeclarationType.CYCLE && !this.isInterruptingTimer) {
            String prepared = this.prepareRepeat(dueDateString);
            timer.setRepeat(prepared);
        }
        return timer;
    }

    protected String prepareRepeat(String dueDate) {
        if (dueDate.startsWith("R") && dueDate.split("/").length == 2) {
            SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss");
            return dueDate.replace("/", "/" + sdf.format(ClockUtil.getCurrentTime()) + "/");
        }
        return dueDate;
    }

    private boolean isParallelMultiInstance(ExecutionEntity execution) {
        if (this.isParallelMultiInstance == null) {
            if (this.eventScopeActivityId == null) {
                this.isParallelMultiInstance = false;
            } else {
                ActivityImpl activity = execution.getProcessDefinition().findActivity(this.eventScopeActivityId);
                this.isParallelMultiInstance = activity.getActivityBehavior() instanceof ParallelMultiInstanceBehavior;
            }
        }
        return this.isParallelMultiInstance;
    }

    public TimerEntity createTimerInstance(ExecutionEntity execution) {
        if (this.isParallelMultiInstance(execution)) {
            return null;
        }
        return this.createTimer(execution);
    }

    public TimerEntity createTimerInstanceForParallelMultiInstance(ExecutionEntity execution) {
        if (this.isParallelMultiInstance(execution)) {
            return this.createTimer(execution);
        }
        return null;
    }

    public TimerEntity createTimer(ExecutionEntity execution) {
        TimerEntity timer = (TimerEntity)super.createJobInstance(execution);
        Context.getCommandContext().getJobManager().schedule(timer);
        return timer;
    }
}

