/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.impl.json;

import org.camunda.bpm.engine.impl.QueryOperator;
import org.camunda.bpm.engine.impl.TaskQueryVariableValue;
import org.camunda.bpm.engine.impl.json.JsonObjectConverter;
import org.camunda.bpm.engine.impl.util.json.JSONObject;

public class JsonTaskQueryVariableValueConverter
extends JsonObjectConverter<TaskQueryVariableValue> {
    @Override
    public JSONObject toJsonObject(TaskQueryVariableValue variable) {
        JSONObject json = new JSONObject();
        json.put("name", variable.getName());
        json.put("value", variable.getValue());
        json.put("operator", variable.getOperator());
        return json;
    }

    @Override
    public TaskQueryVariableValue toObject(JSONObject json) {
        String name = json.getString("name");
        Object value = json.get("value");
        QueryOperator operator = QueryOperator.valueOf(json.getString("operator"));
        boolean isTaskVariable = json.getBoolean("taskVariable");
        boolean isProcessVariable = json.getBoolean("processVariable");
        return new TaskQueryVariableValue(name, value, operator, isTaskVariable, isProcessVariable);
    }
}

