/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.impl.persistence.entity;

import java.util.Date;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.camunda.bpm.engine.impl.calendar.BusinessCalendar;
import org.camunda.bpm.engine.impl.calendar.CycleBusinessCalendar;
import org.camunda.bpm.engine.impl.context.Context;
import org.camunda.bpm.engine.impl.interceptor.CommandContext;
import org.camunda.bpm.engine.impl.jobexecutor.TimerDeclarationImpl;
import org.camunda.bpm.engine.impl.persistence.entity.JobEntity;

public class TimerEntity
extends JobEntity {
    private static final long serialVersionUID = 1L;
    private static Logger log = Logger.getLogger(TimerEntity.class.getName());
    protected String repeat;

    public TimerEntity() {
    }

    public TimerEntity(TimerDeclarationImpl timerDeclaration) {
        this.repeat = timerDeclaration.getRepeat();
    }

    private TimerEntity(TimerEntity te) {
        this.jobHandlerConfiguration = te.jobHandlerConfiguration;
        this.jobHandlerType = te.jobHandlerType;
        this.isExclusive = te.isExclusive;
        this.repeat = te.repeat;
        this.retries = te.retries;
        this.executionId = te.executionId;
        this.processInstanceId = te.processInstanceId;
        this.jobDefinitionId = te.jobDefinitionId;
        this.suspensionState = te.suspensionState;
    }

    @Override
    public void execute(CommandContext commandContext) {
        super.execute(commandContext);
        if (this.repeat == null) {
            if (log.isLoggable(Level.FINE)) {
                log.fine("Timer " + this.getId() + " fired. Deleting timer.");
            }
            this.delete(true);
        } else {
            this.delete(true);
            Date newTimer = this.calculateRepeat();
            if (newTimer != null) {
                TimerEntity te = new TimerEntity(this);
                te.setDuedate(newTimer);
                Context.getCommandContext().getJobManager().schedule(te);
            }
        }
    }

    private Date calculateRepeat() {
        BusinessCalendar businessCalendar = Context.getProcessEngineConfiguration().getBusinessCalendarManager().getBusinessCalendar(CycleBusinessCalendar.NAME);
        return businessCalendar.resolveDuedate(this.repeat);
    }

    public String getRepeat() {
        return this.repeat;
    }

    public void setRepeat(String repeat) {
        this.repeat = repeat;
    }

    @Override
    public String toString() {
        return this.getClass().getSimpleName() + "[repeat" + this.repeat + ", id=" + this.id + ", revision=" + this.revision + ", duedate=" + this.duedate + ", lockOwner=" + this.lockOwner + ", lockExpirationTime=" + this.lockExpirationTime + ", executionId=" + this.executionId + ", processInstanceId=" + this.processInstanceId + ", isExclusive=" + this.isExclusive + ", retries=" + this.retries + ", jobHandlerType=" + this.jobHandlerType + ", jobHandlerConfiguration=" + this.jobHandlerConfiguration + ", exceptionByteArray=" + this.exceptionByteArray + ", exceptionByteArrayId=" + this.exceptionByteArrayId + ", exceptionMessage=" + this.exceptionMessage + ", deploymentId=" + this.deploymentId + "]";
    }
}

