/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.impl.persistence.entity;

import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;
import org.camunda.bpm.engine.delegate.SerializedVariableValue;
import org.camunda.bpm.engine.impl.context.Context;
import org.camunda.bpm.engine.impl.db.DbEntity;
import org.camunda.bpm.engine.impl.db.HasDbRevision;
import org.camunda.bpm.engine.impl.persistence.entity.ByteArrayEntity;
import org.camunda.bpm.engine.impl.persistence.entity.ExecutionEntity;
import org.camunda.bpm.engine.impl.variable.ValueFields;
import org.camunda.bpm.engine.impl.variable.VariableType;
import org.camunda.bpm.engine.runtime.VariableInstance;

public class VariableInstanceEntity
implements VariableInstance,
ValueFields,
DbEntity,
HasDbRevision,
Serializable {
    private static final long serialVersionUID = 1L;
    protected String id;
    protected int revision;
    protected String name;
    protected String processInstanceId;
    protected String executionId;
    protected String taskId;
    protected String caseInstanceId;
    protected String caseExecutionId;
    protected String activityInstanceId;
    protected Long longValue;
    protected Double doubleValue;
    protected String textValue;
    protected String textValue2;
    protected ByteArrayEntity byteArrayValue;
    protected String byteArrayValueId;
    protected Object cachedValue;
    protected VariableType type;
    boolean forcedUpdate;
    protected String errorMessage;
    protected String dataFormatId;
    protected String configuration;
    protected String typeName;

    public static VariableInstanceEntity createAndInsert(String name, VariableType type, Object value) {
        VariableInstanceEntity variableInstance = VariableInstanceEntity.create(name, type, value);
        VariableInstanceEntity.insert(variableInstance);
        return variableInstance;
    }

    public static void insert(VariableInstanceEntity variableInstance) {
        Context.getCommandContext().getDbEntityManager().insert(variableInstance);
    }

    public static VariableInstanceEntity create(String name, VariableType type, Object value) {
        VariableInstanceEntity variableInstance = new VariableInstanceEntity();
        variableInstance.name = name;
        variableInstance.setType(type);
        variableInstance.setValue(value);
        return variableInstance;
    }

    public static VariableInstanceEntity createFromSerializedValue(String name, VariableType type, Object value, Map<String, Object> configuration) {
        VariableInstanceEntity variableInstance = new VariableInstanceEntity();
        variableInstance.name = name;
        variableInstance.setType(type);
        variableInstance.setValueFromSerialized(value, configuration);
        return variableInstance;
    }

    public void setExecution(ExecutionEntity execution) {
        this.executionId = execution.getId();
        this.processInstanceId = execution.getProcessInstanceId();
        this.forcedUpdate = true;
    }

    public void delete() {
        Context.getCommandContext().getDbEntityManager().delete(this);
        this.deleteByteArrayValue();
    }

    @Override
    public Object getPersistentState() {
        HashMap<String, Object> persistentState = new HashMap<String, Object>();
        if (this.type != null) {
            persistentState.put("type", this.type);
        }
        if (this.longValue != null) {
            persistentState.put("longValue", this.longValue);
        }
        if (this.doubleValue != null) {
            persistentState.put("doubleValue", this.doubleValue);
        }
        if (this.textValue != null) {
            persistentState.put("textValue", this.textValue);
        }
        if (this.textValue2 != null) {
            persistentState.put("textValue2", this.textValue2);
        }
        if (this.byteArrayValueId != null) {
            persistentState.put("byteArrayValueId", this.byteArrayValueId);
        }
        if (this.forcedUpdate) {
            persistentState.put("forcedUpdate", Boolean.TRUE);
        }
        if (this.dataFormatId != null) {
            persistentState.put("dataFormatId", this.dataFormatId);
        }
        return persistentState;
    }

    @Override
    public int getRevisionNext() {
        return this.revision + 1;
    }

    public void setProcessInstanceId(String processInstanceId) {
        this.processInstanceId = processInstanceId;
    }

    public void setExecutionId(String executionId) {
        this.executionId = executionId;
    }

    public void setCaseInstanceId(String caseInstanceId) {
        this.caseInstanceId = caseInstanceId;
    }

    public void setCaseExecutionId(String caseExecutionId) {
        this.caseExecutionId = caseExecutionId;
    }

    @Override
    public String getByteArrayValueId() {
        return this.byteArrayValueId;
    }

    public void setByteArrayValueId(String byteArrayValueId) {
        this.byteArrayValueId = byteArrayValueId;
        this.byteArrayValue = null;
    }

    @Override
    public ByteArrayEntity getByteArrayValue() {
        if (this.byteArrayValue == null && this.byteArrayValueId != null && Context.getCommandContext() != null) {
            this.byteArrayValue = Context.getCommandContext().getDbEntityManager().selectById(ByteArrayEntity.class, this.byteArrayValueId);
        }
        return this.byteArrayValue;
    }

    @Override
    public void setByteArrayValue(byte[] bytes) {
        ByteArrayEntity byteArrayValue = null;
        if (this.byteArrayValueId != null) {
            this.getByteArrayValue();
            Context.getCommandContext().getByteArrayManager().deleteByteArrayById(this.byteArrayValueId);
        }
        if (bytes != null) {
            byteArrayValue = new ByteArrayEntity(bytes);
            Context.getCommandContext().getDbEntityManager().insert(byteArrayValue);
        }
        this.byteArrayValue = byteArrayValue;
        this.byteArrayValueId = byteArrayValue != null ? byteArrayValue.getId() : null;
    }

    protected void deleteByteArrayValue() {
        if (this.byteArrayValueId != null) {
            this.getByteArrayValue();
            Context.getCommandContext().getByteArrayManager().deleteByteArrayById(this.byteArrayValueId);
        }
    }

    public void clear() {
        if (this.byteArrayValueId == null) {
            this.setValue(null);
        } else {
            this.deleteByteArrayValue();
            this.setByteArrayValueId(null);
        }
    }

    @Override
    public Object getValue() {
        if (!(this.errorMessage != null || this.getType().isCachable() && this.cachedValue != null)) {
            try {
                this.cachedValue = this.getType().getValue(this);
            }
            catch (RuntimeException e) {
                this.errorMessage = e.getMessage();
                throw e;
            }
        }
        return this.cachedValue;
    }

    public void setValue(Object value) {
        this.getType().setValue(value, this);
        this.cachedValue = value;
    }

    public void setValueFromSerialized(Object value, Map<String, Object> configuration) {
        this.type.setValueFromSerialized(value, configuration, this);
        this.cachedValue = null;
    }

    public boolean isAbleToStore(Object value) {
        return this.getType().isAbleToStore(value);
    }

    public boolean isAbleToStoreSerializedValue(Object value, Map<String, Object> configuration) {
        return this.type.isAbleToStoreSerializedValue(value, configuration);
    }

    @Override
    public String getId() {
        return this.id;
    }

    @Override
    public void setId(String id) {
        this.id = id;
    }

    @Override
    public String getTextValue() {
        return this.textValue;
    }

    @Override
    public String getProcessInstanceId() {
        return this.processInstanceId;
    }

    @Override
    public String getExecutionId() {
        return this.executionId;
    }

    @Override
    public String getCaseInstanceId() {
        return this.caseInstanceId;
    }

    @Override
    public String getCaseExecutionId() {
        return this.caseExecutionId;
    }

    @Override
    public Long getLongValue() {
        return this.longValue;
    }

    @Override
    public void setLongValue(Long longValue) {
        this.longValue = longValue;
    }

    @Override
    public Double getDoubleValue() {
        return this.doubleValue;
    }

    @Override
    public void setDoubleValue(Double doubleValue) {
        this.doubleValue = doubleValue;
    }

    public void setName(String name) {
        this.name = name;
    }

    @Override
    public void setTextValue(String textValue) {
        this.textValue = textValue;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public int getRevision() {
        return this.revision;
    }

    @Override
    public void setRevision(int revision) {
        this.revision = revision;
    }

    public void setType(VariableType type) {
        this.type = type;
        this.typeName = type.getTypeName();
    }

    public void setTypeName(String type) {
        this.typeName = type;
    }

    public VariableType getType() {
        this.ensureTypeInitialized();
        return this.type;
    }

    protected void ensureTypeInitialized() {
        if (this.type == null && this.typeName != null) {
            this.type = Context.getProcessEngineConfiguration().getVariableTypes().getVariableType(this.typeName);
        }
    }

    @Override
    public Object getCachedValue() {
        return this.cachedValue;
    }

    @Override
    public void setCachedValue(Object cachedValue) {
        this.cachedValue = cachedValue;
    }

    @Override
    public String getTextValue2() {
        return this.textValue2;
    }

    @Override
    public void setTextValue2(String textValue2) {
        this.textValue2 = textValue2;
    }

    @Override
    public String getTaskId() {
        return this.taskId;
    }

    public void setTaskId(String taskId) {
        this.taskId = taskId;
    }

    @Override
    public String getActivityInstanceId() {
        return this.activityInstanceId;
    }

    public void setActivityInstanceId(String acitivtyInstanceId) {
        this.activityInstanceId = acitivtyInstanceId;
    }

    @Override
    public String getTypeName() {
        return this.typeName;
    }

    @Override
    public String getErrorMessage() {
        return this.errorMessage;
    }

    @Override
    public String getDataFormatId() {
        return this.dataFormatId;
    }

    @Override
    public void setDataFormatId(String dataFormatId) {
        this.dataFormatId = dataFormatId;
    }

    public String getVariableScope() {
        if (this.taskId != null) {
            return this.taskId;
        }
        if (this.executionId != null) {
            return this.executionId;
        }
        return this.caseExecutionId;
    }

    @Override
    public SerializedVariableValue getSerializedValue() {
        return this.type.getSerializedValue(this);
    }

    @Override
    public String getValueTypeName() {
        return this.type.getTypeNameForValue(this);
    }

    @Override
    public boolean storesCustomObjects() {
        return this.type.storesCustomObjects();
    }

    public String toString() {
        return this.getClass().getSimpleName() + "[id=" + this.id + ", revision=" + this.revision + ", name=" + this.name + ", processInstanceId=" + this.processInstanceId + ", executionId=" + this.executionId + ", caseInstanceId=" + this.caseInstanceId + ", caseExecutionId=" + this.caseExecutionId + ", taskId=" + this.taskId + ", activityInstanceId=" + this.activityInstanceId + ", longValue=" + this.longValue + ", doubleValue=" + this.doubleValue + ", textValue=" + this.textValue + ", textValue2=" + this.textValue2 + ", byteArrayValue=" + this.byteArrayValue + ", byteArrayValueId=" + this.byteArrayValueId + ", forcedUpdate=" + this.forcedUpdate + ", dataFormatId=" + this.dataFormatId + ", configuration=" + this.configuration + "]";
    }
}

