/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.impl.scripting;

import javax.script.CompiledScript;
import org.camunda.bpm.engine.impl.scripting.CompiledExecutableScript;
import org.camunda.bpm.engine.impl.scripting.ExecutableScript;
import org.camunda.bpm.engine.impl.scripting.SourceExecutableScript;
import org.camunda.bpm.engine.impl.scripting.engine.ScriptingEngines;

public class ScriptFactory {
    protected ScriptingEngines scriptingEngines;
    protected boolean compileScripts;

    public ScriptFactory(ScriptingEngines scriptingEngines, boolean compileScripts) {
        this.scriptingEngines = scriptingEngines;
        this.compileScripts = compileScripts;
    }

    public ExecutableScript createScript(String src, String language) {
        CompiledScript compiledScript = null;
        if (this.compileScripts) {
            compiledScript = this.scriptingEngines.compile(src, language);
        }
        if (compiledScript != null) {
            return new CompiledExecutableScript(language, compiledScript);
        }
        return new SourceExecutableScript(language, src);
    }

    public ScriptingEngines getScriptingEngines() {
        return this.scriptingEngines;
    }
}

