/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.impl.spin;

import java.io.UnsupportedEncodingException;
import java.util.HashMap;
import java.util.Map;
import org.camunda.bpm.engine.ProcessEngineException;
import org.camunda.bpm.engine.delegate.ProcessEngineVariableType;
import org.camunda.bpm.engine.delegate.SerializedVariableValue;
import org.camunda.bpm.engine.impl.core.variable.SerializedVariableValueImpl;
import org.camunda.bpm.engine.impl.persistence.entity.ByteArrayEntity;
import org.camunda.bpm.engine.impl.variable.ValueFields;
import org.camunda.bpm.engine.impl.variable.VariableType;
import org.camunda.spin.DataFormats;
import org.camunda.spin.Spin;
import org.camunda.spin.SpinFactory;
import org.camunda.spin.SpinRuntimeException;
import org.camunda.spin.spi.DataFormat;

public class SpinSerializationType
implements VariableType {
    protected Map<String, DataFormat<?>> availableDataFormats = new HashMap();
    protected DataFormat<?> defaultDataFormat;
    protected static final String CONFIG_DATA_FORMAT = "dataFormatId";
    protected static final String CONFIG_ROOT_TYPE = "rootType";

    public SpinSerializationType(DataFormat<?> defaultDataFormat) {
        for (DataFormat format : DataFormats.getAvailableDataFormats()) {
            this.availableDataFormats.put(format.getName(), format.newInstance());
        }
        this.defaultDataFormat = defaultDataFormat.newInstance();
    }

    @Override
    public String getTypeName() {
        return ProcessEngineVariableType.SPIN.getName();
    }

    @Override
    public boolean isCachable() {
        return true;
    }

    @Override
    public boolean isAbleToStore(Object value) {
        return true;
    }

    @Override
    public void setValue(Object value, ValueFields valueFields) {
        try {
            Spin spin = SpinFactory.getInstance().createSpinFromObject(value, this.defaultDataFormat);
            String serializedVariable = spin.toString();
            this.setValue(serializedVariable, this.defaultDataFormat.getName(), this.defaultDataFormat.getCanonicalTypeName(value), valueFields);
        }
        catch (SpinRuntimeException e) {
            throw new ProcessEngineException("Cannot serialize object of type " + value.getClass() + ": " + value, e);
        }
    }

    protected void setValue(String serializedValue, String dataFormatId, String valueType, ValueFields valueFields) {
        if (serializedValue == null) {
            valueFields.setTextValue(null);
        } else if (serializedValue.getBytes().length <= 4000) {
            valueFields.setTextValue(serializedValue);
        } else {
            valueFields.setByteArrayValue(serializedValue.getBytes());
        }
        valueFields.setDataFormatId(dataFormatId);
        valueFields.setTextValue2(valueType);
    }

    @Override
    public Object getValue(ValueFields valueFields) {
        try {
            String dataFormatId = valueFields.getDataFormatId();
            if (!this.availableDataFormats.containsKey(dataFormatId)) {
                throw new ProcessEngineException("No data format found thatmatches the data format " + dataFormatId + " of variable " + valueFields.getName());
            }
            String variableValue = valueFields.getTextValue();
            if (variableValue == null) {
                ByteArrayEntity byteEntity = valueFields.getByteArrayValue();
                if (byteEntity == null) {
                    return null;
                }
                variableValue = new String(valueFields.getByteArrayValue().getBytes());
            }
            Spin spinNode = SpinFactory.getInstance().createSpinFromString(variableValue, this.availableDataFormats.get(dataFormatId));
            return spinNode.mapTo(valueFields.getTextValue2());
        }
        catch (SpinRuntimeException e) {
            throw new ProcessEngineException("Cannot deserialize variable '" + valueFields.getName() + "' of format '" + valueFields.getDataFormatId() + "' with configuration '" + valueFields.getTextValue2() + "'", e);
        }
    }

    public DataFormat<?> getDefaultDataFormat() {
        return this.defaultDataFormat;
    }

    @Override
    public SerializedVariableValue getSerializedValue(ValueFields valueFields) {
        SerializedVariableValueImpl value = new SerializedVariableValueImpl();
        String serializedValue = null;
        if (valueFields.getTextValue() != null) {
            serializedValue = valueFields.getTextValue();
        } else if (valueFields.getByteArrayValue() != null) {
            try {
                ByteArrayEntity byteArray = valueFields.getByteArrayValue();
                serializedValue = new String(byteArray.getBytes(), "UTF-8");
            }
            catch (UnsupportedEncodingException e) {
                throw new ProcessEngineException("UTF-8 is not a supported encoding", e);
            }
        }
        value.setValue(serializedValue);
        value.setConfigValue(CONFIG_DATA_FORMAT, valueFields.getDataFormatId());
        value.setConfigValue(CONFIG_ROOT_TYPE, valueFields.getTextValue2());
        return value;
    }

    @Override
    public void setValueFromSerialized(Object serializedValue, Map<String, Object> configuration, ValueFields valueFields) {
        String dataFormatName = (String)configuration.get(CONFIG_DATA_FORMAT);
        String rootType = (String)configuration.get(CONFIG_ROOT_TYPE);
        this.setValue((String)serializedValue, dataFormatName, rootType, valueFields);
    }

    @Override
    public boolean isAbleToStoreSerializedValue(Object value, Map<String, Object> configuration) {
        return this.isValidObjectSerializedInput(value, configuration) || this.isValidNullInput(value, configuration);
    }

    protected boolean isValidObjectSerializedInput(Object value, Map<String, Object> configuration) {
        return value instanceof String && configuration != null && configuration.get(CONFIG_DATA_FORMAT) instanceof String && configuration.get(CONFIG_ROOT_TYPE) instanceof String && this.availableDataFormats.containsKey(configuration.get(CONFIG_DATA_FORMAT));
    }

    protected boolean isValidNullInput(Object value, Map<String, Object> configuration) {
        return value == null && configuration != null && configuration.get(CONFIG_DATA_FORMAT) instanceof String && configuration.get(CONFIG_ROOT_TYPE) instanceof String && this.availableDataFormats.containsKey(configuration.get(CONFIG_DATA_FORMAT));
    }

    @Override
    public String getTypeNameForValue(ValueFields valueFields) {
        return Object.class.getSimpleName();
    }

    @Override
    public boolean storesCustomObjects() {
        return true;
    }
}

