/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.impl.util;

import java.lang.reflect.Constructor;
import java.util.Collection;
import java.util.Map;
import org.camunda.bpm.engine.ProcessEngineException;
import org.camunda.bpm.engine.exception.NullValueException;

public final class EnsureUtil {
    public static void ensureNotNull(String variableName, Object value) {
        EnsureUtil.ensureNotNull("", variableName, value);
    }

    public static void ensureNotNull(Class<? extends ProcessEngineException> exceptionClass, String variableName, Object value) {
        EnsureUtil.ensureNotNull(exceptionClass, null, variableName, value);
    }

    public static void ensureNotNull(String message, String variableName, Object value) {
        EnsureUtil.ensureNotNull(NullValueException.class, message, variableName, value);
    }

    public static void ensureNotNull(Class<? extends ProcessEngineException> exceptionClass, String message, String variableName, Object value) {
        if (value == null) {
            throw EnsureUtil.generateException(exceptionClass, message, variableName, "is null");
        }
    }

    public static void ensureNull(Class<? extends ProcessEngineException> exceptionClass, String message, String variableName, Object value) {
        if (value != null) {
            throw EnsureUtil.generateException(exceptionClass, message, variableName, "is not null");
        }
    }

    public static void ensureNotNull(String variableName, Object ... values) {
        EnsureUtil.ensureNotNull("", variableName, values);
    }

    public static void ensureNotNull(Class<? extends ProcessEngineException> exceptionClass, String variableName, Object ... values) {
        EnsureUtil.ensureNotNull(exceptionClass, null, variableName, values);
    }

    public static void ensureNotNull(String message, String variableName, Object ... values) {
        EnsureUtil.ensureNotNull(NullValueException.class, message, variableName, values);
    }

    public static void ensureNotNull(Class<? extends ProcessEngineException> exceptionClass, String message, String variableName, Object ... values) {
        if (values == null) {
            throw EnsureUtil.generateException(exceptionClass, message, variableName, "is null");
        }
        for (Object value : values) {
            if (value != null) continue;
            throw EnsureUtil.generateException(exceptionClass, message, variableName, "contains null value");
        }
    }

    public static void ensureNotEmpty(String variableName, String value) {
        EnsureUtil.ensureNotEmpty("", variableName, value);
    }

    public static void ensureNotEmpty(Class<? extends ProcessEngineException> exceptionClass, String variableName, String value) {
        EnsureUtil.ensureNotEmpty(exceptionClass, null, variableName, value);
    }

    public static void ensureNotEmpty(String message, String variableName, String value) {
        EnsureUtil.ensureNotEmpty(ProcessEngineException.class, message, variableName, value);
    }

    public static void ensureNotEmpty(Class<? extends ProcessEngineException> exceptionClass, String message, String variableName, String value) {
        EnsureUtil.ensureNotNull(exceptionClass, message, variableName, (Object)value);
        if (value.trim().isEmpty()) {
            throw EnsureUtil.generateException(exceptionClass, message, variableName, "is empty");
        }
    }

    public static void ensureNotEmpty(String variableName, Collection collection) {
        EnsureUtil.ensureNotEmpty("", variableName, collection);
    }

    public static void ensureNotEmpty(Class<? extends ProcessEngineException> exceptionClass, String variableName, Collection collection) {
        EnsureUtil.ensureNotEmpty(exceptionClass, null, variableName, collection);
    }

    public static void ensureNotEmpty(String message, String variableName, Collection collection) {
        EnsureUtil.ensureNotEmpty(ProcessEngineException.class, message, variableName, collection);
    }

    public static void ensureNotEmpty(Class<? extends ProcessEngineException> exceptionClass, String message, String variableName, Collection collection) {
        EnsureUtil.ensureNotNull(exceptionClass, message, variableName, (Object)collection);
        if (collection.isEmpty()) {
            throw EnsureUtil.generateException(exceptionClass, message, variableName, "is empty");
        }
    }

    public static void ensureNotEmpty(String variableName, Map map) {
        EnsureUtil.ensureNotEmpty("", variableName, map);
    }

    public static void ensureNotEmpty(Class<? extends ProcessEngineException> exceptionClass, String variableName, Map map) {
        EnsureUtil.ensureNotEmpty(exceptionClass, null, variableName, map);
    }

    public static void ensureNotEmpty(String message, String variableName, Map map) {
        EnsureUtil.ensureNotEmpty(ProcessEngineException.class, message, variableName, map);
    }

    public static void ensureNotEmpty(Class<? extends ProcessEngineException> exceptionClass, String message, String variableName, Map map) {
        EnsureUtil.ensureNotNull(exceptionClass, message, variableName, (Object)map);
        if (map.isEmpty()) {
            throw EnsureUtil.generateException(exceptionClass, message, variableName, "is empty");
        }
    }

    public static void ensurePositive(String variableName, Integer value) {
        EnsureUtil.ensurePositive("", variableName, value);
    }

    public static void ensurePositive(Class<? extends ProcessEngineException> exceptionClass, String variableName, Integer value) {
        EnsureUtil.ensurePositive(exceptionClass, null, variableName, value);
    }

    public static void ensurePositive(String message, String variableName, Integer value) {
        EnsureUtil.ensurePositive(ProcessEngineException.class, message, variableName, value);
    }

    public static void ensurePositive(Class<? extends ProcessEngineException> exceptionClass, String message, String variableName, Integer value) {
        EnsureUtil.ensureNotNull(exceptionClass, variableName, (Object)value);
        if (value <= 0) {
            throw EnsureUtil.generateException(exceptionClass, message, variableName, "is not positive");
        }
    }

    public static void ensureInstanceOf(String variableName, Object value, Class<?> expectedClass) {
        EnsureUtil.ensureInstanceOf("", variableName, value, expectedClass);
    }

    public static void ensureInstanceOf(Class<? extends ProcessEngineException> exceptionClass, String variableName, Object value, Class<?> expectedClass) {
        EnsureUtil.ensureInstanceOf(exceptionClass, null, variableName, value, expectedClass);
    }

    public static void ensureInstanceOf(String message, String variableName, Object value, Class<?> expectedClass) {
        EnsureUtil.ensureInstanceOf(ProcessEngineException.class, message, variableName, value, expectedClass);
    }

    public static void ensureInstanceOf(Class<? extends ProcessEngineException> exceptionClass, String message, String variableName, Object value, Class<?> expectedClass) {
        EnsureUtil.ensureNotNull(exceptionClass, message, variableName, value);
        Class<?> valueClass = value.getClass();
        if (!expectedClass.isAssignableFrom(valueClass)) {
            throw EnsureUtil.generateException(exceptionClass, message, variableName, "has class " + valueClass.getName() + " and not " + expectedClass.getName());
        }
    }

    public static void ensureOnlyOneNotNull(String message, Object ... values) {
        EnsureUtil.ensureOnlyOneNotNull(NullValueException.class, message, values);
    }

    public static void ensureOnlyOneNotNull(Class<? extends ProcessEngineException> exceptionClass, String message, Object ... values) {
        boolean oneNotNull = false;
        for (Object value : values) {
            if (value == null) continue;
            if (oneNotNull) {
                throw EnsureUtil.generateException(exceptionClass, null, null, message);
            }
            oneNotNull = true;
        }
        if (!oneNotNull) {
            throw EnsureUtil.generateException(exceptionClass, null, null, message);
        }
    }

    public static void ensureAtLeastOneNotNull(String message, Object ... values) {
        EnsureUtil.ensureAtLeastOneNotNull(NullValueException.class, message, values);
    }

    public static void ensureAtLeastOneNotNull(Class<? extends ProcessEngineException> exceptionClass, String message, Object ... values) {
        for (Object value : values) {
            if (value == null) continue;
            return;
        }
        throw EnsureUtil.generateException(exceptionClass, null, null, message);
    }

    protected static <T extends ProcessEngineException> T generateException(Class<T> exceptionClass, String message, String variableName, String description) {
        String formattedMessage = EnsureUtil.formatMessage(message, variableName, description);
        try {
            Constructor<T> constructor = exceptionClass.getConstructor(String.class);
            return (T)((ProcessEngineException)constructor.newInstance(formattedMessage));
        }
        catch (Exception e) {
            throw new ProcessEngineException("Couldn't instantiate class " + exceptionClass.getName(), e);
        }
    }

    protected static String formatMessage(String message, String variableName, String description) {
        return EnsureUtil.formatMessageElement(message, ": ") + EnsureUtil.formatMessageElement(variableName, " ") + description;
    }

    protected static String formatMessageElement(String element, String delimiter) {
        if (element != null && !element.isEmpty()) {
            return element.concat(delimiter);
        }
        return "";
    }
}

