/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.impl.variable;

import java.io.Serializable;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.camunda.bpm.engine.BadUserRequestException;
import org.camunda.bpm.engine.delegate.PersistentVariableInstance;
import org.camunda.bpm.engine.delegate.ProcessEngineVariableType;
import org.camunda.bpm.engine.delegate.SerializedVariableValue;
import org.camunda.bpm.engine.impl.cfg.ProcessEngineConfigurationImpl;
import org.camunda.bpm.engine.impl.context.Context;
import org.camunda.bpm.engine.impl.core.variable.CorePersistentVariableStore;
import org.camunda.bpm.engine.impl.core.variable.CoreVariableScope;
import org.camunda.bpm.engine.impl.history.event.HistoryEvent;
import org.camunda.bpm.engine.impl.history.handler.HistoryEventHandler;
import org.camunda.bpm.engine.impl.history.producer.HistoryEventProducer;
import org.camunda.bpm.engine.impl.interceptor.CommandContext;
import org.camunda.bpm.engine.impl.persistence.entity.VariableInstanceEntity;
import org.camunda.bpm.engine.impl.util.EnsureUtil;
import org.camunda.bpm.engine.impl.variable.AbstractVariableStore;
import org.camunda.bpm.engine.impl.variable.VariableType;
import org.camunda.bpm.engine.impl.variable.VariableTypes;

public abstract class AbstractPersistentVariableStore
extends AbstractVariableStore<PersistentVariableInstance>
implements Serializable,
CorePersistentVariableStore {
    private static final long serialVersionUID = 1L;
    protected Map<String, VariableInstanceEntity> variableInstances = null;

    protected abstract List<VariableInstanceEntity> loadVariableInstances();

    protected abstract void initializeVariableInstanceBackPointer(VariableInstanceEntity var1);

    public void ensureVariableInstancesInitialized() {
        if (this.variableInstances == null) {
            this.variableInstances = new HashMap<String, VariableInstanceEntity>();
            CommandContext commandContext = Context.getCommandContext();
            EnsureUtil.ensureNotNull("lazy loading outside command context", "commandContext", (Object)commandContext);
            List<VariableInstanceEntity> variableInstancesList = this.loadVariableInstances();
            for (VariableInstanceEntity variableInstance : variableInstancesList) {
                this.variableInstances.put(variableInstance.getName(), variableInstance);
            }
        }
    }

    @Override
    public Map<String, PersistentVariableInstance> getVariableInstances() {
        this.ensureVariableInstancesInitialized();
        return this.variableInstances;
    }

    public void setVariableInstances(Map<String, VariableInstanceEntity> variableInstances) {
        this.variableInstances = variableInstances;
    }

    @Override
    public Collection<PersistentVariableInstance> getVariableInstancesValues() {
        this.ensureVariableInstancesInitialized();
        return this.variableInstances.values();
    }

    @Override
    public PersistentVariableInstance getVariableInstance(String variableName) {
        this.ensureVariableInstancesInitialized();
        return this.variableInstances.get(variableName);
    }

    @Override
    public Set<String> getVariableNames() {
        this.ensureVariableInstancesInitialized();
        return this.variableInstances.keySet();
    }

    @Override
    public boolean isEmpty() {
        this.ensureVariableInstancesInitialized();
        return this.variableInstances.isEmpty();
    }

    @Override
    public boolean containsVariableInstance(String variableName) {
        this.ensureVariableInstancesInitialized();
        return this.variableInstances.containsKey(variableName);
    }

    @Override
    public PersistentVariableInstance removeVariableInstance(String variableName, CoreVariableScope<PersistentVariableInstance> sourceActivityExecution) {
        this.ensureVariableInstancesInitialized();
        VariableInstanceEntity variable = this.variableInstances.remove(variableName);
        if (variable != null) {
            variable.delete();
            variable.setValue(null);
            if (this.isAutoFireHistoryEvents()) {
                this.fireHistoricVariableInstanceDelete(variable, sourceActivityExecution);
            }
        }
        return variable;
    }

    @Override
    public void setVariableInstanceValue(PersistentVariableInstance variableInstance, Object value, CoreVariableScope<PersistentVariableInstance> sourceActivityExecution) {
        if (value != null && value instanceof SerializedVariableValue) {
            SerializedVariableValue serializedVariableValue = (SerializedVariableValue)value;
            this.setVariableInstanceValueFromSerialized(variableInstance, serializedVariableValue.getValue(), ProcessEngineVariableType.SPIN.getName(), serializedVariableValue.getConfig(), sourceActivityExecution);
        } else {
            VariableInstanceEntity variableInstanceEntity = (VariableInstanceEntity)variableInstance;
            if (!this.canStoreValue(variableInstanceEntity, value)) {
                this.clearForNewValue(variableInstanceEntity, this.getVariableTypeForValue(value));
            }
            variableInstanceEntity.setValue(value);
            if (this.isAutoFireHistoryEvents()) {
                this.fireHistoricVariableInstanceUpdate(variableInstanceEntity, sourceActivityExecution);
            }
        }
    }

    public void setVariableInstanceValueFromSerialized(PersistentVariableInstance variableInstance, Object value, String variableTypeName, Map<String, Object> configuration, CoreVariableScope<PersistentVariableInstance> sourceActivityExecution) {
        VariableInstanceEntity variableInstanceEntity = (VariableInstanceEntity)variableInstance;
        if (!this.canStoreSerializedValue(variableInstanceEntity, value, configuration)) {
            this.clearForNewValue(variableInstanceEntity, this.getVariableTypeByName(variableTypeName));
        }
        variableInstanceEntity.setValueFromSerialized(value, configuration);
        if (this.isAutoFireHistoryEvents()) {
            this.fireHistoricVariableInstanceUpdate(variableInstanceEntity, sourceActivityExecution);
        }
    }

    protected boolean canStoreValue(VariableInstanceEntity variableInstance, Object value) {
        return variableInstance.isAbleToStore(value);
    }

    protected boolean canStoreSerializedValue(VariableInstanceEntity variableInstance, Object serializedValue, Map<String, Object> configuration) {
        return variableInstance.isAbleToStoreSerializedValue(serializedValue, configuration);
    }

    @Override
    public PersistentVariableInstance createVariableInstance(String variableName, Object value, CoreVariableScope<PersistentVariableInstance> sourceActivityExecution) {
        if (value != null && value instanceof SerializedVariableValue) {
            SerializedVariableValue serializedVariableValue = (SerializedVariableValue)value;
            return this.createVariableInstanceFromSerialized(variableName, serializedVariableValue.getValue(), ProcessEngineVariableType.SPIN.getName(), serializedVariableValue.getConfig(), sourceActivityExecution);
        }
        VariableType type = this.getVariableTypeForValue(value);
        VariableInstanceEntity variableInstance = VariableInstanceEntity.createAndInsert(variableName, type, value);
        this.initializeVariableInstanceBackPointer(variableInstance);
        this.variableInstances.put(variableName, variableInstance);
        if (this.isAutoFireHistoryEvents()) {
            this.fireHistoricVariableInstanceCreate(variableInstance, sourceActivityExecution);
        }
        return variableInstance;
    }

    @Override
    public PersistentVariableInstance createVariableInstanceFromSerialized(String variableName, Object value, String variableTypeName, Map<String, Object> configuration, CoreVariableScope<PersistentVariableInstance> sourceActivityExecution) {
        VariableType type = this.getVariableTypeByName(variableTypeName);
        if (!type.isAbleToStoreSerializedValue(value, configuration)) {
            throw new BadUserRequestException("Variable type " + variableTypeName + " cannot store provided serialized value and " + "configuration");
        }
        VariableInstanceEntity variableInstance = VariableInstanceEntity.createFromSerializedValue(variableName, type, value, configuration);
        VariableInstanceEntity.insert(variableInstance);
        this.initializeVariableInstanceBackPointer(variableInstance);
        this.variableInstances.put(variableName, variableInstance);
        if (this.isAutoFireHistoryEvents()) {
            this.fireHistoricVariableInstanceCreate(variableInstance, sourceActivityExecution);
        }
        return variableInstance;
    }

    protected boolean isAutoFireHistoryEvents() {
        return true;
    }

    protected VariableType getVariableTypeForValue(Object newValue) {
        VariableTypes variableTypes = Context.getProcessEngineConfiguration().getVariableTypes();
        return variableTypes.findVariableType(newValue);
    }

    protected VariableType getVariableTypeByName(String variableTypeName) {
        VariableTypes variableTypes = Context.getProcessEngineConfiguration().getVariableTypes();
        VariableType type = variableTypes.getVariableType(variableTypeName);
        if (type == null) {
            String message = "No variable type '" + variableTypeName + "' found";
            if (ProcessEngineVariableType.SPIN.getName().equals(variableTypeName)) {
                message = message + ". If you want to use the '" + ProcessEngineVariableType.SPIN.getName() + "' type please adjust your 'defaultSerializationFormat' configuration";
            }
            throw new BadUserRequestException(message);
        }
        return type;
    }

    public void clearForNewValue(PersistentVariableInstance variableInstance, VariableType newType) {
        VariableInstanceEntity variableInstanceEntity = (VariableInstanceEntity)variableInstance;
        VariableType currentType = variableInstanceEntity.getType();
        if (currentType.getTypeName().equals(newType.getTypeName())) {
            return;
        }
        variableInstanceEntity.clear();
        variableInstanceEntity.setType(newType);
    }

    public void removeVariablesWithoutFiringEvents() {
        this.ensureVariableInstancesInitialized();
        for (VariableInstanceEntity variable : this.variableInstances.values()) {
            variable.delete();
        }
        this.variableInstances.clear();
    }

    @Override
    public void createOrUpdateVariableFromSerialized(String variableName, Object value, String variableTypeName, Map<String, Object> configuration, CoreVariableScope<PersistentVariableInstance> sourceActivityExecution) {
        PersistentVariableInstance variableInstance = this.getVariableInstance(variableName);
        if (variableInstance == null) {
            this.createVariableInstanceFromSerialized(variableName, value, variableTypeName, configuration, sourceActivityExecution);
        } else {
            this.setVariableInstanceValueFromSerialized(variableInstance, value, variableTypeName, configuration, sourceActivityExecution);
        }
    }

    public void fireHistoricVariableInstanceDelete(VariableInstanceEntity variableInstance, CoreVariableScope<PersistentVariableInstance> sourceActivityExecution) {
        int historyLevel = Context.getProcessEngineConfiguration().getHistoryLevel();
        if (historyLevel >= 2) {
            ProcessEngineConfigurationImpl processEngineConfiguration = Context.getProcessEngineConfiguration();
            HistoryEventHandler eventHandler = processEngineConfiguration.getHistoryEventHandler();
            HistoryEventProducer eventProducer = processEngineConfiguration.getHistoryEventProducer();
            HistoryEvent evt = eventProducer.createHistoricVariableDeleteEvt(variableInstance, sourceActivityExecution);
            eventHandler.handleEvent(evt);
        }
    }

    public void fireHistoricVariableInstanceCreate(VariableInstanceEntity variableInstance, CoreVariableScope<PersistentVariableInstance> sourceActivityExecution) {
        int historyLevel = Context.getProcessEngineConfiguration().getHistoryLevel();
        if (historyLevel >= 2) {
            ProcessEngineConfigurationImpl processEngineConfiguration = Context.getProcessEngineConfiguration();
            HistoryEventHandler eventHandler = processEngineConfiguration.getHistoryEventHandler();
            HistoryEventProducer eventProducer = processEngineConfiguration.getHistoryEventProducer();
            HistoryEvent evt = eventProducer.createHistoricVariableCreateEvt(variableInstance, sourceActivityExecution);
            eventHandler.handleEvent(evt);
        }
    }

    public void fireHistoricVariableInstanceUpdate(VariableInstanceEntity variableInstance, CoreVariableScope<PersistentVariableInstance> sourceActivityExecution) {
        int historyLevel = Context.getProcessEngineConfiguration().getHistoryLevel();
        if (historyLevel >= 2) {
            ProcessEngineConfigurationImpl processEngineConfiguration = Context.getProcessEngineConfiguration();
            HistoryEventHandler eventHandler = processEngineConfiguration.getHistoryEventHandler();
            HistoryEventProducer eventProducer = processEngineConfiguration.getHistoryEventProducer();
            HistoryEvent evt = eventProducer.createHistoricVariableUpdateEvt(variableInstance, sourceActivityExecution);
            eventHandler.handleEvent(evt);
        }
    }
}

