/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.impl.variable;

import org.camunda.bpm.engine.delegate.ProcessEngineVariableType;
import org.camunda.bpm.engine.impl.variable.PrimitiveVariableType;
import org.camunda.bpm.engine.impl.variable.ValueFields;

public class BooleanType
extends PrimitiveVariableType {
    @Override
    public String getTypeName() {
        return ProcessEngineVariableType.BOOLEAN.getName();
    }

    @Override
    public boolean isCachable() {
        return true;
    }

    @Override
    public Object getValue(ValueFields valueFields) {
        if (valueFields.getLongValue() != null) {
            return valueFields.getLongValue() == 1L;
        }
        return null;
    }

    @Override
    public void setValue(Object value, ValueFields valueFields) {
        if (value == null) {
            valueFields.setLongValue(null);
        } else {
            Boolean booleanValue = (Boolean)value;
            if (booleanValue.booleanValue()) {
                valueFields.setLongValue(1L);
            } else {
                valueFields.setLongValue(0L);
            }
        }
    }

    @Override
    public boolean isAbleToStore(Object value) {
        if (value == null) {
            return true;
        }
        return Boolean.class.isAssignableFrom(value.getClass()) || Boolean.TYPE.isAssignableFrom(value.getClass());
    }

    @Override
    public String getTypeNameForValue(ValueFields valueFields) {
        return Boolean.class.getSimpleName();
    }
}

