/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.impl.variable;

import java.util.Date;
import java.util.Map;
import org.camunda.bpm.engine.delegate.ProcessEngineVariableType;
import org.camunda.bpm.engine.delegate.SerializedVariableValue;
import org.camunda.bpm.engine.impl.core.variable.SerializedVariableValueImpl;
import org.camunda.bpm.engine.impl.variable.ValueFields;
import org.camunda.bpm.engine.impl.variable.VariableType;

public class DateType
implements VariableType {
    @Override
    public String getTypeName() {
        return ProcessEngineVariableType.DATE.getName();
    }

    @Override
    public boolean isCachable() {
        return true;
    }

    @Override
    public boolean isAbleToStore(Object value) {
        if (value == null) {
            return true;
        }
        return Date.class.isAssignableFrom(value.getClass());
    }

    @Override
    public Object getValue(ValueFields valueFields) {
        Long longValue = valueFields.getLongValue();
        if (longValue != null) {
            return new Date(longValue);
        }
        return null;
    }

    @Override
    public void setValue(Object value, ValueFields valueFields) {
        if (value != null) {
            valueFields.setLongValue(((Date)value).getTime());
        } else {
            valueFields.setLongValue(null);
        }
    }

    @Override
    public String getTypeNameForValue(ValueFields valueFields) {
        return Date.class.getSimpleName();
    }

    @Override
    public SerializedVariableValue getSerializedValue(ValueFields valueFields) {
        SerializedVariableValueImpl result = new SerializedVariableValueImpl();
        result.setValue(valueFields.getLongValue());
        return result;
    }

    @Override
    public void setValueFromSerialized(Object serializedValue, Map<String, Object> configuration, ValueFields valueFields) {
        if (serializedValue != null) {
            valueFields.setLongValue((Long)serializedValue);
        } else {
            valueFields.setLongValue(null);
        }
    }

    @Override
    public boolean isAbleToStoreSerializedValue(Object value, Map<String, Object> configuration) {
        if (value == null) {
            return true;
        }
        return Long.class.isAssignableFrom(value.getClass());
    }

    @Override
    public boolean storesCustomObjects() {
        return false;
    }
}

