/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.impl.variable;

import org.camunda.bpm.engine.delegate.ProcessEngineVariableType;
import org.camunda.bpm.engine.impl.variable.PrimitiveVariableType;
import org.camunda.bpm.engine.impl.variable.ValueFields;

public class IntegerType
extends PrimitiveVariableType {
    @Override
    public String getTypeName() {
        return ProcessEngineVariableType.INTEGER.getName();
    }

    @Override
    public boolean isCachable() {
        return true;
    }

    @Override
    public Object getValue(ValueFields valueFields) {
        if (valueFields.getLongValue() != null) {
            return new Integer(valueFields.getLongValue().intValue());
        }
        return null;
    }

    @Override
    public void setValue(Object value, ValueFields valueFields) {
        if (value != null) {
            valueFields.setLongValue(((Integer)value).longValue());
            valueFields.setTextValue(value.toString());
        } else {
            valueFields.setLongValue(null);
            valueFields.setTextValue(null);
        }
    }

    @Override
    public boolean isAbleToStore(Object value) {
        if (value == null) {
            return true;
        }
        return Integer.class.isAssignableFrom(value.getClass()) || Integer.TYPE.isAssignableFrom(value.getClass());
    }

    @Override
    public String getTypeNameForValue(ValueFields valueFields) {
        return Integer.class.getSimpleName();
    }
}

