/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.impl.variable;

import java.util.Map;
import org.camunda.bpm.engine.ProcessEngineException;
import org.camunda.bpm.engine.delegate.ProcessEngineVariableType;
import org.camunda.bpm.engine.delegate.SerializedVariableValue;
import org.camunda.bpm.engine.impl.context.Context;
import org.camunda.bpm.engine.impl.core.variable.SerializedVariableValueImpl;
import org.camunda.bpm.engine.impl.variable.EntityManagerSession;
import org.camunda.bpm.engine.impl.variable.JPAEntityMappings;
import org.camunda.bpm.engine.impl.variable.ValueFields;
import org.camunda.bpm.engine.impl.variable.VariableType;

public class JPAEntityVariableType
implements VariableType {
    public static final String CONFIG_CLASS_NAME = "class";
    public static final String CONFIG_ENTITY_ID_STRING = "id";
    private JPAEntityMappings mappings = new JPAEntityMappings();

    @Override
    public String getTypeName() {
        return ProcessEngineVariableType.JPA.getName();
    }

    @Override
    public boolean isCachable() {
        return false;
    }

    @Override
    public boolean isAbleToStore(Object value) {
        if (value == null) {
            return true;
        }
        return this.mappings.isJPAEntity(value);
    }

    @Override
    public void setValue(Object value, ValueFields valueFields) {
        EntityManagerSession entityManagerSession = Context.getCommandContext().getSession(EntityManagerSession.class);
        if (entityManagerSession == null) {
            throw new ProcessEngineException("Cannot set JPA variable: " + EntityManagerSession.class + " not configured");
        }
        entityManagerSession.flush();
        if (value != null) {
            String className = this.mappings.getJPAClassString(value);
            String idString = this.mappings.getJPAIdString(value);
            valueFields.setTextValue(className);
            valueFields.setTextValue2(idString);
        } else {
            valueFields.setTextValue(null);
            valueFields.setTextValue2(null);
        }
    }

    @Override
    public Object getValue(ValueFields valueFields) {
        if (valueFields.getTextValue() != null && valueFields.getTextValue2() != null) {
            return this.mappings.getJPAEntity(valueFields.getTextValue(), valueFields.getTextValue2());
        }
        return null;
    }

    @Override
    public String getTypeNameForValue(ValueFields valueFields) {
        return Object.class.getSimpleName();
    }

    @Override
    public SerializedVariableValue getSerializedValue(ValueFields valueFields) {
        SerializedVariableValueImpl result = new SerializedVariableValueImpl();
        result.setConfigValue(CONFIG_CLASS_NAME, valueFields.getTextValue());
        result.setConfigValue(CONFIG_ENTITY_ID_STRING, valueFields.getTextValue2());
        return result;
    }

    @Override
    public void setValueFromSerialized(Object serializedValue, Map<String, Object> configuration, ValueFields valueFields) {
        valueFields.setTextValue((String)configuration.get(CONFIG_CLASS_NAME));
        valueFields.setTextValue2((String)configuration.get(CONFIG_ENTITY_ID_STRING));
    }

    @Override
    public boolean isAbleToStoreSerializedValue(Object value, Map<String, Object> configuration) {
        return value == null && configuration != null && configuration.get(CONFIG_CLASS_NAME) instanceof String && configuration.get(CONFIG_ENTITY_ID_STRING) instanceof String;
    }

    @Override
    public boolean storesCustomObjects() {
        return true;
    }
}

