/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.impl.variable;

import org.camunda.bpm.engine.delegate.ProcessEngineVariableType;
import org.camunda.bpm.engine.impl.variable.PrimitiveVariableType;
import org.camunda.bpm.engine.impl.variable.ValueFields;

public class LongType
extends PrimitiveVariableType {
    @Override
    public String getTypeName() {
        return ProcessEngineVariableType.LONG.getName();
    }

    @Override
    public boolean isCachable() {
        return true;
    }

    @Override
    public Object getValue(ValueFields valueFields) {
        return valueFields.getLongValue();
    }

    @Override
    public void setValue(Object value, ValueFields valueFields) {
        valueFields.setLongValue((Long)value);
        if (value != null) {
            valueFields.setTextValue(value.toString());
        } else {
            valueFields.setTextValue(null);
        }
    }

    @Override
    public boolean isAbleToStore(Object value) {
        if (value == null) {
            return true;
        }
        return Long.class.isAssignableFrom(value.getClass()) || Long.TYPE.isAssignableFrom(value.getClass());
    }

    @Override
    public String getTypeNameForValue(ValueFields valueFields) {
        return Long.class.getSimpleName();
    }
}

