/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.impl.variable;

import org.camunda.bpm.engine.delegate.ProcessEngineVariableType;
import org.camunda.bpm.engine.impl.variable.PrimitiveVariableType;
import org.camunda.bpm.engine.impl.variable.ValueFields;

public class ShortType
extends PrimitiveVariableType {
    @Override
    public String getTypeName() {
        return ProcessEngineVariableType.SHORT.getName();
    }

    @Override
    public boolean isCachable() {
        return true;
    }

    @Override
    public Object getValue(ValueFields valueFields) {
        if (valueFields.getLongValue() != null) {
            return new Short(valueFields.getLongValue().shortValue());
        }
        return null;
    }

    @Override
    public void setValue(Object value, ValueFields valueFields) {
        if (value != null) {
            valueFields.setLongValue(((Short)value).longValue());
            valueFields.setTextValue(value.toString());
        } else {
            valueFields.setLongValue(null);
            valueFields.setTextValue(null);
        }
    }

    @Override
    public boolean isAbleToStore(Object value) {
        if (value == null) {
            return true;
        }
        return Short.class.isAssignableFrom(value.getClass()) || Short.TYPE.isAssignableFrom(value.getClass());
    }

    @Override
    public String getTypeNameForValue(ValueFields valueFields) {
        return Short.class.getSimpleName();
    }
}

