/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.test.api.identity;

import java.util.List;
import org.camunda.bpm.engine.ProcessEngineException;
import org.camunda.bpm.engine.identity.User;
import org.camunda.bpm.engine.identity.UserQuery;
import org.camunda.bpm.engine.impl.test.PluggableProcessEngineTestCase;

public class UserQueryTest
extends PluggableProcessEngineTestCase {
    protected void setUp() throws Exception {
        super.setUp();
        this.createUser("kermit", "Kermit", "Thefrog", "kermit@muppetshow.com");
        this.createUser("fozzie", "Fozzie", "Bear", "fozzie@muppetshow.com");
        this.createUser("gonzo", "Gonzo", "The great", "gonzo@muppetshow.com");
        this.identityService.saveGroup(this.identityService.newGroup("muppets"));
        this.identityService.saveGroup(this.identityService.newGroup("frogs"));
        this.identityService.createMembership("kermit", "muppets");
        this.identityService.createMembership("kermit", "frogs");
        this.identityService.createMembership("fozzie", "muppets");
        this.identityService.createMembership("gonzo", "muppets");
    }

    private User createUser(String id, String firstName, String lastName, String email) {
        User user = this.identityService.newUser(id);
        user.setFirstName(firstName);
        user.setLastName(lastName);
        user.setEmail(email);
        this.identityService.saveUser(user);
        return user;
    }

    protected void tearDown() throws Exception {
        this.identityService.deleteUser("kermit");
        this.identityService.deleteUser("fozzie");
        this.identityService.deleteUser("gonzo");
        this.identityService.deleteGroup("muppets");
        this.identityService.deleteGroup("frogs");
        super.tearDown();
    }

    public void testQueryByNoCriteria() {
        UserQuery query = this.identityService.createUserQuery();
        this.verifyQueryResults(query, 3);
    }

    public void testQueryById() {
        UserQuery query = this.identityService.createUserQuery().userId("kermit");
        this.verifyQueryResults(query, 1);
    }

    public void testQueryByInvalidId() {
        UserQuery query = this.identityService.createUserQuery().userId("invalid");
        this.verifyQueryResults(query, 0);
        try {
            this.identityService.createUserQuery().userId(null).singleResult();
            UserQueryTest.fail();
        }
        catch (ProcessEngineException processEngineException) {
            // empty catch block
        }
    }

    public void testQueryByFirstName() {
        UserQuery query = this.identityService.createUserQuery().userFirstName("Gonzo");
        this.verifyQueryResults(query, 1);
        User result = (User)query.singleResult();
        UserQueryTest.assertEquals((String)"gonzo", (String)result.getId());
    }

    public void testQueryByInvalidFirstName() {
        UserQuery query = this.identityService.createUserQuery().userFirstName("invalid");
        this.verifyQueryResults(query, 0);
        try {
            this.identityService.createUserQuery().userFirstName(null).singleResult();
            UserQueryTest.fail();
        }
        catch (ProcessEngineException processEngineException) {
            // empty catch block
        }
    }

    public void testQueryByFirstNameLike() {
        UserQuery query = this.identityService.createUserQuery().userFirstNameLike("%o%");
        this.verifyQueryResults(query, 2);
        query = this.identityService.createUserQuery().userFirstNameLike("Ker%");
        this.verifyQueryResults(query, 1);
    }

    public void testQueryByInvalidFirstNameLike() {
        UserQuery query = this.identityService.createUserQuery().userFirstNameLike("%mispiggy%");
        this.verifyQueryResults(query, 0);
        try {
            this.identityService.createUserQuery().userFirstNameLike(null).singleResult();
            UserQueryTest.fail();
        }
        catch (ProcessEngineException processEngineException) {
            // empty catch block
        }
    }

    public void testQueryByLastName() {
        UserQuery query = this.identityService.createUserQuery().userLastName("Bear");
        this.verifyQueryResults(query, 1);
        User result = (User)query.singleResult();
        UserQueryTest.assertEquals((String)"fozzie", (String)result.getId());
    }

    public void testQueryByInvalidLastName() {
        UserQuery query = this.identityService.createUserQuery().userLastName("invalid");
        this.verifyQueryResults(query, 0);
        try {
            this.identityService.createUserQuery().userLastName(null).singleResult();
            UserQueryTest.fail();
        }
        catch (ProcessEngineException processEngineException) {
            // empty catch block
        }
    }

    public void testQueryByLastNameLike() {
        UserQuery query = this.identityService.createUserQuery().userLastNameLike("%rog%");
        this.verifyQueryResults(query, 1);
        query = this.identityService.createUserQuery().userLastNameLike("%ea%");
        this.verifyQueryResults(query, 2);
    }

    public void testQueryByInvalidLastNameLike() {
        UserQuery query = this.identityService.createUserQuery().userLastNameLike("%invalid%");
        this.verifyQueryResults(query, 0);
        try {
            this.identityService.createUserQuery().userLastNameLike(null).singleResult();
            UserQueryTest.fail();
        }
        catch (ProcessEngineException processEngineException) {
            // empty catch block
        }
    }

    public void testQueryByEmail() {
        UserQuery query = this.identityService.createUserQuery().userEmail("kermit@muppetshow.com");
        this.verifyQueryResults(query, 1);
    }

    public void testQueryByInvalidEmail() {
        UserQuery query = this.identityService.createUserQuery().userEmail("invalid");
        this.verifyQueryResults(query, 0);
        try {
            this.identityService.createUserQuery().userEmail(null).singleResult();
            UserQueryTest.fail();
        }
        catch (ProcessEngineException processEngineException) {
            // empty catch block
        }
    }

    public void testQueryByEmailLike() {
        UserQuery query = this.identityService.createUserQuery().userEmailLike("%muppetshow.com");
        this.verifyQueryResults(query, 3);
        query = this.identityService.createUserQuery().userEmailLike("%kermit%");
        this.verifyQueryResults(query, 1);
    }

    public void testQueryByInvalidEmailLike() {
        UserQuery query = this.identityService.createUserQuery().userEmailLike("%invalid%");
        this.verifyQueryResults(query, 0);
        try {
            this.identityService.createUserQuery().userEmailLike(null).singleResult();
            UserQueryTest.fail();
        }
        catch (ProcessEngineException processEngineException) {
            // empty catch block
        }
    }

    public void testQuerySorting() {
        UserQueryTest.assertEquals((long)3L, (long)((UserQuery)this.identityService.createUserQuery().orderByUserId().asc()).count());
        UserQueryTest.assertEquals((long)3L, (long)((UserQuery)this.identityService.createUserQuery().orderByUserEmail().asc()).count());
        UserQueryTest.assertEquals((long)3L, (long)((UserQuery)this.identityService.createUserQuery().orderByUserFirstName().asc()).count());
        UserQueryTest.assertEquals((long)3L, (long)((UserQuery)this.identityService.createUserQuery().orderByUserLastName().asc()).count());
        UserQueryTest.assertEquals((long)3L, (long)((UserQuery)this.identityService.createUserQuery().orderByUserId().desc()).count());
        UserQueryTest.assertEquals((long)3L, (long)((UserQuery)this.identityService.createUserQuery().orderByUserEmail().desc()).count());
        UserQueryTest.assertEquals((long)3L, (long)((UserQuery)this.identityService.createUserQuery().orderByUserFirstName().desc()).count());
        UserQueryTest.assertEquals((long)3L, (long)((UserQuery)this.identityService.createUserQuery().orderByUserLastName().desc()).count());
        UserQuery query = (UserQuery)this.identityService.createUserQuery().userLastNameLike("%ea%").orderByUserFirstName().asc();
        List users = query.list();
        UserQueryTest.assertEquals((int)2, (int)users.size());
        UserQueryTest.assertEquals((String)"Fozzie", (String)((User)users.get(0)).getFirstName());
        UserQueryTest.assertEquals((String)"Gonzo", (String)((User)users.get(1)).getFirstName());
    }

    public void testQueryInvalidSortingUsage() {
        try {
            this.identityService.createUserQuery().orderByUserId().list();
            UserQueryTest.fail();
        }
        catch (ProcessEngineException e) {
            // empty catch block
        }
        try {
            this.identityService.createUserQuery().orderByUserId().orderByUserEmail().list();
            UserQueryTest.fail();
        }
        catch (ProcessEngineException processEngineException) {
            // empty catch block
        }
    }

    public void testQueryByMemberOf() {
        UserQuery query = this.identityService.createUserQuery().memberOfGroup("muppets");
        this.verifyQueryResults(query, 3);
        query = this.identityService.createUserQuery().memberOfGroup("frogs");
        this.verifyQueryResults(query, 1);
        User result = (User)query.singleResult();
        UserQueryTest.assertEquals((String)"kermit", (String)result.getId());
    }

    public void testQueryByInvalidMemberOf() {
        UserQuery query = this.identityService.createUserQuery().memberOfGroup("invalid");
        this.verifyQueryResults(query, 0);
        try {
            this.identityService.createUserQuery().memberOfGroup(null).list();
            UserQueryTest.fail();
        }
        catch (ProcessEngineException processEngineException) {
            // empty catch block
        }
    }

    private void verifyQueryResults(UserQuery query, int countExpected) {
        UserQueryTest.assertEquals((int)countExpected, (int)query.list().size());
        UserQueryTest.assertEquals((long)countExpected, (long)query.count());
        if (countExpected == 1) {
            UserQueryTest.assertNotNull((Object)query.singleResult());
        } else if (countExpected > 1) {
            this.verifySingleResultFails(query);
        } else if (countExpected == 0) {
            UserQueryTest.assertNull((Object)query.singleResult());
        }
    }

    private void verifySingleResultFails(UserQuery query) {
        try {
            query.singleResult();
            UserQueryTest.fail();
        }
        catch (ProcessEngineException processEngineException) {
            // empty catch block
        }
    }

    public void testQueryByIdIn() {
        UserQueryTest.assertTrue((boolean)this.identityService.createUserQuery().userIdIn(new String[]{"a", "b"}).list().isEmpty());
        List list = this.identityService.createUserQuery().list();
        String[] ids = new String[list.size()];
        for (int i = 0; i < ids.length; ++i) {
            ids[i] = ((User)list.get(i)).getId();
        }
        List idInList = this.identityService.createUserQuery().userIdIn(ids).list();
        for (User user : idInList) {
            boolean found = false;
            for (User otherUser : list) {
                if (!otherUser.getId().equals(user.getId())) continue;
                found = true;
                break;
            }
            if (found) continue;
            UserQueryTest.fail((String)("Expected to find user " + user));
        }
    }
}

