/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.test.api.runtime;

import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import org.camunda.bpm.engine.ProcessEngineException;
import org.camunda.bpm.engine.impl.persistence.entity.ExecutionEntity;
import org.camunda.bpm.engine.impl.test.PluggableProcessEngineTestCase;
import org.camunda.bpm.engine.repository.ProcessDefinitionQuery;
import org.camunda.bpm.engine.runtime.EventSubscription;
import org.camunda.bpm.engine.runtime.Execution;
import org.camunda.bpm.engine.runtime.ExecutionQuery;
import org.camunda.bpm.engine.runtime.Incident;
import org.camunda.bpm.engine.runtime.NativeExecutionQuery;
import org.camunda.bpm.engine.runtime.ProcessInstance;
import org.camunda.bpm.engine.test.Deployment;
import org.camunda.bpm.engine.test.api.runtime.DummySerializable;
import org.junit.Assert;

public class ExecutionQueryTest
extends PluggableProcessEngineTestCase {
    private static String CONCURRENT_PROCESS_KEY = "concurrent";
    private static String SEQUENTIAL_PROCESS_KEY = "oneTaskProcess";
    private List<String> concurrentProcessInstanceIds;
    private List<String> sequentialProcessInstanceIds;

    protected void setUp() throws Exception {
        super.setUp();
        this.repositoryService.createDeployment().addClasspathResource("org/camunda/bpm/engine/test/api/runtime/oneTaskProcess.bpmn20.xml").addClasspathResource("org/camunda/bpm/engine/test/api/runtime/concurrentExecution.bpmn20.xml").deploy();
        this.concurrentProcessInstanceIds = new ArrayList<String>();
        this.sequentialProcessInstanceIds = new ArrayList<String>();
        for (int i = 0; i < 4; ++i) {
            this.concurrentProcessInstanceIds.add(this.runtimeService.startProcessInstanceByKey(CONCURRENT_PROCESS_KEY, "BUSINESS-KEY-" + i).getId());
        }
        this.sequentialProcessInstanceIds.add(this.runtimeService.startProcessInstanceByKey(SEQUENTIAL_PROCESS_KEY).getId());
    }

    protected void tearDown() throws Exception {
        for (org.camunda.bpm.engine.repository.Deployment deployment : this.repositoryService.createDeploymentQuery().list()) {
            this.repositoryService.deleteDeployment(deployment.getId(), true);
        }
        super.tearDown();
    }

    public void testQueryByProcessDefinitionKey() {
        ExecutionQueryTest.assertEquals((int)12, (int)this.runtimeService.createExecutionQuery().processDefinitionKey(CONCURRENT_PROCESS_KEY).list().size());
        ExecutionQueryTest.assertEquals((int)1, (int)this.runtimeService.createExecutionQuery().processDefinitionKey(SEQUENTIAL_PROCESS_KEY).list().size());
    }

    public void testQueryByInvalidProcessDefinitionKey() {
        ExecutionQuery query = this.runtimeService.createExecutionQuery().processDefinitionKey("invalid");
        ExecutionQueryTest.assertNull((Object)query.singleResult());
        ExecutionQueryTest.assertEquals((int)0, (int)query.list().size());
        ExecutionQueryTest.assertEquals((long)0L, (long)query.count());
    }

    public void testQueryByProcessInstanceId() {
        for (String processInstanceId : this.concurrentProcessInstanceIds) {
            ExecutionQuery query = this.runtimeService.createExecutionQuery().processInstanceId(processInstanceId);
            ExecutionQueryTest.assertEquals((int)3, (int)query.list().size());
            ExecutionQueryTest.assertEquals((long)3L, (long)query.count());
        }
        ExecutionQueryTest.assertEquals((int)1, (int)this.runtimeService.createExecutionQuery().processInstanceId(this.sequentialProcessInstanceIds.get(0)).list().size());
    }

    public void testQueryByInvalidProcessInstanceId() {
        ExecutionQuery query = this.runtimeService.createExecutionQuery().processInstanceId("invalid");
        ExecutionQueryTest.assertNull((Object)query.singleResult());
        ExecutionQueryTest.assertEquals((int)0, (int)query.list().size());
        ExecutionQueryTest.assertEquals((long)0L, (long)query.count());
    }

    public void testQueryExecutionId() {
        Execution execution = (Execution)this.runtimeService.createExecutionQuery().processDefinitionKey(SEQUENTIAL_PROCESS_KEY).singleResult();
        ExecutionQueryTest.assertNotNull((Object)this.runtimeService.createExecutionQuery().executionId(execution.getId()));
    }

    public void testQueryByInvalidExecutionId() {
        ExecutionQuery query = this.runtimeService.createExecutionQuery().executionId("invalid");
        ExecutionQueryTest.assertNull((Object)query.singleResult());
        ExecutionQueryTest.assertEquals((int)0, (int)query.list().size());
        ExecutionQueryTest.assertEquals((long)0L, (long)query.count());
    }

    public void testQueryByActivityId() {
        ExecutionQuery query = this.runtimeService.createExecutionQuery().activityId("receivePayment");
        ExecutionQueryTest.assertEquals((int)4, (int)query.list().size());
        ExecutionQueryTest.assertEquals((long)4L, (long)query.count());
        try {
            ExecutionQueryTest.assertNull((Object)query.singleResult());
            ExecutionQueryTest.fail();
        }
        catch (ProcessEngineException processEngineException) {
            // empty catch block
        }
    }

    public void testQueryByInvalidActivityId() {
        ExecutionQuery query = this.runtimeService.createExecutionQuery().activityId("invalid");
        ExecutionQueryTest.assertNull((Object)query.singleResult());
        ExecutionQueryTest.assertEquals((int)0, (int)query.list().size());
        ExecutionQueryTest.assertEquals((long)0L, (long)query.count());
    }

    public void testQueryPaging() {
        ExecutionQueryTest.assertEquals((long)13L, (long)this.runtimeService.createExecutionQuery().count());
        ExecutionQueryTest.assertEquals((int)4, (int)this.runtimeService.createExecutionQuery().processDefinitionKey(CONCURRENT_PROCESS_KEY).listPage(0, 4).size());
        ExecutionQueryTest.assertEquals((int)1, (int)this.runtimeService.createExecutionQuery().processDefinitionKey(CONCURRENT_PROCESS_KEY).listPage(2, 1).size());
        ExecutionQueryTest.assertEquals((int)10, (int)this.runtimeService.createExecutionQuery().processDefinitionKey(CONCURRENT_PROCESS_KEY).listPage(1, 10).size());
        ExecutionQueryTest.assertEquals((int)12, (int)this.runtimeService.createExecutionQuery().processDefinitionKey(CONCURRENT_PROCESS_KEY).listPage(0, 20).size());
    }

    public void testQuerySorting() {
        ExecutionQueryTest.assertEquals((int)13, (int)((ExecutionQuery)this.runtimeService.createExecutionQuery().orderByProcessInstanceId().asc()).list().size());
        ExecutionQueryTest.assertEquals((int)13, (int)((ExecutionQuery)this.runtimeService.createExecutionQuery().orderByProcessDefinitionId().asc()).list().size());
        ExecutionQueryTest.assertEquals((int)13, (int)((ExecutionQuery)this.runtimeService.createExecutionQuery().orderByProcessDefinitionKey().asc()).list().size());
        ExecutionQueryTest.assertEquals((int)13, (int)((ExecutionQuery)this.runtimeService.createExecutionQuery().orderByProcessInstanceId().desc()).list().size());
        ExecutionQueryTest.assertEquals((int)13, (int)((ExecutionQuery)this.runtimeService.createExecutionQuery().orderByProcessDefinitionId().desc()).list().size());
        ExecutionQueryTest.assertEquals((int)13, (int)((ExecutionQuery)this.runtimeService.createExecutionQuery().orderByProcessDefinitionKey().desc()).list().size());
        ExecutionQueryTest.assertEquals((int)12, (int)((ExecutionQuery)this.runtimeService.createExecutionQuery().processDefinitionKey(CONCURRENT_PROCESS_KEY).orderByProcessDefinitionId().asc()).list().size());
        ExecutionQueryTest.assertEquals((int)12, (int)((ExecutionQuery)this.runtimeService.createExecutionQuery().processDefinitionKey(CONCURRENT_PROCESS_KEY).orderByProcessDefinitionId().desc()).list().size());
        ExecutionQueryTest.assertEquals((int)12, (int)((ExecutionQuery)((ExecutionQuery)this.runtimeService.createExecutionQuery().processDefinitionKey(CONCURRENT_PROCESS_KEY).orderByProcessDefinitionKey().asc()).orderByProcessInstanceId().desc()).list().size());
    }

    public void testQueryInvalidSorting() {
        try {
            this.runtimeService.createExecutionQuery().orderByProcessDefinitionKey().list();
            ExecutionQueryTest.fail();
        }
        catch (ProcessEngineException processEngineException) {
            // empty catch block
        }
    }

    public void testQueryByBusinessKey() {
        ExecutionQueryTest.assertEquals((int)3, (int)this.runtimeService.createExecutionQuery().processDefinitionKey(CONCURRENT_PROCESS_KEY).processInstanceBusinessKey("BUSINESS-KEY-1").list().size());
        ExecutionQueryTest.assertEquals((int)3, (int)this.runtimeService.createExecutionQuery().processDefinitionKey(CONCURRENT_PROCESS_KEY).processInstanceBusinessKey("BUSINESS-KEY-2").list().size());
        ExecutionQueryTest.assertEquals((int)0, (int)this.runtimeService.createExecutionQuery().processDefinitionKey(CONCURRENT_PROCESS_KEY).processInstanceBusinessKey("NON-EXISTING").list().size());
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/oneTaskProcess.bpmn20.xml"})
    public void testQueryStringVariable() {
        HashMap<String, String> vars = new HashMap<String, String>();
        vars.put("stringVar", "abcdef");
        ProcessInstance processInstance1 = this.runtimeService.startProcessInstanceByKey("oneTaskProcess", vars);
        vars = new HashMap();
        vars.put("stringVar", "abcdef");
        vars.put("stringVar2", "ghijkl");
        ProcessInstance processInstance2 = this.runtimeService.startProcessInstanceByKey("oneTaskProcess", vars);
        vars = new HashMap();
        vars.put("stringVar", "azerty");
        ProcessInstance processInstance3 = this.runtimeService.startProcessInstanceByKey("oneTaskProcess", vars);
        ExecutionQuery query = this.runtimeService.createExecutionQuery().variableValueEquals("stringVar", (Object)"abcdef");
        List executions = query.list();
        Assert.assertNotNull((Object)executions);
        Assert.assertEquals((long)2L, (long)executions.size());
        query = this.runtimeService.createExecutionQuery().variableValueEquals("stringVar", (Object)"abcdef").variableValueEquals("stringVar2", (Object)"ghijkl");
        Execution execution = (Execution)query.singleResult();
        Assert.assertNotNull((Object)execution);
        Assert.assertEquals((Object)processInstance2.getId(), (Object)execution.getId());
        execution = (Execution)this.runtimeService.createExecutionQuery().variableValueNotEquals("stringVar", (Object)"abcdef").singleResult();
        Assert.assertNotNull((Object)execution);
        Assert.assertEquals((Object)processInstance3.getId(), (Object)execution.getId());
        execution = (Execution)this.runtimeService.createExecutionQuery().variableValueGreaterThan("stringVar", (Object)"abcdef").singleResult();
        Assert.assertNotNull((Object)execution);
        Assert.assertEquals((Object)processInstance3.getId(), (Object)execution.getId());
        execution = (Execution)this.runtimeService.createExecutionQuery().variableValueGreaterThan("stringVar", (Object)"z").singleResult();
        Assert.assertNull((Object)execution);
        ExecutionQueryTest.assertEquals((long)3L, (long)this.runtimeService.createExecutionQuery().variableValueGreaterThanOrEqual("stringVar", (Object)"abcdef").count());
        ExecutionQueryTest.assertEquals((long)0L, (long)this.runtimeService.createExecutionQuery().variableValueGreaterThanOrEqual("stringVar", (Object)"z").count());
        executions = this.runtimeService.createExecutionQuery().variableValueLessThan("stringVar", (Object)"abcdeg").list();
        Assert.assertEquals((long)2L, (long)executions.size());
        List<String> expecedIds = Arrays.asList(processInstance1.getId(), processInstance2.getId());
        ArrayList<String> ids = new ArrayList<String>(Arrays.asList(((Execution)executions.get(0)).getId(), ((Execution)executions.get(1)).getId()));
        ids.removeAll(expecedIds);
        ExecutionQueryTest.assertTrue((boolean)ids.isEmpty());
        ExecutionQueryTest.assertEquals((long)0L, (long)this.runtimeService.createExecutionQuery().variableValueLessThan("stringVar", (Object)"abcdef").count());
        ExecutionQueryTest.assertEquals((long)3L, (long)this.runtimeService.createExecutionQuery().variableValueLessThanOrEqual("stringVar", (Object)"z").count());
        executions = this.runtimeService.createExecutionQuery().variableValueLessThanOrEqual("stringVar", (Object)"abcdef").list();
        Assert.assertEquals((long)2L, (long)executions.size());
        expecedIds = Arrays.asList(processInstance1.getId(), processInstance2.getId());
        ids = new ArrayList<String>(Arrays.asList(((Execution)executions.get(0)).getId(), ((Execution)executions.get(1)).getId()));
        ids.removeAll(expecedIds);
        ExecutionQueryTest.assertTrue((boolean)ids.isEmpty());
        ExecutionQueryTest.assertEquals((long)3L, (long)this.runtimeService.createExecutionQuery().variableValueLessThanOrEqual("stringVar", (Object)"z").count());
        ExecutionQueryTest.assertEquals((long)0L, (long)this.runtimeService.createExecutionQuery().variableValueLessThanOrEqual("stringVar", (Object)"aa").count());
        execution = (Execution)this.runtimeService.createExecutionQuery().variableValueLike("stringVar", "azert%").singleResult();
        ExecutionQueryTest.assertNotNull((Object)execution);
        ExecutionQueryTest.assertEquals((String)processInstance3.getId(), (String)execution.getId());
        execution = (Execution)this.runtimeService.createExecutionQuery().variableValueLike("stringVar", "%y").singleResult();
        ExecutionQueryTest.assertNotNull((Object)execution);
        ExecutionQueryTest.assertEquals((String)processInstance3.getId(), (String)execution.getId());
        execution = (Execution)this.runtimeService.createExecutionQuery().variableValueLike("stringVar", "%zer%").singleResult();
        ExecutionQueryTest.assertNotNull((Object)execution);
        ExecutionQueryTest.assertEquals((String)processInstance3.getId(), (String)execution.getId());
        ExecutionQueryTest.assertEquals((long)3L, (long)this.runtimeService.createExecutionQuery().variableValueLike("stringVar", "a%").count());
        ExecutionQueryTest.assertEquals((long)0L, (long)this.runtimeService.createExecutionQuery().variableValueLike("stringVar", "%x%").count());
        this.runtimeService.deleteProcessInstance(processInstance1.getId(), "test");
        this.runtimeService.deleteProcessInstance(processInstance2.getId(), "test");
        this.runtimeService.deleteProcessInstance(processInstance3.getId(), "test");
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/oneTaskProcess.bpmn20.xml"})
    public void testQueryLongVariable() {
        HashMap<String, Long> vars = new HashMap<String, Long>();
        vars.put("longVar", 12345L);
        ProcessInstance processInstance1 = this.runtimeService.startProcessInstanceByKey("oneTaskProcess", vars);
        vars = new HashMap();
        vars.put("longVar", 12345L);
        vars.put("longVar2", 67890L);
        ProcessInstance processInstance2 = this.runtimeService.startProcessInstanceByKey("oneTaskProcess", vars);
        vars = new HashMap();
        vars.put("longVar", 55555L);
        ProcessInstance processInstance3 = this.runtimeService.startProcessInstanceByKey("oneTaskProcess", vars);
        ExecutionQuery query = this.runtimeService.createExecutionQuery().variableValueEquals("longVar", (Object)12345L);
        List executions = query.list();
        Assert.assertNotNull((Object)executions);
        Assert.assertEquals((long)2L, (long)executions.size());
        query = this.runtimeService.createExecutionQuery().variableValueEquals("longVar", (Object)12345L).variableValueEquals("longVar2", (Object)67890L);
        Execution execution = (Execution)query.singleResult();
        Assert.assertNotNull((Object)execution);
        Assert.assertEquals((Object)processInstance2.getId(), (Object)execution.getId());
        execution = (Execution)this.runtimeService.createExecutionQuery().variableValueEquals("longVar", (Object)999L).singleResult();
        Assert.assertNull((Object)execution);
        execution = (Execution)this.runtimeService.createExecutionQuery().variableValueNotEquals("longVar", (Object)12345L).singleResult();
        Assert.assertNotNull((Object)execution);
        Assert.assertEquals((Object)processInstance3.getId(), (Object)execution.getId());
        execution = (Execution)this.runtimeService.createExecutionQuery().variableValueGreaterThan("longVar", (Object)44444L).singleResult();
        Assert.assertNotNull((Object)execution);
        Assert.assertEquals((Object)processInstance3.getId(), (Object)execution.getId());
        Assert.assertEquals((long)0L, (long)this.runtimeService.createExecutionQuery().variableValueGreaterThan("longVar", (Object)55555L).count());
        Assert.assertEquals((long)3L, (long)this.runtimeService.createExecutionQuery().variableValueGreaterThan("longVar", (Object)1L).count());
        execution = (Execution)this.runtimeService.createExecutionQuery().variableValueGreaterThanOrEqual("longVar", (Object)44444L).singleResult();
        Assert.assertNotNull((Object)execution);
        Assert.assertEquals((Object)processInstance3.getId(), (Object)execution.getId());
        execution = (Execution)this.runtimeService.createExecutionQuery().variableValueGreaterThanOrEqual("longVar", (Object)55555L).singleResult();
        Assert.assertNotNull((Object)execution);
        Assert.assertEquals((Object)processInstance3.getId(), (Object)execution.getId());
        Assert.assertEquals((long)3L, (long)this.runtimeService.createExecutionQuery().variableValueGreaterThanOrEqual("longVar", (Object)1L).count());
        executions = this.runtimeService.createExecutionQuery().variableValueLessThan("longVar", (Object)55555L).list();
        Assert.assertEquals((long)2L, (long)executions.size());
        List<String> expecedIds = Arrays.asList(processInstance1.getId(), processInstance2.getId());
        ArrayList<String> ids = new ArrayList<String>(Arrays.asList(((Execution)executions.get(0)).getId(), ((Execution)executions.get(1)).getId()));
        ids.removeAll(expecedIds);
        ExecutionQueryTest.assertTrue((boolean)ids.isEmpty());
        Assert.assertEquals((long)0L, (long)this.runtimeService.createExecutionQuery().variableValueLessThan("longVar", (Object)12345L).count());
        Assert.assertEquals((long)3L, (long)this.runtimeService.createExecutionQuery().variableValueLessThan("longVar", (Object)66666L).count());
        executions = this.runtimeService.createExecutionQuery().variableValueLessThanOrEqual("longVar", (Object)55555L).list();
        Assert.assertEquals((long)3L, (long)executions.size());
        Assert.assertEquals((long)0L, (long)this.runtimeService.createExecutionQuery().variableValueLessThanOrEqual("longVar", (Object)12344L).count());
        this.runtimeService.deleteProcessInstance(processInstance1.getId(), "test");
        this.runtimeService.deleteProcessInstance(processInstance2.getId(), "test");
        this.runtimeService.deleteProcessInstance(processInstance3.getId(), "test");
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/oneTaskProcess.bpmn20.xml"})
    public void testQueryDoubleVariable() {
        HashMap<String, Double> vars = new HashMap<String, Double>();
        vars.put("doubleVar", 12345.6789);
        ProcessInstance processInstance1 = this.runtimeService.startProcessInstanceByKey("oneTaskProcess", vars);
        vars = new HashMap();
        vars.put("doubleVar", 12345.6789);
        vars.put("doubleVar2", 9876.54321);
        ProcessInstance processInstance2 = this.runtimeService.startProcessInstanceByKey("oneTaskProcess", vars);
        vars = new HashMap();
        vars.put("doubleVar", 55555.5555);
        ProcessInstance processInstance3 = this.runtimeService.startProcessInstanceByKey("oneTaskProcess", vars);
        ExecutionQuery query = this.runtimeService.createExecutionQuery().variableValueEquals("doubleVar", (Object)12345.6789);
        List executions = query.list();
        Assert.assertNotNull((Object)executions);
        Assert.assertEquals((long)2L, (long)executions.size());
        query = this.runtimeService.createExecutionQuery().variableValueEquals("doubleVar", (Object)12345.6789).variableValueEquals("doubleVar2", (Object)9876.54321);
        Execution execution = (Execution)query.singleResult();
        Assert.assertNotNull((Object)execution);
        Assert.assertEquals((Object)processInstance2.getId(), (Object)execution.getId());
        execution = (Execution)this.runtimeService.createExecutionQuery().variableValueEquals("doubleVar", (Object)9999.99).singleResult();
        Assert.assertNull((Object)execution);
        execution = (Execution)this.runtimeService.createExecutionQuery().variableValueNotEquals("doubleVar", (Object)12345.6789).singleResult();
        Assert.assertNotNull((Object)execution);
        Assert.assertEquals((Object)processInstance3.getId(), (Object)execution.getId());
        execution = (Execution)this.runtimeService.createExecutionQuery().variableValueGreaterThan("doubleVar", (Object)44444.4444).singleResult();
        Assert.assertNotNull((Object)execution);
        Assert.assertEquals((Object)processInstance3.getId(), (Object)execution.getId());
        Assert.assertEquals((long)0L, (long)this.runtimeService.createExecutionQuery().variableValueGreaterThan("doubleVar", (Object)55555.5555).count());
        Assert.assertEquals((long)3L, (long)this.runtimeService.createExecutionQuery().variableValueGreaterThan("doubleVar", (Object)1.234).count());
        execution = (Execution)this.runtimeService.createExecutionQuery().variableValueGreaterThanOrEqual("doubleVar", (Object)44444.4444).singleResult();
        Assert.assertNotNull((Object)execution);
        Assert.assertEquals((Object)processInstance3.getId(), (Object)execution.getId());
        execution = (Execution)this.runtimeService.createExecutionQuery().variableValueGreaterThanOrEqual("doubleVar", (Object)55555.5555).singleResult();
        Assert.assertNotNull((Object)execution);
        Assert.assertEquals((Object)processInstance3.getId(), (Object)execution.getId());
        Assert.assertEquals((long)3L, (long)this.runtimeService.createExecutionQuery().variableValueGreaterThanOrEqual("doubleVar", (Object)1.234).count());
        executions = this.runtimeService.createExecutionQuery().variableValueLessThan("doubleVar", (Object)55555.5555).list();
        Assert.assertEquals((long)2L, (long)executions.size());
        List<String> expecedIds = Arrays.asList(processInstance1.getId(), processInstance2.getId());
        ArrayList<String> ids = new ArrayList<String>(Arrays.asList(((Execution)executions.get(0)).getId(), ((Execution)executions.get(1)).getId()));
        ids.removeAll(expecedIds);
        ExecutionQueryTest.assertTrue((boolean)ids.isEmpty());
        Assert.assertEquals((long)0L, (long)this.runtimeService.createExecutionQuery().variableValueLessThan("doubleVar", (Object)12345.6789).count());
        Assert.assertEquals((long)3L, (long)this.runtimeService.createExecutionQuery().variableValueLessThan("doubleVar", (Object)66666.6666).count());
        executions = this.runtimeService.createExecutionQuery().variableValueLessThanOrEqual("doubleVar", (Object)55555.5555).list();
        Assert.assertEquals((long)3L, (long)executions.size());
        Assert.assertEquals((long)0L, (long)this.runtimeService.createExecutionQuery().variableValueLessThanOrEqual("doubleVar", (Object)12344.6789).count());
        this.runtimeService.deleteProcessInstance(processInstance1.getId(), "test");
        this.runtimeService.deleteProcessInstance(processInstance2.getId(), "test");
        this.runtimeService.deleteProcessInstance(processInstance3.getId(), "test");
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/oneTaskProcess.bpmn20.xml"})
    public void testQueryIntegerVariable() {
        HashMap<String, Integer> vars = new HashMap<String, Integer>();
        vars.put("integerVar", 12345);
        ProcessInstance processInstance1 = this.runtimeService.startProcessInstanceByKey("oneTaskProcess", vars);
        vars = new HashMap();
        vars.put("integerVar", 12345);
        vars.put("integerVar2", 67890);
        ProcessInstance processInstance2 = this.runtimeService.startProcessInstanceByKey("oneTaskProcess", vars);
        vars = new HashMap();
        vars.put("integerVar", 55555);
        ProcessInstance processInstance3 = this.runtimeService.startProcessInstanceByKey("oneTaskProcess", vars);
        ExecutionQuery query = this.runtimeService.createExecutionQuery().variableValueEquals("integerVar", (Object)12345);
        List executions = query.list();
        Assert.assertNotNull((Object)executions);
        Assert.assertEquals((long)2L, (long)executions.size());
        query = this.runtimeService.createExecutionQuery().variableValueEquals("integerVar", (Object)12345).variableValueEquals("integerVar2", (Object)67890);
        Execution execution = (Execution)query.singleResult();
        Assert.assertNotNull((Object)execution);
        Assert.assertEquals((Object)processInstance2.getId(), (Object)execution.getId());
        execution = (Execution)this.runtimeService.createExecutionQuery().variableValueEquals("integerVar", (Object)9999).singleResult();
        Assert.assertNull((Object)execution);
        execution = (Execution)this.runtimeService.createExecutionQuery().variableValueNotEquals("integerVar", (Object)12345).singleResult();
        Assert.assertNotNull((Object)execution);
        Assert.assertEquals((Object)processInstance3.getId(), (Object)execution.getId());
        execution = (Execution)this.runtimeService.createExecutionQuery().variableValueGreaterThan("integerVar", (Object)44444).singleResult();
        Assert.assertNotNull((Object)execution);
        Assert.assertEquals((Object)processInstance3.getId(), (Object)execution.getId());
        Assert.assertEquals((long)0L, (long)this.runtimeService.createExecutionQuery().variableValueGreaterThan("integerVar", (Object)55555).count());
        Assert.assertEquals((long)3L, (long)this.runtimeService.createExecutionQuery().variableValueGreaterThan("integerVar", (Object)1).count());
        execution = (Execution)this.runtimeService.createExecutionQuery().variableValueGreaterThanOrEqual("integerVar", (Object)44444).singleResult();
        Assert.assertNotNull((Object)execution);
        Assert.assertEquals((Object)processInstance3.getId(), (Object)execution.getId());
        execution = (Execution)this.runtimeService.createExecutionQuery().variableValueGreaterThanOrEqual("integerVar", (Object)55555).singleResult();
        Assert.assertNotNull((Object)execution);
        Assert.assertEquals((Object)processInstance3.getId(), (Object)execution.getId());
        Assert.assertEquals((long)3L, (long)this.runtimeService.createExecutionQuery().variableValueGreaterThanOrEqual("integerVar", (Object)1).count());
        executions = this.runtimeService.createExecutionQuery().variableValueLessThan("integerVar", (Object)55555).list();
        Assert.assertEquals((long)2L, (long)executions.size());
        List<String> expecedIds = Arrays.asList(processInstance1.getId(), processInstance2.getId());
        ArrayList<String> ids = new ArrayList<String>(Arrays.asList(((Execution)executions.get(0)).getId(), ((Execution)executions.get(1)).getId()));
        ids.removeAll(expecedIds);
        ExecutionQueryTest.assertTrue((boolean)ids.isEmpty());
        Assert.assertEquals((long)0L, (long)this.runtimeService.createExecutionQuery().variableValueLessThan("integerVar", (Object)12345).count());
        Assert.assertEquals((long)3L, (long)this.runtimeService.createExecutionQuery().variableValueLessThan("integerVar", (Object)66666).count());
        executions = this.runtimeService.createExecutionQuery().variableValueLessThanOrEqual("integerVar", (Object)55555).list();
        Assert.assertEquals((long)3L, (long)executions.size());
        Assert.assertEquals((long)0L, (long)this.runtimeService.createExecutionQuery().variableValueLessThanOrEqual("integerVar", (Object)12344).count());
        this.runtimeService.deleteProcessInstance(processInstance1.getId(), "test");
        this.runtimeService.deleteProcessInstance(processInstance2.getId(), "test");
        this.runtimeService.deleteProcessInstance(processInstance3.getId(), "test");
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/oneTaskProcess.bpmn20.xml"})
    public void testQueryShortVariable() {
        HashMap<String, Short> vars = new HashMap<String, Short>();
        short shortVar = 1234;
        vars.put("shortVar", shortVar);
        ProcessInstance processInstance1 = this.runtimeService.startProcessInstanceByKey("oneTaskProcess", vars);
        short shortVar2 = 6789;
        vars = new HashMap();
        vars.put("shortVar", shortVar);
        vars.put("shortVar2", shortVar2);
        ProcessInstance processInstance2 = this.runtimeService.startProcessInstanceByKey("oneTaskProcess", vars);
        vars = new HashMap();
        vars.put("shortVar", (short)5555);
        ProcessInstance processInstance3 = this.runtimeService.startProcessInstanceByKey("oneTaskProcess", vars);
        ExecutionQuery query = this.runtimeService.createExecutionQuery().variableValueEquals("shortVar", (Object)shortVar);
        List executions = query.list();
        Assert.assertNotNull((Object)executions);
        Assert.assertEquals((long)2L, (long)executions.size());
        query = this.runtimeService.createExecutionQuery().variableValueEquals("shortVar", (Object)shortVar).variableValueEquals("shortVar2", (Object)shortVar2);
        Execution execution = (Execution)query.singleResult();
        Assert.assertNotNull((Object)execution);
        Assert.assertEquals((Object)processInstance2.getId(), (Object)execution.getId());
        short unexistingValue = 9999;
        execution = (Execution)this.runtimeService.createExecutionQuery().variableValueEquals("shortVar", (Object)unexistingValue).singleResult();
        Assert.assertNull((Object)execution);
        execution = (Execution)this.runtimeService.createExecutionQuery().variableValueNotEquals("shortVar", (Object)1234).singleResult();
        Assert.assertNotNull((Object)execution);
        Assert.assertEquals((Object)processInstance3.getId(), (Object)execution.getId());
        execution = (Execution)this.runtimeService.createExecutionQuery().variableValueGreaterThan("shortVar", (Object)4444).singleResult();
        Assert.assertNotNull((Object)execution);
        Assert.assertEquals((Object)processInstance3.getId(), (Object)execution.getId());
        Assert.assertEquals((long)0L, (long)this.runtimeService.createExecutionQuery().variableValueGreaterThan("shortVar", (Object)5555).count());
        Assert.assertEquals((long)3L, (long)this.runtimeService.createExecutionQuery().variableValueGreaterThan("shortVar", (Object)1).count());
        execution = (Execution)this.runtimeService.createExecutionQuery().variableValueGreaterThanOrEqual("shortVar", (Object)4444).singleResult();
        Assert.assertNotNull((Object)execution);
        Assert.assertEquals((Object)processInstance3.getId(), (Object)execution.getId());
        execution = (Execution)this.runtimeService.createExecutionQuery().variableValueGreaterThanOrEqual("shortVar", (Object)5555).singleResult();
        Assert.assertNotNull((Object)execution);
        Assert.assertEquals((Object)processInstance3.getId(), (Object)execution.getId());
        Assert.assertEquals((long)3L, (long)this.runtimeService.createExecutionQuery().variableValueGreaterThanOrEqual("shortVar", (Object)1).count());
        executions = this.runtimeService.createExecutionQuery().variableValueLessThan("shortVar", (Object)5555).list();
        Assert.assertEquals((long)2L, (long)executions.size());
        List<String> expecedIds = Arrays.asList(processInstance1.getId(), processInstance2.getId());
        ArrayList<String> ids = new ArrayList<String>(Arrays.asList(((Execution)executions.get(0)).getId(), ((Execution)executions.get(1)).getId()));
        ids.removeAll(expecedIds);
        ExecutionQueryTest.assertTrue((boolean)ids.isEmpty());
        Assert.assertEquals((long)0L, (long)this.runtimeService.createExecutionQuery().variableValueLessThan("shortVar", (Object)1234).count());
        Assert.assertEquals((long)3L, (long)this.runtimeService.createExecutionQuery().variableValueLessThan("shortVar", (Object)6666).count());
        executions = this.runtimeService.createExecutionQuery().variableValueLessThanOrEqual("shortVar", (Object)5555).list();
        Assert.assertEquals((long)3L, (long)executions.size());
        Assert.assertEquals((long)0L, (long)this.runtimeService.createExecutionQuery().variableValueLessThanOrEqual("shortVar", (Object)1233).count());
        this.runtimeService.deleteProcessInstance(processInstance1.getId(), "test");
        this.runtimeService.deleteProcessInstance(processInstance2.getId(), "test");
        this.runtimeService.deleteProcessInstance(processInstance3.getId(), "test");
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/oneTaskProcess.bpmn20.xml"})
    public void testQueryDateVariable() throws Exception {
        HashMap<String, Date> vars = new HashMap<String, Date>();
        Date date1 = Calendar.getInstance().getTime();
        vars.put("dateVar", date1);
        ProcessInstance processInstance1 = this.runtimeService.startProcessInstanceByKey("oneTaskProcess", vars);
        Date date2 = Calendar.getInstance().getTime();
        vars = new HashMap();
        vars.put("dateVar", date1);
        vars.put("dateVar2", date2);
        ProcessInstance processInstance2 = this.runtimeService.startProcessInstanceByKey("oneTaskProcess", vars);
        Calendar nextYear = Calendar.getInstance();
        nextYear.add(1, 1);
        vars = new HashMap();
        vars.put("dateVar", nextYear.getTime());
        ProcessInstance processInstance3 = this.runtimeService.startProcessInstanceByKey("oneTaskProcess", vars);
        Calendar nextMonth = Calendar.getInstance();
        nextMonth.add(2, 1);
        Calendar twoYearsLater = Calendar.getInstance();
        twoYearsLater.add(1, 2);
        Calendar oneYearAgo = Calendar.getInstance();
        oneYearAgo.add(1, -1);
        ExecutionQuery query = this.runtimeService.createExecutionQuery().variableValueEquals("dateVar", (Object)date1);
        List executions = query.list();
        Assert.assertNotNull((Object)executions);
        Assert.assertEquals((long)2L, (long)executions.size());
        query = this.runtimeService.createExecutionQuery().variableValueEquals("dateVar", (Object)date1).variableValueEquals("dateVar2", (Object)date2);
        Execution execution = (Execution)query.singleResult();
        Assert.assertNotNull((Object)execution);
        Assert.assertEquals((Object)processInstance2.getId(), (Object)execution.getId());
        Date unexistingDate = new SimpleDateFormat("dd/MM/yyyy hh:mm:ss").parse("01/01/1989 12:00:00");
        execution = (Execution)this.runtimeService.createExecutionQuery().variableValueEquals("dateVar", (Object)unexistingDate).singleResult();
        Assert.assertNull((Object)execution);
        execution = (Execution)this.runtimeService.createExecutionQuery().variableValueNotEquals("dateVar", (Object)date1).singleResult();
        Assert.assertNotNull((Object)execution);
        Assert.assertEquals((Object)processInstance3.getId(), (Object)execution.getId());
        execution = (Execution)this.runtimeService.createExecutionQuery().variableValueGreaterThan("dateVar", (Object)nextMonth.getTime()).singleResult();
        Assert.assertNotNull((Object)execution);
        Assert.assertEquals((Object)processInstance3.getId(), (Object)execution.getId());
        Assert.assertEquals((long)0L, (long)this.runtimeService.createExecutionQuery().variableValueGreaterThan("dateVar", (Object)nextYear.getTime()).count());
        Assert.assertEquals((long)3L, (long)this.runtimeService.createExecutionQuery().variableValueGreaterThan("dateVar", (Object)oneYearAgo.getTime()).count());
        execution = (Execution)this.runtimeService.createExecutionQuery().variableValueGreaterThanOrEqual("dateVar", (Object)nextMonth.getTime()).singleResult();
        Assert.assertNotNull((Object)execution);
        Assert.assertEquals((Object)processInstance3.getId(), (Object)execution.getId());
        execution = (Execution)this.runtimeService.createExecutionQuery().variableValueGreaterThanOrEqual("dateVar", (Object)nextYear.getTime()).singleResult();
        Assert.assertNotNull((Object)execution);
        Assert.assertEquals((Object)processInstance3.getId(), (Object)execution.getId());
        Assert.assertEquals((long)3L, (long)this.runtimeService.createExecutionQuery().variableValueGreaterThanOrEqual("dateVar", (Object)oneYearAgo.getTime()).count());
        executions = this.runtimeService.createExecutionQuery().variableValueLessThan("dateVar", (Object)nextYear.getTime()).list();
        Assert.assertEquals((long)2L, (long)executions.size());
        List<String> expecedIds = Arrays.asList(processInstance1.getId(), processInstance2.getId());
        ArrayList<String> ids = new ArrayList<String>(Arrays.asList(((Execution)executions.get(0)).getId(), ((Execution)executions.get(1)).getId()));
        ids.removeAll(expecedIds);
        ExecutionQueryTest.assertTrue((boolean)ids.isEmpty());
        Assert.assertEquals((long)0L, (long)this.runtimeService.createExecutionQuery().variableValueLessThan("dateVar", (Object)date1).count());
        Assert.assertEquals((long)3L, (long)this.runtimeService.createExecutionQuery().variableValueLessThan("dateVar", (Object)twoYearsLater.getTime()).count());
        executions = this.runtimeService.createExecutionQuery().variableValueLessThanOrEqual("dateVar", (Object)nextYear.getTime()).list();
        Assert.assertEquals((long)3L, (long)executions.size());
        Assert.assertEquals((long)0L, (long)this.runtimeService.createExecutionQuery().variableValueLessThanOrEqual("dateVar", (Object)oneYearAgo.getTime()).count());
        this.runtimeService.deleteProcessInstance(processInstance1.getId(), "test");
        this.runtimeService.deleteProcessInstance(processInstance2.getId(), "test");
        this.runtimeService.deleteProcessInstance(processInstance3.getId(), "test");
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/oneTaskProcess.bpmn20.xml"})
    public void testBooleanVariable() throws Exception {
        HashMap<String, Boolean> vars = new HashMap<String, Boolean>();
        vars.put("booleanVar", true);
        ProcessInstance processInstance1 = this.runtimeService.startProcessInstanceByKey("oneTaskProcess", vars);
        vars = new HashMap();
        vars.put("booleanVar", false);
        ProcessInstance processInstance2 = this.runtimeService.startProcessInstanceByKey("oneTaskProcess", vars);
        List instances = this.runtimeService.createProcessInstanceQuery().variableValueEquals("booleanVar", (Object)true).list();
        ExecutionQueryTest.assertNotNull((Object)instances);
        ExecutionQueryTest.assertEquals((int)1, (int)instances.size());
        ExecutionQueryTest.assertEquals((String)processInstance1.getId(), (String)((ProcessInstance)instances.get(0)).getId());
        instances = this.runtimeService.createProcessInstanceQuery().variableValueEquals("booleanVar", (Object)false).list();
        ExecutionQueryTest.assertNotNull((Object)instances);
        ExecutionQueryTest.assertEquals((int)1, (int)instances.size());
        ExecutionQueryTest.assertEquals((String)processInstance2.getId(), (String)((ProcessInstance)instances.get(0)).getId());
        instances = this.runtimeService.createProcessInstanceQuery().variableValueNotEquals("booleanVar", (Object)true).list();
        ExecutionQueryTest.assertNotNull((Object)instances);
        ExecutionQueryTest.assertEquals((int)1, (int)instances.size());
        ExecutionQueryTest.assertEquals((String)processInstance2.getId(), (String)((ProcessInstance)instances.get(0)).getId());
        instances = this.runtimeService.createProcessInstanceQuery().variableValueNotEquals("booleanVar", (Object)false).list();
        ExecutionQueryTest.assertNotNull((Object)instances);
        ExecutionQueryTest.assertEquals((int)1, (int)instances.size());
        ExecutionQueryTest.assertEquals((String)processInstance1.getId(), (String)((ProcessInstance)instances.get(0)).getId());
        try {
            this.runtimeService.createProcessInstanceQuery().variableValueGreaterThan("booleanVar", (Object)true);
            ExecutionQueryTest.fail((String)"Excetion expected");
        }
        catch (ProcessEngineException ae) {
            this.assertTextPresent("Booleans and null cannot be used in 'greater than' condition", ae.getMessage());
        }
        try {
            this.runtimeService.createProcessInstanceQuery().variableValueGreaterThanOrEqual("booleanVar", (Object)true);
            ExecutionQueryTest.fail((String)"Excetion expected");
        }
        catch (ProcessEngineException ae) {
            this.assertTextPresent("Booleans and null cannot be used in 'greater than or equal' condition", ae.getMessage());
        }
        try {
            this.runtimeService.createProcessInstanceQuery().variableValueLessThan("booleanVar", (Object)true);
            ExecutionQueryTest.fail((String)"Excetion expected");
        }
        catch (ProcessEngineException ae) {
            this.assertTextPresent("Booleans and null cannot be used in 'less than' condition", ae.getMessage());
        }
        try {
            this.runtimeService.createProcessInstanceQuery().variableValueLessThanOrEqual("booleanVar", (Object)true);
            ExecutionQueryTest.fail((String)"Excetion expected");
        }
        catch (ProcessEngineException ae) {
            this.assertTextPresent("Booleans and null cannot be used in 'less than or equal' condition", ae.getMessage());
        }
        this.runtimeService.deleteProcessInstance(processInstance1.getId(), "test");
        this.runtimeService.deleteProcessInstance(processInstance2.getId(), "test");
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/oneTaskProcess.bpmn20.xml"})
    public void testQueryVariablesUpdatedToNullValue() {
        HashMap<String, Object> variables = new HashMap<String, Object>();
        variables.put("longVar", 928374L);
        variables.put("shortVar", (short)123);
        variables.put("integerVar", 1234);
        variables.put("stringVar", "coca-cola");
        variables.put("booleanVar", true);
        variables.put("dateVar", new Date());
        variables.put("nullVar", null);
        ProcessInstance processInstance = this.runtimeService.startProcessInstanceByKey("oneTaskProcess", variables);
        ExecutionQuery query = this.runtimeService.createExecutionQuery().variableValueEquals("longVar", null).variableValueEquals("shortVar", null).variableValueEquals("integerVar", null).variableValueEquals("stringVar", null).variableValueEquals("booleanVar", null).variableValueEquals("dateVar", null);
        ExecutionQuery notQuery = this.runtimeService.createExecutionQuery().variableValueNotEquals("longVar", null).variableValueNotEquals("shortVar", null).variableValueNotEquals("integerVar", null).variableValueNotEquals("stringVar", null).variableValueNotEquals("booleanVar", null).variableValueNotEquals("dateVar", null);
        ExecutionQueryTest.assertNull((Object)query.singleResult());
        ExecutionQueryTest.assertNotNull((Object)notQuery.singleResult());
        this.runtimeService.setVariable(processInstance.getId(), "longVar", null);
        this.runtimeService.setVariable(processInstance.getId(), "shortVar", null);
        this.runtimeService.setVariable(processInstance.getId(), "integerVar", null);
        this.runtimeService.setVariable(processInstance.getId(), "stringVar", null);
        this.runtimeService.setVariable(processInstance.getId(), "booleanVar", null);
        this.runtimeService.setVariable(processInstance.getId(), "dateVar", null);
        this.runtimeService.setVariable(processInstance.getId(), "nullVar", null);
        Execution queryResult = (Execution)query.singleResult();
        ExecutionQueryTest.assertNotNull((Object)queryResult);
        ExecutionQueryTest.assertEquals((String)processInstance.getId(), (String)queryResult.getId());
        ExecutionQueryTest.assertNull((Object)notQuery.singleResult());
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/oneTaskProcess.bpmn20.xml"})
    public void testQueryNullVariable() throws Exception {
        HashMap<String, Object> vars = new HashMap<String, Object>();
        vars.put("nullVar", null);
        ProcessInstance processInstance1 = this.runtimeService.startProcessInstanceByKey("oneTaskProcess", vars);
        vars = new HashMap();
        vars.put("nullVar", "notnull");
        ProcessInstance processInstance2 = this.runtimeService.startProcessInstanceByKey("oneTaskProcess", vars);
        vars = new HashMap();
        vars.put("nullVarLong", "notnull");
        ProcessInstance processInstance3 = this.runtimeService.startProcessInstanceByKey("oneTaskProcess", vars);
        vars = new HashMap();
        vars.put("nullVarDouble", "notnull");
        ProcessInstance processInstance4 = this.runtimeService.startProcessInstanceByKey("oneTaskProcess", vars);
        vars = new HashMap();
        vars.put("nullVarByte", "testbytes".getBytes());
        ProcessInstance processInstance5 = this.runtimeService.startProcessInstanceByKey("oneTaskProcess", vars);
        ExecutionQuery query = this.runtimeService.createExecutionQuery().variableValueEquals("nullVar", null);
        List executions = query.list();
        Assert.assertNotNull((Object)executions);
        Assert.assertEquals((long)1L, (long)executions.size());
        Assert.assertEquals((Object)processInstance1.getId(), (Object)((Execution)executions.get(0)).getId());
        Assert.assertEquals((long)1L, (long)this.runtimeService.createExecutionQuery().variableValueNotEquals("nullVar", null).count());
        Assert.assertEquals((long)1L, (long)this.runtimeService.createExecutionQuery().variableValueNotEquals("nullVarLong", null).count());
        Assert.assertEquals((long)1L, (long)this.runtimeService.createExecutionQuery().variableValueNotEquals("nullVarDouble", null).count());
        Assert.assertEquals((long)1L, (long)this.runtimeService.createExecutionQuery().variableValueNotEquals("nullVarByte", null).count());
        try {
            this.runtimeService.createExecutionQuery().variableValueGreaterThan("nullVar", null);
            ExecutionQueryTest.fail((String)"Excetion expected");
        }
        catch (ProcessEngineException ae) {
            this.assertTextPresent("Booleans and null cannot be used in 'greater than' condition", ae.getMessage());
        }
        try {
            this.runtimeService.createExecutionQuery().variableValueGreaterThanOrEqual("nullVar", null);
            ExecutionQueryTest.fail((String)"Excetion expected");
        }
        catch (ProcessEngineException ae) {
            this.assertTextPresent("Booleans and null cannot be used in 'greater than or equal' condition", ae.getMessage());
        }
        try {
            this.runtimeService.createExecutionQuery().variableValueLessThan("nullVar", null);
            ExecutionQueryTest.fail((String)"Excetion expected");
        }
        catch (ProcessEngineException ae) {
            this.assertTextPresent("Booleans and null cannot be used in 'less than' condition", ae.getMessage());
        }
        try {
            this.runtimeService.createExecutionQuery().variableValueLessThanOrEqual("nullVar", null);
            ExecutionQueryTest.fail((String)"Excetion expected");
        }
        catch (ProcessEngineException ae) {
            this.assertTextPresent("Booleans and null cannot be used in 'less than or equal' condition", ae.getMessage());
        }
        try {
            this.runtimeService.createExecutionQuery().variableValueLike("nullVar", null);
            ExecutionQueryTest.fail((String)"Excetion expected");
        }
        catch (ProcessEngineException ae) {
            this.assertTextPresent("Booleans and null cannot be used in 'like' condition", ae.getMessage());
        }
        this.runtimeService.deleteProcessInstance(processInstance1.getId(), "test");
        this.runtimeService.deleteProcessInstance(processInstance2.getId(), "test");
        this.runtimeService.deleteProcessInstance(processInstance3.getId(), "test");
        this.runtimeService.deleteProcessInstance(processInstance4.getId(), "test");
        this.runtimeService.deleteProcessInstance(processInstance5.getId(), "test");
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/oneTaskProcess.bpmn20.xml"})
    public void testQueryInvalidTypes() throws Exception {
        HashMap<String, Object> vars = new HashMap<String, Object>();
        vars.put("bytesVar", "test".getBytes());
        vars.put("serializableVar", new DummySerializable());
        ProcessInstance processInstance = this.runtimeService.startProcessInstanceByKey("oneTaskProcess", vars);
        try {
            this.runtimeService.createExecutionQuery().variableValueEquals("bytesVar", (Object)"test".getBytes()).list();
            ExecutionQueryTest.fail((String)"Expected exception");
        }
        catch (ProcessEngineException ae) {
            this.assertTextPresent("Variables of type ByteArray cannot be used to query", ae.getMessage());
        }
        try {
            this.runtimeService.createExecutionQuery().variableValueEquals("serializableVar", (Object)new DummySerializable()).list();
            ExecutionQueryTest.fail((String)"Expected exception");
        }
        catch (ProcessEngineException ae) {
            this.assertTextPresent("Object values cannot be used to query", ae.getMessage());
        }
        this.runtimeService.deleteProcessInstance(processInstance.getId(), "test");
    }

    public void testQueryVariablesNullNameArgument() {
        try {
            this.runtimeService.createExecutionQuery().variableValueEquals(null, (Object)"value");
            ExecutionQueryTest.fail((String)"Expected exception");
        }
        catch (ProcessEngineException ae) {
            this.assertTextPresent("name is null", ae.getMessage());
        }
        try {
            this.runtimeService.createExecutionQuery().variableValueNotEquals(null, (Object)"value");
            ExecutionQueryTest.fail((String)"Expected exception");
        }
        catch (ProcessEngineException ae) {
            this.assertTextPresent("name is null", ae.getMessage());
        }
        try {
            this.runtimeService.createExecutionQuery().variableValueGreaterThan(null, (Object)"value");
            ExecutionQueryTest.fail((String)"Expected exception");
        }
        catch (ProcessEngineException ae) {
            this.assertTextPresent("name is null", ae.getMessage());
        }
        try {
            this.runtimeService.createExecutionQuery().variableValueGreaterThanOrEqual(null, (Object)"value");
            ExecutionQueryTest.fail((String)"Expected exception");
        }
        catch (ProcessEngineException ae) {
            this.assertTextPresent("name is null", ae.getMessage());
        }
        try {
            this.runtimeService.createExecutionQuery().variableValueLessThan(null, (Object)"value");
            ExecutionQueryTest.fail((String)"Expected exception");
        }
        catch (ProcessEngineException ae) {
            this.assertTextPresent("name is null", ae.getMessage());
        }
        try {
            this.runtimeService.createExecutionQuery().variableValueLessThanOrEqual(null, (Object)"value");
            ExecutionQueryTest.fail((String)"Expected exception");
        }
        catch (ProcessEngineException ae) {
            this.assertTextPresent("name is null", ae.getMessage());
        }
        try {
            this.runtimeService.createExecutionQuery().variableValueLike(null, "value");
            ExecutionQueryTest.fail((String)"Expected exception");
        }
        catch (ProcessEngineException ae) {
            this.assertTextPresent("name is null", ae.getMessage());
        }
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/oneTaskProcess.bpmn20.xml"})
    public void testQueryAllVariableTypes() throws Exception {
        HashMap<String, Object> vars = new HashMap<String, Object>();
        vars.put("nullVar", null);
        vars.put("stringVar", "string");
        vars.put("longVar", 10L);
        vars.put("doubleVar", 1.2);
        vars.put("integerVar", 1234);
        vars.put("booleanVar", true);
        vars.put("shortVar", (short)123);
        ProcessInstance processInstance = this.runtimeService.startProcessInstanceByKey("oneTaskProcess", vars);
        ExecutionQuery query = this.runtimeService.createExecutionQuery().variableValueEquals("nullVar", null).variableValueEquals("stringVar", (Object)"string").variableValueEquals("longVar", (Object)10L).variableValueEquals("doubleVar", (Object)1.2).variableValueEquals("integerVar", (Object)1234).variableValueEquals("booleanVar", (Object)true).variableValueEquals("shortVar", (Object)123);
        List executions = query.list();
        Assert.assertNotNull((Object)executions);
        Assert.assertEquals((long)1L, (long)executions.size());
        Assert.assertEquals((Object)processInstance.getId(), (Object)((Execution)executions.get(0)).getId());
        this.runtimeService.deleteProcessInstance(processInstance.getId(), "test");
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/oneTaskProcess.bpmn20.xml"})
    public void testClashingValues() throws Exception {
        HashMap<String, Long> vars = new HashMap<String, Long>();
        vars.put("var", 1234L);
        ProcessInstance processInstance = this.runtimeService.startProcessInstanceByKey("oneTaskProcess", vars);
        HashMap<String, Integer> vars2 = new HashMap<String, Integer>();
        vars2.put("var", 1234);
        ProcessInstance processInstance2 = this.runtimeService.startProcessInstanceByKey("oneTaskProcess", vars2);
        List executions = this.runtimeService.createExecutionQuery().processDefinitionKey("oneTaskProcess").variableValueEquals("var", (Object)1234L).list();
        ExecutionQueryTest.assertEquals((int)1, (int)executions.size());
        ExecutionQueryTest.assertEquals((String)processInstance.getId(), (String)((Execution)executions.get(0)).getProcessInstanceId());
        this.runtimeService.deleteProcessInstance(processInstance.getId(), "test");
        this.runtimeService.deleteProcessInstance(processInstance2.getId(), "test");
    }

    @Deployment
    public void testQueryBySignalSubscriptionName() {
        this.runtimeService.startProcessInstanceByKey("catchSignal");
        Execution execution = (Execution)this.runtimeService.createExecutionQuery().signalEventSubscription("alert").singleResult();
        ExecutionQueryTest.assertNotNull((Object)execution);
        execution = (Execution)this.runtimeService.createExecutionQuery().signalEventSubscription("nonExisitng").singleResult();
        ExecutionQueryTest.assertNull((Object)execution);
        this.runtimeService.startProcessInstanceByKey("catchSignal");
        ExecutionQueryTest.assertEquals((long)2L, (long)this.runtimeService.createExecutionQuery().signalEventSubscription("alert").count());
    }

    @Deployment
    public void testQueryBySignalSubscriptionNameBoundary() {
        this.runtimeService.startProcessInstanceByKey("signalProces");
        Execution execution = (Execution)this.runtimeService.createExecutionQuery().signalEventSubscription("Test signal").singleResult();
        ExecutionQueryTest.assertNotNull((Object)execution);
        execution = (Execution)this.runtimeService.createExecutionQuery().signalEventSubscription("nonExisitng").singleResult();
        ExecutionQueryTest.assertNull((Object)execution);
        this.runtimeService.startProcessInstanceByKey("signalProces");
        ExecutionQueryTest.assertEquals((long)2L, (long)this.runtimeService.createExecutionQuery().signalEventSubscription("Test signal").count());
    }

    public void testNativeQuery() {
        ExecutionQueryTest.assertEquals((String)"ACT_RU_EXECUTION", (String)this.managementService.getTableName(Execution.class));
        long executionCount = this.runtimeService.createExecutionQuery().count();
        ExecutionQueryTest.assertEquals((long)executionCount, (long)((NativeExecutionQuery)this.runtimeService.createNativeExecutionQuery().sql("SELECT * FROM " + this.managementService.getTableName(Execution.class))).list().size());
        ExecutionQueryTest.assertEquals((long)executionCount, (long)((NativeExecutionQuery)this.runtimeService.createNativeExecutionQuery().sql("SELECT count(*) FROM " + this.managementService.getTableName(Execution.class))).count());
    }

    public void testNativeQueryPaging() {
        ExecutionQueryTest.assertEquals((int)5, (int)((NativeExecutionQuery)this.runtimeService.createNativeExecutionQuery().sql("SELECT * FROM " + this.managementService.getTableName(Execution.class))).listPage(1, 5).size());
        ExecutionQueryTest.assertEquals((int)1, (int)((NativeExecutionQuery)this.runtimeService.createNativeExecutionQuery().sql("SELECT * FROM " + this.managementService.getTableName(Execution.class))).listPage(2, 1).size());
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/runtime/concurrentExecution.bpmn20.xml"})
    public void testExecutionQueryWithProcessVariable() {
        HashMap<String, String> variables = new HashMap<String, String>();
        variables.put("x", "parent");
        ProcessInstance pi = this.runtimeService.startProcessInstanceByKey("concurrent", variables);
        List concurrentExecutions = this.runtimeService.createExecutionQuery().processInstanceId(pi.getId()).list();
        ExecutionQueryTest.assertEquals((int)3, (int)concurrentExecutions.size());
        for (Execution execution : concurrentExecutions) {
            if (((ExecutionEntity)execution).isProcessInstanceExecution()) continue;
            this.runtimeService.setVariableLocal(execution.getId(), "x", (Object)"child");
        }
        ExecutionQueryTest.assertEquals((long)2L, (long)this.runtimeService.createExecutionQuery().processInstanceId(pi.getId()).variableValueEquals("x", (Object)"child").count());
        ExecutionQueryTest.assertEquals((long)1L, (long)this.runtimeService.createExecutionQuery().processInstanceId(pi.getId()).variableValueEquals("x", (Object)"parent").count());
        ExecutionQueryTest.assertEquals((long)3L, (long)this.runtimeService.createExecutionQuery().processInstanceId(pi.getId()).processVariableValueEquals("x", (Object)"parent").count());
        ExecutionQueryTest.assertEquals((long)3L, (long)this.runtimeService.createExecutionQuery().processInstanceId(pi.getId()).processVariableValueNotEquals("x", (Object)"xxx").count());
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/runtime/concurrentExecution.bpmn20.xml"})
    public void testExecutionQueryForSuspendedExecutions() {
        List suspendedExecutions = this.runtimeService.createExecutionQuery().suspended().list();
        ExecutionQueryTest.assertEquals((int)suspendedExecutions.size(), (int)0);
        for (String instanceId : this.concurrentProcessInstanceIds) {
            this.runtimeService.suspendProcessInstanceById(instanceId);
        }
        suspendedExecutions = this.runtimeService.createExecutionQuery().suspended().list();
        ExecutionQueryTest.assertEquals((int)12, (int)suspendedExecutions.size());
        List activeExecutions = this.runtimeService.createExecutionQuery().active().list();
        ExecutionQueryTest.assertEquals((int)1, (int)activeExecutions.size());
        for (Execution activeExecution : activeExecutions) {
            ExecutionQueryTest.assertEquals((String)activeExecution.getProcessInstanceId(), (String)this.sequentialProcessInstanceIds.get(0));
        }
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/runtime/failingProcessCreateOneIncident.bpmn20.xml"})
    public void testQueryByIncidentId() {
        ProcessInstance processInstance = this.runtimeService.startProcessInstanceByKey("failingProcess");
        this.executeAvailableJobs();
        List incidentList = this.runtimeService.createIncidentQuery().list();
        ExecutionQueryTest.assertEquals((int)1, (int)incidentList.size());
        Incident incident = (Incident)this.runtimeService.createIncidentQuery().processInstanceId(processInstance.getId()).singleResult();
        List executionList = this.runtimeService.createExecutionQuery().incidentId(incident.getId()).list();
        ExecutionQueryTest.assertEquals((int)1, (int)executionList.size());
    }

    public void testQueryByInvalidIncidentId() {
        ProcessDefinitionQuery query = this.repositoryService.createProcessDefinitionQuery();
        ExecutionQueryTest.assertEquals((long)0L, (long)query.incidentId("invalid").count());
        try {
            query.incidentId(null);
            ExecutionQueryTest.fail();
        }
        catch (ProcessEngineException processEngineException) {
            // empty catch block
        }
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/runtime/failingProcessCreateOneIncident.bpmn20.xml"})
    public void testQueryByIncidentType() {
        ProcessInstance processInstance = this.runtimeService.startProcessInstanceByKey("failingProcess");
        this.executeAvailableJobs();
        List incidentList = this.runtimeService.createIncidentQuery().list();
        ExecutionQueryTest.assertEquals((int)1, (int)incidentList.size());
        Incident incident = (Incident)this.runtimeService.createIncidentQuery().processInstanceId(processInstance.getId()).singleResult();
        List executionList = this.runtimeService.createExecutionQuery().incidentType(incident.getIncidentType()).list();
        ExecutionQueryTest.assertEquals((int)1, (int)executionList.size());
    }

    public void testQueryByInvalidIncidentType() {
        ProcessDefinitionQuery query = this.repositoryService.createProcessDefinitionQuery();
        ExecutionQueryTest.assertEquals((long)0L, (long)query.incidentType("invalid").count());
        try {
            query.incidentType(null);
            ExecutionQueryTest.fail();
        }
        catch (ProcessEngineException processEngineException) {
            // empty catch block
        }
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/runtime/failingProcessCreateOneIncident.bpmn20.xml"})
    public void testQueryByIncidentMessage() {
        ProcessInstance processInstance = this.runtimeService.startProcessInstanceByKey("failingProcess");
        this.executeAvailableJobs();
        List incidentList = this.runtimeService.createIncidentQuery().list();
        ExecutionQueryTest.assertEquals((int)1, (int)incidentList.size());
        Incident incident = (Incident)this.runtimeService.createIncidentQuery().processInstanceId(processInstance.getId()).singleResult();
        List executionList = this.runtimeService.createExecutionQuery().incidentMessage(incident.getIncidentMessage()).list();
        ExecutionQueryTest.assertEquals((int)1, (int)executionList.size());
    }

    public void testQueryByInvalidIncidentMessage() {
        ProcessDefinitionQuery query = this.repositoryService.createProcessDefinitionQuery();
        ExecutionQueryTest.assertEquals((long)0L, (long)query.incidentMessage("invalid").count());
        try {
            query.incidentMessage(null);
            ExecutionQueryTest.fail();
        }
        catch (ProcessEngineException processEngineException) {
            // empty catch block
        }
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/runtime/failingProcessCreateOneIncident.bpmn20.xml"})
    public void testQueryByIncidentMessageLike() {
        this.runtimeService.startProcessInstanceByKey("failingProcess");
        this.executeAvailableJobs();
        List incidentList = this.runtimeService.createIncidentQuery().list();
        ExecutionQueryTest.assertEquals((int)1, (int)incidentList.size());
        List executionList = this.runtimeService.createExecutionQuery().incidentMessageLike("%exception%").list();
        ExecutionQueryTest.assertEquals((int)1, (int)executionList.size());
    }

    public void testQueryByInvalidIncidentMessageLike() {
        ProcessDefinitionQuery query = this.repositoryService.createProcessDefinitionQuery();
        ExecutionQueryTest.assertEquals((long)0L, (long)query.incidentMessageLike("invalid").count());
        try {
            query.incidentMessageLike(null);
            ExecutionQueryTest.fail();
        }
        catch (ProcessEngineException processEngineException) {
            // empty catch block
        }
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/runtime/failingSubProcessCreateOneIncident.bpmn20.xml"})
    public void testQueryByIncidentIdSubProcess() {
        ProcessInstance processInstance = this.runtimeService.startProcessInstanceByKey("failingSubProcess");
        this.executeAvailableJobs();
        List incidentList = this.runtimeService.createIncidentQuery().list();
        ExecutionQueryTest.assertEquals((int)1, (int)incidentList.size());
        Incident incident = (Incident)this.runtimeService.createIncidentQuery().processInstanceId(processInstance.getId()).singleResult();
        List executionList = this.runtimeService.createExecutionQuery().incidentId(incident.getId()).list();
        ExecutionQueryTest.assertEquals((int)1, (int)executionList.size());
        ExecutionQueryTest.assertNotSame((Object)processInstance.getId(), (Object)((Execution)executionList.get(0)).getId());
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/runtime/failingSubProcessCreateOneIncident.bpmn20.xml"})
    public void testQueryByIncidentTypeInSubprocess() {
        ProcessInstance processInstance = this.runtimeService.startProcessInstanceByKey("failingSubProcess");
        this.executeAvailableJobs();
        List incidentList = this.runtimeService.createIncidentQuery().list();
        ExecutionQueryTest.assertEquals((int)1, (int)incidentList.size());
        Incident incident = (Incident)this.runtimeService.createIncidentQuery().processInstanceId(processInstance.getId()).singleResult();
        List executionList = this.runtimeService.createExecutionQuery().incidentType(incident.getIncidentType()).list();
        ExecutionQueryTest.assertEquals((int)1, (int)executionList.size());
        ExecutionQueryTest.assertNotSame((Object)processInstance.getId(), (Object)((Execution)executionList.get(0)).getId());
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/runtime/failingSubProcessCreateOneIncident.bpmn20.xml"})
    public void testQueryByIncidentMessageInSubProcess() {
        ProcessInstance processInstance = this.runtimeService.startProcessInstanceByKey("failingSubProcess");
        this.executeAvailableJobs();
        List incidentList = this.runtimeService.createIncidentQuery().list();
        ExecutionQueryTest.assertEquals((int)1, (int)incidentList.size());
        Incident incident = (Incident)this.runtimeService.createIncidentQuery().processInstanceId(processInstance.getId()).singleResult();
        List executionList = this.runtimeService.createExecutionQuery().incidentMessage(incident.getIncidentMessage()).list();
        ExecutionQueryTest.assertEquals((int)1, (int)executionList.size());
        ExecutionQueryTest.assertNotSame((Object)processInstance.getId(), (Object)((Execution)executionList.get(0)).getId());
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/runtime/failingSubProcessCreateOneIncident.bpmn20.xml"})
    public void testQueryByIncidentMessageLikeSubProcess() {
        ProcessInstance processInstance = this.runtimeService.startProcessInstanceByKey("failingSubProcess");
        this.executeAvailableJobs();
        List incidentList = this.runtimeService.createIncidentQuery().list();
        ExecutionQueryTest.assertEquals((int)1, (int)incidentList.size());
        this.runtimeService.createIncidentQuery().processInstanceId(processInstance.getId()).singleResult();
        List executionList = this.runtimeService.createExecutionQuery().incidentMessageLike("%exception%").list();
        ExecutionQueryTest.assertEquals((int)1, (int)executionList.size());
        ExecutionQueryTest.assertNotSame((Object)processInstance.getId(), (Object)((Execution)executionList.get(0)).getId());
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/runtime/oneTaskProcess.bpmn20.xml", "org/camunda/bpm/engine/test/api/runtime/oneMessageCatchProcess.bpmn20.xml"})
    public void testQueryForExecutionsWithMessageEventSubscriptions() {
        this.runtimeService.startProcessInstanceByKey("oneTaskProcess");
        this.runtimeService.startProcessInstanceByKey("oneTaskProcess");
        ProcessInstance instance1 = this.runtimeService.startProcessInstanceByKey("oneMessageCatchProcess");
        ProcessInstance instance2 = this.runtimeService.startProcessInstanceByKey("oneMessageCatchProcess");
        List executions = ((ExecutionQuery)this.runtimeService.createExecutionQuery().messageEventSubscription().orderByProcessInstanceId().asc()).list();
        ExecutionQueryTest.assertEquals((int)2, (int)executions.size());
        if (instance1.getId().compareTo(instance2.getId()) < 0) {
            ExecutionQueryTest.assertEquals((String)instance1.getId(), (String)((Execution)executions.get(0)).getProcessInstanceId());
            ExecutionQueryTest.assertEquals((String)instance2.getId(), (String)((Execution)executions.get(1)).getProcessInstanceId());
        } else {
            ExecutionQueryTest.assertEquals((String)instance2.getId(), (String)((Execution)executions.get(0)).getProcessInstanceId());
            ExecutionQueryTest.assertEquals((String)instance1.getId(), (String)((Execution)executions.get(1)).getProcessInstanceId());
        }
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/runtime/oneMessageCatchProcess.bpmn20.xml"})
    public void testQueryForExecutionsWithMessageEventSubscriptionsOverlappingFilters() {
        ProcessInstance instance = this.runtimeService.startProcessInstanceByKey("oneMessageCatchProcess");
        Execution execution = (Execution)this.runtimeService.createExecutionQuery().messageEventSubscriptionName("newInvoiceMessage").messageEventSubscription().singleResult();
        ExecutionQueryTest.assertNotNull((Object)execution);
        ExecutionQueryTest.assertEquals((String)instance.getId(), (String)execution.getProcessInstanceId());
        this.runtimeService.createExecutionQuery().messageEventSubscription().messageEventSubscriptionName("newInvoiceMessage").list();
        ExecutionQueryTest.assertNotNull((Object)execution);
        ExecutionQueryTest.assertEquals((String)instance.getId(), (String)execution.getProcessInstanceId());
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/runtime/twoBoundaryEventSubscriptions.bpmn20.xml"})
    public void testQueryForExecutionsWithMultipleSubscriptions() {
        ProcessInstance instance = this.runtimeService.startProcessInstanceByKey("process");
        List subscriptions = this.runtimeService.createEventSubscriptionQuery().processInstanceId(instance.getId()).list();
        ExecutionQueryTest.assertEquals((int)2, (int)subscriptions.size());
        ExecutionQueryTest.assertEquals((String)((EventSubscription)subscriptions.get(0)).getExecutionId(), (String)((EventSubscription)subscriptions.get(1)).getExecutionId());
        Execution execution = (Execution)this.runtimeService.createExecutionQuery().messageEventSubscription().singleResult();
        ExecutionQueryTest.assertNotNull((Object)execution);
        ExecutionQueryTest.assertEquals((String)instance.getId(), (String)execution.getProcessInstanceId());
        execution = (Execution)this.runtimeService.createExecutionQuery().messageEventSubscriptionName("messageName_1").singleResult();
        ExecutionQueryTest.assertNotNull((Object)execution);
        ExecutionQueryTest.assertEquals((String)instance.getId(), (String)execution.getProcessInstanceId());
        execution = (Execution)this.runtimeService.createExecutionQuery().messageEventSubscriptionName("messageName_2").singleResult();
        ExecutionQueryTest.assertNotNull((Object)execution);
        ExecutionQueryTest.assertEquals((String)instance.getId(), (String)execution.getProcessInstanceId());
        execution = (Execution)this.runtimeService.createExecutionQuery().messageEventSubscriptionName("messageName_1").messageEventSubscriptionName("messageName_2").singleResult();
        ExecutionQueryTest.assertNotNull((Object)execution);
        ExecutionQueryTest.assertEquals((String)instance.getId(), (String)execution.getProcessInstanceId());
        execution = (Execution)this.runtimeService.createExecutionQuery().messageEventSubscriptionName("messageName_1").messageEventSubscriptionName("messageName_2").messageEventSubscriptionName("another").singleResult();
        ExecutionQueryTest.assertNull((Object)execution);
    }
}

