/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.test.api.runtime;

import java.util.HashMap;
import java.util.List;
import org.camunda.bpm.engine.MismatchingMessageCorrelationException;
import org.camunda.bpm.engine.ProcessEngineException;
import org.camunda.bpm.engine.exception.NullValueException;
import org.camunda.bpm.engine.impl.test.PluggableProcessEngineTestCase;
import org.camunda.bpm.engine.runtime.Execution;
import org.camunda.bpm.engine.runtime.ExecutionQuery;
import org.camunda.bpm.engine.runtime.ProcessInstance;
import org.camunda.bpm.engine.task.Task;
import org.camunda.bpm.engine.test.Deployment;

public class MessageCorrelationTest
extends PluggableProcessEngineTestCase {
    @Deployment
    public void testCatchingMessageEventCorrelation() {
        HashMap<String, String> variables = new HashMap<String, String>();
        variables.put("aKey", "aValue");
        ProcessInstance processInstance = this.runtimeService.startProcessInstanceByKey("process", variables);
        variables = new HashMap();
        variables.put("aKey", "anotherValue");
        this.runtimeService.startProcessInstanceByKey("process", variables);
        String messageName = "newInvoiceMessage";
        HashMap<String, String> correlationKeys = new HashMap<String, String>();
        correlationKeys.put("aKey", "aValue");
        HashMap<String, String> messagePayload = new HashMap<String, String>();
        messagePayload.put("aNewKey", "aNewVariable");
        this.runtimeService.correlateMessage(messageName, correlationKeys, messagePayload);
        long uncorrelatedExecutions = this.runtimeService.createExecutionQuery().processVariableValueEquals("aKey", (Object)"anotherValue").messageEventSubscriptionName("newInvoiceMessage").count();
        MessageCorrelationTest.assertEquals((long)1L, (long)uncorrelatedExecutions);
        long correlatedExecutions = this.runtimeService.createExecutionQuery().activityId("task").processVariableValueEquals("aKey", (Object)"aValue").processVariableValueEquals("aNewKey", (Object)"aNewVariable").count();
        MessageCorrelationTest.assertEquals((long)1L, (long)correlatedExecutions);
        this.runtimeService.deleteProcessInstance(processInstance.getId(), null);
        variables = new HashMap();
        variables.put("aKey", "aValue");
        processInstance = this.runtimeService.startProcessInstanceByKey("process", variables);
        this.runtimeService.createMessageCorrelation(messageName).processInstanceVariableEquals("aKey", (Object)"aValue").setVariable("aNewKey", (Object)"aNewVariable").correlate();
        uncorrelatedExecutions = this.runtimeService.createExecutionQuery().processVariableValueEquals("aKey", (Object)"anotherValue").messageEventSubscriptionName("newInvoiceMessage").count();
        MessageCorrelationTest.assertEquals((long)1L, (long)uncorrelatedExecutions);
        correlatedExecutions = this.runtimeService.createExecutionQuery().activityId("task").processVariableValueEquals("aKey", (Object)"aValue").processVariableValueEquals("aNewKey", (Object)"aNewVariable").count();
        MessageCorrelationTest.assertEquals((long)1L, (long)correlatedExecutions);
        this.runtimeService.deleteProcessInstance(processInstance.getId(), null);
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/runtime/MessageCorrelationTest.testCatchingMessageEventCorrelation.bpmn20.xml"})
    public void testOneMatchinProcessInstanceUsingFluentCorrelateAll() {
        HashMap<String, String> variables = new HashMap<String, String>();
        variables.put("aKey", "aValue");
        this.runtimeService.startProcessInstanceByKey("process", variables);
        variables = new HashMap();
        variables.put("aKey", "anotherValue");
        this.runtimeService.startProcessInstanceByKey("process", variables);
        String messageName = "newInvoiceMessage";
        this.runtimeService.createMessageCorrelation(messageName).processInstanceVariableEquals("aKey", (Object)"aValue").setVariable("aNewKey", (Object)"aNewVariable").correlateAll();
        long uncorrelatedExecutions = this.runtimeService.createExecutionQuery().processVariableValueEquals("aKey", (Object)"anotherValue").messageEventSubscriptionName("newInvoiceMessage").count();
        MessageCorrelationTest.assertEquals((long)1L, (long)uncorrelatedExecutions);
        long correlatedExecutions = this.runtimeService.createExecutionQuery().activityId("task").processVariableValueEquals("aKey", (Object)"aValue").processVariableValueEquals("aNewKey", (Object)"aNewVariable").count();
        MessageCorrelationTest.assertEquals((long)1L, (long)correlatedExecutions);
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/runtime/MessageCorrelationTest.testCatchingMessageEventCorrelation.bpmn20.xml"})
    public void testTwoMatchingProcessInstancesCorrelation() {
        HashMap<String, String> variables = new HashMap<String, String>();
        variables.put("aKey", "aValue");
        this.runtimeService.startProcessInstanceByKey("process", variables);
        variables = new HashMap();
        variables.put("aKey", "aValue");
        this.runtimeService.startProcessInstanceByKey("process", variables);
        String messageName = "newInvoiceMessage";
        HashMap<String, String> correlationKeys = new HashMap<String, String>();
        correlationKeys.put("aKey", "aValue");
        try {
            this.runtimeService.correlateMessage(messageName, correlationKeys);
            MessageCorrelationTest.fail((String)"Expected an Exception");
        }
        catch (MismatchingMessageCorrelationException e) {
            this.assertTextPresent("2 executions match the correlation keys.", e.getMessage());
        }
        try {
            this.runtimeService.createMessageCorrelation(messageName).processInstanceVariableEquals("aKey", (Object)"aValue").correlate();
            MessageCorrelationTest.fail((String)"Expected an Exception");
        }
        catch (MismatchingMessageCorrelationException e) {
            this.assertTextPresent("2 executions match the correlation keys.", e.getMessage());
        }
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/runtime/MessageCorrelationTest.testCatchingMessageEventCorrelation.bpmn20.xml"})
    public void testTwoMatchingProcessInstancesUsingFluentCorrelateAll() {
        HashMap<String, String> variables = new HashMap<String, String>();
        variables.put("aKey", "aValue");
        this.runtimeService.startProcessInstanceByKey("process", variables);
        variables = new HashMap();
        variables.put("aKey", "aValue");
        this.runtimeService.startProcessInstanceByKey("process", variables);
        String messageName = "newInvoiceMessage";
        HashMap<String, String> correlationKeys = new HashMap<String, String>();
        correlationKeys.put("aKey", "aValue");
        this.runtimeService.createMessageCorrelation(messageName).processInstanceVariableEquals("aKey", (Object)"aValue").setVariable("aNewKey", (Object)"aNewVariable").correlateAll();
        long uncorrelatedExecutions = this.runtimeService.createExecutionQuery().messageEventSubscriptionName("newInvoiceMessage").count();
        MessageCorrelationTest.assertEquals((long)0L, (long)uncorrelatedExecutions);
        long correlatedExecutions = this.runtimeService.createExecutionQuery().activityId("task").processVariableValueEquals("aKey", (Object)"aValue").processVariableValueEquals("aNewKey", (Object)"aNewVariable").count();
        MessageCorrelationTest.assertEquals((long)2L, (long)correlatedExecutions);
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/runtime/MessageCorrelationTest.testCatchingMessageEventCorrelation.bpmn20.xml"})
    public void testExecutionCorrelationByBusinessKey() {
        String businessKey = "aBusinessKey";
        ProcessInstance processInstance = this.runtimeService.startProcessInstanceByKey("process", businessKey);
        this.runtimeService.correlateMessage("newInvoiceMessage", businessKey);
        long correlatedExecutions = this.runtimeService.createExecutionQuery().activityId("task").count();
        MessageCorrelationTest.assertEquals((long)1L, (long)correlatedExecutions);
        this.runtimeService.deleteProcessInstance(processInstance.getId(), null);
        processInstance = this.runtimeService.startProcessInstanceByKey("process", businessKey);
        this.runtimeService.createMessageCorrelation("newInvoiceMessage").processInstanceBusinessKey(businessKey).correlate();
        correlatedExecutions = this.runtimeService.createExecutionQuery().activityId("task").count();
        MessageCorrelationTest.assertEquals((long)1L, (long)correlatedExecutions);
        this.runtimeService.deleteProcessInstance(processInstance.getId(), null);
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/runtime/MessageCorrelationTest.testCatchingMessageEventCorrelation.bpmn20.xml"})
    public void testExecutionCorrelationByBusinessKeyUsingFluentCorrelateAll() {
        String businessKey = "aBusinessKey";
        this.runtimeService.startProcessInstanceByKey("process", businessKey);
        this.runtimeService.startProcessInstanceByKey("process", businessKey);
        this.runtimeService.createMessageCorrelation("newInvoiceMessage").processInstanceBusinessKey(businessKey).correlateAll();
        long correlatedExecutions = this.runtimeService.createExecutionQuery().activityId("task").count();
        MessageCorrelationTest.assertEquals((long)2L, (long)correlatedExecutions);
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/runtime/MessageCorrelationTest.testCatchingMessageEventCorrelation.bpmn20.xml"})
    public void testExecutionCorrelationByBusinessKeyWithVariables() {
        String businessKey = "aBusinessKey";
        ProcessInstance processInstance = this.runtimeService.startProcessInstanceByKey("process", businessKey);
        HashMap<String, String> variables = new HashMap<String, String>();
        variables.put("aKey", "aValue");
        this.runtimeService.correlateMessage("newInvoiceMessage", businessKey, variables);
        long correlatedExecutions = this.runtimeService.createExecutionQuery().processVariableValueEquals("aKey", (Object)"aValue").count();
        MessageCorrelationTest.assertEquals((long)1L, (long)correlatedExecutions);
        this.runtimeService.deleteProcessInstance(processInstance.getId(), null);
        processInstance = this.runtimeService.startProcessInstanceByKey("process", businessKey);
        this.runtimeService.createMessageCorrelation("newInvoiceMessage").processInstanceBusinessKey(businessKey).setVariable("aKey", (Object)"aValue").correlate();
        correlatedExecutions = this.runtimeService.createExecutionQuery().processVariableValueEquals("aKey", (Object)"aValue").count();
        MessageCorrelationTest.assertEquals((long)1L, (long)correlatedExecutions);
        this.runtimeService.deleteProcessInstance(processInstance.getId(), null);
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/runtime/MessageCorrelationTest.testCatchingMessageEventCorrelation.bpmn20.xml"})
    public void testExecutionCorrelationByBusinessKeyWithVariablesUsingFluentCorrelateAll() {
        String businessKey = "aBusinessKey";
        this.runtimeService.startProcessInstanceByKey("process", businessKey);
        this.runtimeService.startProcessInstanceByKey("process", businessKey);
        this.runtimeService.createMessageCorrelation("newInvoiceMessage").processInstanceBusinessKey(businessKey).setVariable("aKey", (Object)"aValue").correlateAll();
        long correlatedExecutions = this.runtimeService.createExecutionQuery().processVariableValueEquals("aKey", (Object)"aValue").count();
        MessageCorrelationTest.assertEquals((long)2L, (long)correlatedExecutions);
    }

    @Deployment
    public void testMessageStartEventCorrelation() {
        HashMap<String, String> variables = new HashMap<String, String>();
        variables.put("aKey", "aValue");
        this.runtimeService.correlateMessage("newInvoiceMessage", new HashMap(), variables);
        long instances = this.runtimeService.createProcessInstanceQuery().processDefinitionKey("messageStartEvent").variableValueEquals("aKey", (Object)"aValue").count();
        MessageCorrelationTest.assertEquals((long)1L, (long)instances);
        this.runtimeService.createMessageCorrelation("newInvoiceMessage").setVariable("aKey", (Object)"aValue").correlate();
        instances = this.runtimeService.createProcessInstanceQuery().processDefinitionKey("messageStartEvent").variableValueEquals("aKey", (Object)"aValue").count();
        MessageCorrelationTest.assertEquals((long)2L, (long)instances);
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/runtime/MessageCorrelationTest.testMessageStartEventCorrelation.bpmn20.xml"})
    public void testMessageStartEventCorrelationUsingFluentCorrelateAll() {
        HashMap<String, String> variables = new HashMap<String, String>();
        variables.put("aKey", "aValue");
        this.runtimeService.createMessageCorrelation("newInvoiceMessage").setVariable("aKey", (Object)"aValue").correlateAll();
        long instances = this.runtimeService.createProcessInstanceQuery().processDefinitionKey("messageStartEvent").variableValueEquals("aKey", (Object)"aValue").count();
        MessageCorrelationTest.assertEquals((long)1L, (long)instances);
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/runtime/MessageCorrelationTest.testMessageStartEventCorrelation.bpmn20.xml"})
    public void testMessageStartEventCorrelationBusKey() {
        String businessKey = "aBusinessKey";
        this.runtimeService.correlateMessage("newInvoiceMessage", "aBusinessKey");
        ProcessInstance processInstance = (ProcessInstance)this.runtimeService.createProcessInstanceQuery().singleResult();
        MessageCorrelationTest.assertEquals((String)"aBusinessKey", (String)processInstance.getBusinessKey());
        this.runtimeService.deleteProcessInstance(processInstance.getId(), null);
        this.runtimeService.createMessageCorrelation("newInvoiceMessage").processInstanceBusinessKey("aBusinessKey").correlate();
        processInstance = (ProcessInstance)this.runtimeService.createProcessInstanceQuery().singleResult();
        MessageCorrelationTest.assertEquals((String)"aBusinessKey", (String)processInstance.getBusinessKey());
        this.runtimeService.deleteProcessInstance(processInstance.getId(), null);
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/runtime/MessageCorrelationTest.testMessageStartEventCorrelation.bpmn20.xml"})
    public void testMessageStartEventCorrelationBusKeyUsingFluentCorrelateAll() {
        String businessKey = "aBusinessKey";
        this.runtimeService.createMessageCorrelation("newInvoiceMessage").processInstanceBusinessKey("aBusinessKey").correlateAll();
        ProcessInstance processInstance = (ProcessInstance)this.runtimeService.createProcessInstanceQuery().singleResult();
        MessageCorrelationTest.assertEquals((String)"aBusinessKey", (String)processInstance.getBusinessKey());
    }

    @Deployment
    public void testMultipleMessageStartEventsCorrelation() {
        this.runtimeService.correlateMessage("someMessage");
        Task task = (Task)this.taskService.createTaskQuery().taskDefinitionKey("task1").singleResult();
        MessageCorrelationTest.assertNotNull((Object)task);
        MessageCorrelationTest.assertNull((Object)this.taskService.createTaskQuery().taskDefinitionKey("task2").singleResult());
        this.taskService.complete(task.getId());
        this.runtimeService.correlateMessage("someOtherMessage");
        task = (Task)this.taskService.createTaskQuery().taskDefinitionKey("task2").singleResult();
        MessageCorrelationTest.assertNotNull((Object)task);
        MessageCorrelationTest.assertNull((Object)this.taskService.createTaskQuery().taskDefinitionKey("task1").singleResult());
        this.taskService.complete(task.getId());
        this.runtimeService.createMessageCorrelation("someMessage").correlate();
        task = (Task)this.taskService.createTaskQuery().taskDefinitionKey("task1").singleResult();
        MessageCorrelationTest.assertNotNull((Object)task);
        MessageCorrelationTest.assertNull((Object)this.taskService.createTaskQuery().taskDefinitionKey("task2").singleResult());
        this.taskService.complete(task.getId());
        this.runtimeService.createMessageCorrelation("someOtherMessage").correlate();
        task = (Task)this.taskService.createTaskQuery().taskDefinitionKey("task2").singleResult();
        MessageCorrelationTest.assertNotNull((Object)task);
        MessageCorrelationTest.assertNull((Object)this.taskService.createTaskQuery().taskDefinitionKey("task1").singleResult());
        this.taskService.complete(task.getId());
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/runtime/MessageCorrelationTest.testMultipleMessageStartEventsCorrelation.bpmn20.xml"})
    public void testMultipleMessageStartEventsCorrelationUsingFluentCorrelateAll() {
        this.runtimeService.createMessageCorrelation("someMessage").correlateAll();
        Task task = (Task)this.taskService.createTaskQuery().taskDefinitionKey("task1").singleResult();
        MessageCorrelationTest.assertNotNull((Object)task);
        MessageCorrelationTest.assertNull((Object)this.taskService.createTaskQuery().taskDefinitionKey("task2").singleResult());
        this.taskService.complete(task.getId());
        this.runtimeService.createMessageCorrelation("someOtherMessage").correlateAll();
        task = (Task)this.taskService.createTaskQuery().taskDefinitionKey("task2").singleResult();
        MessageCorrelationTest.assertNotNull((Object)task);
        MessageCorrelationTest.assertNull((Object)this.taskService.createTaskQuery().taskDefinitionKey("task1").singleResult());
        this.taskService.complete(task.getId());
    }

    @Deployment
    public void testMatchingStartEventAndExecution() {
        ProcessInstance processInstance = this.runtimeService.startProcessInstanceByKey("process");
        MessageCorrelationTest.assertNotNull((Object)this.runtimeService.createExecutionQuery().messageEventSubscriptionName("newInvoiceMessage").singleResult());
        this.runtimeService.correlateMessage("newInvoiceMessage");
        MessageCorrelationTest.assertNull((Object)this.runtimeService.createExecutionQuery().messageEventSubscriptionName("newInvoiceMessage").singleResult());
        this.runtimeService.deleteProcessInstance(processInstance.getId(), null);
        processInstance = this.runtimeService.startProcessInstanceByKey("process");
        MessageCorrelationTest.assertNotNull((Object)this.runtimeService.createExecutionQuery().messageEventSubscriptionName("newInvoiceMessage").singleResult());
        this.runtimeService.createMessageCorrelation("newInvoiceMessage").correlate();
        MessageCorrelationTest.assertNull((Object)this.runtimeService.createExecutionQuery().messageEventSubscriptionName("newInvoiceMessage").singleResult());
        this.runtimeService.deleteProcessInstance(processInstance.getId(), null);
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/runtime/MessageCorrelationTest.testMatchingStartEventAndExecution.bpmn20.xml"})
    public void testMatchingStartEventAndExecutionUsingFluentCorrelateAll() {
        this.runtimeService.startProcessInstanceByKey("process");
        this.runtimeService.startProcessInstanceByKey("process");
        MessageCorrelationTest.assertEquals((long)2L, (long)this.runtimeService.createExecutionQuery().messageEventSubscriptionName("newInvoiceMessage").count());
        this.runtimeService.createMessageCorrelation("newInvoiceMessage").correlateAll();
        MessageCorrelationTest.assertNotNull((Object)this.runtimeService.createExecutionQuery().messageEventSubscriptionName("newInvoiceMessage").singleResult());
        MessageCorrelationTest.assertEquals((long)3L, (long)this.runtimeService.createProcessInstanceQuery().count());
    }

    public void testMessageStartEventCorrelationWithNonMatchingDefinition() {
        try {
            this.runtimeService.correlateMessage("aMessageName");
            MessageCorrelationTest.fail((String)"Expect an Exception");
        }
        catch (MismatchingMessageCorrelationException e) {
            this.assertTextPresent("Cannot correlate message", e.getMessage());
        }
        try {
            this.runtimeService.createMessageCorrelation("aMessageName").correlate();
            MessageCorrelationTest.fail((String)"Expect an Exception");
        }
        catch (MismatchingMessageCorrelationException e) {
            this.assertTextPresent("Cannot correlate message", e.getMessage());
        }
        this.runtimeService.createMessageCorrelation("aMessageName").correlateAll();
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/runtime/MessageCorrelationTest.testCatchingMessageEventCorrelation.bpmn20.xml"})
    public void testCorrelationByBusinessKeyAndVariables() {
        HashMap<String, String> variables = new HashMap<String, String>();
        variables.put("aKey", "aValue");
        ProcessInstance processInstance = this.runtimeService.startProcessInstanceByKey("process", "aBusinessKey", variables);
        variables = new HashMap();
        variables.put("aKey", "aValue");
        this.runtimeService.startProcessInstanceByKey("process", "anotherBusinessKey", variables);
        String messageName = "newInvoiceMessage";
        HashMap<String, String> correlationKeys = new HashMap<String, String>();
        correlationKeys.put("aKey", "aValue");
        HashMap<String, String> processVariables = new HashMap<String, String>();
        processVariables.put("aProcessVariable", "aVariableValue");
        this.runtimeService.correlateMessage(messageName, "aBusinessKey", correlationKeys, processVariables);
        Execution correlatedExecution = (Execution)this.runtimeService.createExecutionQuery().activityId("task").processVariableValueEquals("aProcessVariable", (Object)"aVariableValue").singleResult();
        MessageCorrelationTest.assertNotNull((Object)correlatedExecution);
        ProcessInstance correlatedProcessInstance = (ProcessInstance)this.runtimeService.createProcessInstanceQuery().processInstanceId(correlatedExecution.getProcessInstanceId()).singleResult();
        MessageCorrelationTest.assertEquals((String)"aBusinessKey", (String)correlatedProcessInstance.getBusinessKey());
        this.runtimeService.deleteProcessInstance(processInstance.getId(), null);
        variables = new HashMap();
        variables.put("aKey", "aValue");
        processInstance = this.runtimeService.startProcessInstanceByKey("process", "aBusinessKey", variables);
        this.runtimeService.createMessageCorrelation(messageName).processInstanceBusinessKey("aBusinessKey").processInstanceVariableEquals("aKey", (Object)"aValue").setVariable("aProcessVariable", (Object)"aVariableValue").correlate();
        correlatedExecution = (Execution)this.runtimeService.createExecutionQuery().activityId("task").processVariableValueEquals("aProcessVariable", (Object)"aVariableValue").singleResult();
        MessageCorrelationTest.assertNotNull((Object)correlatedExecution);
        correlatedProcessInstance = (ProcessInstance)this.runtimeService.createProcessInstanceQuery().processInstanceId(correlatedExecution.getProcessInstanceId()).singleResult();
        MessageCorrelationTest.assertEquals((String)"aBusinessKey", (String)correlatedProcessInstance.getBusinessKey());
        this.runtimeService.deleteProcessInstance(processInstance.getId(), null);
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/runtime/MessageCorrelationTest.testCatchingMessageEventCorrelation.bpmn20.xml"})
    public void testCorrelationByBusinessKeyAndVariablesUsingFluentCorrelateAll() {
        HashMap<String, String> variables = new HashMap<String, String>();
        variables.put("aKey", "aValue");
        this.runtimeService.startProcessInstanceByKey("process", "aBusinessKey", variables);
        this.runtimeService.startProcessInstanceByKey("process", "aBusinessKey", variables);
        String messageName = "newInvoiceMessage";
        this.runtimeService.createMessageCorrelation(messageName).processInstanceBusinessKey("aBusinessKey").processInstanceVariableEquals("aKey", (Object)"aValue").setVariable("aProcessVariable", (Object)"aVariableValue").correlateAll();
        List correlatedExecutions = this.runtimeService.createExecutionQuery().activityId("task").processVariableValueEquals("aProcessVariable", (Object)"aVariableValue").list();
        MessageCorrelationTest.assertEquals((int)2, (int)correlatedExecutions.size());
        Execution correlatedExecution = (Execution)correlatedExecutions.get(0);
        ProcessInstance correlatedProcessInstance = (ProcessInstance)this.runtimeService.createProcessInstanceQuery().processInstanceId(correlatedExecution.getProcessInstanceId()).singleResult();
        MessageCorrelationTest.assertEquals((String)"aBusinessKey", (String)correlatedProcessInstance.getBusinessKey());
        correlatedExecution = (Execution)correlatedExecutions.get(1);
        correlatedProcessInstance = (ProcessInstance)this.runtimeService.createProcessInstanceQuery().processInstanceId(correlatedExecution.getProcessInstanceId()).singleResult();
        MessageCorrelationTest.assertEquals((String)"aBusinessKey", (String)correlatedProcessInstance.getBusinessKey());
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/runtime/MessageCorrelationTest.testCatchingMessageEventCorrelation.bpmn20.xml"})
    public void testCorrelationByProcessInstanceId() {
        ProcessInstance processInstance1 = this.runtimeService.startProcessInstanceByKey("process");
        ProcessInstance processInstance2 = this.runtimeService.startProcessInstanceByKey("process");
        try {
            this.runtimeService.createMessageCorrelation("aMessageName").correlate();
            MessageCorrelationTest.fail((String)"Expect an Exception");
        }
        catch (MismatchingMessageCorrelationException e) {
            this.assertTextPresent("Cannot correlate message", e.getMessage());
        }
        this.runtimeService.createMessageCorrelation("newInvoiceMessage").processInstanceId(processInstance1.getId()).correlate();
        Execution correlatedExecution = (Execution)this.runtimeService.createExecutionQuery().activityId("task").processInstanceId(processInstance1.getId()).singleResult();
        MessageCorrelationTest.assertNotNull((Object)correlatedExecution);
        Execution uncorrelatedExecution = (Execution)this.runtimeService.createExecutionQuery().activityId("task").processInstanceId(processInstance2.getId()).singleResult();
        MessageCorrelationTest.assertNull((Object)uncorrelatedExecution);
        this.runtimeService.deleteProcessInstance(processInstance1.getId(), null);
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/runtime/MessageCorrelationTest.testCatchingMessageEventCorrelation.bpmn20.xml"})
    public void testCorrelationByProcessInstanceIdUsingFluentCorrelateAll() {
        ProcessInstance processInstance1 = this.runtimeService.startProcessInstanceByKey("process");
        ProcessInstance processInstance2 = this.runtimeService.startProcessInstanceByKey("process");
        this.runtimeService.createMessageCorrelation("aMessageName").correlateAll();
        MessageCorrelationTest.assertEquals((long)0L, (long)this.runtimeService.createExecutionQuery().activityId("task").count());
        processInstance1 = this.runtimeService.startProcessInstanceByKey("process");
        processInstance2 = this.runtimeService.startProcessInstanceByKey("process");
        this.runtimeService.createMessageCorrelation("newInvoiceMessage").processInstanceId(processInstance1.getId()).correlateAll();
        Execution correlatedExecution = (Execution)this.runtimeService.createExecutionQuery().activityId("task").processInstanceId(processInstance1.getId()).singleResult();
        MessageCorrelationTest.assertNotNull((Object)correlatedExecution);
        Execution uncorrelatedExecution = (Execution)this.runtimeService.createExecutionQuery().activityId("task").processInstanceId(processInstance2.getId()).singleResult();
        MessageCorrelationTest.assertNull((Object)uncorrelatedExecution);
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/runtime/MessageCorrelationTest.testCatchingMessageEventCorrelation.bpmn20.xml"})
    public void testCorrelationByBusinessKeyAndNullVariableUsingFluentCorrelateAll() {
        this.runtimeService.startProcessInstanceByKey("process", "aBusinessKey");
        String messageName = "newInvoiceMessage";
        try {
            this.runtimeService.createMessageCorrelation(messageName).processInstanceBusinessKey("aBusinessKey").setVariable(null, (Object)"aVariableValue").correlateAll();
            MessageCorrelationTest.fail((String)"Variable name is null");
        }
        catch (Exception e) {
            MessageCorrelationTest.assertTrue((boolean)(e instanceof ProcessEngineException));
            this.assertTextPresent("null", e.getMessage());
        }
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/runtime/MessageCorrelationTest.testCatchingMessageEventCorrelation.bpmn20.xml"})
    public void testCorrelationByBusinessKeyAndNullVariableEqualsUsingFluentCorrelateAll() {
        HashMap<String, String> variables = new HashMap<String, String>();
        variables.put("foo", "bar");
        this.runtimeService.startProcessInstanceByKey("process", "aBusinessKey", variables);
        String messageName = "newInvoiceMessage";
        try {
            this.runtimeService.createMessageCorrelation(messageName).processInstanceBusinessKey("aBusinessKey").processInstanceVariableEquals(null, (Object)"bar").correlateAll();
            MessageCorrelationTest.fail((String)"Variable name is null");
        }
        catch (Exception e) {
            MessageCorrelationTest.assertTrue((boolean)(e instanceof ProcessEngineException));
            this.assertTextPresent("null", e.getMessage());
        }
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/runtime/MessageCorrelationTest.testCatchingMessageEventCorrelation.bpmn20.xml"})
    public void testCorrelationByBusinessKeyAndNullVariablesUsingFluentCorrelateAll() {
        this.runtimeService.startProcessInstanceByKey("process", "aBusinessKey");
        String messageName = "newInvoiceMessage";
        this.runtimeService.createMessageCorrelation(messageName).processInstanceBusinessKey("aBusinessKey").setVariables(null).setVariable("foo", (Object)"bar").correlateAll();
        List correlatedExecutions = this.runtimeService.createExecutionQuery().activityId("task").processVariableValueEquals("foo", (Object)"bar").list();
        MessageCorrelationTest.assertFalse((boolean)correlatedExecutions.isEmpty());
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/runtime/MessageCorrelationTest.testCatchingMessageEventCorrelation.bpmn20.xml"})
    public void testCorrelationByVariablesOnly() {
        HashMap<String, String> variables = new HashMap<String, String>();
        variables.put("variable", "value1");
        this.runtimeService.startProcessInstanceByKey("process", variables);
        variables.put("variable", "value2");
        ProcessInstance instance = this.runtimeService.startProcessInstanceByKey("process", variables);
        this.runtimeService.correlateMessage(null, variables);
        List correlatedExecutions = this.runtimeService.createExecutionQuery().activityId("task").list();
        MessageCorrelationTest.assertEquals((int)1, (int)correlatedExecutions.size());
        MessageCorrelationTest.assertEquals((String)instance.getId(), (String)((Execution)correlatedExecutions.get(0)).getId());
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/runtime/MessageCorrelationTest.testCatchingMessageEventCorrelation.bpmn20.xml"})
    public void testCorrelationByBusinessKey() {
        this.runtimeService.startProcessInstanceByKey("process", "businessKey1");
        ProcessInstance instance = this.runtimeService.startProcessInstanceByKey("process", "businessKey2");
        this.runtimeService.correlateMessage(null, "businessKey2");
        List correlatedExecutions = this.runtimeService.createExecutionQuery().activityId("task").list();
        MessageCorrelationTest.assertEquals((int)1, (int)correlatedExecutions.size());
        MessageCorrelationTest.assertEquals((String)instance.getId(), (String)((Execution)correlatedExecutions.get(0)).getId());
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/runtime/MessageCorrelationTest.testCatchingMessageEventCorrelation.bpmn20.xml"})
    public void testCorrelationByProcessInstanceIdOnly() {
        this.runtimeService.startProcessInstanceByKey("process");
        ProcessInstance instance = this.runtimeService.startProcessInstanceByKey("process");
        this.runtimeService.createMessageCorrelation(null).processInstanceId(instance.getId()).correlate();
        List correlatedExecutions = this.runtimeService.createExecutionQuery().activityId("task").list();
        MessageCorrelationTest.assertEquals((int)1, (int)correlatedExecutions.size());
        MessageCorrelationTest.assertEquals((String)instance.getId(), (String)((Execution)correlatedExecutions.get(0)).getId());
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/runtime/MessageCorrelationTest.testCatchingMessageEventCorrelation.bpmn20.xml"})
    public void testCorrelationWithoutMessageNameFluent() {
        HashMap<String, String> variables = new HashMap<String, String>();
        variables.put("variable", "value1");
        this.runtimeService.startProcessInstanceByKey("process", variables);
        variables.put("variable", "value2");
        ProcessInstance instance = this.runtimeService.startProcessInstanceByKey("process", variables);
        this.runtimeService.createMessageCorrelation(null).processInstanceVariableEquals("variable", (Object)"value2").correlate();
        List correlatedExecutions = this.runtimeService.createExecutionQuery().activityId("task").list();
        MessageCorrelationTest.assertEquals((int)1, (int)correlatedExecutions.size());
        MessageCorrelationTest.assertEquals((String)instance.getId(), (String)((Execution)correlatedExecutions.get(0)).getId());
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/runtime/MessageCorrelationTest.testCatchingMessageEventCorrelation.bpmn20.xml", "org/camunda/bpm/engine/test/api/runtime/MessageCorrelationTest.testCorrelateAllWithoutMessage.bpmn20.xml"})
    public void testCorrelateAllWithoutMessage() {
        HashMap<String, String> variables = new HashMap<String, String>();
        variables.put("variable", "value1");
        this.runtimeService.startProcessInstanceByKey("process", variables);
        this.runtimeService.startProcessInstanceByKey("secondProcess", variables);
        variables.put("variable", "value2");
        ProcessInstance instance1 = this.runtimeService.startProcessInstanceByKey("process", variables);
        ProcessInstance instance2 = this.runtimeService.startProcessInstanceByKey("secondProcess", variables);
        this.runtimeService.createMessageCorrelation(null).processInstanceVariableEquals("variable", (Object)"value2").correlateAll();
        List correlatedExecutions = ((ExecutionQuery)this.runtimeService.createExecutionQuery().activityId("task").orderByProcessDefinitionKey().asc()).list();
        MessageCorrelationTest.assertEquals((int)2, (int)correlatedExecutions.size());
        MessageCorrelationTest.assertEquals((String)instance1.getId(), (String)((Execution)correlatedExecutions.get(0)).getId());
        MessageCorrelationTest.assertEquals((String)instance2.getId(), (String)((Execution)correlatedExecutions.get(1)).getId());
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/runtime/MessageCorrelationTest.testMessageStartEventCorrelation.bpmn20.xml"})
    public void testCorrelationWithoutMessageDoesNotMatchStartEvent() {
        try {
            this.runtimeService.createMessageCorrelation(null).processInstanceVariableEquals("variable", (Object)"value2").correlate();
            MessageCorrelationTest.fail((String)"exception expected");
        }
        catch (MismatchingMessageCorrelationException e) {
            // empty catch block
        }
        List correlatedExecutions = this.runtimeService.createExecutionQuery().activityId("task").list();
        MessageCorrelationTest.assertTrue((boolean)correlatedExecutions.isEmpty());
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/runtime/MessageCorrelationTest.testCatchingMessageEventCorrelation.bpmn20.xml"})
    public void testCorrelationWithoutCorrelationPropertiesFails() {
        this.runtimeService.startProcessInstanceByKey("process");
        try {
            this.runtimeService.createMessageCorrelation(null).correlate();
            MessageCorrelationTest.fail((String)"expected exception");
        }
        catch (NullValueException e) {
            // empty catch block
        }
        try {
            this.runtimeService.correlateMessage(null);
            MessageCorrelationTest.fail((String)"expected exception");
        }
        catch (NullValueException nullValueException) {
            // empty catch block
        }
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/runtime/twoBoundaryEventSubscriptions.bpmn20.xml"})
    public void testCorrelationToExecutionWithMultipleSubscriptionsFails() {
        ProcessInstance instance = this.runtimeService.startProcessInstanceByKey("process");
        try {
            this.runtimeService.createMessageCorrelation(null).processInstanceId(instance.getId()).correlate();
            MessageCorrelationTest.fail((String)"expected exception");
        }
        catch (ProcessEngineException processEngineException) {
            // empty catch block
        }
    }
}

