/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.test.api.variable;

import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import org.camunda.bpm.engine.test.api.variable.ExampleObject;
import org.camunda.bpm.engine.variable.VariableMap;
import org.camunda.bpm.engine.variable.Variables;
import org.camunda.bpm.engine.variable.type.ValueType;
import org.camunda.bpm.engine.variable.value.BooleanValue;
import org.camunda.bpm.engine.variable.value.BytesValue;
import org.camunda.bpm.engine.variable.value.DateValue;
import org.camunda.bpm.engine.variable.value.DoubleValue;
import org.camunda.bpm.engine.variable.value.IntegerValue;
import org.camunda.bpm.engine.variable.value.ObjectValue;
import org.camunda.bpm.engine.variable.value.ShortValue;
import org.camunda.bpm.engine.variable.value.StringValue;
import org.camunda.bpm.engine.variable.value.TypedValue;
import org.junit.Assert;
import org.junit.Test;

public class VariableApiOfflineTest {
    private static final String STRING_VAR_NAME = "stringVariable";
    private static final String STRING_VAR_VALUE = "someString";
    private static final String INTEGER_VAR_NAME = "integerVariable";
    private static final Integer INTEGER_VAR_VALUE = 1;
    private static final String BOOLEAN_VAR_NAME = "booleanVariable";
    private static final Boolean BOOLEAN_VAR_VALUE = true;
    private static final String NULL_VAR_NAME = "nullVariable";
    private static final String SHORT_VAR_NAME = "shortVariable";
    private static final Short SHORT_VAR_VALUE = 1;
    private static final String DOUBLE_VAR_NAME = "doubleVariable";
    private static final Double DOUBLE_VAR_VALUE = 1.0;
    private static final String DATE_VAR_NAME = "dateVariable";
    private static final Date DATE_VAR_VALUE = new Date(0L);
    private static final String BYTES_VAR_NAME = "bytesVariable";
    private static final byte[] BYTES_VAR_VALUE = "a".getBytes();
    private static final String DESERIALIZED_OBJECT_VAR_NAME = "deserializedObject";
    private static final ExampleObject DESERIALIZED_OBJECT_VAR_VALUE = new ExampleObject();
    private static final String SERIALIZATION_DATA_FORMAT_NAME = "data-format-name";

    @Test
    public void testCreatePrimitiveVariablesUntyped() {
        VariableMap variables = Variables.createVariables().putValue(STRING_VAR_NAME, (Object)STRING_VAR_VALUE).putValue(INTEGER_VAR_NAME, (Object)INTEGER_VAR_VALUE).putValue(BOOLEAN_VAR_NAME, (Object)BOOLEAN_VAR_VALUE).putValue(NULL_VAR_NAME, null).putValue(SHORT_VAR_NAME, (Object)SHORT_VAR_VALUE).putValue(DOUBLE_VAR_NAME, (Object)DOUBLE_VAR_VALUE).putValue(DATE_VAR_NAME, (Object)DATE_VAR_VALUE).putValue(BYTES_VAR_NAME, (Object)BYTES_VAR_VALUE);
        Assert.assertEquals((Object)STRING_VAR_VALUE, (Object)variables.get((Object)STRING_VAR_NAME));
        Assert.assertEquals((Object)INTEGER_VAR_VALUE, (Object)variables.get((Object)INTEGER_VAR_NAME));
        Assert.assertEquals((Object)BOOLEAN_VAR_VALUE, (Object)variables.get((Object)BOOLEAN_VAR_NAME));
        Assert.assertEquals(null, (Object)variables.get((Object)NULL_VAR_NAME));
        Assert.assertEquals((Object)SHORT_VAR_VALUE, (Object)variables.get((Object)SHORT_VAR_NAME));
        Assert.assertEquals((Object)DOUBLE_VAR_VALUE, (Object)variables.get((Object)DOUBLE_VAR_NAME));
        Assert.assertEquals((Object)DATE_VAR_VALUE, (Object)variables.get((Object)DATE_VAR_NAME));
        Assert.assertEquals((Object)BYTES_VAR_VALUE, (Object)variables.get((Object)BYTES_VAR_NAME));
        Assert.assertEquals((Object)STRING_VAR_VALUE, (Object)variables.getValueTyped(STRING_VAR_NAME).getValue());
        Assert.assertEquals((Object)INTEGER_VAR_VALUE, (Object)variables.getValueTyped(INTEGER_VAR_NAME).getValue());
        Assert.assertEquals((Object)BOOLEAN_VAR_VALUE, (Object)variables.getValueTyped(BOOLEAN_VAR_NAME).getValue());
        Assert.assertEquals(null, (Object)variables.getValueTyped(NULL_VAR_NAME).getValue());
        Assert.assertEquals((Object)SHORT_VAR_VALUE, (Object)variables.getValueTyped(SHORT_VAR_NAME).getValue());
        Assert.assertEquals((Object)DOUBLE_VAR_VALUE, (Object)variables.getValueTyped(DOUBLE_VAR_NAME).getValue());
        Assert.assertEquals((Object)DATE_VAR_VALUE, (Object)variables.getValueTyped(DATE_VAR_NAME).getValue());
        Assert.assertEquals((Object)BYTES_VAR_VALUE, (Object)variables.getValueTyped(BYTES_VAR_NAME).getValue());
        TypedValue untypedNullVariable = variables.getValueTyped(NULL_VAR_NAME);
        Assert.assertNotNull((Object)untypedNullVariable);
        Assert.assertEquals((Object)ValueType.NULL, (Object)untypedNullVariable.getType());
        variables.remove((Object)NULL_VAR_NAME);
        for (String varName : variables.keySet()) {
            TypedValue typedValue = variables.getValueTyped(varName);
            Assert.assertNull((Object)typedValue.getType());
            Assert.assertEquals((Object)variables.get((Object)varName), (Object)typedValue.getValue());
        }
    }

    @Test
    public void testCreatePrimitiveVariablesTyped() {
        VariableMap variables = Variables.createVariables().putValue(STRING_VAR_NAME, (Object)Variables.stringValue((String)STRING_VAR_VALUE)).putValue(INTEGER_VAR_NAME, (Object)Variables.integerValue((Integer)INTEGER_VAR_VALUE)).putValue(BOOLEAN_VAR_NAME, (Object)Variables.booleanValue((Boolean)BOOLEAN_VAR_VALUE)).putValue(NULL_VAR_NAME, (Object)Variables.untypedNullValue()).putValue(SHORT_VAR_NAME, (Object)Variables.shortValue((Short)SHORT_VAR_VALUE)).putValue(DOUBLE_VAR_NAME, (Object)Variables.doubleValue((Double)DOUBLE_VAR_VALUE)).putValue(DATE_VAR_NAME, (Object)Variables.dateValue((Date)DATE_VAR_VALUE)).putValue(BYTES_VAR_NAME, (Object)Variables.byteArrayValue((byte[])BYTES_VAR_VALUE));
        Assert.assertEquals((Object)STRING_VAR_VALUE, (Object)variables.get((Object)STRING_VAR_NAME));
        Assert.assertEquals((Object)INTEGER_VAR_VALUE, (Object)variables.get((Object)INTEGER_VAR_NAME));
        Assert.assertEquals((Object)BOOLEAN_VAR_VALUE, (Object)variables.get((Object)BOOLEAN_VAR_NAME));
        Assert.assertEquals(null, (Object)variables.get((Object)NULL_VAR_NAME));
        Assert.assertEquals((Object)SHORT_VAR_VALUE, (Object)variables.get((Object)SHORT_VAR_NAME));
        Assert.assertEquals((Object)DOUBLE_VAR_VALUE, (Object)variables.get((Object)DOUBLE_VAR_NAME));
        Assert.assertEquals((Object)DATE_VAR_VALUE, (Object)variables.get((Object)DATE_VAR_NAME));
        Assert.assertEquals((Object)BYTES_VAR_VALUE, (Object)variables.get((Object)BYTES_VAR_NAME));
        Assert.assertEquals((Object)ValueType.STRING, (Object)variables.getValueTyped(STRING_VAR_NAME).getType());
        Assert.assertEquals((Object)ValueType.INTEGER, (Object)variables.getValueTyped(INTEGER_VAR_NAME).getType());
        Assert.assertEquals((Object)ValueType.BOOLEAN, (Object)variables.getValueTyped(BOOLEAN_VAR_NAME).getType());
        Assert.assertEquals((Object)ValueType.NULL, (Object)variables.getValueTyped(NULL_VAR_NAME).getType());
        Assert.assertEquals((Object)ValueType.SHORT, (Object)variables.getValueTyped(SHORT_VAR_NAME).getType());
        Assert.assertEquals((Object)ValueType.DOUBLE, (Object)variables.getValueTyped(DOUBLE_VAR_NAME).getType());
        Assert.assertEquals((Object)ValueType.DATE, (Object)variables.getValueTyped(DATE_VAR_NAME).getType());
        Assert.assertEquals((Object)ValueType.BYTES, (Object)variables.getValueTyped(BYTES_VAR_NAME).getType());
        String stringValue = (String)((StringValue)variables.getValueTyped(STRING_VAR_NAME)).getValue();
        Assert.assertEquals((Object)STRING_VAR_VALUE, (Object)stringValue);
        Integer integerValue = (Integer)((IntegerValue)variables.getValueTyped(INTEGER_VAR_NAME)).getValue();
        Assert.assertEquals((Object)INTEGER_VAR_VALUE, (Object)integerValue);
        Boolean booleanValue = (Boolean)((BooleanValue)variables.getValueTyped(BOOLEAN_VAR_NAME)).getValue();
        Assert.assertEquals((Object)BOOLEAN_VAR_VALUE, (Object)booleanValue);
        Short shortValue = (Short)((ShortValue)variables.getValueTyped(SHORT_VAR_NAME)).getValue();
        Assert.assertEquals((Object)SHORT_VAR_VALUE, (Object)shortValue);
        Double doubleValue = (Double)((DoubleValue)variables.getValueTyped(DOUBLE_VAR_NAME)).getValue();
        Assert.assertEquals((Object)DOUBLE_VAR_VALUE, (Object)doubleValue);
        Date dateValue = (Date)((DateValue)variables.getValueTyped(DATE_VAR_NAME)).getValue();
        Assert.assertEquals((Object)DATE_VAR_VALUE, (Object)dateValue);
        byte[] bytesValue = (byte[])((BytesValue)variables.getValueTyped(BYTES_VAR_NAME)).getValue();
        Assert.assertEquals((Object)BYTES_VAR_VALUE, (Object)bytesValue);
    }

    @Test
    public void testCreatePrimitiveVariablesNull() {
        VariableMap variables = Variables.createVariables().putValue(STRING_VAR_NAME, (Object)Variables.stringValue(null)).putValue(INTEGER_VAR_NAME, (Object)Variables.integerValue(null)).putValue(BOOLEAN_VAR_NAME, (Object)Variables.booleanValue(null)).putValue(NULL_VAR_NAME, (Object)Variables.untypedNullValue()).putValue(SHORT_VAR_NAME, (Object)Variables.shortValue(null)).putValue(DOUBLE_VAR_NAME, (Object)Variables.doubleValue(null)).putValue(DATE_VAR_NAME, (Object)Variables.dateValue(null)).putValue(BYTES_VAR_NAME, (Object)Variables.byteArrayValue(null));
        Assert.assertEquals(null, (Object)variables.get((Object)STRING_VAR_NAME));
        Assert.assertEquals(null, (Object)variables.get((Object)INTEGER_VAR_NAME));
        Assert.assertEquals(null, (Object)variables.get((Object)BOOLEAN_VAR_NAME));
        Assert.assertEquals(null, (Object)variables.get((Object)NULL_VAR_NAME));
        Assert.assertEquals(null, (Object)variables.get((Object)SHORT_VAR_NAME));
        Assert.assertEquals(null, (Object)variables.get((Object)DOUBLE_VAR_NAME));
        Assert.assertEquals(null, (Object)variables.get((Object)DATE_VAR_NAME));
        Assert.assertEquals(null, (Object)variables.get((Object)BYTES_VAR_NAME));
        Assert.assertEquals((Object)ValueType.STRING, (Object)variables.getValueTyped(STRING_VAR_NAME).getType());
        Assert.assertEquals((Object)ValueType.INTEGER, (Object)variables.getValueTyped(INTEGER_VAR_NAME).getType());
        Assert.assertEquals((Object)ValueType.BOOLEAN, (Object)variables.getValueTyped(BOOLEAN_VAR_NAME).getType());
        Assert.assertEquals((Object)ValueType.NULL, (Object)variables.getValueTyped(NULL_VAR_NAME).getType());
        Assert.assertEquals((Object)ValueType.SHORT, (Object)variables.getValueTyped(SHORT_VAR_NAME).getType());
        Assert.assertEquals((Object)ValueType.DOUBLE, (Object)variables.getValueTyped(DOUBLE_VAR_NAME).getType());
        Assert.assertEquals((Object)ValueType.DATE, (Object)variables.getValueTyped(DATE_VAR_NAME).getType());
        Assert.assertEquals((Object)ValueType.BYTES, (Object)variables.getValueTyped(BYTES_VAR_NAME).getType());
        String stringValue = (String)((StringValue)variables.getValueTyped(STRING_VAR_NAME)).getValue();
        Assert.assertEquals(null, (Object)stringValue);
        Integer integerValue = (Integer)((IntegerValue)variables.getValueTyped(INTEGER_VAR_NAME)).getValue();
        Assert.assertEquals(null, (Object)integerValue);
        Boolean booleanValue = (Boolean)((BooleanValue)variables.getValueTyped(BOOLEAN_VAR_NAME)).getValue();
        Assert.assertEquals(null, (Object)booleanValue);
        Short shortValue = (Short)((ShortValue)variables.getValueTyped(SHORT_VAR_NAME)).getValue();
        Assert.assertEquals(null, (Object)shortValue);
        Double doubleValue = (Double)((DoubleValue)variables.getValueTyped(DOUBLE_VAR_NAME)).getValue();
        Assert.assertEquals(null, (Object)doubleValue);
        Date dateValue = (Date)((DateValue)variables.getValueTyped(DATE_VAR_NAME)).getValue();
        Assert.assertEquals(null, (Object)dateValue);
        byte[] bytesValue = (byte[])((BytesValue)variables.getValueTyped(BYTES_VAR_NAME)).getValue();
        Assert.assertEquals(null, (Object)bytesValue);
    }

    @Test
    public void testCreateObjectVariables() {
        VariableMap variables = Variables.createVariables().putValue(DESERIALIZED_OBJECT_VAR_NAME, (Object)Variables.objectValue((Object)DESERIALIZED_OBJECT_VAR_VALUE));
        Assert.assertEquals((Object)DESERIALIZED_OBJECT_VAR_VALUE, (Object)variables.get((Object)DESERIALIZED_OBJECT_VAR_NAME));
        Assert.assertEquals((Object)DESERIALIZED_OBJECT_VAR_VALUE, (Object)variables.getValue(DESERIALIZED_OBJECT_VAR_NAME, ExampleObject.class));
        Object untypedValue = variables.getValueTyped(DESERIALIZED_OBJECT_VAR_NAME).getValue();
        Assert.assertEquals((Object)DESERIALIZED_OBJECT_VAR_VALUE, (Object)untypedValue);
        ExampleObject typedValue = (ExampleObject)((ObjectValue)variables.getValueTyped(DESERIALIZED_OBJECT_VAR_NAME)).getValue(ExampleObject.class);
        Assert.assertEquals((Object)DESERIALIZED_OBJECT_VAR_VALUE, (Object)typedValue);
        Assert.assertNull((Object)((ObjectValue)variables.getValueTyped(DESERIALIZED_OBJECT_VAR_NAME)).getObjectTypeName());
        Assert.assertEquals(DESERIALIZED_OBJECT_VAR_VALUE.getClass(), (Object)((ObjectValue)variables.getValueTyped(DESERIALIZED_OBJECT_VAR_NAME)).getObjectType());
        variables = Variables.createVariables().putValue(DESERIALIZED_OBJECT_VAR_NAME, (Object)Variables.objectValue((Object)DESERIALIZED_OBJECT_VAR_VALUE).serializationDataFormat(SERIALIZATION_DATA_FORMAT_NAME));
        Assert.assertEquals((Object)DESERIALIZED_OBJECT_VAR_VALUE, (Object)variables.get((Object)DESERIALIZED_OBJECT_VAR_NAME));
    }

    @Test
    public void testVariableMapCompatibility() {
        VariableMap map1;
        VariableMap assignable = map1 = Variables.createVariables().putValue("foo", (Object)10).putValue("bar", (Object)20);
        VariableMap map2 = Variables.createVariables().putValueTyped("foo", (TypedValue)Variables.integerValue((Integer)10)).putValueTyped("bar", (TypedValue)Variables.integerValue((Integer)20));
        HashMap<String, Integer> map3 = new HashMap<String, Integer>();
        map3.put("foo", 10);
        map3.put("bar", 20);
        Assert.assertEquals((Object)map1, (Object)map2);
        Assert.assertEquals((Object)map2, map3);
        Assert.assertEquals((Object)map1, (Object)Variables.fromMap((Map)map1));
        Assert.assertEquals((Object)map1, (Object)Variables.fromMap(map3));
        Assert.assertEquals((long)map1.hashCode(), (long)map2.hashCode());
        Assert.assertEquals((long)map2.hashCode(), (long)((Object)map3).hashCode());
        Collection values1 = map1.values();
        Collection values2 = map2.values();
        Collection values3 = map3.values();
        Assert.assertTrue((boolean)values1.containsAll(values2));
        Assert.assertTrue((boolean)values2.containsAll(values1));
        Assert.assertTrue((boolean)values2.containsAll(values3));
        Assert.assertTrue((boolean)values3.containsAll(values2));
        Assert.assertEquals((Object)map1.entrySet(), (Object)map2.entrySet());
        Assert.assertEquals((Object)map2.entrySet(), map3.entrySet());
    }
}

