/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.test.bpmn.event.compensate;

import java.util.HashMap;
import java.util.List;
import org.camunda.bpm.engine.ProcessEngineException;
import org.camunda.bpm.engine.history.HistoricVariableInstance;
import org.camunda.bpm.engine.history.HistoricVariableInstanceQuery;
import org.camunda.bpm.engine.impl.cfg.ProcessEngineConfigurationImpl;
import org.camunda.bpm.engine.impl.test.PluggableProcessEngineTestCase;
import org.camunda.bpm.engine.runtime.ActivityInstance;
import org.camunda.bpm.engine.runtime.ProcessInstance;
import org.camunda.bpm.engine.task.Task;
import org.camunda.bpm.engine.test.Deployment;
import org.camunda.bpm.engine.test.bpmn.event.compensate.helper.SetVariablesDelegate;

public class CompensateEventTest
extends PluggableProcessEngineTestCase {
    @Deployment
    public void testCompensateSubprocess() {
        ProcessInstance processInstance = this.runtimeService.startProcessInstanceByKey("compensateProcess");
        CompensateEventTest.assertEquals((Object)5, (Object)this.runtimeService.getVariable(processInstance.getId(), "undoBookHotel"));
        this.runtimeService.signal(processInstance.getId());
        this.assertProcessEnded(processInstance.getId());
    }

    @Deployment
    public void testCompensateParallelSubprocess() {
        ProcessInstance processInstance = this.runtimeService.startProcessInstanceByKey("compensateProcess");
        CompensateEventTest.assertEquals((Object)5, (Object)this.runtimeService.getVariable(processInstance.getId(), "undoBookHotel"));
        Task singleResult = (Task)this.taskService.createTaskQuery().singleResult();
        this.taskService.complete(singleResult.getId());
        this.runtimeService.signal(processInstance.getId());
        this.assertProcessEnded(processInstance.getId());
    }

    @Deployment
    public void testCompensateParallelSubprocessCompHandlerWaitstate() {
        ProcessInstance processInstance = this.runtimeService.startProcessInstanceByKey("compensateProcess");
        List compensationHandlerTasks = this.taskService.createTaskQuery().taskDefinitionKey("undoBookHotel").list();
        CompensateEventTest.assertEquals((int)5, (int)compensationHandlerTasks.size());
        ActivityInstance rootActivityInstance = this.runtimeService.getActivityInstance(processInstance.getId());
        List compensationHandlerInstances = this.getInstancesForActivitiyId(rootActivityInstance, "undoBookHotel");
        CompensateEventTest.assertEquals((int)5, (int)compensationHandlerInstances.size());
        for (Task task : compensationHandlerTasks) {
            this.taskService.complete(task.getId());
        }
        Task singleResult = (Task)this.taskService.createTaskQuery().singleResult();
        this.taskService.complete(singleResult.getId());
        this.runtimeService.signal(processInstance.getId());
        this.assertProcessEnded(processInstance.getId());
    }

    @Deployment
    public void testCompensateMiSubprocess() {
        ProcessInstance processInstance = this.runtimeService.startProcessInstanceByKey("compensateProcess");
        CompensateEventTest.assertEquals((Object)5, (Object)this.runtimeService.getVariable(processInstance.getId(), "undoBookHotel"));
        this.runtimeService.signal(processInstance.getId());
        this.assertProcessEnded(processInstance.getId());
    }

    @Deployment
    public void testCompensateScope() {
        ProcessInstance processInstance = this.runtimeService.startProcessInstanceByKey("compensateProcess");
        CompensateEventTest.assertEquals((Object)5, (Object)this.runtimeService.getVariable(processInstance.getId(), "undoBookHotel"));
        CompensateEventTest.assertEquals((Object)5, (Object)this.runtimeService.getVariable(processInstance.getId(), "undoBookFlight"));
        this.runtimeService.signal(processInstance.getId());
        this.assertProcessEnded(processInstance.getId());
    }

    @Deployment
    public void testCompensateActivityRef() {
        ProcessInstance processInstance = this.runtimeService.startProcessInstanceByKey("compensateProcess");
        CompensateEventTest.assertEquals((Object)5, (Object)this.runtimeService.getVariable(processInstance.getId(), "undoBookHotel"));
        CompensateEventTest.assertNull((Object)this.runtimeService.getVariable(processInstance.getId(), "undoBookFlight"));
        this.runtimeService.signal(processInstance.getId());
        this.assertProcessEnded(processInstance.getId());
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/bpmn/event/compensate/CompensateEventTest.testCallActivityCompensationHandler.bpmn20.xml", "org/camunda/bpm/engine/test/bpmn/event/compensate/CompensationHandler.bpmn20.xml"})
    public void testCallActivityCompensationHandler() {
        ProcessInstance processInstance = this.runtimeService.startProcessInstanceByKey("compensateProcess");
        if (!this.processEngineConfiguration.getHistory().equals("none")) {
            CompensateEventTest.assertEquals((long)5L, (long)this.historyService.createHistoricActivityInstanceQuery().activityId("undoBookHotel").count());
        }
        this.runtimeService.signal(processInstance.getId());
        this.assertProcessEnded(processInstance.getId());
        CompensateEventTest.assertEquals((long)0L, (long)this.runtimeService.createProcessInstanceQuery().count());
        if (!this.processEngineConfiguration.getHistory().equals("none")) {
            CompensateEventTest.assertEquals((long)6L, (long)this.historyService.createHistoricProcessInstanceQuery().count());
        }
    }

    @Deployment
    public void testCompensateMiSubprocessVariableSnapshots() {
        SetVariablesDelegate.variablesMap.clear();
        ProcessInstance processInstance = this.runtimeService.startProcessInstanceByKey("compensateProcess");
        if (!this.processEngineConfiguration.getHistory().equals("none")) {
            CompensateEventTest.assertEquals((long)5L, (long)this.historyService.createHistoricActivityInstanceQuery().activityId("undoBookHotel").count());
        }
        this.assertProcessEnded(processInstance.getId());
    }

    public void testMultipleCompensationCatchEventsFails() {
        block2: {
            try {
                this.repositoryService.createDeployment().addClasspathResource("org/camunda/bpm/engine/test/bpmn/event/compensate/CompensateEventTest.testMultipleCompensationCatchEventsFails.bpmn20.xml").deploy();
                CompensateEventTest.fail((String)"exception expected");
            }
            catch (Exception e) {
                if (e.getMessage().contains("multiple boundary events with compensateEventDefinition not supported on same activity")) break block2;
                CompensateEventTest.fail((String)"different exception expected");
            }
        }
    }

    public void testMultipleCompensationCatchEventsCompensationAttributeMissingFails() {
        block2: {
            try {
                this.repositoryService.createDeployment().addClasspathResource("org/camunda/bpm/engine/test/bpmn/event/compensate/CompensateEventTest.testMultipleCompensationCatchEventsCompensationAttributeMissingFails.bpmn20.xml").deploy();
                CompensateEventTest.fail((String)"exception expected");
            }
            catch (Exception e) {
                if (e.getMessage().contains("compensation boundary catch must be connected to element with isForCompensation=true")) break block2;
                CompensateEventTest.fail((String)"different exception expected");
            }
        }
    }

    public void testInvalidActivityRefFails() {
        block2: {
            try {
                this.repositoryService.createDeployment().addClasspathResource("org/camunda/bpm/engine/test/bpmn/event/compensate/CompensateEventTest.testInvalidActivityRefFails.bpmn20.xml").deploy();
                CompensateEventTest.fail((String)"exception expected");
            }
            catch (Exception e) {
                if (e.getMessage().contains("Invalid attribute value for 'activityRef':")) break block2;
                CompensateEventTest.fail((String)"different exception expected");
            }
        }
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/bpmn/event/compensate/CompensateEventTest.testCompensationTriggeredByEventSubProcessActivityRef.bpmn20.xml"})
    public void testCompensateActivityRefTriggeredByEventSubprocess() {
        ProcessInstance processInstance = this.runtimeService.startProcessInstanceByKey("compensateProcess");
        this.assertProcessEnded(processInstance.getId());
        HistoricVariableInstanceQuery historicVariableInstanceQuery = this.historyService.createHistoricVariableInstanceQuery().processInstanceId(processInstance.getId()).variableName("undoBookHotel");
        if (this.processEngineConfiguration.getHistoryLevel().getId() >= ProcessEngineConfigurationImpl.HISTORYLEVEL_AUDIT) {
            CompensateEventTest.assertEquals((long)1L, (long)historicVariableInstanceQuery.count());
            CompensateEventTest.assertEquals((String)"undoBookHotel", (String)((HistoricVariableInstance)historicVariableInstanceQuery.list().get(0)).getVariableName());
            CompensateEventTest.assertEquals((Object)5, (Object)((HistoricVariableInstance)historicVariableInstanceQuery.list().get(0)).getValue());
            CompensateEventTest.assertEquals((long)0L, (long)this.historyService.createHistoricVariableInstanceQuery().processInstanceId(processInstance.getId()).variableName("undoBookFlight").count());
        }
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/bpmn/event/compensate/CompensateEventTest.testCompensationTriggeredByEventSubProcessInSubProcessActivityRef.bpmn20.xml"})
    public void testCompensateActivityRefTriggeredByEventSubprocessInSubProcess() {
        ProcessInstance processInstance = this.runtimeService.startProcessInstanceByKey("compensateProcess");
        this.assertProcessEnded(processInstance.getId());
        HistoricVariableInstanceQuery historicVariableInstanceQuery = this.historyService.createHistoricVariableInstanceQuery().processInstanceId(processInstance.getId()).variableName("undoBookHotel");
        if (this.processEngineConfiguration.getHistoryLevel().getId() >= ProcessEngineConfigurationImpl.HISTORYLEVEL_AUDIT) {
            CompensateEventTest.assertEquals((long)1L, (long)historicVariableInstanceQuery.count());
            CompensateEventTest.assertEquals((String)"undoBookHotel", (String)((HistoricVariableInstance)historicVariableInstanceQuery.list().get(0)).getVariableName());
            CompensateEventTest.assertEquals((Object)5, (Object)((HistoricVariableInstance)historicVariableInstanceQuery.list().get(0)).getValue());
            CompensateEventTest.assertEquals((long)0L, (long)this.historyService.createHistoricVariableInstanceQuery().processInstanceId(processInstance.getId()).variableName("undoBookFlight").count());
        }
    }

    public void testIllegalCompensateActivityRefParentScope() {
        block2: {
            try {
                String id = this.repositoryService.createDeployment().addClasspathResource("org/camunda/bpm/engine/test/bpmn/event/compensate/CompensateEventTest.testIllegalCompensateActivityRefParentScope.bpmn20.xml").deploy().getId();
                this.repositoryService.deleteDeployment(id, true);
                CompensateEventTest.fail((String)"Exception expected!");
            }
            catch (ProcessEngineException e) {
                if (e.getMessage().contains("Invalid attribute value for 'activityRef': no activity with id 'someServiceInMainProcess' in scope 'subProcess'")) break block2;
                CompensateEventTest.fail((String)"different exception expected");
            }
        }
    }

    public void testIllegalCompensateActivityRefNestedScope() {
        block2: {
            try {
                String id = this.repositoryService.createDeployment().addClasspathResource("org/camunda/bpm/engine/test/bpmn/event/compensate/CompensateEventTest.testIllegalCompensateActivityRefNestedScope.bpmn20.xml").deploy().getId();
                this.repositoryService.deleteDeployment(id, true);
                CompensateEventTest.fail((String)"Exception expected!");
            }
            catch (ProcessEngineException e) {
                if (e.getMessage().contains("Invalid attribute value for 'activityRef': no activity with id 'someServiceInNestedScope' in scope 'subProcess'")) break block2;
                CompensateEventTest.fail((String)"different exception expected");
            }
        }
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/bpmn/event/compensate/CompensateEventTest.testCompensationInEventSubProcessActivityRef.bpmn20.xml"})
    public void testCompensateActivityRefInEventSubprocess() {
        ProcessInstance processInstance = this.runtimeService.startProcessInstanceByKey("compensateProcess");
        this.assertProcessEnded(processInstance.getId());
        HistoricVariableInstanceQuery historicVariableInstanceQuery = this.historyService.createHistoricVariableInstanceQuery().variableName("undoBookSecondHotel");
        if (this.processEngineConfiguration.getHistoryLevel().getId() >= ProcessEngineConfigurationImpl.HISTORYLEVEL_AUDIT) {
            CompensateEventTest.assertEquals((long)1L, (long)historicVariableInstanceQuery.count());
            CompensateEventTest.assertEquals((String)"undoBookSecondHotel", (String)((HistoricVariableInstance)historicVariableInstanceQuery.list().get(0)).getVariableName());
            CompensateEventTest.assertEquals((Object)5, (Object)((HistoricVariableInstance)historicVariableInstanceQuery.list().get(0)).getValue());
            CompensateEventTest.assertEquals((long)0L, (long)this.historyService.createHistoricVariableInstanceQuery().processInstanceId(processInstance.getId()).variableName("undoBookFlight").count());
            CompensateEventTest.assertEquals((long)0L, (long)this.historyService.createHistoricVariableInstanceQuery().processInstanceId(processInstance.getId()).variableName("undoBookHotel").count());
        }
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/bpmn/event/compensate/CompensateEventTest.testCompensationInEventSubProcess.bpmn20.xml"})
    public void testCompensateInEventSubprocess() {
        ProcessInstance processInstance = this.runtimeService.startProcessInstanceByKey("compensateProcess");
        this.assertProcessEnded(processInstance.getId());
        HistoricVariableInstanceQuery historicVariableInstanceQuery = this.historyService.createHistoricVariableInstanceQuery().variableName("undoBookSecondHotel");
        if (this.processEngineConfiguration.getHistoryLevel().getId() >= ProcessEngineConfigurationImpl.HISTORYLEVEL_AUDIT) {
            CompensateEventTest.assertEquals((long)1L, (long)historicVariableInstanceQuery.count());
            CompensateEventTest.assertEquals((String)"undoBookSecondHotel", (String)((HistoricVariableInstance)historicVariableInstanceQuery.list().get(0)).getVariableName());
            CompensateEventTest.assertEquals((Object)5, (Object)((HistoricVariableInstance)historicVariableInstanceQuery.list().get(0)).getValue());
            historicVariableInstanceQuery = this.historyService.createHistoricVariableInstanceQuery().variableName("undoBookFlight");
            CompensateEventTest.assertEquals((long)1L, (long)historicVariableInstanceQuery.count());
            CompensateEventTest.assertEquals((Object)5, (Object)((HistoricVariableInstance)historicVariableInstanceQuery.list().get(0)).getValue());
            historicVariableInstanceQuery = this.historyService.createHistoricVariableInstanceQuery().variableName("undoBookHotel");
            CompensateEventTest.assertEquals((long)1L, (long)historicVariableInstanceQuery.count());
            CompensateEventTest.assertEquals((Object)5, (Object)((HistoricVariableInstance)historicVariableInstanceQuery.list().get(0)).getValue());
        }
    }

    @Deployment
    public void testExecutionListeners() {
        HashMap<String, Integer> variables = new HashMap<String, Integer>();
        variables.put("start", 0);
        variables.put("end", 0);
        ProcessInstance processInstance = this.runtimeService.startProcessInstanceByKey("testProcess", variables);
        int started = (Integer)this.runtimeService.getVariable(processInstance.getId(), "start");
        CompensateEventTest.assertEquals((int)5, (int)started);
        int ended = (Integer)this.runtimeService.getVariable(processInstance.getId(), "end");
        CompensateEventTest.assertEquals((int)5, (int)ended);
        int historyLevel = this.processEngineConfiguration.getHistoryLevel().getId();
        if (historyLevel > ProcessEngineConfigurationImpl.HISTORYLEVEL_NONE) {
            long finishedCount = this.historyService.createHistoricActivityInstanceQuery().activityId("undoBookHotel").finished().count();
            CompensateEventTest.assertEquals((long)5L, (long)finishedCount);
        }
    }
}

