/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.test.bpmn.event.message;

import java.util.List;
import org.camunda.bpm.engine.ProcessEngineException;
import org.camunda.bpm.engine.history.HistoricActivityInstance;
import org.camunda.bpm.engine.impl.cfg.ProcessEngineConfigurationImpl;
import org.camunda.bpm.engine.impl.test.PluggableProcessEngineTestCase;
import org.camunda.bpm.engine.runtime.Execution;
import org.camunda.bpm.engine.runtime.ProcessInstance;
import org.camunda.bpm.engine.task.Task;
import org.camunda.bpm.engine.test.Deployment;

public class MessageBoundaryEventTest
extends PluggableProcessEngineTestCase {
    @Deployment
    public void testSingleBoundaryMessageEvent() {
        this.runtimeService.startProcessInstanceByKey("process");
        MessageBoundaryEventTest.assertEquals((long)2L, (long)this.runtimeService.createExecutionQuery().count());
        Task userTask = (Task)this.taskService.createTaskQuery().singleResult();
        MessageBoundaryEventTest.assertNotNull((Object)userTask);
        Execution execution = (Execution)this.runtimeService.createExecutionQuery().messageEventSubscriptionName("messageName").singleResult();
        MessageBoundaryEventTest.assertNotNull((Object)execution);
        this.runtimeService.messageEventReceived("messageName", execution.getId());
        userTask = (Task)this.taskService.createTaskQuery().singleResult();
        MessageBoundaryEventTest.assertNotNull((Object)userTask);
        MessageBoundaryEventTest.assertEquals((String)"taskAfterMessage", (String)userTask.getTaskDefinitionKey());
        this.taskService.complete(userTask.getId());
        MessageBoundaryEventTest.assertEquals((long)0L, (long)this.runtimeService.createProcessInstanceQuery().count());
        this.runtimeService.startProcessInstanceByKey("process");
        userTask = (Task)this.taskService.createTaskQuery().singleResult();
        MessageBoundaryEventTest.assertNotNull((Object)userTask);
        this.taskService.complete(userTask.getId());
        execution = (Execution)this.runtimeService.createExecutionQuery().messageEventSubscriptionName("messageName").singleResult();
        MessageBoundaryEventTest.assertNull((Object)execution);
        userTask = (Task)this.taskService.createTaskQuery().singleResult();
        MessageBoundaryEventTest.assertNotNull((Object)userTask);
        MessageBoundaryEventTest.assertEquals((String)"taskAfterTask", (String)userTask.getTaskDefinitionKey());
        this.taskService.complete(userTask.getId());
        MessageBoundaryEventTest.assertEquals((long)0L, (long)this.runtimeService.createProcessInstanceQuery().count());
    }

    public void testDoubleBoundaryMessageEventSameMessageId() {
        try {
            this.repositoryService.createDeployment().addClasspathResource("org/camunda/bpm/engine/test/bpmn/event/message/MessageBoundaryEventTest.testDoubleBoundaryMessageEventSameMessageId.bpmn20.xml").deploy();
            MessageBoundaryEventTest.fail((String)"Deployment should fail because Activiti cannot handle two boundary message events with same messageId.");
        }
        catch (Exception e) {
            this.assertTextPresent("Cannot have more than one message event subscription with name 'messageName' for scope 'task'", e.getMessage());
            MessageBoundaryEventTest.assertEquals((long)0L, (long)this.repositoryService.createDeploymentQuery().count());
        }
    }

    @Deployment
    public void testDoubleBoundaryMessageEvent() {
        this.runtimeService.startProcessInstanceByKey("process");
        MessageBoundaryEventTest.assertEquals((long)2L, (long)this.runtimeService.createExecutionQuery().count());
        Task userTask = (Task)this.taskService.createTaskQuery().singleResult();
        MessageBoundaryEventTest.assertNotNull((Object)userTask);
        Execution execution1 = (Execution)this.runtimeService.createExecutionQuery().messageEventSubscriptionName("messageName_1").singleResult();
        MessageBoundaryEventTest.assertNotNull((Object)execution1);
        Execution execution2 = (Execution)this.runtimeService.createExecutionQuery().messageEventSubscriptionName("messageName_2").singleResult();
        MessageBoundaryEventTest.assertNotNull((Object)execution2);
        MessageBoundaryEventTest.assertEquals((String)execution1.getId(), (String)execution2.getId());
        this.runtimeService.messageEventReceived("messageName_1", execution1.getId());
        try {
            this.runtimeService.messageEventReceived("messageName_2", execution2.getId());
            MessageBoundaryEventTest.fail();
        }
        catch (ProcessEngineException e) {
            this.assertTextPresent("does not have a subscription to a message event with name 'messageName_2'", e.getMessage());
        }
        userTask = (Task)this.taskService.createTaskQuery().singleResult();
        MessageBoundaryEventTest.assertNotNull((Object)userTask);
        MessageBoundaryEventTest.assertEquals((String)"taskAfterMessage_1", (String)userTask.getTaskDefinitionKey());
        this.taskService.complete(userTask.getId());
        MessageBoundaryEventTest.assertEquals((long)0L, (long)this.runtimeService.createProcessInstanceQuery().count());
        this.runtimeService.startProcessInstanceByKey("process");
        userTask = (Task)this.taskService.createTaskQuery().singleResult();
        MessageBoundaryEventTest.assertNotNull((Object)userTask);
        this.taskService.complete(userTask.getId());
        execution1 = (Execution)this.runtimeService.createExecutionQuery().messageEventSubscriptionName("messageName_1").singleResult();
        MessageBoundaryEventTest.assertNull((Object)execution1);
        execution2 = (Execution)this.runtimeService.createExecutionQuery().messageEventSubscriptionName("messageName_2").singleResult();
        MessageBoundaryEventTest.assertNull((Object)execution2);
        userTask = (Task)this.taskService.createTaskQuery().singleResult();
        MessageBoundaryEventTest.assertNotNull((Object)userTask);
        MessageBoundaryEventTest.assertEquals((String)"taskAfterTask", (String)userTask.getTaskDefinitionKey());
        this.taskService.complete(userTask.getId());
        MessageBoundaryEventTest.assertEquals((long)0L, (long)this.runtimeService.createProcessInstanceQuery().count());
    }

    @Deployment
    public void testDoubleBoundaryMessageEventMultiInstance() {
        ProcessInstance processInstance = this.runtimeService.startProcessInstanceByKey("process");
        MessageBoundaryEventTest.assertEquals((long)7L, (long)this.runtimeService.createExecutionQuery().count());
        MessageBoundaryEventTest.assertEquals((long)5L, (long)this.taskService.createTaskQuery().count());
        Execution execution1 = (Execution)this.runtimeService.createExecutionQuery().messageEventSubscriptionName("messageName_1").singleResult();
        Execution execution2 = (Execution)this.runtimeService.createExecutionQuery().messageEventSubscriptionName("messageName_2").singleResult();
        MessageBoundaryEventTest.assertEquals((String)execution1.getId(), (String)execution2.getId());
        this.runtimeService.messageEventReceived("messageName_1", execution1.getId());
        try {
            this.runtimeService.messageEventReceived("messageName_2", execution2.getId());
            MessageBoundaryEventTest.fail();
        }
        catch (ProcessEngineException e) {
            this.assertTextPresent("does not have a subscription to a message event with name 'messageName_2'", e.getMessage());
        }
        MessageBoundaryEventTest.assertEquals((long)1L, (long)this.runtimeService.createExecutionQuery().count());
        Task userTask = (Task)this.taskService.createTaskQuery().singleResult();
        MessageBoundaryEventTest.assertNotNull((Object)userTask);
        MessageBoundaryEventTest.assertEquals((String)"taskAfterMessage_1", (String)userTask.getTaskDefinitionKey());
        this.taskService.complete(userTask.getId());
        this.assertProcessEnded(processInstance.getId());
        processInstance = this.runtimeService.startProcessInstanceByKey("process");
        MessageBoundaryEventTest.assertEquals((long)7L, (long)this.runtimeService.createExecutionQuery().count());
        MessageBoundaryEventTest.assertEquals((long)5L, (long)this.taskService.createTaskQuery().count());
        execution1 = (Execution)this.runtimeService.createExecutionQuery().messageEventSubscriptionName("messageName_1").singleResult();
        execution2 = (Execution)this.runtimeService.createExecutionQuery().messageEventSubscriptionName("messageName_2").singleResult();
        MessageBoundaryEventTest.assertEquals((String)execution1.getId(), (String)execution2.getId());
        List userTasks = this.taskService.createTaskQuery().list();
        MessageBoundaryEventTest.assertNotNull((Object)userTasks);
        MessageBoundaryEventTest.assertEquals((int)5, (int)userTasks.size());
        for (int i = 0; i < userTasks.size() - 1; ++i) {
            Task task = (Task)userTasks.get(i);
            this.taskService.complete(task.getId());
            execution1 = (Execution)this.runtimeService.createExecutionQuery().messageEventSubscriptionName("messageName_1").singleResult();
            MessageBoundaryEventTest.assertNotNull((Object)execution1);
            execution2 = (Execution)this.runtimeService.createExecutionQuery().messageEventSubscriptionName("messageName_2").singleResult();
            MessageBoundaryEventTest.assertNotNull((Object)execution2);
        }
        userTask = (Task)this.taskService.createTaskQuery().singleResult();
        MessageBoundaryEventTest.assertNotNull((Object)userTask);
        this.taskService.complete(userTask.getId());
        execution1 = (Execution)this.runtimeService.createExecutionQuery().messageEventSubscriptionName("messageName_1").singleResult();
        MessageBoundaryEventTest.assertNull((Object)execution1);
        execution2 = (Execution)this.runtimeService.createExecutionQuery().messageEventSubscriptionName("messageName_2").singleResult();
        MessageBoundaryEventTest.assertNull((Object)execution2);
        userTask = (Task)this.taskService.createTaskQuery().singleResult();
        MessageBoundaryEventTest.assertNotNull((Object)userTask);
        MessageBoundaryEventTest.assertEquals((String)"taskAfterTask", (String)userTask.getTaskDefinitionKey());
        this.taskService.complete(userTask.getId());
        this.assertProcessEnded(processInstance.getId());
    }

    @Deployment
    public void testBoundaryMessageEventInsideSubprocess() {
        this.runtimeService.startProcessInstanceByKey("process");
        MessageBoundaryEventTest.assertEquals((long)3L, (long)this.runtimeService.createExecutionQuery().count());
        Task userTask = (Task)this.taskService.createTaskQuery().singleResult();
        MessageBoundaryEventTest.assertNotNull((Object)userTask);
        Execution execution = (Execution)this.runtimeService.createExecutionQuery().messageEventSubscriptionName("messageName").singleResult();
        MessageBoundaryEventTest.assertNotNull((Object)execution);
        this.runtimeService.messageEventReceived("messageName", execution.getId());
        userTask = (Task)this.taskService.createTaskQuery().singleResult();
        MessageBoundaryEventTest.assertNotNull((Object)userTask);
        MessageBoundaryEventTest.assertEquals((String)"taskAfterMessage", (String)userTask.getTaskDefinitionKey());
        this.taskService.complete(userTask.getId());
        MessageBoundaryEventTest.assertEquals((long)0L, (long)this.runtimeService.createProcessInstanceQuery().count());
        this.runtimeService.startProcessInstanceByKey("process");
        userTask = (Task)this.taskService.createTaskQuery().singleResult();
        MessageBoundaryEventTest.assertNotNull((Object)userTask);
        this.taskService.complete(userTask.getId());
        execution = (Execution)this.runtimeService.createExecutionQuery().messageEventSubscriptionName("messageName").singleResult();
        MessageBoundaryEventTest.assertNull((Object)execution);
        userTask = (Task)this.taskService.createTaskQuery().singleResult();
        MessageBoundaryEventTest.assertNotNull((Object)userTask);
        MessageBoundaryEventTest.assertEquals((String)"taskAfterTask", (String)userTask.getTaskDefinitionKey());
        this.taskService.complete(userTask.getId());
        MessageBoundaryEventTest.assertEquals((long)0L, (long)this.runtimeService.createProcessInstanceQuery().count());
    }

    @Deployment
    public void testBoundaryMessageEventOnSubprocessAndInsideSubprocess() {
        this.runtimeService.startProcessInstanceByKey("process");
        MessageBoundaryEventTest.assertEquals((long)3L, (long)this.runtimeService.createExecutionQuery().count());
        Task userTask = (Task)this.taskService.createTaskQuery().singleResult();
        MessageBoundaryEventTest.assertNotNull((Object)userTask);
        Execution execution1 = (Execution)this.runtimeService.createExecutionQuery().messageEventSubscriptionName("messageName").singleResult();
        MessageBoundaryEventTest.assertNotNull((Object)execution1);
        Execution execution2 = (Execution)this.runtimeService.createExecutionQuery().messageEventSubscriptionName("messageName2").singleResult();
        MessageBoundaryEventTest.assertNotNull((Object)execution2);
        MessageBoundaryEventTest.assertNotSame((Object)execution1.getId(), (Object)execution2.getId());
        this.taskService.complete(userTask.getId());
        userTask = (Task)this.taskService.createTaskQuery().singleResult();
        MessageBoundaryEventTest.assertNotNull((Object)userTask);
        MessageBoundaryEventTest.assertEquals((String)"taskAfterTask", (String)userTask.getTaskDefinitionKey());
        Execution execution = (Execution)this.runtimeService.createExecutionQuery().messageEventSubscriptionName("messageName").singleResult();
        MessageBoundaryEventTest.assertNull((Object)execution);
        execution = (Execution)this.runtimeService.createExecutionQuery().messageEventSubscriptionName("messageName2").singleResult();
        MessageBoundaryEventTest.assertNotNull((Object)execution);
        this.taskService.complete(userTask.getId());
        execution = (Execution)this.runtimeService.createExecutionQuery().messageEventSubscriptionName("messageName2").singleResult();
        MessageBoundaryEventTest.assertNull((Object)execution);
        userTask = (Task)this.taskService.createTaskQuery().singleResult();
        MessageBoundaryEventTest.assertNotNull((Object)userTask);
        MessageBoundaryEventTest.assertEquals((String)"taskAfterSubprocess", (String)userTask.getTaskDefinitionKey());
        this.taskService.complete(userTask.getId());
        this.runtimeService.startProcessInstanceByKey("process");
        execution = (Execution)this.runtimeService.createExecutionQuery().messageEventSubscriptionName("messageName").singleResult();
        this.runtimeService.messageEventReceived("messageName", execution.getId());
        userTask = (Task)this.taskService.createTaskQuery().singleResult();
        MessageBoundaryEventTest.assertNotNull((Object)userTask);
        MessageBoundaryEventTest.assertEquals((String)"taskAfterMessage", (String)userTask.getTaskDefinitionKey());
        execution = (Execution)this.runtimeService.createExecutionQuery().messageEventSubscriptionName("messageName").singleResult();
        MessageBoundaryEventTest.assertNull((Object)execution);
        execution = (Execution)this.runtimeService.createExecutionQuery().messageEventSubscriptionName("messageName2").singleResult();
        MessageBoundaryEventTest.assertNotNull((Object)execution);
        this.taskService.complete(userTask.getId());
        execution = (Execution)this.runtimeService.createExecutionQuery().messageEventSubscriptionName("messageName2").singleResult();
        MessageBoundaryEventTest.assertNull((Object)execution);
        userTask = (Task)this.taskService.createTaskQuery().singleResult();
        MessageBoundaryEventTest.assertNotNull((Object)userTask);
        MessageBoundaryEventTest.assertEquals((String)"taskAfterSubprocess", (String)userTask.getTaskDefinitionKey());
        this.taskService.complete(userTask.getId());
        this.runtimeService.startProcessInstanceByKey("process");
        execution = (Execution)this.runtimeService.createExecutionQuery().messageEventSubscriptionName("messageName2").singleResult();
        this.runtimeService.messageEventReceived("messageName2", execution.getId());
        userTask = (Task)this.taskService.createTaskQuery().singleResult();
        MessageBoundaryEventTest.assertNotNull((Object)userTask);
        MessageBoundaryEventTest.assertEquals((String)"taskAfterOuterMessageBoundary", (String)userTask.getTaskDefinitionKey());
        execution = (Execution)this.runtimeService.createExecutionQuery().messageEventSubscriptionName("messageName").singleResult();
        MessageBoundaryEventTest.assertNull((Object)execution);
        execution = (Execution)this.runtimeService.createExecutionQuery().messageEventSubscriptionName("messageName2").singleResult();
        MessageBoundaryEventTest.assertNull((Object)execution);
        this.taskService.complete(userTask.getId());
    }

    @Deployment
    public void testBoundaryMessageEventOnSubprocess() {
        this.runtimeService.startProcessInstanceByKey("process");
        MessageBoundaryEventTest.assertEquals((long)2L, (long)this.runtimeService.createExecutionQuery().count());
        Task userTask = (Task)this.taskService.createTaskQuery().singleResult();
        MessageBoundaryEventTest.assertNotNull((Object)userTask);
        Execution executionMessageOne = (Execution)this.runtimeService.createExecutionQuery().messageEventSubscriptionName("messageName_one").singleResult();
        MessageBoundaryEventTest.assertNotNull((Object)executionMessageOne);
        this.runtimeService.messageEventReceived("messageName_one", executionMessageOne.getId());
        userTask = (Task)this.taskService.createTaskQuery().singleResult();
        MessageBoundaryEventTest.assertNotNull((Object)userTask);
        MessageBoundaryEventTest.assertEquals((String)"taskAfterMessage_one", (String)userTask.getTaskDefinitionKey());
        this.taskService.complete(userTask.getId());
        MessageBoundaryEventTest.assertEquals((long)0L, (long)this.runtimeService.createProcessInstanceQuery().count());
        this.runtimeService.startProcessInstanceByKey("process");
        Execution executionMessageTwo = (Execution)this.runtimeService.createExecutionQuery().messageEventSubscriptionName("messageName_two").singleResult();
        MessageBoundaryEventTest.assertNotNull((Object)executionMessageTwo);
        this.runtimeService.messageEventReceived("messageName_two", executionMessageTwo.getId());
        userTask = (Task)this.taskService.createTaskQuery().singleResult();
        MessageBoundaryEventTest.assertNotNull((Object)userTask);
        MessageBoundaryEventTest.assertEquals((String)"taskAfterMessage_two", (String)userTask.getTaskDefinitionKey());
        this.taskService.complete(userTask.getId());
        MessageBoundaryEventTest.assertEquals((long)0L, (long)this.runtimeService.createProcessInstanceQuery().count());
        this.runtimeService.startProcessInstanceByKey("process");
        userTask = (Task)this.taskService.createTaskQuery().singleResult();
        MessageBoundaryEventTest.assertNotNull((Object)userTask);
        this.taskService.complete(userTask.getId());
        executionMessageOne = (Execution)this.runtimeService.createExecutionQuery().messageEventSubscriptionName("messageName_one").singleResult();
        MessageBoundaryEventTest.assertNull((Object)executionMessageOne);
        executionMessageTwo = (Execution)this.runtimeService.createExecutionQuery().messageEventSubscriptionName("messageName_two").singleResult();
        MessageBoundaryEventTest.assertNull((Object)executionMessageTwo);
        userTask = (Task)this.taskService.createTaskQuery().singleResult();
        MessageBoundaryEventTest.assertNotNull((Object)userTask);
        MessageBoundaryEventTest.assertEquals((String)"taskAfterSubProcess", (String)userTask.getTaskDefinitionKey());
        this.taskService.complete(userTask.getId());
        MessageBoundaryEventTest.assertEquals((long)0L, (long)this.runtimeService.createProcessInstanceQuery().count());
    }

    @Deployment
    public void testBoundaryMessageEventOnSubprocessWithIntermediateMessageCatch() {
        ProcessInstance processInstance = this.runtimeService.startProcessInstanceByKey("testProcess");
        this.runtimeService.correlateMessage("cancelMessage");
        this.assertProcessEnded(processInstance.getId());
        if (this.processEngineConfiguration.getHistoryLevel().getId() > ProcessEngineConfigurationImpl.HISTORYLEVEL_NONE) {
            List hais = this.historyService.createHistoricActivityInstanceQuery().list();
            for (HistoricActivityInstance historicActivityInstance : hais) {
                MessageBoundaryEventTest.assertNotNull((Object)historicActivityInstance.getEndTime());
            }
        }
    }

    @Deployment
    public void testBoundaryMessageEventOnSubprocessAndInsideSubprocessMultiInstance() {
        this.runtimeService.startProcessInstanceByKey("process");
        MessageBoundaryEventTest.assertEquals((long)17L, (long)this.runtimeService.createExecutionQuery().count());
        List userTasks = this.taskService.createTaskQuery().list();
        MessageBoundaryEventTest.assertNotNull((Object)userTasks);
        MessageBoundaryEventTest.assertEquals((int)5, (int)userTasks.size());
        List executions = this.runtimeService.createExecutionQuery().messageEventSubscriptionName("messageName").list();
        MessageBoundaryEventTest.assertNotNull((Object)executions);
        MessageBoundaryEventTest.assertEquals((int)5, (int)executions.size());
        executions = this.runtimeService.createExecutionQuery().messageEventSubscriptionName("messageName2").list();
        MessageBoundaryEventTest.assertNotNull((Object)executions);
        MessageBoundaryEventTest.assertEquals((int)1, (int)executions.size());
        Execution outerScopeExecution = (Execution)executions.get(0);
        this.runtimeService.messageEventReceived("messageName2", outerScopeExecution.getId());
        executions = this.runtimeService.createExecutionQuery().messageEventSubscriptionName("messageName").list();
        MessageBoundaryEventTest.assertEquals((int)0, (int)executions.size());
        Task userTask = (Task)this.taskService.createTaskQuery().singleResult();
        MessageBoundaryEventTest.assertNotNull((Object)userTask);
        MessageBoundaryEventTest.assertEquals((String)"taskAfterOuterMessageBoundary", (String)userTask.getTaskDefinitionKey());
        this.taskService.complete(userTask.getId());
    }
}

