/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.test.bpmn.parse;

import org.camunda.bpm.engine.impl.persistence.entity.ExecutionEntity;
import org.camunda.bpm.engine.impl.pvm.process.ActivityImpl;
import org.camunda.bpm.engine.impl.pvm.process.ProcessDefinitionImpl;
import org.camunda.bpm.engine.impl.test.PluggableProcessEngineTestCase;
import org.camunda.bpm.engine.runtime.ProcessInstance;
import org.camunda.bpm.engine.test.Deployment;

public class FoxFailedJobParseListenerTest
extends PluggableProcessEngineTestCase {
    @Deployment(resources={"org/camunda/bpm/engine/test/bpmn/parse/FoxFailedJobParseListenerTest.testUserTask.bpmn20.xml"})
    public void testUserTaskParseFailedJobRetryTimeCycle() {
        ProcessInstance pi = this.runtimeService.startProcessInstanceByKey("asyncUserTaskFailedJobRetryTimeCycle");
        FoxFailedJobParseListenerTest.assertTrue((boolean)(pi instanceof ExecutionEntity));
        ExecutionEntity execution = (ExecutionEntity)pi;
        ProcessDefinitionImpl processDefinition = execution.getProcessDefinition();
        FoxFailedJobParseListenerTest.assertNotNull((Object)processDefinition);
        ActivityImpl userTask = processDefinition.findActivity("task");
        FoxFailedJobParseListenerTest.assertNotNull((Object)userTask);
        this.checkFoxFailedJobConfig(userTask);
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/bpmn/parse/CamundaFailedJobParseListenerTest.testUserTask.bpmn20.xml"})
    public void testUserTaskParseFailedJobRetryTimeCycleInActivitiNamespace() {
        ProcessInstance pi = this.runtimeService.startProcessInstanceByKey("asyncUserTaskFailedJobRetryTimeCycle");
        FoxFailedJobParseListenerTest.assertTrue((boolean)(pi instanceof ExecutionEntity));
        ExecutionEntity execution = (ExecutionEntity)pi;
        ProcessDefinitionImpl processDefinition = execution.getProcessDefinition();
        FoxFailedJobParseListenerTest.assertNotNull((Object)processDefinition);
        ActivityImpl userTask = processDefinition.findActivity("task");
        FoxFailedJobParseListenerTest.assertNotNull((Object)userTask);
        this.checkFoxFailedJobConfig(userTask);
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/bpmn/parse/FoxFailedJobParseListenerTest.testUserTask.bpmn20.xml"})
    public void testNotAsyncUserTaskParseFailedJobRetryTimeCycle() {
        ProcessInstance pi = this.runtimeService.startProcessInstanceByKey("notAsyncUserTaskFailedJobRetryTimeCycle");
        FoxFailedJobParseListenerTest.assertTrue((boolean)(pi instanceof ExecutionEntity));
        ExecutionEntity execution = (ExecutionEntity)pi;
        ProcessDefinitionImpl processDefinition = execution.getProcessDefinition();
        FoxFailedJobParseListenerTest.assertNotNull((Object)processDefinition);
        ActivityImpl userTask = processDefinition.findActivity("notAsyncTask");
        FoxFailedJobParseListenerTest.assertNotNull((Object)userTask);
        this.checkNotContainingFoxFailedJobConfig(userTask);
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/bpmn/parse/FoxFailedJobParseListenerTest.testUserTask.bpmn20.xml"})
    public void testAsyncUserTaskButWithoutParseFailedJobRetryTimeCycle() {
        ProcessInstance pi = this.runtimeService.startProcessInstanceByKey("asyncUserTaskButWithoutFailedJobRetryTimeCycle");
        FoxFailedJobParseListenerTest.assertTrue((boolean)(pi instanceof ExecutionEntity));
        ExecutionEntity execution = (ExecutionEntity)pi;
        ProcessDefinitionImpl processDefinition = execution.getProcessDefinition();
        FoxFailedJobParseListenerTest.assertNotNull((Object)processDefinition);
        ActivityImpl userTask = processDefinition.findActivity("asyncTaskWithoutFailedJobRetryTimeCycle");
        FoxFailedJobParseListenerTest.assertNotNull((Object)userTask);
        FoxFailedJobParseListenerTest.assertTrue((boolean)userTask.isAsyncBefore());
        this.checkNotContainingFoxFailedJobConfig(userTask);
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/bpmn/parse/FoxFailedJobParseListenerTest.testTimer.bpmn20.xml"})
    public void testTimerBoundaryEventWithFailedJobRetryTimeCycle() {
        ProcessInstance pi = this.runtimeService.startProcessInstanceByKey("boundaryEventWithFailedJobRetryTimeCycle");
        FoxFailedJobParseListenerTest.assertTrue((boolean)(pi instanceof ExecutionEntity));
        ExecutionEntity execution = (ExecutionEntity)pi;
        ProcessDefinitionImpl processDefinition = execution.getProcessDefinition();
        FoxFailedJobParseListenerTest.assertNotNull((Object)processDefinition);
        ActivityImpl boundaryActivity = processDefinition.findActivity("boundaryTimerWithFailedJobRetryTimeCycle");
        FoxFailedJobParseListenerTest.assertNotNull((Object)boundaryActivity);
        this.checkFoxFailedJobConfig(boundaryActivity);
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/bpmn/parse/FoxFailedJobParseListenerTest.testTimer.bpmn20.xml"})
    public void testTimerBoundaryEventWithoutFailedJobRetryTimeCycle() {
        ProcessInstance pi = this.runtimeService.startProcessInstanceByKey("boundaryEventWithoutFailedJobRetryTimeCycle");
        FoxFailedJobParseListenerTest.assertTrue((boolean)(pi instanceof ExecutionEntity));
        ExecutionEntity execution = (ExecutionEntity)pi;
        ProcessDefinitionImpl processDefinition = execution.getProcessDefinition();
        FoxFailedJobParseListenerTest.assertNotNull((Object)processDefinition);
        ActivityImpl boundaryActivity = processDefinition.findActivity("boundaryTimerWithoutFailedJobRetryTimeCycle");
        FoxFailedJobParseListenerTest.assertNotNull((Object)boundaryActivity);
        this.checkNotContainingFoxFailedJobConfig(boundaryActivity);
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/bpmn/parse/FoxFailedJobParseListenerTest.testTimer.bpmn20.xml"})
    public void testTimerStartEventWithFailedJobRetryTimeCycle() {
        ProcessInstance pi = this.runtimeService.startProcessInstanceByKey("startEventWithFailedJobRetryTimeCycle");
        FoxFailedJobParseListenerTest.assertTrue((boolean)(pi instanceof ExecutionEntity));
        ExecutionEntity execution = (ExecutionEntity)pi;
        ProcessDefinitionImpl processDefinition = execution.getProcessDefinition();
        FoxFailedJobParseListenerTest.assertNotNull((Object)processDefinition);
        ActivityImpl startEvent = processDefinition.findActivity("startEventFailedJobRetryTimeCycle");
        FoxFailedJobParseListenerTest.assertNotNull((Object)startEvent);
        this.checkFoxFailedJobConfig(startEvent);
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/bpmn/parse/FoxFailedJobParseListenerTest.testTimer.bpmn20.xml"})
    public void testIntermediateCatchTimerEventWithFailedJobRetryTimeCycle() {
        ProcessInstance pi = this.runtimeService.startProcessInstanceByKey("intermediateTimerEventWithFailedJobRetryTimeCycle");
        FoxFailedJobParseListenerTest.assertTrue((boolean)(pi instanceof ExecutionEntity));
        ExecutionEntity execution = (ExecutionEntity)pi;
        ProcessDefinitionImpl processDefinition = execution.getProcessDefinition();
        FoxFailedJobParseListenerTest.assertNotNull((Object)processDefinition);
        ActivityImpl timer = processDefinition.findActivity("timerEventWithFailedJobRetryTimeCycle");
        FoxFailedJobParseListenerTest.assertNotNull((Object)timer);
        this.checkFoxFailedJobConfig(timer);
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/bpmn/parse/FoxFailedJobParseListenerTest.testSignal.bpmn20.xml"})
    public void testSignalEventWithFailedJobRetryTimeCycle() {
        ProcessInstance pi = this.runtimeService.startProcessInstanceByKey("signalEventWithFailedJobRetryTimeCycle");
        FoxFailedJobParseListenerTest.assertTrue((boolean)(pi instanceof ExecutionEntity));
        ExecutionEntity execution = (ExecutionEntity)pi;
        ProcessDefinitionImpl processDefinition = execution.getProcessDefinition();
        FoxFailedJobParseListenerTest.assertNotNull((Object)processDefinition);
        ActivityImpl signal = processDefinition.findActivity("signalWithFailedJobRetryTimeCycle");
        FoxFailedJobParseListenerTest.assertNotNull((Object)signal);
        this.checkFoxFailedJobConfig(signal);
    }

    private void checkFoxFailedJobConfig(ActivityImpl activity) {
        FoxFailedJobParseListenerTest.assertTrue((boolean)activity.getProperties().containsKey("FOX_FAILED_JOB_CONFIGURATION"));
        Object value = activity.getProperties().get("FOX_FAILED_JOB_CONFIGURATION");
        FoxFailedJobParseListenerTest.assertNotNull(value);
        FoxFailedJobParseListenerTest.assertEquals((Object)"R5/PT5M", value);
    }

    private void checkNotContainingFoxFailedJobConfig(ActivityImpl activity) {
        FoxFailedJobParseListenerTest.assertFalse((boolean)activity.getProperties().containsKey("FOX_FAILED_JOB_CONFIGURATION"));
    }
}

