/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.test.cmd;

import org.camunda.bpm.engine.impl.persistence.entity.ExecutionEntity;
import org.camunda.bpm.engine.impl.test.PluggableProcessEngineTestCase;
import org.camunda.bpm.engine.runtime.Job;
import org.camunda.bpm.engine.runtime.JobQuery;
import org.camunda.bpm.engine.runtime.ProcessInstance;
import org.camunda.bpm.engine.test.Deployment;

public class FoxJobRetryCmdTest
extends PluggableProcessEngineTestCase {
    private void waitForExecutedJobWithRetriesLeft(int retriesLeft) {
        Job job = (Job)this.managementService.createJobQuery().singleResult();
        try {
            this.managementService.executeJob(job.getId());
        }
        catch (Exception exception) {
            // empty catch block
        }
        job = (Job)this.managementService.createJobQuery().singleResult();
        if (job.getRetries() != retriesLeft) {
            this.waitForExecutedJobWithRetriesLeft(retriesLeft);
        }
    }

    private ExecutionEntity refreshExecutionEntity(String executionId) {
        return (ExecutionEntity)this.runtimeService.createExecutionQuery().executionId(executionId).singleResult();
    }

    private ExecutionEntity fetchExecutionEntity(String processInstanceId) {
        return (ExecutionEntity)this.runtimeService.createExecutionQuery().processInstanceId(processInstanceId).singleResult();
    }

    private Job refreshJob(String jobId) {
        return (Job)this.managementService.createJobQuery().jobId(jobId).singleResult();
    }

    private Job fetchJob(String processInstanceId) {
        return (Job)this.managementService.createJobQuery().processInstanceId(processInstanceId).singleResult();
    }

    private void stillOneJobWithExceptionAndRetriesLeft() {
        FoxJobRetryCmdTest.assertEquals((long)1L, (long)this.managementService.createJobQuery().withException().count());
        FoxJobRetryCmdTest.assertEquals((long)1L, (long)this.managementService.createJobQuery().withRetriesLeft().count());
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/cmd/FoxJobRetryCmdTest.testFailedServiceTask.bpmn20.xml"})
    public void testFailedServiceTask() {
        ProcessInstance pi = this.runtimeService.startProcessInstanceByKey("failedServiceTask");
        FoxJobRetryCmdTest.assertNotNull((Object)pi);
        this.waitForExecutedJobWithRetriesLeft(4);
        this.stillOneJobWithExceptionAndRetriesLeft();
        Job job = this.fetchJob(pi.getProcessInstanceId());
        FoxJobRetryCmdTest.assertNotNull((Object)job);
        FoxJobRetryCmdTest.assertEquals((String)pi.getProcessInstanceId(), (String)job.getProcessInstanceId());
        FoxJobRetryCmdTest.assertEquals((int)4, (int)job.getRetries());
        ExecutionEntity execution = this.fetchExecutionEntity(pi.getProcessInstanceId());
        FoxJobRetryCmdTest.assertEquals((String)"failingServiceTask", (String)execution.getActivityId());
        this.waitForExecutedJobWithRetriesLeft(3);
        job = this.refreshJob(job.getId());
        FoxJobRetryCmdTest.assertEquals((int)3, (int)job.getRetries());
        this.stillOneJobWithExceptionAndRetriesLeft();
        execution = this.refreshExecutionEntity(execution.getId());
        FoxJobRetryCmdTest.assertEquals((String)"failingServiceTask", (String)execution.getActivityId());
        this.waitForExecutedJobWithRetriesLeft(2);
        job = this.refreshJob(job.getId());
        FoxJobRetryCmdTest.assertEquals((int)2, (int)job.getRetries());
        this.stillOneJobWithExceptionAndRetriesLeft();
        execution = this.refreshExecutionEntity(execution.getId());
        FoxJobRetryCmdTest.assertEquals((String)"failingServiceTask", (String)execution.getActivityId());
        this.waitForExecutedJobWithRetriesLeft(1);
        job = this.refreshJob(job.getId());
        FoxJobRetryCmdTest.assertEquals((int)1, (int)job.getRetries());
        this.stillOneJobWithExceptionAndRetriesLeft();
        execution = this.refreshExecutionEntity(execution.getId());
        FoxJobRetryCmdTest.assertEquals((String)"failingServiceTask", (String)execution.getActivityId());
        this.waitForExecutedJobWithRetriesLeft(0);
        job = this.refreshJob(job.getId());
        FoxJobRetryCmdTest.assertEquals((int)0, (int)job.getRetries());
        FoxJobRetryCmdTest.assertEquals((long)1L, (long)this.managementService.createJobQuery().withException().count());
        FoxJobRetryCmdTest.assertEquals((long)0L, (long)this.managementService.createJobQuery().withRetriesLeft().count());
        FoxJobRetryCmdTest.assertEquals((long)1L, (long)this.managementService.createJobQuery().noRetriesLeft().count());
        execution = this.refreshExecutionEntity(execution.getId());
        FoxJobRetryCmdTest.assertEquals((String)"failingServiceTask", (String)execution.getActivityId());
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/cmd/FoxJobRetryCmdTest.testFailedUserTask.bpmn20.xml"})
    public void testFailedUserTask() {
        ProcessInstance pi = this.runtimeService.startProcessInstanceByKey("failedUserTask");
        FoxJobRetryCmdTest.assertNotNull((Object)pi);
        this.waitForExecutedJobWithRetriesLeft(4);
        this.stillOneJobWithExceptionAndRetriesLeft();
        Job job = this.fetchJob(pi.getProcessInstanceId());
        FoxJobRetryCmdTest.assertNotNull((Object)job);
        FoxJobRetryCmdTest.assertEquals((String)pi.getProcessInstanceId(), (String)job.getProcessInstanceId());
        FoxJobRetryCmdTest.assertEquals((int)4, (int)job.getRetries());
        ExecutionEntity execution = this.fetchExecutionEntity(pi.getProcessInstanceId());
        FoxJobRetryCmdTest.assertEquals((String)"failingUserTask", (String)execution.getActivityId());
        this.waitForExecutedJobWithRetriesLeft(3);
        job = this.refreshJob(job.getId());
        FoxJobRetryCmdTest.assertEquals((int)3, (int)job.getRetries());
        this.stillOneJobWithExceptionAndRetriesLeft();
        execution = this.refreshExecutionEntity(execution.getId());
        FoxJobRetryCmdTest.assertEquals((String)"failingUserTask", (String)execution.getActivityId());
        this.waitForExecutedJobWithRetriesLeft(2);
        job = this.refreshJob(job.getId());
        FoxJobRetryCmdTest.assertEquals((int)2, (int)job.getRetries());
        this.stillOneJobWithExceptionAndRetriesLeft();
        execution = this.refreshExecutionEntity(execution.getId());
        FoxJobRetryCmdTest.assertEquals((String)"failingUserTask", (String)execution.getActivityId());
        this.waitForExecutedJobWithRetriesLeft(1);
        job = this.refreshJob(job.getId());
        FoxJobRetryCmdTest.assertEquals((int)1, (int)job.getRetries());
        this.stillOneJobWithExceptionAndRetriesLeft();
        execution = this.refreshExecutionEntity(execution.getId());
        FoxJobRetryCmdTest.assertEquals((String)"failingUserTask", (String)execution.getActivityId());
        this.waitForExecutedJobWithRetriesLeft(0);
        job = this.refreshJob(job.getId());
        FoxJobRetryCmdTest.assertEquals((int)0, (int)job.getRetries());
        FoxJobRetryCmdTest.assertEquals((long)1L, (long)this.managementService.createJobQuery().withException().count());
        FoxJobRetryCmdTest.assertEquals((long)0L, (long)this.managementService.createJobQuery().withRetriesLeft().count());
        FoxJobRetryCmdTest.assertEquals((long)1L, (long)this.managementService.createJobQuery().noRetriesLeft().count());
        execution = this.refreshExecutionEntity(execution.getId());
        FoxJobRetryCmdTest.assertEquals((String)"failingUserTask", (String)execution.getActivityId());
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/cmd/FoxJobRetryCmdTest.testFailedBusinessRuleTask.bpmn20.xml"})
    public void testFailedBusinessRuleTask() {
        ProcessInstance pi = this.runtimeService.startProcessInstanceByKey("failedBusinessRuleTask");
        FoxJobRetryCmdTest.assertNotNull((Object)pi);
        this.waitForExecutedJobWithRetriesLeft(4);
        this.stillOneJobWithExceptionAndRetriesLeft();
        ExecutionEntity execution = this.fetchExecutionEntity(pi.getProcessInstanceId());
        FoxJobRetryCmdTest.assertEquals((String)"failingBusinessRuleTask", (String)execution.getActivityId());
        Job job = this.fetchJob(pi.getProcessInstanceId());
        FoxJobRetryCmdTest.assertNotNull((Object)job);
        FoxJobRetryCmdTest.assertEquals((String)pi.getProcessInstanceId(), (String)job.getProcessInstanceId());
        FoxJobRetryCmdTest.assertEquals((int)4, (int)job.getRetries());
        this.waitForExecutedJobWithRetriesLeft(3);
        job = this.refreshJob(job.getId());
        FoxJobRetryCmdTest.assertEquals((int)3, (int)job.getRetries());
        this.stillOneJobWithExceptionAndRetriesLeft();
        execution = this.refreshExecutionEntity(execution.getId());
        FoxJobRetryCmdTest.assertEquals((String)"failingBusinessRuleTask", (String)execution.getActivityId());
        this.waitForExecutedJobWithRetriesLeft(2);
        job = this.refreshJob(job.getId());
        FoxJobRetryCmdTest.assertEquals((int)2, (int)job.getRetries());
        this.stillOneJobWithExceptionAndRetriesLeft();
        execution = this.refreshExecutionEntity(execution.getId());
        FoxJobRetryCmdTest.assertEquals((String)"failingBusinessRuleTask", (String)execution.getActivityId());
        this.waitForExecutedJobWithRetriesLeft(1);
        job = this.refreshJob(job.getId());
        FoxJobRetryCmdTest.assertEquals((int)1, (int)job.getRetries());
        this.stillOneJobWithExceptionAndRetriesLeft();
        execution = this.refreshExecutionEntity(execution.getId());
        FoxJobRetryCmdTest.assertEquals((String)"failingBusinessRuleTask", (String)execution.getActivityId());
        this.waitForExecutedJobWithRetriesLeft(0);
        job = this.refreshJob(job.getId());
        FoxJobRetryCmdTest.assertEquals((int)0, (int)job.getRetries());
        FoxJobRetryCmdTest.assertEquals((long)1L, (long)this.managementService.createJobQuery().withException().count());
        FoxJobRetryCmdTest.assertEquals((long)0L, (long)this.managementService.createJobQuery().withRetriesLeft().count());
        FoxJobRetryCmdTest.assertEquals((long)1L, (long)this.managementService.createJobQuery().noRetriesLeft().count());
        execution = this.refreshExecutionEntity(execution.getId());
        FoxJobRetryCmdTest.assertEquals((String)"failingBusinessRuleTask", (String)execution.getActivityId());
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/cmd/FoxJobRetryCmdTest.testFailedCallActivity.bpmn20.xml"})
    public void testFailedCallActivity() {
        ProcessInstance pi = this.runtimeService.startProcessInstanceByKey("failedCallActivity");
        FoxJobRetryCmdTest.assertNotNull((Object)pi);
        this.waitForExecutedJobWithRetriesLeft(4);
        this.stillOneJobWithExceptionAndRetriesLeft();
        ExecutionEntity execution = this.fetchExecutionEntity(pi.getProcessInstanceId());
        FoxJobRetryCmdTest.assertEquals((String)"failingCallActivity", (String)execution.getActivityId());
        Job job = this.fetchJob(pi.getProcessInstanceId());
        FoxJobRetryCmdTest.assertNotNull((Object)job);
        FoxJobRetryCmdTest.assertEquals((String)pi.getProcessInstanceId(), (String)job.getProcessInstanceId());
        FoxJobRetryCmdTest.assertEquals((int)4, (int)job.getRetries());
        this.waitForExecutedJobWithRetriesLeft(3);
        job = this.refreshJob(job.getId());
        FoxJobRetryCmdTest.assertEquals((int)3, (int)job.getRetries());
        this.stillOneJobWithExceptionAndRetriesLeft();
        execution = this.refreshExecutionEntity(execution.getId());
        FoxJobRetryCmdTest.assertEquals((String)"failingCallActivity", (String)execution.getActivityId());
        this.waitForExecutedJobWithRetriesLeft(2);
        job = this.refreshJob(job.getId());
        FoxJobRetryCmdTest.assertEquals((int)2, (int)job.getRetries());
        this.stillOneJobWithExceptionAndRetriesLeft();
        execution = this.refreshExecutionEntity(execution.getId());
        FoxJobRetryCmdTest.assertEquals((String)"failingCallActivity", (String)execution.getActivityId());
        this.waitForExecutedJobWithRetriesLeft(1);
        job = this.refreshJob(job.getId());
        FoxJobRetryCmdTest.assertEquals((int)1, (int)job.getRetries());
        this.stillOneJobWithExceptionAndRetriesLeft();
        execution = this.refreshExecutionEntity(execution.getId());
        FoxJobRetryCmdTest.assertEquals((String)"failingCallActivity", (String)execution.getActivityId());
        this.waitForExecutedJobWithRetriesLeft(0);
        job = this.refreshJob(job.getId());
        FoxJobRetryCmdTest.assertEquals((int)0, (int)job.getRetries());
        FoxJobRetryCmdTest.assertEquals((long)1L, (long)this.managementService.createJobQuery().withException().count());
        FoxJobRetryCmdTest.assertEquals((long)0L, (long)this.managementService.createJobQuery().withRetriesLeft().count());
        FoxJobRetryCmdTest.assertEquals((long)1L, (long)this.managementService.createJobQuery().noRetriesLeft().count());
        execution = this.refreshExecutionEntity(execution.getId());
        FoxJobRetryCmdTest.assertEquals((String)"failingCallActivity", (String)execution.getActivityId());
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/cmd/FoxJobRetryCmdTest.testFailedScriptTask.bpmn20.xml"})
    public void testFailedScriptTask() {
        ProcessInstance pi = this.runtimeService.startProcessInstanceByKey("failedScriptTask");
        FoxJobRetryCmdTest.assertNotNull((Object)pi);
        this.waitForExecutedJobWithRetriesLeft(4);
        this.stillOneJobWithExceptionAndRetriesLeft();
        ExecutionEntity execution = this.fetchExecutionEntity(pi.getProcessInstanceId());
        FoxJobRetryCmdTest.assertEquals((String)"failingScriptTask", (String)execution.getActivityId());
        Job job = this.fetchJob(pi.getProcessInstanceId());
        FoxJobRetryCmdTest.assertNotNull((Object)job);
        FoxJobRetryCmdTest.assertEquals((String)pi.getProcessInstanceId(), (String)job.getProcessInstanceId());
        FoxJobRetryCmdTest.assertEquals((int)4, (int)job.getRetries());
        this.waitForExecutedJobWithRetriesLeft(3);
        job = this.refreshJob(job.getId());
        FoxJobRetryCmdTest.assertEquals((int)3, (int)job.getRetries());
        this.stillOneJobWithExceptionAndRetriesLeft();
        execution = this.refreshExecutionEntity(execution.getId());
        FoxJobRetryCmdTest.assertEquals((String)"failingScriptTask", (String)execution.getActivityId());
        this.waitForExecutedJobWithRetriesLeft(2);
        job = this.refreshJob(job.getId());
        FoxJobRetryCmdTest.assertEquals((int)2, (int)job.getRetries());
        this.stillOneJobWithExceptionAndRetriesLeft();
        execution = this.refreshExecutionEntity(execution.getId());
        FoxJobRetryCmdTest.assertEquals((String)"failingScriptTask", (String)execution.getActivityId());
        this.waitForExecutedJobWithRetriesLeft(1);
        job = this.refreshJob(job.getId());
        FoxJobRetryCmdTest.assertEquals((int)1, (int)job.getRetries());
        this.stillOneJobWithExceptionAndRetriesLeft();
        execution = this.refreshExecutionEntity(execution.getId());
        FoxJobRetryCmdTest.assertEquals((String)"failingScriptTask", (String)execution.getActivityId());
        this.waitForExecutedJobWithRetriesLeft(0);
        job = this.refreshJob(job.getId());
        FoxJobRetryCmdTest.assertEquals((int)0, (int)job.getRetries());
        FoxJobRetryCmdTest.assertEquals((long)1L, (long)this.managementService.createJobQuery().withException().count());
        FoxJobRetryCmdTest.assertEquals((long)0L, (long)this.managementService.createJobQuery().withRetriesLeft().count());
        FoxJobRetryCmdTest.assertEquals((long)1L, (long)this.managementService.createJobQuery().noRetriesLeft().count());
        execution = this.refreshExecutionEntity(execution.getId());
        FoxJobRetryCmdTest.assertEquals((String)"failingScriptTask", (String)execution.getActivityId());
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/cmd/FoxJobRetryCmdTest.testFailedSendTask.bpmn20.xml"})
    public void testFailedSendTask() {
        ProcessInstance pi = this.runtimeService.startProcessInstanceByKey("failedSendTask");
        FoxJobRetryCmdTest.assertNotNull((Object)pi);
        this.waitForExecutedJobWithRetriesLeft(4);
        this.stillOneJobWithExceptionAndRetriesLeft();
        ExecutionEntity execution = this.fetchExecutionEntity(pi.getProcessInstanceId());
        FoxJobRetryCmdTest.assertEquals((String)"failingSendTask", (String)execution.getActivityId());
        Job job = this.fetchJob(pi.getProcessInstanceId());
        FoxJobRetryCmdTest.assertNotNull((Object)job);
        FoxJobRetryCmdTest.assertEquals((String)pi.getProcessInstanceId(), (String)job.getProcessInstanceId());
        FoxJobRetryCmdTest.assertEquals((int)4, (int)job.getRetries());
        this.waitForExecutedJobWithRetriesLeft(3);
        job = this.refreshJob(job.getId());
        FoxJobRetryCmdTest.assertEquals((int)3, (int)job.getRetries());
        this.stillOneJobWithExceptionAndRetriesLeft();
        execution = this.refreshExecutionEntity(execution.getId());
        FoxJobRetryCmdTest.assertEquals((String)"failingSendTask", (String)execution.getActivityId());
        this.waitForExecutedJobWithRetriesLeft(2);
        job = this.refreshJob(job.getId());
        FoxJobRetryCmdTest.assertEquals((int)2, (int)job.getRetries());
        this.stillOneJobWithExceptionAndRetriesLeft();
        execution = this.refreshExecutionEntity(execution.getId());
        FoxJobRetryCmdTest.assertEquals((String)"failingSendTask", (String)execution.getActivityId());
        this.waitForExecutedJobWithRetriesLeft(1);
        job = this.refreshJob(job.getId());
        FoxJobRetryCmdTest.assertEquals((int)1, (int)job.getRetries());
        this.stillOneJobWithExceptionAndRetriesLeft();
        execution = this.refreshExecutionEntity(execution.getId());
        FoxJobRetryCmdTest.assertEquals((String)"failingSendTask", (String)execution.getActivityId());
        this.waitForExecutedJobWithRetriesLeft(0);
        job = this.refreshJob(job.getId());
        FoxJobRetryCmdTest.assertEquals((int)0, (int)job.getRetries());
        FoxJobRetryCmdTest.assertEquals((long)1L, (long)this.managementService.createJobQuery().withException().count());
        FoxJobRetryCmdTest.assertEquals((long)0L, (long)this.managementService.createJobQuery().withRetriesLeft().count());
        FoxJobRetryCmdTest.assertEquals((long)1L, (long)this.managementService.createJobQuery().noRetriesLeft().count());
        execution = this.refreshExecutionEntity(execution.getId());
        FoxJobRetryCmdTest.assertEquals((String)"failingSendTask", (String)execution.getActivityId());
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/cmd/FoxJobRetryCmdTest.testFailedSubProcess.bpmn20.xml"})
    public void testFailedSubProcess() {
        ProcessInstance pi = this.runtimeService.startProcessInstanceByKey("failedSubProcess");
        FoxJobRetryCmdTest.assertNotNull((Object)pi);
        this.waitForExecutedJobWithRetriesLeft(4);
        this.stillOneJobWithExceptionAndRetriesLeft();
        ExecutionEntity execution = this.fetchExecutionEntity(pi.getProcessInstanceId());
        FoxJobRetryCmdTest.assertEquals((String)"failingSubProcess", (String)execution.getActivityId());
        Job job = this.fetchJob(pi.getProcessInstanceId());
        FoxJobRetryCmdTest.assertNotNull((Object)job);
        FoxJobRetryCmdTest.assertEquals((String)pi.getProcessInstanceId(), (String)job.getProcessInstanceId());
        FoxJobRetryCmdTest.assertEquals((int)4, (int)job.getRetries());
        this.waitForExecutedJobWithRetriesLeft(3);
        job = this.refreshJob(job.getId());
        FoxJobRetryCmdTest.assertEquals((int)3, (int)job.getRetries());
        this.stillOneJobWithExceptionAndRetriesLeft();
        execution = this.refreshExecutionEntity(execution.getId());
        FoxJobRetryCmdTest.assertEquals((String)"failingSubProcess", (String)execution.getActivityId());
        this.waitForExecutedJobWithRetriesLeft(2);
        job = this.refreshJob(job.getId());
        FoxJobRetryCmdTest.assertEquals((int)2, (int)job.getRetries());
        this.stillOneJobWithExceptionAndRetriesLeft();
        execution = this.refreshExecutionEntity(execution.getId());
        FoxJobRetryCmdTest.assertEquals((String)"failingSubProcess", (String)execution.getActivityId());
        this.waitForExecutedJobWithRetriesLeft(1);
        job = this.refreshJob(job.getId());
        FoxJobRetryCmdTest.assertEquals((int)1, (int)job.getRetries());
        this.stillOneJobWithExceptionAndRetriesLeft();
        execution = this.refreshExecutionEntity(execution.getId());
        FoxJobRetryCmdTest.assertEquals((String)"failingSubProcess", (String)execution.getActivityId());
        this.waitForExecutedJobWithRetriesLeft(0);
        job = this.refreshJob(job.getId());
        FoxJobRetryCmdTest.assertEquals((int)0, (int)job.getRetries());
        FoxJobRetryCmdTest.assertEquals((long)1L, (long)this.managementService.createJobQuery().withException().count());
        FoxJobRetryCmdTest.assertEquals((long)0L, (long)this.managementService.createJobQuery().withRetriesLeft().count());
        FoxJobRetryCmdTest.assertEquals((long)1L, (long)this.managementService.createJobQuery().noRetriesLeft().count());
        execution = this.refreshExecutionEntity(execution.getId());
        FoxJobRetryCmdTest.assertEquals((String)"failingSubProcess", (String)execution.getActivityId());
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/cmd/FoxJobRetryCmdTest.testFailedTask.bpmn20.xml"})
    public void testFailedTask() {
        ProcessInstance pi = this.runtimeService.startProcessInstanceByKey("failedTask");
        FoxJobRetryCmdTest.assertNotNull((Object)pi);
        this.waitForExecutedJobWithRetriesLeft(4);
        this.stillOneJobWithExceptionAndRetriesLeft();
        ExecutionEntity execution = this.fetchExecutionEntity(pi.getProcessInstanceId());
        FoxJobRetryCmdTest.assertEquals((String)"failingTask", (String)execution.getActivityId());
        Job job = this.fetchJob(pi.getProcessInstanceId());
        FoxJobRetryCmdTest.assertNotNull((Object)job);
        FoxJobRetryCmdTest.assertEquals((String)pi.getProcessInstanceId(), (String)job.getProcessInstanceId());
        FoxJobRetryCmdTest.assertEquals((int)4, (int)job.getRetries());
        this.waitForExecutedJobWithRetriesLeft(3);
        job = this.refreshJob(job.getId());
        FoxJobRetryCmdTest.assertEquals((int)3, (int)job.getRetries());
        this.stillOneJobWithExceptionAndRetriesLeft();
        execution = this.refreshExecutionEntity(execution.getId());
        FoxJobRetryCmdTest.assertEquals((String)"failingTask", (String)execution.getActivityId());
        this.waitForExecutedJobWithRetriesLeft(2);
        job = this.refreshJob(job.getId());
        FoxJobRetryCmdTest.assertEquals((int)2, (int)job.getRetries());
        this.stillOneJobWithExceptionAndRetriesLeft();
        execution = this.refreshExecutionEntity(execution.getId());
        FoxJobRetryCmdTest.assertEquals((String)"failingTask", (String)execution.getActivityId());
        this.waitForExecutedJobWithRetriesLeft(1);
        job = this.refreshJob(job.getId());
        FoxJobRetryCmdTest.assertEquals((int)1, (int)job.getRetries());
        this.stillOneJobWithExceptionAndRetriesLeft();
        execution = this.refreshExecutionEntity(execution.getId());
        FoxJobRetryCmdTest.assertEquals((String)"failingTask", (String)execution.getActivityId());
        this.waitForExecutedJobWithRetriesLeft(0);
        job = this.refreshJob(job.getId());
        FoxJobRetryCmdTest.assertEquals((int)0, (int)job.getRetries());
        FoxJobRetryCmdTest.assertEquals((long)1L, (long)this.managementService.createJobQuery().withException().count());
        FoxJobRetryCmdTest.assertEquals((long)0L, (long)this.managementService.createJobQuery().withRetriesLeft().count());
        FoxJobRetryCmdTest.assertEquals((long)1L, (long)this.managementService.createJobQuery().noRetriesLeft().count());
        execution = this.refreshExecutionEntity(execution.getId());
        FoxJobRetryCmdTest.assertEquals((String)"failingTask", (String)execution.getActivityId());
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/cmd/FoxJobRetryCmdTest.testFailedTransaction.bpmn20.xml"})
    public void testFailedTransaction() {
        ProcessInstance pi = this.runtimeService.startProcessInstanceByKey("failedTask");
        FoxJobRetryCmdTest.assertNotNull((Object)pi);
        this.waitForExecutedJobWithRetriesLeft(4);
        this.stillOneJobWithExceptionAndRetriesLeft();
        ExecutionEntity execution = this.fetchExecutionEntity(pi.getProcessInstanceId());
        FoxJobRetryCmdTest.assertEquals((String)"failingTransaction", (String)execution.getActivityId());
        Job job = this.fetchJob(pi.getProcessInstanceId());
        FoxJobRetryCmdTest.assertNotNull((Object)job);
        FoxJobRetryCmdTest.assertEquals((String)pi.getProcessInstanceId(), (String)job.getProcessInstanceId());
        FoxJobRetryCmdTest.assertEquals((int)4, (int)job.getRetries());
        this.waitForExecutedJobWithRetriesLeft(3);
        job = this.refreshJob(job.getId());
        FoxJobRetryCmdTest.assertEquals((int)3, (int)job.getRetries());
        this.stillOneJobWithExceptionAndRetriesLeft();
        execution = this.refreshExecutionEntity(execution.getId());
        FoxJobRetryCmdTest.assertEquals((String)"failingTransaction", (String)execution.getActivityId());
        this.waitForExecutedJobWithRetriesLeft(2);
        job = this.refreshJob(job.getId());
        FoxJobRetryCmdTest.assertEquals((int)2, (int)job.getRetries());
        this.stillOneJobWithExceptionAndRetriesLeft();
        execution = this.refreshExecutionEntity(execution.getId());
        FoxJobRetryCmdTest.assertEquals((String)"failingTransaction", (String)execution.getActivityId());
        this.waitForExecutedJobWithRetriesLeft(1);
        job = this.refreshJob(job.getId());
        FoxJobRetryCmdTest.assertEquals((int)1, (int)job.getRetries());
        this.stillOneJobWithExceptionAndRetriesLeft();
        execution = this.refreshExecutionEntity(execution.getId());
        FoxJobRetryCmdTest.assertEquals((String)"failingTransaction", (String)execution.getActivityId());
        this.waitForExecutedJobWithRetriesLeft(0);
        job = this.refreshJob(job.getId());
        FoxJobRetryCmdTest.assertEquals((int)0, (int)job.getRetries());
        FoxJobRetryCmdTest.assertEquals((long)1L, (long)this.managementService.createJobQuery().withException().count());
        FoxJobRetryCmdTest.assertEquals((long)0L, (long)this.managementService.createJobQuery().withRetriesLeft().count());
        FoxJobRetryCmdTest.assertEquals((long)1L, (long)this.managementService.createJobQuery().noRetriesLeft().count());
        execution = this.refreshExecutionEntity(execution.getId());
        FoxJobRetryCmdTest.assertEquals((String)"failingTransaction", (String)execution.getActivityId());
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/cmd/FoxJobRetryCmdTest.testFailedReceiveTask.bpmn20.xml"})
    public void testFailedReceiveTask() {
        ProcessInstance pi = this.runtimeService.startProcessInstanceByKey("failedReceiveTask");
        FoxJobRetryCmdTest.assertNotNull((Object)pi);
        this.waitForExecutedJobWithRetriesLeft(4);
        this.stillOneJobWithExceptionAndRetriesLeft();
        ExecutionEntity execution = this.fetchExecutionEntity(pi.getProcessInstanceId());
        FoxJobRetryCmdTest.assertEquals((String)"failingReceiveTask", (String)execution.getActivityId());
        Job job = this.fetchJob(pi.getProcessInstanceId());
        FoxJobRetryCmdTest.assertNotNull((Object)job);
        FoxJobRetryCmdTest.assertEquals((String)pi.getProcessInstanceId(), (String)job.getProcessInstanceId());
        FoxJobRetryCmdTest.assertEquals((int)4, (int)job.getRetries());
        this.waitForExecutedJobWithRetriesLeft(3);
        job = this.refreshJob(job.getId());
        FoxJobRetryCmdTest.assertEquals((int)3, (int)job.getRetries());
        this.stillOneJobWithExceptionAndRetriesLeft();
        execution = this.refreshExecutionEntity(execution.getId());
        FoxJobRetryCmdTest.assertEquals((String)"failingReceiveTask", (String)execution.getActivityId());
        this.waitForExecutedJobWithRetriesLeft(2);
        job = this.refreshJob(job.getId());
        FoxJobRetryCmdTest.assertEquals((int)2, (int)job.getRetries());
        this.stillOneJobWithExceptionAndRetriesLeft();
        execution = this.refreshExecutionEntity(execution.getId());
        FoxJobRetryCmdTest.assertEquals((String)"failingReceiveTask", (String)execution.getActivityId());
        this.waitForExecutedJobWithRetriesLeft(1);
        job = this.refreshJob(job.getId());
        FoxJobRetryCmdTest.assertEquals((int)1, (int)job.getRetries());
        this.stillOneJobWithExceptionAndRetriesLeft();
        execution = this.refreshExecutionEntity(execution.getId());
        FoxJobRetryCmdTest.assertEquals((String)"failingReceiveTask", (String)execution.getActivityId());
        this.waitForExecutedJobWithRetriesLeft(0);
        job = this.refreshJob(job.getId());
        FoxJobRetryCmdTest.assertEquals((int)0, (int)job.getRetries());
        FoxJobRetryCmdTest.assertEquals((long)1L, (long)this.managementService.createJobQuery().withException().count());
        FoxJobRetryCmdTest.assertEquals((long)0L, (long)this.managementService.createJobQuery().withRetriesLeft().count());
        FoxJobRetryCmdTest.assertEquals((long)1L, (long)this.managementService.createJobQuery().noRetriesLeft().count());
        execution = this.refreshExecutionEntity(execution.getId());
        FoxJobRetryCmdTest.assertEquals((String)"failingReceiveTask", (String)execution.getActivityId());
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/cmd/FoxJobRetryCmdTest.testFailedStartTimerEvent.bpmn20.xml"})
    public void testFailedTimerStartEvent() {
        JobQuery jobQuery = this.managementService.createJobQuery();
        FoxJobRetryCmdTest.assertEquals((long)1L, (long)jobQuery.count());
        Job job = (Job)this.managementService.createJobQuery().list().get(0);
        FoxJobRetryCmdTest.assertNotNull((Object)job);
        this.waitForExecutedJobWithRetriesLeft(4);
        this.stillOneJobWithExceptionAndRetriesLeft();
        job = this.refreshJob(job.getId());
        FoxJobRetryCmdTest.assertNotNull((Object)job);
        FoxJobRetryCmdTest.assertEquals((int)4, (int)job.getRetries());
        this.waitForExecutedJobWithRetriesLeft(3);
        job = this.refreshJob(job.getId());
        FoxJobRetryCmdTest.assertEquals((int)3, (int)job.getRetries());
        this.stillOneJobWithExceptionAndRetriesLeft();
        this.waitForExecutedJobWithRetriesLeft(2);
        job = this.refreshJob(job.getId());
        FoxJobRetryCmdTest.assertEquals((int)2, (int)job.getRetries());
        this.stillOneJobWithExceptionAndRetriesLeft();
        this.waitForExecutedJobWithRetriesLeft(1);
        job = this.refreshJob(job.getId());
        FoxJobRetryCmdTest.assertEquals((int)1, (int)job.getRetries());
        this.stillOneJobWithExceptionAndRetriesLeft();
        this.waitForExecutedJobWithRetriesLeft(0);
        job = this.refreshJob(job.getId());
        FoxJobRetryCmdTest.assertEquals((int)0, (int)job.getRetries());
        FoxJobRetryCmdTest.assertEquals((long)1L, (long)this.managementService.createJobQuery().withException().count());
        FoxJobRetryCmdTest.assertEquals((long)0L, (long)this.managementService.createJobQuery().withRetriesLeft().count());
        FoxJobRetryCmdTest.assertEquals((long)1L, (long)this.managementService.createJobQuery().noRetriesLeft().count());
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/cmd/FoxJobRetryCmdTest.testFailedBoundaryTimerEvent.bpmn20.xml"})
    public void testFailedBoundaryTimerEvent() {
        ProcessInstance pi = this.runtimeService.startProcessInstanceByKey("failedBoundaryTimerEvent");
        FoxJobRetryCmdTest.assertNotNull((Object)pi);
        this.waitForExecutedJobWithRetriesLeft(4);
        this.stillOneJobWithExceptionAndRetriesLeft();
        Job job = this.fetchJob(pi.getProcessInstanceId());
        FoxJobRetryCmdTest.assertNotNull((Object)job);
        FoxJobRetryCmdTest.assertEquals((String)pi.getProcessInstanceId(), (String)job.getProcessInstanceId());
        FoxJobRetryCmdTest.assertEquals((int)4, (int)job.getRetries());
        this.waitForExecutedJobWithRetriesLeft(3);
        this.stillOneJobWithExceptionAndRetriesLeft();
        job = this.refreshJob(job.getId());
        FoxJobRetryCmdTest.assertNotNull((Object)job);
        FoxJobRetryCmdTest.assertEquals((String)pi.getProcessInstanceId(), (String)job.getProcessInstanceId());
        FoxJobRetryCmdTest.assertEquals((int)3, (int)job.getRetries());
        this.waitForExecutedJobWithRetriesLeft(2);
        this.stillOneJobWithExceptionAndRetriesLeft();
        job = this.refreshJob(job.getId());
        FoxJobRetryCmdTest.assertNotNull((Object)job);
        FoxJobRetryCmdTest.assertEquals((String)pi.getProcessInstanceId(), (String)job.getProcessInstanceId());
        FoxJobRetryCmdTest.assertEquals((int)2, (int)job.getRetries());
        this.waitForExecutedJobWithRetriesLeft(1);
        this.stillOneJobWithExceptionAndRetriesLeft();
        job = this.refreshJob(job.getId());
        FoxJobRetryCmdTest.assertNotNull((Object)job);
        FoxJobRetryCmdTest.assertEquals((String)pi.getProcessInstanceId(), (String)job.getProcessInstanceId());
        FoxJobRetryCmdTest.assertEquals((int)1, (int)job.getRetries());
        this.waitForExecutedJobWithRetriesLeft(0);
        job = this.refreshJob(job.getId());
        FoxJobRetryCmdTest.assertNotNull((Object)job);
        FoxJobRetryCmdTest.assertEquals((String)pi.getProcessInstanceId(), (String)job.getProcessInstanceId());
        FoxJobRetryCmdTest.assertEquals((int)0, (int)job.getRetries());
        FoxJobRetryCmdTest.assertEquals((long)1L, (long)this.managementService.createJobQuery().noRetriesLeft().count());
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/cmd/FoxJobRetryCmdTest.testFailedIntermediateCatchingTimerEvent.bpmn20.xml"})
    public void testFailedIntermediateCatchingTimerEvent() {
        ProcessInstance pi = this.runtimeService.startProcessInstanceByKey("failedIntermediateCatchingTimerEvent");
        FoxJobRetryCmdTest.assertNotNull((Object)pi);
        this.waitForExecutedJobWithRetriesLeft(4);
        this.stillOneJobWithExceptionAndRetriesLeft();
        Job job = this.fetchJob(pi.getProcessInstanceId());
        FoxJobRetryCmdTest.assertNotNull((Object)job);
        FoxJobRetryCmdTest.assertEquals((String)pi.getProcessInstanceId(), (String)job.getProcessInstanceId());
        FoxJobRetryCmdTest.assertEquals((int)4, (int)job.getRetries());
        this.waitForExecutedJobWithRetriesLeft(3);
        this.stillOneJobWithExceptionAndRetriesLeft();
        job = this.refreshJob(job.getId());
        FoxJobRetryCmdTest.assertNotNull((Object)job);
        FoxJobRetryCmdTest.assertEquals((String)pi.getProcessInstanceId(), (String)job.getProcessInstanceId());
        FoxJobRetryCmdTest.assertEquals((int)3, (int)job.getRetries());
        this.waitForExecutedJobWithRetriesLeft(2);
        this.stillOneJobWithExceptionAndRetriesLeft();
        job = this.refreshJob(job.getId());
        FoxJobRetryCmdTest.assertNotNull((Object)job);
        FoxJobRetryCmdTest.assertEquals((String)pi.getProcessInstanceId(), (String)job.getProcessInstanceId());
        FoxJobRetryCmdTest.assertEquals((int)2, (int)job.getRetries());
        this.waitForExecutedJobWithRetriesLeft(1);
        this.stillOneJobWithExceptionAndRetriesLeft();
        job = this.refreshJob(job.getId());
        FoxJobRetryCmdTest.assertNotNull((Object)job);
        FoxJobRetryCmdTest.assertEquals((String)pi.getProcessInstanceId(), (String)job.getProcessInstanceId());
        FoxJobRetryCmdTest.assertEquals((int)1, (int)job.getRetries());
        this.waitForExecutedJobWithRetriesLeft(0);
        job = this.refreshJob(job.getId());
        FoxJobRetryCmdTest.assertNotNull((Object)job);
        FoxJobRetryCmdTest.assertEquals((String)pi.getProcessInstanceId(), (String)job.getProcessInstanceId());
        FoxJobRetryCmdTest.assertEquals((int)0, (int)job.getRetries());
        FoxJobRetryCmdTest.assertEquals((long)1L, (long)this.managementService.createJobQuery().noRetriesLeft().count());
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/cmd/FoxJobRetryCmdTest.testBrokenFoxJobRetryValue.bpmn20.xml"})
    public void testBrokenFoxJobRetryValue() {
        Job job = (Job)this.managementService.createJobQuery().list().get(0);
        FoxJobRetryCmdTest.assertNotNull((Object)job);
        FoxJobRetryCmdTest.assertEquals((int)3, (int)job.getRetries());
        this.waitForExecutedJobWithRetriesLeft(0);
        job = this.refreshJob(job.getId());
        FoxJobRetryCmdTest.assertEquals((int)0, (int)job.getRetries());
        FoxJobRetryCmdTest.assertEquals((long)1L, (long)this.managementService.createJobQuery().noRetriesLeft().count());
    }
}

