/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.test.history;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import org.camunda.bpm.engine.ProcessEngineException;
import org.camunda.bpm.engine.history.HistoricCaseActivityInstance;
import org.camunda.bpm.engine.history.HistoricCaseActivityInstanceQuery;
import org.camunda.bpm.engine.history.NativeHistoricCaseActivityInstanceQuery;
import org.camunda.bpm.engine.impl.AbstractQuery;
import org.camunda.bpm.engine.impl.cmmn.execution.CaseExecutionState;
import org.camunda.bpm.engine.impl.history.event.HistoricCaseActivityInstanceEventEntity;
import org.camunda.bpm.engine.impl.persistence.entity.HistoricCaseActivityInstanceEntity;
import org.camunda.bpm.engine.impl.test.CmmnProcessEngineTestCase;
import org.camunda.bpm.engine.impl.util.ClockUtil;
import org.camunda.bpm.engine.query.Query;
import org.camunda.bpm.engine.query.QueryProperty;
import org.camunda.bpm.engine.runtime.CaseExecution;
import org.camunda.bpm.engine.runtime.CaseInstance;
import org.camunda.bpm.engine.runtime.ProcessInstance;
import org.camunda.bpm.engine.task.Task;
import org.camunda.bpm.engine.test.Deployment;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.hamcrest.collection.IsIterableContainingInOrder;
import org.junit.Assert;

public class HistoricCaseActivityInstanceTest
extends CmmnProcessEngineTestCase {
    @Deployment(resources={"org/camunda/bpm/engine/test/api/cmmn/emptyStageCase.cmmn"})
    public void testHistoricCaseActivityInstanceProperties() {
        String activityId = "PI_Stage_1";
        this.createCaseInstance();
        CaseExecution stage = this.queryCaseExecutionByActivityId(activityId);
        HistoricCaseActivityInstance historicStage = this.queryHistoricActivityCaseInstance(activityId);
        HistoricCaseActivityInstanceTest.assertEquals((String)stage.getId(), (String)historicStage.getId());
        HistoricCaseActivityInstanceTest.assertEquals((String)stage.getParentId(), (String)historicStage.getParentCaseActivityInstanceId());
        HistoricCaseActivityInstanceTest.assertEquals((String)stage.getCaseDefinitionId(), (String)historicStage.getCaseDefinitionId());
        HistoricCaseActivityInstanceTest.assertEquals((String)stage.getCaseInstanceId(), (String)historicStage.getCaseInstanceId());
        HistoricCaseActivityInstanceTest.assertEquals((String)stage.getActivityId(), (String)historicStage.getCaseActivityId());
        HistoricCaseActivityInstanceTest.assertEquals((String)stage.getActivityName(), (String)historicStage.getCaseActivityName());
        this.manualStart(stage.getId());
        historicStage = this.queryHistoricActivityCaseInstance(activityId);
        HistoricCaseActivityInstanceTest.assertNotNull((Object)historicStage.getEndTime());
    }

    @Deployment
    public void testHistoricCaseActivityTaskStates() {
        String humanTaskId1 = "PI_HumanTask_1";
        String humanTaskId2 = "PI_HumanTask_2";
        String humanTaskId3 = "PI_HumanTask_3";
        String caseInstanceId = this.createCaseInstance().getId();
        String taskInstanceId1 = this.queryCaseExecutionByActivityId(humanTaskId1).getId();
        String taskInstanceId2 = this.queryCaseExecutionByActivityId(humanTaskId2).getId();
        String taskInstanceId3 = this.queryCaseExecutionByActivityId(humanTaskId3).getId();
        this.assertHistoricState(humanTaskId1, CaseExecutionState.ENABLED);
        this.assertHistoricState(humanTaskId2, CaseExecutionState.AVAILABLE);
        this.assertHistoricState(humanTaskId3, CaseExecutionState.AVAILABLE);
        this.assertStateQuery(CaseExecutionState.ENABLED, CaseExecutionState.AVAILABLE, CaseExecutionState.AVAILABLE);
        this.manualStart(taskInstanceId1);
        this.assertHistoricState(humanTaskId1, CaseExecutionState.ACTIVE);
        this.assertHistoricState(humanTaskId2, CaseExecutionState.AVAILABLE);
        this.assertHistoricState(humanTaskId3, CaseExecutionState.AVAILABLE);
        this.assertStateQuery(CaseExecutionState.ACTIVE, CaseExecutionState.AVAILABLE, CaseExecutionState.AVAILABLE);
        this.complete(taskInstanceId1);
        this.assertHistoricState(humanTaskId1, CaseExecutionState.COMPLETED);
        this.assertHistoricState(humanTaskId2, CaseExecutionState.ENABLED);
        this.assertHistoricState(humanTaskId3, CaseExecutionState.ACTIVE);
        this.assertStateQuery(CaseExecutionState.COMPLETED, CaseExecutionState.ENABLED, CaseExecutionState.ACTIVE);
        this.disable(taskInstanceId2);
        this.assertHistoricState(humanTaskId1, CaseExecutionState.COMPLETED);
        this.assertHistoricState(humanTaskId2, CaseExecutionState.DISABLED);
        this.assertHistoricState(humanTaskId3, CaseExecutionState.ACTIVE);
        this.assertStateQuery(CaseExecutionState.COMPLETED, CaseExecutionState.DISABLED, CaseExecutionState.ACTIVE);
        this.reenable(taskInstanceId2);
        this.assertHistoricState(humanTaskId1, CaseExecutionState.COMPLETED);
        this.assertHistoricState(humanTaskId2, CaseExecutionState.ENABLED);
        this.assertHistoricState(humanTaskId3, CaseExecutionState.ACTIVE);
        this.assertStateQuery(CaseExecutionState.COMPLETED, CaseExecutionState.ENABLED, CaseExecutionState.ACTIVE);
        this.suspend(taskInstanceId3);
        this.assertHistoricState(humanTaskId1, CaseExecutionState.COMPLETED);
        this.assertHistoricState(humanTaskId2, CaseExecutionState.ENABLED);
        this.assertHistoricState(humanTaskId3, CaseExecutionState.SUSPENDED);
        this.assertStateQuery(CaseExecutionState.COMPLETED, CaseExecutionState.ENABLED, CaseExecutionState.SUSPENDED);
        this.resume(taskInstanceId3);
        this.assertHistoricState(humanTaskId1, CaseExecutionState.COMPLETED);
        this.assertHistoricState(humanTaskId2, CaseExecutionState.ENABLED);
        this.assertHistoricState(humanTaskId3, CaseExecutionState.ACTIVE);
        this.assertStateQuery(CaseExecutionState.COMPLETED, CaseExecutionState.ENABLED, CaseExecutionState.ACTIVE);
        this.suspend(caseInstanceId);
        this.assertHistoricState(humanTaskId1, CaseExecutionState.COMPLETED);
        this.assertHistoricState(humanTaskId2, CaseExecutionState.SUSPENDED);
        this.assertHistoricState(humanTaskId3, CaseExecutionState.SUSPENDED);
        this.assertStateQuery(CaseExecutionState.COMPLETED, CaseExecutionState.SUSPENDED, CaseExecutionState.SUSPENDED);
        this.reactivate(caseInstanceId);
        this.assertHistoricState(humanTaskId1, CaseExecutionState.COMPLETED);
        this.assertHistoricState(humanTaskId2, CaseExecutionState.ENABLED);
        this.assertHistoricState(humanTaskId3, CaseExecutionState.ACTIVE);
        this.assertStateQuery(CaseExecutionState.COMPLETED, CaseExecutionState.ENABLED, CaseExecutionState.ACTIVE);
        this.terminate(taskInstanceId3);
        this.assertHistoricState(humanTaskId1, CaseExecutionState.COMPLETED);
        this.assertHistoricState(humanTaskId2, CaseExecutionState.TERMINATED);
        this.assertHistoricState(humanTaskId3, CaseExecutionState.TERMINATED);
        this.assertStateQuery(CaseExecutionState.COMPLETED, CaseExecutionState.TERMINATED, CaseExecutionState.TERMINATED);
    }

    @Deployment
    public void testHistoricCaseActivityEventListenerAndMilestoneStates() {
        String milestoneId = "PI_Milestone";
        String userEventId1 = "PI_UserEvent_1";
        String userEventId2 = "PI_UserEvent_2";
        String caseInstanceId = this.createCaseInstance().getId();
        String eventInstance1 = this.queryCaseExecutionByActivityId(userEventId1).getId();
        String eventInstance2 = this.queryCaseExecutionByActivityId(userEventId2).getId();
        this.assertHistoricState(milestoneId, CaseExecutionState.AVAILABLE);
        this.assertHistoricState(userEventId1, CaseExecutionState.AVAILABLE);
        this.assertHistoricState(userEventId2, CaseExecutionState.AVAILABLE);
        this.assertStateQuery(CaseExecutionState.AVAILABLE, CaseExecutionState.AVAILABLE, CaseExecutionState.AVAILABLE);
        this.suspend(eventInstance1);
        this.suspend(eventInstance2);
        this.assertHistoricState(milestoneId, CaseExecutionState.AVAILABLE);
        this.assertHistoricState(userEventId1, CaseExecutionState.SUSPENDED);
        this.assertHistoricState(userEventId2, CaseExecutionState.SUSPENDED);
        this.assertStateQuery(CaseExecutionState.AVAILABLE, CaseExecutionState.SUSPENDED, CaseExecutionState.SUSPENDED);
        this.resume(eventInstance1);
        this.assertHistoricState(milestoneId, CaseExecutionState.AVAILABLE);
        this.assertHistoricState(userEventId1, CaseExecutionState.AVAILABLE);
        this.assertHistoricState(userEventId2, CaseExecutionState.SUSPENDED);
        this.assertStateQuery(CaseExecutionState.AVAILABLE, CaseExecutionState.AVAILABLE, CaseExecutionState.SUSPENDED);
        this.terminate(eventInstance1);
        this.assertHistoricState(milestoneId, CaseExecutionState.COMPLETED);
        this.assertHistoricState(userEventId1, CaseExecutionState.TERMINATED);
        this.assertHistoricState(userEventId2, CaseExecutionState.SUSPENDED);
        this.assertStateQuery(CaseExecutionState.COMPLETED, CaseExecutionState.TERMINATED, CaseExecutionState.SUSPENDED);
        this.terminate(caseInstanceId);
        this.assertHistoricState(milestoneId, CaseExecutionState.COMPLETED);
        this.assertHistoricState(userEventId1, CaseExecutionState.TERMINATED);
        this.assertHistoricState(userEventId2, CaseExecutionState.TERMINATED);
        this.assertStateQuery(CaseExecutionState.COMPLETED, CaseExecutionState.TERMINATED, CaseExecutionState.TERMINATED);
    }

    @Deployment
    public void testHistoricCaseActivityInstanceDates() {
        String taskId1 = "PI_HumanTask_1";
        String taskId2 = "PI_HumanTask_2";
        String taskId3 = "PI_HumanTask_3";
        String eventId1 = "PI_UserEvent_1";
        String eventId2 = "PI_UserEvent_2";
        String eventId3 = "PI_UserEvent_3";
        long duration = 259200000L;
        Date created = ClockUtil.getCurrentTime();
        Date ended = new Date(created.getTime() + duration);
        ClockUtil.setCurrentTime((Date)created);
        String caseInstanceId = this.createCaseInstance().getId();
        String taskInstance1 = this.queryCaseExecutionByActivityId(taskId1).getId();
        String taskInstance2 = this.queryCaseExecutionByActivityId(taskId2).getId();
        String taskInstance3 = this.queryCaseExecutionByActivityId(taskId3).getId();
        String eventInstance1 = this.queryCaseExecutionByActivityId(eventId1).getId();
        String eventInstance2 = this.queryCaseExecutionByActivityId(eventId2).getId();
        String eventInstance3 = this.queryCaseExecutionByActivityId(eventId3).getId();
        this.assertHistoricCreateTime(taskId1, created);
        this.assertHistoricCreateTime(taskId2, created);
        this.assertHistoricCreateTime(eventId1, created);
        this.assertHistoricCreateTime(eventId2, created);
        this.manualStart(taskInstance1);
        ClockUtil.setCurrentTime((Date)ended);
        this.complete(taskInstance1);
        this.assertHistoricEndTime(taskId1, ended);
        this.assertHistoricDuration(taskId1, duration);
        ClockUtil.setCurrentTime((Date)ended);
        this.occur(eventInstance1);
        this.assertHistoricEndTime(eventId1, ended);
        this.assertHistoricDuration(eventId1, duration);
        this.manualStart(taskInstance2);
        ClockUtil.setCurrentTime((Date)ended);
        this.terminate(taskInstance2);
        this.assertHistoricEndTime(taskId2, ended);
        this.assertHistoricDuration(taskId2, duration);
        ClockUtil.setCurrentTime((Date)ended);
        this.terminate(eventInstance2);
        this.assertHistoricEndTime(eventId2, ended);
        this.assertHistoricDuration(eventId2, duration);
        this.disable(taskInstance3);
        this.suspend(eventInstance3);
        ClockUtil.setCurrentTime((Date)ended);
        this.terminate(caseInstanceId);
        this.assertHistoricEndTime(taskId3, ended);
        this.assertHistoricEndTime(eventId3, ended);
        this.assertHistoricDuration(taskId3, duration);
        this.assertHistoricDuration(eventId3, duration);
        Date beforeCreate = new Date(created.getTime() - 3600000L);
        Date afterEnd = new Date(ended.getTime() + 3600000L);
        this.assertCount(6L, (Query<?, ?>)this.historicQuery().createdAfter(beforeCreate));
        this.assertCount(0L, (Query<?, ?>)this.historicQuery().createdAfter(ended));
        this.assertCount(0L, (Query<?, ?>)this.historicQuery().createdBefore(beforeCreate));
        this.assertCount(6L, (Query<?, ?>)this.historicQuery().createdBefore(ended));
        this.assertCount(6L, (Query<?, ?>)this.historicQuery().endedAfter(created));
        this.assertCount(0L, (Query<?, ?>)this.historicQuery().endedAfter(afterEnd));
        this.assertCount(0L, (Query<?, ?>)this.historicQuery().endedBefore(created));
        this.assertCount(6L, (Query<?, ?>)this.historicQuery().endedBefore(afterEnd));
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/cmmn/oneTaskCase.cmmn"})
    public void testHistoricCaseActivityTaskId() {
        String taskId = "PI_HumanTask_1";
        this.createCaseInstance();
        this.assertCount(0L, (Query<?, ?>)this.taskService.createTaskQuery());
        HistoricCaseActivityInstance historicInstance = this.queryHistoricActivityCaseInstance(taskId);
        HistoricCaseActivityInstanceTest.assertNull((Object)historicInstance.getTaskId());
        CaseExecution humanTask = this.queryCaseExecutionByActivityId(taskId);
        this.manualStart(humanTask.getId());
        Task task = (Task)this.taskService.createTaskQuery().singleResult();
        HistoricCaseActivityInstanceTest.assertNotNull((Object)task);
        historicInstance = this.queryHistoricActivityCaseInstance(taskId);
        HistoricCaseActivityInstanceTest.assertEquals((String)task.getId(), (String)historicInstance.getTaskId());
        this.taskService.complete(task.getId());
        this.assertCount(0L, (Query<?, ?>)this.taskService.createTaskQuery());
        historicInstance = this.queryHistoricActivityCaseInstance(taskId);
        HistoricCaseActivityInstanceTest.assertEquals((String)task.getId(), (String)historicInstance.getTaskId());
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/cmmn/oneProcessTaskCase.cmmn", "org/camunda/bpm/engine/test/api/oneTaskProcess.bpmn20.xml"})
    public void testHistoricCaseActivityCalledProcessInstanceId() {
        String taskId = "PI_ProcessTask_1";
        this.createCaseInstanceByKey("oneProcessTaskCase").getId();
        this.assertCount(0L, (Query<?, ?>)this.runtimeService.createProcessInstanceQuery());
        HistoricCaseActivityInstance historicInstance = this.queryHistoricActivityCaseInstance(taskId);
        HistoricCaseActivityInstanceTest.assertNull((Object)historicInstance.getCalledProcessInstanceId());
        CaseExecution processTask = this.queryCaseExecutionByActivityId(taskId);
        this.manualStart(processTask.getId());
        ProcessInstance calledProcessInstance = (ProcessInstance)this.runtimeService.createProcessInstanceQuery().singleResult();
        HistoricCaseActivityInstanceTest.assertNotNull((Object)calledProcessInstance);
        historicInstance = this.queryHistoricActivityCaseInstance(taskId);
        HistoricCaseActivityInstanceTest.assertEquals((String)calledProcessInstance.getId(), (String)historicInstance.getCalledProcessInstanceId());
        Task task = (Task)this.taskService.createTaskQuery().singleResult();
        this.taskService.complete(task.getId());
        this.assertCount(0L, (Query<?, ?>)this.runtimeService.createProcessInstanceQuery());
        historicInstance = this.queryHistoricActivityCaseInstance(taskId);
        HistoricCaseActivityInstanceTest.assertEquals((String)calledProcessInstance.getId(), (String)historicInstance.getCalledProcessInstanceId());
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/cmmn/oneCaseTaskCase.cmmn", "org/camunda/bpm/engine/test/api/cmmn/oneTaskCase.cmmn"})
    public void testHistoricCaseActivityCalledCaseInstanceId() {
        String taskId = "PI_CaseTask_1";
        String calledCaseId = "oneTaskCase";
        String calledTaskId = "PI_HumanTask_1";
        this.createCaseInstanceByKey("oneCaseTaskCase").getId();
        this.assertCount(0L, (Query<?, ?>)this.caseService.createCaseInstanceQuery().caseDefinitionKey(calledCaseId));
        HistoricCaseActivityInstance historicInstance = this.queryHistoricActivityCaseInstance(taskId);
        HistoricCaseActivityInstanceTest.assertNull((Object)historicInstance.getCalledCaseInstanceId());
        CaseExecution caseTask = this.queryCaseExecutionByActivityId(taskId);
        this.manualStart(caseTask.getId());
        CaseInstance calledCaseInstance = (CaseInstance)this.caseService.createCaseInstanceQuery().caseDefinitionKey(calledCaseId).singleResult();
        HistoricCaseActivityInstanceTest.assertNotNull((Object)calledCaseInstance);
        historicInstance = this.queryHistoricActivityCaseInstance(taskId);
        HistoricCaseActivityInstanceTest.assertEquals((String)calledCaseInstance.getId(), (String)historicInstance.getCalledCaseInstanceId());
        CaseExecution calledTask = this.queryCaseExecutionByActivityId(calledTaskId);
        this.disable(calledTask.getId());
        this.close(calledCaseInstance.getId());
        this.assertCount(0L, (Query<?, ?>)this.caseService.createCaseInstanceQuery().caseDefinitionKey(calledCaseId));
        historicInstance = this.queryHistoricActivityCaseInstance(taskId);
        HistoricCaseActivityInstanceTest.assertEquals((String)calledCaseInstance.getId(), (String)historicInstance.getCalledCaseInstanceId());
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/cmmn/oneTaskAndOneStageCase.cmmn"})
    public void testHistoricCaseActivityQuery() {
        String stageId = "PI_Stage_1";
        String stageName = "A HumanTask";
        String taskId = "PI_HumanTask_1";
        String taskName = "A HumanTask";
        String caseInstanceId = this.createCaseInstance().getId();
        CaseExecution stageExecution = this.queryCaseExecutionByActivityId(stageId);
        CaseExecution taskExecution = this.queryCaseExecutionByActivityId(taskId);
        this.assertCount(1L, (Query<?, ?>)this.historicQuery().caseActivityInstanceId(stageExecution.getId()));
        this.assertCount(1L, (Query<?, ?>)this.historicQuery().caseActivityInstanceId(taskExecution.getId()));
        this.assertCount(2L, (Query<?, ?>)this.historicQuery().caseInstanceId(caseInstanceId));
        this.assertCount(2L, (Query<?, ?>)this.historicQuery().caseDefinitionId(stageExecution.getCaseDefinitionId()));
        this.assertCount(1L, (Query<?, ?>)this.historicQuery().caseExecutionId(stageExecution.getId()));
        this.assertCount(1L, (Query<?, ?>)this.historicQuery().caseExecutionId(taskExecution.getId()));
        this.assertCount(1L, (Query<?, ?>)this.historicQuery().caseActivityId(stageId));
        this.assertCount(1L, (Query<?, ?>)this.historicQuery().caseActivityId(taskId));
        this.assertCount(1L, (Query<?, ?>)this.historicQuery().caseActivityName(stageName));
        this.assertCount(1L, (Query<?, ?>)this.historicQuery().caseActivityName(taskName));
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/cmmn/oneTaskCase.cmmn"})
    public void testQueryPaging() {
        this.createCaseInstance();
        this.createCaseInstance();
        this.createCaseInstance();
        this.createCaseInstance();
        HistoricCaseActivityInstanceTest.assertEquals((int)3, (int)this.historicQuery().listPage(0, 3).size());
        HistoricCaseActivityInstanceTest.assertEquals((int)2, (int)this.historicQuery().listPage(2, 2).size());
        HistoricCaseActivityInstanceTest.assertEquals((int)1, (int)this.historicQuery().listPage(3, 2).size());
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/cmmn/oneTaskCase.cmmn", "org/camunda/bpm/engine/test/api/cmmn/twoTaskCase.cmmn"})
    public void testQuerySorting() {
        String taskId1 = "PI_HumanTask_1";
        String taskId2 = "PI_HumanTask_2";
        String oneTaskCaseId = this.createCaseInstanceByKey("oneTaskCase").getId();
        String twoTaskCaseId = this.createCaseInstanceByKey("twoTaskCase").getId();
        CaseExecution task1 = (CaseExecution)this.caseService.createCaseExecutionQuery().caseInstanceId(oneTaskCaseId).activityId(taskId1).singleResult();
        CaseExecution task2 = (CaseExecution)this.caseService.createCaseExecutionQuery().caseInstanceId(twoTaskCaseId).activityId(taskId1).singleResult();
        CaseExecution task3 = (CaseExecution)this.caseService.createCaseExecutionQuery().caseInstanceId(twoTaskCaseId).activityId(taskId2).singleResult();
        this.assertQuerySorting("id", (Query<?, ?>)this.historicQuery().orderByHistoricCaseActivityInstanceId(), new Comparable[]{task1.getId(), task2.getId(), task3.getId()});
        this.assertQuerySorting("caseInstanceId", (Query<?, ?>)this.historicQuery().orderByCaseInstanceId(), new Comparable[]{oneTaskCaseId, twoTaskCaseId, twoTaskCaseId});
        this.assertQuerySorting("caseExecutionId", (Query<?, ?>)this.historicQuery().orderByCaseExecutionId(), new Comparable[]{task1.getId(), task2.getId(), task3.getId()});
        this.assertQuerySorting("caseActivityId", (Query<?, ?>)this.historicQuery().orderByCaseActivityId(), new Comparable[]{taskId1, taskId1, taskId2});
        this.assertQuerySorting("caseActivityName", (Query<?, ?>)this.historicQuery().orderByCaseActivityName(), new Comparable[]{"A HumanTask", "A HumanTask", "Another HumanTask"});
        this.assertQuerySorting("caseDefinitionId", (Query<?, ?>)this.historicQuery().orderByCaseDefinitionId(), new Comparable[]{task1.getCaseDefinitionId(), task2.getCaseDefinitionId(), task3.getCaseDefinitionId()});
        this.manualStart(task1.getId());
        this.manualStart(task2.getId());
        this.manualStart(task3.getId());
        for (Task task : this.taskService.createTaskQuery().list()) {
            this.taskService.complete(task.getId());
        }
        HistoricCaseActivityInstanceQuery query = this.historyService.createHistoricCaseActivityInstanceQuery();
        HistoricCaseActivityInstance historicTask1 = (HistoricCaseActivityInstance)query.caseInstanceId(oneTaskCaseId).caseActivityId(taskId1).singleResult();
        HistoricCaseActivityInstance historicTask2 = (HistoricCaseActivityInstance)query.caseInstanceId(twoTaskCaseId).caseActivityId(taskId1).singleResult();
        HistoricCaseActivityInstance historicTask3 = (HistoricCaseActivityInstance)query.caseInstanceId(twoTaskCaseId).caseActivityId(taskId2).singleResult();
        this.assertQuerySorting("createTime", (Query<?, ?>)this.historicQuery().orderByHistoricCaseActivityInstanceCreateTime(), historicTask1.getCreateTime(), historicTask2.getCreateTime(), historicTask3.getCreateTime());
        this.assertQuerySorting("endTime", (Query<?, ?>)this.historicQuery().orderByHistoricCaseActivityInstanceEndTime(), historicTask1.getEndTime(), historicTask2.getEndTime(), historicTask3.getEndTime());
        this.assertQuerySorting("durationInMillis", (Query<?, ?>)this.historicQuery().orderByHistoricCaseActivityInstanceDuration(), historicTask1.getDurationInMillis(), historicTask2.getDurationInMillis(), historicTask3.getDurationInMillis());
    }

    public void testInvalidSorting() {
        try {
            this.historicQuery().asc();
            HistoricCaseActivityInstanceTest.fail((String)"Exception expected");
        }
        catch (ProcessEngineException e) {
            // empty catch block
        }
        try {
            this.historicQuery().desc();
            HistoricCaseActivityInstanceTest.fail((String)"Exception expected");
        }
        catch (ProcessEngineException e) {
            // empty catch block
        }
        try {
            this.historicQuery().orderByHistoricCaseActivityInstanceId().count();
            HistoricCaseActivityInstanceTest.fail((String)"Exception expected");
        }
        catch (ProcessEngineException processEngineException) {
            // empty catch block
        }
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/cmmn/oneTaskCase.cmmn"})
    public void testNativeQuery() {
        this.createCaseInstance();
        this.createCaseInstance();
        this.createCaseInstance();
        this.createCaseInstance();
        String instanceId = ((CaseExecution)this.caseService.createCaseExecutionQuery().activityId("PI_HumanTask_1").list().get(0)).getId();
        String tableName = this.managementService.getTableName(HistoricCaseActivityInstance.class);
        HistoricCaseActivityInstanceTest.assertEquals((String)"ACT_HI_CASEACTINST", (String)tableName);
        HistoricCaseActivityInstanceTest.assertEquals((String)tableName, (String)this.managementService.getTableName(HistoricCaseActivityInstanceEntity.class));
        HistoricCaseActivityInstanceTest.assertEquals((int)4, (int)((NativeHistoricCaseActivityInstanceQuery)this.historyService.createNativeHistoricCaseActivityInstanceQuery().sql("SELECT * FROM " + tableName)).list().size());
        HistoricCaseActivityInstanceTest.assertEquals((long)4L, (long)((NativeHistoricCaseActivityInstanceQuery)this.historyService.createNativeHistoricCaseActivityInstanceQuery().sql("SELECT count(*) FROM " + tableName)).count());
        HistoricCaseActivityInstanceTest.assertEquals((long)16L, (long)((NativeHistoricCaseActivityInstanceQuery)this.historyService.createNativeHistoricCaseActivityInstanceQuery().sql("SELECT count(*) FROM " + tableName + " H1, " + tableName + " H2")).count());
        HistoricCaseActivityInstanceTest.assertEquals((int)4, (int)((NativeHistoricCaseActivityInstanceQuery)this.historyService.createNativeHistoricCaseActivityInstanceQuery().sql("SELECT DISTINCT * FROM " + tableName)).list().size());
        HistoricCaseActivityInstanceTest.assertEquals((long)1L, (long)((NativeHistoricCaseActivityInstanceQuery)this.historyService.createNativeHistoricCaseActivityInstanceQuery().sql("SELECT count(*) FROM " + tableName + " H WHERE H.ID_ = '" + instanceId + "'")).count());
        HistoricCaseActivityInstanceTest.assertEquals((int)1, (int)((NativeHistoricCaseActivityInstanceQuery)this.historyService.createNativeHistoricCaseActivityInstanceQuery().sql("SELECT * FROM " + tableName + " H WHERE H.ID_ = '" + instanceId + "'")).list().size());
        HistoricCaseActivityInstanceTest.assertEquals((long)1L, (long)((NativeHistoricCaseActivityInstanceQuery)((NativeHistoricCaseActivityInstanceQuery)this.historyService.createNativeHistoricCaseActivityInstanceQuery().sql("SELECT count(*) FROM " + tableName + " H WHERE H.ID_ = #{caseActivityInstanceId}")).parameter("caseActivityInstanceId", (Object)instanceId)).count());
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/cmmn/oneTaskCase.cmmn"})
    public void testNativeQueryPaging() {
        this.createCaseInstance();
        this.createCaseInstance();
        this.createCaseInstance();
        this.createCaseInstance();
        String tableName = this.managementService.getTableName(HistoricCaseActivityInstance.class);
        HistoricCaseActivityInstanceTest.assertEquals((int)3, (int)((NativeHistoricCaseActivityInstanceQuery)this.historyService.createNativeHistoricCaseActivityInstanceQuery().sql("SELECT * FROM " + tableName)).listPage(0, 3).size());
        HistoricCaseActivityInstanceTest.assertEquals((int)2, (int)((NativeHistoricCaseActivityInstanceQuery)this.historyService.createNativeHistoricCaseActivityInstanceQuery().sql("SELECT * FROM " + tableName)).listPage(2, 2).size());
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/cmmn/oneTaskCase.cmmn"})
    public void testDeleteHistoricCaseActivityInstance() {
        CaseInstance caseInstance = this.createCaseInstance();
        HistoricCaseActivityInstance historicInstance = (HistoricCaseActivityInstance)this.historicQuery().singleResult();
        HistoricCaseActivityInstanceTest.assertNotNull((Object)historicInstance);
        this.disable(historicInstance.getId());
        this.close(caseInstance.getId());
        this.historyService.deleteHistoricCaseInstance(caseInstance.getId());
        this.assertCount(0L, (Query<?, ?>)this.historicQuery());
    }

    @Deployment
    public void testNonBlockingHumanTask() {
        CaseInstance caseInstance = this.createCaseInstance();
        HistoricCaseActivityInstanceTest.assertNotNull((Object)caseInstance);
    }

    protected HistoricCaseActivityInstanceQuery historicQuery() {
        return this.historyService.createHistoricCaseActivityInstanceQuery();
    }

    protected HistoricCaseActivityInstance queryHistoricActivityCaseInstance(String activityId) {
        HistoricCaseActivityInstance historicActivityInstance = (HistoricCaseActivityInstance)this.historicQuery().caseActivityId(activityId).singleResult();
        HistoricCaseActivityInstanceTest.assertNotNull((String)("No historic activity instance found for activity id: " + activityId), (Object)historicActivityInstance);
        return historicActivityInstance;
    }

    protected void assertHistoricState(String activityId, CaseExecutionState expectedState) {
        HistoricCaseActivityInstanceEventEntity historicActivityInstance = (HistoricCaseActivityInstanceEventEntity)this.queryHistoricActivityCaseInstance(activityId);
        int actualStateCode = historicActivityInstance.getCaseActivityInstanceState();
        CaseExecutionState actualState = CaseExecutionState.CaseExecutionStateImpl.getStateForCode((Integer)actualStateCode);
        HistoricCaseActivityInstanceTest.assertEquals((String)("The state of historic case activity '" + activityId + "' wasn't as expected"), (Object)expectedState, (Object)actualState);
    }

    protected void assertHistoricCreateTime(String activityId, Date expectedCreateTime) {
        HistoricCaseActivityInstance historicActivityInstance = this.queryHistoricActivityCaseInstance(activityId);
        Date actualCreateTime = historicActivityInstance.getCreateTime();
        this.assertSimilarDate(expectedCreateTime, actualCreateTime);
    }

    protected void assertHistoricEndTime(String activityId, Date expectedEndTime) {
        HistoricCaseActivityInstance historicActivityInstance = this.queryHistoricActivityCaseInstance(activityId);
        Date actualEndTime = historicActivityInstance.getEndTime();
        this.assertSimilarDate(expectedEndTime, actualEndTime);
    }

    protected void assertSimilarDate(Date expectedDate, Date actualDate) {
        long difference = Math.abs(expectedDate.getTime() - actualDate.getTime());
        HistoricCaseActivityInstanceTest.assertTrue((difference < 1000L ? 1 : 0) != 0);
    }

    protected void assertHistoricDuration(String activityId, long expectedDuration) {
        Long actualDuration = this.queryHistoricActivityCaseInstance(activityId).getDurationInMillis();
        HistoricCaseActivityInstanceTest.assertNotNull((Object)actualDuration);
        HistoricCaseActivityInstanceTest.assertTrue((actualDuration >= expectedDuration ? 1 : 0) != 0);
        HistoricCaseActivityInstanceTest.assertTrue((actualDuration < expectedDuration + 1000L ? 1 : 0) != 0);
    }

    protected void assertCount(long count, Query<?, ?> historicQuery) {
        HistoricCaseActivityInstanceTest.assertEquals((long)count, (long)historicQuery.count());
    }

    protected void assertStateQuery(CaseExecutionState ... states) {
        CaseExecutionStateCountMap stateCounts = new CaseExecutionStateCountMap();
        if (states != null) {
            for (CaseExecutionState state : states) {
                stateCounts.put(state, stateCounts.get(state) + 1L);
            }
        }
        this.assertCount(stateCounts.count(), (Query<?, ?>)this.historicQuery());
        this.assertCount(stateCounts.unfinished(), (Query<?, ?>)this.historicQuery().notEnded());
        this.assertCount(stateCounts.finished(), (Query<?, ?>)this.historicQuery().ended());
        this.assertCount(stateCounts.get(CaseExecutionState.ACTIVE), (Query<?, ?>)this.historicQuery().active());
        this.assertCount(stateCounts.get(CaseExecutionState.AVAILABLE), (Query<?, ?>)this.historicQuery().available());
        this.assertCount(stateCounts.get(CaseExecutionState.COMPLETED), (Query<?, ?>)this.historicQuery().completed());
        this.assertCount(stateCounts.get(CaseExecutionState.DISABLED), (Query<?, ?>)this.historicQuery().disabled());
        this.assertCount(stateCounts.get(CaseExecutionState.ENABLED), (Query<?, ?>)this.historicQuery().enabled());
        this.assertCount(stateCounts.get(CaseExecutionState.TERMINATED), (Query<?, ?>)this.historicQuery().terminated());
    }

    protected void assertQuerySorting(String property, Query<?, ?> query, Comparable ... items) {
        AbstractQuery queryImpl = (AbstractQuery)query;
        QueryProperty orderProperty = queryImpl.getOrderProperty();
        List<Comparable> sortedList = Arrays.asList(items);
        Collections.sort(sortedList);
        ArrayList<Matcher> matchers = new ArrayList<Matcher>();
        for (Comparable comparable : sortedList) {
            matchers.add(Matchers.hasProperty((String)property, (Matcher)Matchers.equalTo((Object)comparable)));
        }
        List instances = query.asc().list();
        HistoricCaseActivityInstanceTest.assertEquals((int)sortedList.size(), (int)instances.size());
        Assert.assertThat((Object)instances, (Matcher)IsIterableContainingInOrder.contains((Matcher[])matchers.toArray(new Matcher[matchers.size()])));
        queryImpl.setOrderBy(null);
        queryImpl.orderBy(orderProperty);
        Collections.reverse(matchers);
        instances = query.desc().list();
        HistoricCaseActivityInstanceTest.assertEquals((int)sortedList.size(), (int)instances.size());
        Assert.assertThat((Object)instances, (Matcher)IsIterableContainingInOrder.contains((Matcher[])matchers.toArray(new Matcher[matchers.size()])));
    }

    protected class CaseExecutionStateCountMap
    extends HashMap<CaseExecutionState, Long> {
        private static final long serialVersionUID = 1L;
        public final Collection<CaseExecutionState> ALL_STATES = CaseExecutionState.CASE_EXECUTION_STATES.values();
        public final Collection<CaseExecutionState> ENDED_STATES = Arrays.asList(CaseExecutionState.COMPLETED, CaseExecutionState.TERMINATED);
        public final Collection<CaseExecutionState> NOT_ENDED_STATES = new ArrayList<CaseExecutionState>(this.ALL_STATES);

        public CaseExecutionStateCountMap() {
            this.NOT_ENDED_STATES.removeAll(this.ENDED_STATES);
        }

        public Long get(CaseExecutionState state) {
            return state != null && this.containsKey(state) ? (Long)super.get(state) : 0L;
        }

        public Long count() {
            return this.count(this.ALL_STATES);
        }

        public Long finished() {
            return this.count(this.ENDED_STATES);
        }

        public Long unfinished() {
            return this.count(this.NOT_ENDED_STATES);
        }

        public Long count(Collection<CaseExecutionState> states) {
            long count = 0L;
            for (CaseExecutionState state : states) {
                count += this.get(state).longValue();
            }
            return count;
        }
    }
}

