/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.impl;

import java.io.Serializable;
import org.camunda.bpm.engine.ProcessEngineException;
import org.camunda.bpm.engine.impl.QueryOperator;
import org.camunda.bpm.engine.impl.persistence.entity.VariableInstanceEntity;
import org.camunda.bpm.engine.impl.variable.serializer.TypedValueSerializer;
import org.camunda.bpm.engine.impl.variable.serializer.VariableSerializers;
import org.camunda.bpm.engine.impl.variable.serializer.jpa.JPAVariableSerializer;
import org.camunda.bpm.engine.variable.Variables;
import org.camunda.bpm.engine.variable.type.ValueType;
import org.camunda.bpm.engine.variable.value.TypedValue;

public class QueryVariableValue
implements Serializable {
    private static final long serialVersionUID = 1L;
    private String name;
    private TypedValue value;
    private QueryOperator operator;
    private VariableInstanceEntity variableInstanceEntity;
    private boolean local;

    public QueryVariableValue(String name, Object value, QueryOperator operator, boolean local) {
        this.name = name;
        this.value = Variables.untypedValue(value);
        this.operator = operator;
        this.local = local;
    }

    public void initialize(VariableSerializers types) {
        if (this.variableInstanceEntity == null) {
            this.variableInstanceEntity = VariableInstanceEntity.create(this.name, this.value);
            TypedValueSerializer<?> serializer = this.variableInstanceEntity.getSerializer();
            if (serializer.getType() == ValueType.BYTES) {
                throw new ProcessEngineException("Variables of type ByteArray cannot be used to query");
            }
            if (serializer instanceof JPAVariableSerializer) {
                if (this.operator != QueryOperator.EQUALS) {
                    throw new ProcessEngineException("JPA entity variables can only be used in 'variableValueEquals'");
                }
            } else if (!serializer.getType().isPrimitiveValueType()) {
                throw new ProcessEngineException("Object values cannot be used to query");
            }
        }
    }

    public String getName() {
        return this.name;
    }

    public String getOperator() {
        if (this.operator != null) {
            return this.operator.toString();
        }
        return QueryOperator.EQUALS.toString();
    }

    public Object getValue() {
        return this.value.getValue();
    }

    public String getTextValue() {
        if (this.variableInstanceEntity != null) {
            return this.variableInstanceEntity.getTextValue();
        }
        return null;
    }

    public Long getLongValue() {
        if (this.variableInstanceEntity != null) {
            return this.variableInstanceEntity.getLongValue();
        }
        return null;
    }

    public Double getDoubleValue() {
        if (this.variableInstanceEntity != null) {
            return this.variableInstanceEntity.getDoubleValue();
        }
        return null;
    }

    public String getTextValue2() {
        if (this.variableInstanceEntity != null) {
            return this.variableInstanceEntity.getTextValue2();
        }
        return null;
    }

    public String getType() {
        if (this.variableInstanceEntity != null) {
            return this.variableInstanceEntity.getSerializer().getName();
        }
        return null;
    }

    public boolean isLocal() {
        return this.local;
    }
}

